/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Point;
import android.graphics.Rect;

public class Face {
    public static final int ID_UNSUPPORTED = -1;
    public static final int SCORE_MIN = 1;
    public static final int SCORE_MAX = 100;
    private Rect mBounds;
    private int mScore;
    private int mId;
    private Point mLeftEye;
    private Point mRightEye;
    private Point mMouth;

    public Face(@NonNull Rect bounds, int score, int id2, @NonNull Point leftEyePosition, @NonNull Point rightEyePosition, @NonNull Point mouthPosition) {
        this.init(bounds, score, id2, leftEyePosition, rightEyePosition, mouthPosition);
    }

    public Face(@NonNull Rect bounds, int score) {
        this.init(bounds, score, -1, null, null, null);
    }

    private void init(@NonNull Rect bounds, int score, int id2, @Nullable Point leftEyePosition, @Nullable Point rightEyePosition, @Nullable Point mouthPosition) {
        Face.checkNotNull("bounds", bounds);
        Face.checkScore(score);
        Face.checkId(id2);
        if (id2 == -1) {
            Face.checkNull("leftEyePosition", leftEyePosition);
            Face.checkNull("rightEyePosition", rightEyePosition);
            Face.checkNull("mouthPosition", mouthPosition);
        }
        Face.checkFace(leftEyePosition, rightEyePosition, mouthPosition);
        this.mBounds = bounds;
        this.mScore = score;
        this.mId = id2;
        this.mLeftEye = leftEyePosition;
        this.mRightEye = rightEyePosition;
        this.mMouth = mouthPosition;
    }

    public Rect getBounds() {
        return this.mBounds;
    }

    public int getScore() {
        return this.mScore;
    }

    public int getId() {
        return this.mId;
    }

    public Point getLeftEyePosition() {
        return this.mLeftEye;
    }

    public Point getRightEyePosition() {
        return this.mRightEye;
    }

    public Point getMouthPosition() {
        return this.mMouth;
    }

    public String toString() {
        return String.format("{ bounds: %s, score: %s, id: %d, leftEyePosition: %s, rightEyePosition: %s, mouthPosition: %s }", this.mBounds, this.mScore, this.mId, this.mLeftEye, this.mRightEye, this.mMouth);
    }

    private static void checkNotNull(String name, Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " was required, but it was null");
        }
    }

    private static void checkNull(String name, Object obj) {
        if (obj != null) {
            throw new IllegalArgumentException(name + " was required to be null, but it wasn't");
        }
    }

    private static void checkScore(int score) {
        if (score < 1 || score > 100) {
            throw new IllegalArgumentException("Confidence out of range");
        }
    }

    private static void checkId(int id2) {
        if (id2 < 0 && id2 != -1) {
            throw new IllegalArgumentException("Id out of range");
        }
    }

    private static void checkFace(@Nullable Point leftEyePosition, @Nullable Point rightEyePosition, @Nullable Point mouthPosition) {
        if (!(leftEyePosition == null && rightEyePosition == null && mouthPosition == null || leftEyePosition != null && rightEyePosition != null && mouthPosition != null)) {
            throw new IllegalArgumentException("If any of leftEyePosition, rightEyePosition, or mouthPosition are non-null, all three must be non-null.");
        }
    }

    public static class Builder {
        private long mBuilderFieldsSet = 0L;
        private static final long FIELD_BOUNDS = 2L;
        private static final long FIELD_SCORE = 4L;
        private static final long FIELD_ID = 8L;
        private static final long FIELD_LEFT_EYE = 16L;
        private static final long FIELD_RIGHT_EYE = 32L;
        private static final long FIELD_MOUTH = 64L;
        private static final long FIELD_BUILT = 1L;
        private static final String FIELD_NAME_BOUNDS = "bounds";
        private static final String FIELD_NAME_SCORE = "score";
        private static final String FIELD_NAME_LEFT_EYE = "left eye";
        private static final String FIELD_NAME_RIGHT_EYE = "right eye";
        private static final String FIELD_NAME_MOUTH = "mouth";
        private Rect mBounds = null;
        private int mScore = 0;
        private int mId = -1;
        private Point mLeftEye = null;
        private Point mRightEye = null;
        private Point mMouth = null;

        public Builder() {
        }

        public Builder(@NonNull Face current) {
            this.mBounds = current.mBounds;
            this.mScore = current.mScore;
            this.mId = current.mId;
            this.mLeftEye = current.mLeftEye;
            this.mRightEye = current.mRightEye;
            this.mMouth = current.mMouth;
        }

        @NonNull
        public Builder setBounds(@NonNull Rect bounds) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mBounds = bounds;
            return this;
        }

        @NonNull
        public Builder setScore(int score) {
            this.checkNotUsed();
            Face.checkScore(score);
            this.mBuilderFieldsSet |= 4L;
            this.mScore = score;
            return this;
        }

        @NonNull
        public Builder setId(int id2) {
            this.checkNotUsed();
            Face.checkId(id2);
            this.mBuilderFieldsSet |= 8L;
            this.mId = id2;
            return this;
        }

        @NonNull
        public Builder setLeftEyePosition(@NonNull Point leftEyePosition) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mLeftEye = leftEyePosition;
            return this;
        }

        @NonNull
        public Builder setRightEyePosition(@NonNull Point rightEyePosition) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mRightEye = rightEyePosition;
            return this;
        }

        @NonNull
        public Builder setMouthPosition(@NonNull Point mouthPosition) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            this.mMouth = mouthPosition;
            return this;
        }

        @NonNull
        public Face build() {
            this.checkNotUsed();
            this.checkFieldSet(2L, FIELD_NAME_BOUNDS);
            this.checkFieldSet(4L, FIELD_NAME_SCORE);
            if (this.mId == -1) {
                this.checkIdUnsupportedThenNull(this.mLeftEye, FIELD_NAME_LEFT_EYE);
                this.checkIdUnsupportedThenNull(this.mRightEye, FIELD_NAME_RIGHT_EYE);
                this.checkIdUnsupportedThenNull(this.mMouth, FIELD_NAME_MOUTH);
            }
            Face.checkFace(this.mLeftEye, this.mRightEye, this.mMouth);
            this.mBuilderFieldsSet |= 1L;
            return new Face(this.mBounds, this.mScore, this.mId, this.mLeftEye, this.mRightEye, this.mMouth);
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 1L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }

        private void checkFieldSet(long field, String fieldName) {
            if ((this.mBuilderFieldsSet & field) == 0L) {
                throw new IllegalStateException("Field \"" + fieldName + "\" must be set before building.");
            }
        }

        private void checkIdUnsupportedThenNull(Object obj, String fieldName) {
            if (obj != null) {
                throw new IllegalArgumentException("Field \"" + fieldName + "\" must be unset or null if id is ID_UNSUPPORTED.");
            }
        }
    }
}

