/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.params.StreamConfigurationDuration;
import android.hardware.camera2.utils.TypeReference;
import java.nio.ByteBuffer;

public class MarshalQueryableStreamConfigurationDuration
implements MarshalQueryable<StreamConfigurationDuration> {
    private static final int SIZE = 32;
    private static final long MASK_UNSIGNED_INT = 0xFFFFFFFFL;

    @Override
    public Marshaler<StreamConfigurationDuration> createMarshaler(TypeReference<StreamConfigurationDuration> managedType, int nativeType) {
        return new MarshalerStreamConfigurationDuration(this, managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<StreamConfigurationDuration> managedType, int nativeType) {
        return nativeType == 3 && StreamConfigurationDuration.class.equals((Object)managedType.getType());
    }

    private class MarshalerStreamConfigurationDuration
    extends Marshaler<StreamConfigurationDuration> {
        protected MarshalerStreamConfigurationDuration(MarshalQueryableStreamConfigurationDuration marshalQueryableStreamConfigurationDuration, TypeReference<StreamConfigurationDuration> typeReference, int nativeType) {
            super(marshalQueryableStreamConfigurationDuration, typeReference, nativeType);
        }

        @Override
        public void marshal(StreamConfigurationDuration value, ByteBuffer buffer) {
            buffer.putLong((long)value.getFormat() & 0xFFFFFFFFL);
            buffer.putLong(value.getWidth());
            buffer.putLong(value.getHeight());
            buffer.putLong(value.getDuration());
        }

        @Override
        public StreamConfigurationDuration unmarshal(ByteBuffer buffer) {
            int format = (int)buffer.getLong();
            int width = (int)buffer.getLong();
            int height = (int)buffer.getLong();
            long durationNs = buffer.getLong();
            return new StreamConfigurationDuration(format, width, height, durationNs);
        }

        @Override
        public int getNativeSize() {
            return 32;
        }
    }
}

