/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.camera2.CaptureRequest;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CaptureFailure {
    public static final int REASON_ERROR = 0;
    public static final int REASON_FLUSHED = 1;
    private final CaptureRequest mRequest;
    private final int mReason;
    private final boolean mWasImageCaptured;
    private final int mSequenceId;
    private final long mFrameNumber;
    private final String mErrorPhysicalCameraId;

    public CaptureFailure(CaptureRequest request, int reason, boolean wasImageCaptured, int sequenceId, long frameNumber, String errorPhysicalCameraId) {
        this.mRequest = request;
        this.mReason = reason;
        this.mWasImageCaptured = wasImageCaptured;
        this.mSequenceId = sequenceId;
        this.mFrameNumber = frameNumber;
        this.mErrorPhysicalCameraId = errorPhysicalCameraId;
    }

    @NonNull
    public CaptureRequest getRequest() {
        return this.mRequest;
    }

    public long getFrameNumber() {
        return this.mFrameNumber;
    }

    public int getReason() {
        return this.mReason;
    }

    public boolean wasImageCaptured() {
        return this.mWasImageCaptured;
    }

    public int getSequenceId() {
        return this.mSequenceId;
    }

    @Nullable
    public String getPhysicalCameraId() {
        return this.mErrorPhysicalCameraId;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FailureReason {
    }
}

