/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.ExtensionSessionConfiguration;
import android.hardware.camera2.params.InputConfiguration;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.SessionConfiguration;
import android.os.Handler;
import android.view.Surface;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

public abstract class CameraDevice
implements AutoCloseable {
    public static final int TEMPLATE_PREVIEW = 1;
    public static final int TEMPLATE_STILL_CAPTURE = 2;
    public static final int TEMPLATE_RECORD = 3;
    public static final int TEMPLATE_VIDEO_SNAPSHOT = 4;
    public static final int TEMPLATE_ZERO_SHUTTER_LAG = 5;
    public static final int TEMPLATE_MANUAL = 6;
    public static final int AUDIO_RESTRICTION_NONE = 0;
    public static final int AUDIO_RESTRICTION_VIBRATION = 1;
    public static final int AUDIO_RESTRICTION_VIBRATION_SOUND = 3;
    @SystemApi
    public static final int SESSION_OPERATION_MODE_NORMAL = 0;
    @SystemApi
    public static final int SESSION_OPERATION_MODE_CONSTRAINED_HIGH_SPEED = 1;
    @SystemApi
    @FlaggedApi(value="com.android.internal.camera.flags.camera_multi_client")
    public static final int SESSION_OPERATION_MODE_SHARED = 2;
    @SystemApi
    public static final int SESSION_OPERATION_MODE_VENDOR_START = 32768;

    @NonNull
    public abstract String getId();

    @Deprecated
    public abstract void createCaptureSession(@NonNull List<Surface> var1, @NonNull CameraCaptureSession.StateCallback var2, @Nullable Handler var3) throws CameraAccessException;

    @Deprecated
    public abstract void createCaptureSessionByOutputConfigurations(List<OutputConfiguration> var1, CameraCaptureSession.StateCallback var2, @Nullable Handler var3) throws CameraAccessException;

    @Deprecated
    public abstract void createReprocessableCaptureSession(@NonNull InputConfiguration var1, @NonNull List<Surface> var2, @NonNull CameraCaptureSession.StateCallback var3, @Nullable Handler var4) throws CameraAccessException;

    @Deprecated
    public abstract void createReprocessableCaptureSessionByConfigurations(@NonNull InputConfiguration var1, @NonNull List<OutputConfiguration> var2, @NonNull CameraCaptureSession.StateCallback var3, @Nullable Handler var4) throws CameraAccessException;

    @Deprecated
    public abstract void createConstrainedHighSpeedCaptureSession(@NonNull List<Surface> var1, @NonNull CameraCaptureSession.StateCallback var2, @Nullable Handler var3) throws CameraAccessException;

    public void createExtensionSession(@NonNull ExtensionSessionConfiguration extensionConfiguration) throws CameraAccessException {
        throw new UnsupportedOperationException("No default implementation");
    }

    @SystemApi
    @Deprecated
    public abstract void createCustomCaptureSession(InputConfiguration var1, @NonNull List<OutputConfiguration> var2, int var3, @NonNull CameraCaptureSession.StateCallback var4, @Nullable Handler var5) throws CameraAccessException;

    public void createCaptureSession(SessionConfiguration config) throws CameraAccessException {
        throw new UnsupportedOperationException("No default implementation");
    }

    @NonNull
    public abstract CaptureRequest.Builder createCaptureRequest(int var1) throws CameraAccessException;

    @NonNull
    public CaptureRequest.Builder createCaptureRequest(int templateType, Set<String> physicalCameraIdSet) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    @NonNull
    public abstract CaptureRequest.Builder createReprocessCaptureRequest(@NonNull TotalCaptureResult var1) throws CameraAccessException;

    @Override
    public abstract void close();

    public boolean isSessionConfigurationSupported(@NonNull SessionConfiguration sessionConfig) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public void setCameraAudioRestriction(int mode) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public int getCameraAudioRestriction() throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public static abstract class CameraDeviceSetup {
        @NonNull
        public abstract CaptureRequest.Builder createCaptureRequest(int var1) throws CameraAccessException;

        public abstract boolean isSessionConfigurationSupported(@NonNull SessionConfiguration var1) throws CameraAccessException;

        @NonNull
        public abstract CameraCharacteristics getSessionCharacteristics(@NonNull SessionConfiguration var1) throws CameraAccessException;

        @RequiresPermission(value="android.permission.CAMERA")
        public abstract void openCamera(@NonNull Executor var1, @NonNull StateCallback var2) throws CameraAccessException;

        @NonNull
        public abstract String getId();
    }

    public static abstract class StateCallback {
        public static final int ERROR_CAMERA_IN_USE = 1;
        public static final int ERROR_MAX_CAMERAS_IN_USE = 2;
        public static final int ERROR_CAMERA_DISABLED = 3;
        public static final int ERROR_CAMERA_DEVICE = 4;
        public static final int ERROR_CAMERA_SERVICE = 5;

        public abstract void onOpened(@NonNull CameraDevice var1);

        @SystemApi
        @FlaggedApi(value="com.android.internal.camera.flags.camera_multi_client")
        public void onOpenedInSharedMode(@NonNull CameraDevice camera, boolean isPrimaryClient) {
        }

        @SystemApi
        @FlaggedApi(value="com.android.internal.camera.flags.camera_multi_client")
        public void onClientSharedAccessPriorityChanged(@NonNull CameraDevice camera, boolean isPrimaryClient) {
        }

        public void onClosed(@NonNull CameraDevice camera) {
        }

        public abstract void onDisconnected(@NonNull CameraDevice var1);

        public abstract void onError(@NonNull CameraDevice var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ErrorCode {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SessionOperatingMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CAMERA_AUDIO_RESTRICTION {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestTemplate {
    }
}

