/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics.face;

import android.hardware.biometrics.face.AuthenticationFrame;
import android.hardware.biometrics.face.EnrollmentFrame;
import android.hardware.keymaster.HardwareAuthToken;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISessionCallback
extends IInterface {
    public static final int VERSION = 4;
    public static final String HASH = "c43fbb9be4a662cc9ace640dba21cccdb84c6c21";
    public static final String DESCRIPTOR = "android$hardware$biometrics$face$ISessionCallback".replace('$', '.');

    public void onChallengeGenerated(long var1) throws RemoteException;

    public void onChallengeRevoked(long var1) throws RemoteException;

    public void onAuthenticationFrame(AuthenticationFrame var1) throws RemoteException;

    public void onEnrollmentFrame(EnrollmentFrame var1) throws RemoteException;

    public void onError(byte var1, int var2) throws RemoteException;

    public void onEnrollmentProgress(int var1, int var2) throws RemoteException;

    public void onAuthenticationSucceeded(int var1, HardwareAuthToken var2) throws RemoteException;

    public void onAuthenticationFailed() throws RemoteException;

    public void onLockoutTimed(long var1) throws RemoteException;

    public void onLockoutPermanent() throws RemoteException;

    public void onLockoutCleared() throws RemoteException;

    public void onInteractionDetected() throws RemoteException;

    public void onEnrollmentsEnumerated(int[] var1) throws RemoteException;

    public void onFeaturesRetrieved(byte[] var1) throws RemoteException;

    public void onFeatureSet(byte var1) throws RemoteException;

    public void onEnrollmentsRemoved(int[] var1) throws RemoteException;

    public void onAuthenticatorIdRetrieved(long var1) throws RemoteException;

    public void onAuthenticatorIdInvalidated(long var1) throws RemoteException;

    public void onSessionClosed() throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public String getInterfaceHash() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISessionCallback {
        static final int TRANSACTION_onChallengeGenerated = 1;
        static final int TRANSACTION_onChallengeRevoked = 2;
        static final int TRANSACTION_onAuthenticationFrame = 3;
        static final int TRANSACTION_onEnrollmentFrame = 4;
        static final int TRANSACTION_onError = 5;
        static final int TRANSACTION_onEnrollmentProgress = 6;
        static final int TRANSACTION_onAuthenticationSucceeded = 7;
        static final int TRANSACTION_onAuthenticationFailed = 8;
        static final int TRANSACTION_onLockoutTimed = 9;
        static final int TRANSACTION_onLockoutPermanent = 10;
        static final int TRANSACTION_onLockoutCleared = 11;
        static final int TRANSACTION_onInteractionDetected = 12;
        static final int TRANSACTION_onEnrollmentsEnumerated = 13;
        static final int TRANSACTION_onFeaturesRetrieved = 14;
        static final int TRANSACTION_onFeatureSet = 15;
        static final int TRANSACTION_onEnrollmentsRemoved = 16;
        static final int TRANSACTION_onAuthenticatorIdRetrieved = 17;
        static final int TRANSACTION_onAuthenticatorIdInvalidated = 18;
        static final int TRANSACTION_onSessionClosed = 19;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;
        static final int TRANSACTION_getInterfaceHash = 0xFFFFFE;

        public Stub() {
            this.markVintfStability();
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISessionCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISessionCallback) {
                return (ISessionCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onChallengeGenerated";
                }
                case 2: {
                    return "onChallengeRevoked";
                }
                case 3: {
                    return "onAuthenticationFrame";
                }
                case 4: {
                    return "onEnrollmentFrame";
                }
                case 5: {
                    return "onError";
                }
                case 6: {
                    return "onEnrollmentProgress";
                }
                case 7: {
                    return "onAuthenticationSucceeded";
                }
                case 8: {
                    return "onAuthenticationFailed";
                }
                case 9: {
                    return "onLockoutTimed";
                }
                case 10: {
                    return "onLockoutPermanent";
                }
                case 11: {
                    return "onLockoutCleared";
                }
                case 12: {
                    return "onInteractionDetected";
                }
                case 13: {
                    return "onEnrollmentsEnumerated";
                }
                case 14: {
                    return "onFeaturesRetrieved";
                }
                case 15: {
                    return "onFeatureSet";
                }
                case 16: {
                    return "onEnrollmentsRemoved";
                }
                case 17: {
                    return "onAuthenticatorIdRetrieved";
                }
                case 18: {
                    return "onAuthenticatorIdInvalidated";
                }
                case 19: {
                    return "onSessionClosed";
                }
                case 0xFFFFFF: {
                    return "getInterfaceVersion";
                }
                case 0xFFFFFE: {
                    return "getInterfaceHash";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            if (code == 0xFFFFFF) {
                reply.writeNoException();
                reply.writeInt(this.getInterfaceVersion());
                return true;
            }
            if (code == 0xFFFFFE) {
                reply.writeNoException();
                reply.writeString(this.getInterfaceHash());
                return true;
            }
            switch (code) {
                case 1: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onChallengeGenerated(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onChallengeRevoked(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    AuthenticationFrame _arg0 = data.readTypedObject(AuthenticationFrame.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAuthenticationFrame(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    EnrollmentFrame _arg0 = data.readTypedObject(EnrollmentFrame.CREATOR);
                    data.enforceNoDataAvail();
                    this.onEnrollmentFrame(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    byte _arg0 = data.readByte();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onError(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onEnrollmentProgress(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    HardwareAuthToken _arg1 = data.readTypedObject(HardwareAuthToken.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAuthenticationSucceeded(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    this.onAuthenticationFailed();
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onLockoutTimed(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    this.onLockoutPermanent();
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    this.onLockoutCleared();
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    this.onInteractionDetected();
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.onEnrollmentsEnumerated(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    byte[] _arg0 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onFeaturesRetrieved(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    byte _arg0 = data.readByte();
                    data.enforceNoDataAvail();
                    this.onFeatureSet(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.onEnrollmentsRemoved(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onAuthenticatorIdRetrieved(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onAuthenticatorIdInvalidated(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    this.onSessionClosed();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0xFFFFFE;
        }

        private static class Proxy
        implements ISessionCallback {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            private String mCachedHash = "-1";

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChallengeGenerated(long challenge) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeLong(challenge);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onChallengeGenerated is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChallengeRevoked(long challenge) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeLong(challenge);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onChallengeRevoked is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationFrame(AuthenticationFrame frame) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(frame, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onAuthenticationFrame is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnrollmentFrame(EnrollmentFrame frame) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(frame, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onEnrollmentFrame is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(byte error, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByte(error);
                    _data.writeInt(vendorCode);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onError is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnrollmentProgress(int enrollmentId, int remaining) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(enrollmentId);
                    _data.writeInt(remaining);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onEnrollmentProgress is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationSucceeded(int enrollmentId, HardwareAuthToken hat) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(enrollmentId);
                    _data.writeTypedObject(hat, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onAuthenticationSucceeded is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationFailed() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onAuthenticationFailed is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLockoutTimed(long durationMillis) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeLong(durationMillis);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onLockoutTimed is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLockoutPermanent() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onLockoutPermanent is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLockoutCleared() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onLockoutCleared is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInteractionDetected() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onInteractionDetected is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnrollmentsEnumerated(int[] enrollmentIds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeIntArray(enrollmentIds);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onEnrollmentsEnumerated is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFeaturesRetrieved(byte[] features) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByteArray(features);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onFeaturesRetrieved is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFeatureSet(byte feature) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByte(feature);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onFeatureSet is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnrollmentsRemoved(int[] enrollmentIds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeIntArray(enrollmentIds);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onEnrollmentsRemoved is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticatorIdRetrieved(long authenticatorId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeLong(authenticatorId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onAuthenticatorIdRetrieved is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticatorIdInvalidated(long newAuthenticatorId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeLong(newAuthenticatorId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onAuthenticatorIdInvalidated is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionClosed() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onSessionClosed is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain(this.asBinder());
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized String getInterfaceHash() throws RemoteException {
                if ("-1".equals(this.mCachedHash)) {
                    Parcel data = Parcel.obtain(this.asBinder());
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFE, data, reply, 0);
                        reply.readException();
                        this.mCachedHash = reply.readString();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedHash;
            }
        }
    }

    public static class Default
    implements ISessionCallback {
        @Override
        public void onChallengeGenerated(long challenge) throws RemoteException {
        }

        @Override
        public void onChallengeRevoked(long challenge) throws RemoteException {
        }

        @Override
        public void onAuthenticationFrame(AuthenticationFrame frame) throws RemoteException {
        }

        @Override
        public void onEnrollmentFrame(EnrollmentFrame frame) throws RemoteException {
        }

        @Override
        public void onError(byte error, int vendorCode) throws RemoteException {
        }

        @Override
        public void onEnrollmentProgress(int enrollmentId, int remaining) throws RemoteException {
        }

        @Override
        public void onAuthenticationSucceeded(int enrollmentId, HardwareAuthToken hat) throws RemoteException {
        }

        @Override
        public void onAuthenticationFailed() throws RemoteException {
        }

        @Override
        public void onLockoutTimed(long durationMillis) throws RemoteException {
        }

        @Override
        public void onLockoutPermanent() throws RemoteException {
        }

        @Override
        public void onLockoutCleared() throws RemoteException {
        }

        @Override
        public void onInteractionDetected() throws RemoteException {
        }

        @Override
        public void onEnrollmentsEnumerated(int[] enrollmentIds) throws RemoteException {
        }

        @Override
        public void onFeaturesRetrieved(byte[] features) throws RemoteException {
        }

        @Override
        public void onFeatureSet(byte feature) throws RemoteException {
        }

        @Override
        public void onEnrollmentsRemoved(int[] enrollmentIds) throws RemoteException {
        }

        @Override
        public void onAuthenticatorIdRetrieved(long authenticatorId) throws RemoteException {
        }

        @Override
        public void onAuthenticatorIdInvalidated(long newAuthenticatorId) throws RemoteException {
        }

        @Override
        public void onSessionClosed() throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return 0;
        }

        @Override
        public String getInterfaceHash() {
            return "";
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

