/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics.face;

import android.hardware.biometrics.common.ICancellationSignal;
import android.hardware.biometrics.common.OperationContext;
import android.hardware.biometrics.face.EnrollmentStageConfig;
import android.hardware.biometrics.face.FaceEnrollOptions;
import android.hardware.common.NativeHandle;
import android.hardware.keymaster.HardwareAuthToken;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface ISession
extends IInterface {
    public static final int VERSION = 4;
    public static final String HASH = "c43fbb9be4a662cc9ace640dba21cccdb84c6c21";
    public static final String DESCRIPTOR = "android$hardware$biometrics$face$ISession".replace('$', '.');

    public void generateChallenge() throws RemoteException;

    public void revokeChallenge(long var1) throws RemoteException;

    public EnrollmentStageConfig[] getEnrollmentConfig(byte var1) throws RemoteException;

    @Deprecated
    public ICancellationSignal enroll(HardwareAuthToken var1, byte var2, byte[] var3, NativeHandle var4) throws RemoteException;

    public ICancellationSignal authenticate(long var1) throws RemoteException;

    public ICancellationSignal detectInteraction() throws RemoteException;

    public void enumerateEnrollments() throws RemoteException;

    public void removeEnrollments(int[] var1) throws RemoteException;

    public void getFeatures() throws RemoteException;

    public void setFeature(HardwareAuthToken var1, byte var2, boolean var3) throws RemoteException;

    public void getAuthenticatorId() throws RemoteException;

    public void invalidateAuthenticatorId() throws RemoteException;

    public void resetLockout(HardwareAuthToken var1) throws RemoteException;

    public void close() throws RemoteException;

    public ICancellationSignal authenticateWithContext(long var1, OperationContext var3) throws RemoteException;

    @Deprecated
    public ICancellationSignal enrollWithContext(HardwareAuthToken var1, byte var2, byte[] var3, NativeHandle var4, OperationContext var5) throws RemoteException;

    public ICancellationSignal detectInteractionWithContext(OperationContext var1) throws RemoteException;

    public void onContextChanged(OperationContext var1) throws RemoteException;

    public ICancellationSignal enrollWithOptions(FaceEnrollOptions var1) throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public String getInterfaceHash() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISession {
        static final int TRANSACTION_generateChallenge = 1;
        static final int TRANSACTION_revokeChallenge = 2;
        static final int TRANSACTION_getEnrollmentConfig = 3;
        static final int TRANSACTION_enroll = 4;
        static final int TRANSACTION_authenticate = 5;
        static final int TRANSACTION_detectInteraction = 6;
        static final int TRANSACTION_enumerateEnrollments = 7;
        static final int TRANSACTION_removeEnrollments = 8;
        static final int TRANSACTION_getFeatures = 9;
        static final int TRANSACTION_setFeature = 10;
        static final int TRANSACTION_getAuthenticatorId = 11;
        static final int TRANSACTION_invalidateAuthenticatorId = 12;
        static final int TRANSACTION_resetLockout = 13;
        static final int TRANSACTION_close = 14;
        static final int TRANSACTION_authenticateWithContext = 15;
        static final int TRANSACTION_enrollWithContext = 16;
        static final int TRANSACTION_detectInteractionWithContext = 17;
        static final int TRANSACTION_onContextChanged = 18;
        static final int TRANSACTION_enrollWithOptions = 19;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;
        static final int TRANSACTION_getInterfaceHash = 0xFFFFFE;

        public Stub() {
            this.markVintfStability();
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISession) {
                return (ISession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "generateChallenge";
                }
                case 2: {
                    return "revokeChallenge";
                }
                case 3: {
                    return "getEnrollmentConfig";
                }
                case 4: {
                    return "enroll";
                }
                case 5: {
                    return "authenticate";
                }
                case 6: {
                    return "detectInteraction";
                }
                case 7: {
                    return "enumerateEnrollments";
                }
                case 8: {
                    return "removeEnrollments";
                }
                case 9: {
                    return "getFeatures";
                }
                case 10: {
                    return "setFeature";
                }
                case 11: {
                    return "getAuthenticatorId";
                }
                case 12: {
                    return "invalidateAuthenticatorId";
                }
                case 13: {
                    return "resetLockout";
                }
                case 14: {
                    return "close";
                }
                case 15: {
                    return "authenticateWithContext";
                }
                case 16: {
                    return "enrollWithContext";
                }
                case 17: {
                    return "detectInteractionWithContext";
                }
                case 18: {
                    return "onContextChanged";
                }
                case 19: {
                    return "enrollWithOptions";
                }
                case 0xFFFFFF: {
                    return "getInterfaceVersion";
                }
                case 0xFFFFFE: {
                    return "getInterfaceHash";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            if (code == 0xFFFFFF) {
                reply.writeNoException();
                reply.writeInt(this.getInterfaceVersion());
                return true;
            }
            if (code == 0xFFFFFE) {
                reply.writeNoException();
                reply.writeString(this.getInterfaceHash());
                return true;
            }
            switch (code) {
                case 1: {
                    this.generateChallenge();
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.revokeChallenge(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    byte _arg0 = data.readByte();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getEnrollmentConfig(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 4: {
                    HardwareAuthToken _arg0 = data.readTypedObject(HardwareAuthToken.CREATOR);
                    byte _arg1 = data.readByte();
                    byte[] _arg2 = data.createByteArray();
                    NativeHandle _arg3 = data.readTypedObject(NativeHandle.CREATOR);
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.enroll(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 5: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.authenticate(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 6: {
                    ICancellationSignal _result = this.detectInteraction();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 7: {
                    this.enumerateEnrollments();
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.removeEnrollments(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    this.getFeatures();
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    HardwareAuthToken _arg0 = data.readTypedObject(HardwareAuthToken.CREATOR);
                    byte _arg1 = data.readByte();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setFeature(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    this.getAuthenticatorId();
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    this.invalidateAuthenticatorId();
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    HardwareAuthToken _arg0 = data.readTypedObject(HardwareAuthToken.CREATOR);
                    data.enforceNoDataAvail();
                    this.resetLockout(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    this.close();
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    long _arg0 = data.readLong();
                    OperationContext _arg1 = data.readTypedObject(OperationContext.CREATOR);
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.authenticateWithContext(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 16: {
                    HardwareAuthToken _arg0 = data.readTypedObject(HardwareAuthToken.CREATOR);
                    byte _arg1 = data.readByte();
                    byte[] _arg2 = data.createByteArray();
                    NativeHandle _arg3 = data.readTypedObject(NativeHandle.CREATOR);
                    OperationContext _arg4 = data.readTypedObject(OperationContext.CREATOR);
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.enrollWithContext(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 17: {
                    OperationContext _arg0 = data.readTypedObject(OperationContext.CREATOR);
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.detectInteractionWithContext(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 18: {
                    OperationContext _arg0 = data.readTypedObject(OperationContext.CREATOR);
                    data.enforceNoDataAvail();
                    this.onContextChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    FaceEnrollOptions _arg0 = data.readTypedObject(FaceEnrollOptions.CREATOR);
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.enrollWithOptions(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0xFFFFFE;
        }

        private static class Proxy
        implements ISession {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            private String mCachedHash = "-1";

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generateChallenge() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method generateChallenge is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeChallenge(long challenge) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeLong(challenge);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method revokeChallenge is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EnrollmentStageConfig[] getEnrollmentConfig(byte enrollmentType) throws RemoteException {
                EnrollmentStageConfig[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByte(enrollmentType);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method getEnrollmentConfig is unimplemented.");
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(EnrollmentStageConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal enroll(HardwareAuthToken hat, byte type, byte[] features, NativeHandle previewSurface) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(hat, 0);
                    _data.writeByte(type);
                    _data.writeByteArray(features);
                    _data.writeTypedObject(previewSurface, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method enroll is unimplemented.");
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal authenticate(long operationId) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeLong(operationId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method authenticate is unimplemented.");
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal detectInteraction() throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method detectInteraction is unimplemented.");
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enumerateEnrollments() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method enumerateEnrollments is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeEnrollments(int[] enrollmentIds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeIntArray(enrollmentIds);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method removeEnrollments is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getFeatures() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method getFeatures is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFeature(HardwareAuthToken hat, byte feature, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(hat, 0);
                    _data.writeByte(feature);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method setFeature is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAuthenticatorId() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method getAuthenticatorId is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invalidateAuthenticatorId() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method invalidateAuthenticatorId is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetLockout(HardwareAuthToken hat) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(hat, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method resetLockout is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method close is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal authenticateWithContext(long operationId, OperationContext context) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeLong(operationId);
                    _data.writeTypedObject(context, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method authenticateWithContext is unimplemented.");
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal enrollWithContext(HardwareAuthToken hat, byte type, byte[] features, NativeHandle previewSurface, OperationContext context) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(hat, 0);
                    _data.writeByte(type);
                    _data.writeByteArray(features);
                    _data.writeTypedObject(previewSurface, 0);
                    _data.writeTypedObject(context, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method enrollWithContext is unimplemented.");
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal detectInteractionWithContext(OperationContext context) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(context, 0);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method detectInteractionWithContext is unimplemented.");
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onContextChanged(OperationContext context) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(context, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onContextChanged is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal enrollWithOptions(FaceEnrollOptions options) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method enrollWithOptions is unimplemented.");
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain(this.asBinder());
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized String getInterfaceHash() throws RemoteException {
                if ("-1".equals(this.mCachedHash)) {
                    Parcel data = Parcel.obtain(this.asBinder());
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFE, data, reply, 0);
                        reply.readException();
                        this.mCachedHash = reply.readString();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedHash;
            }
        }
    }

    public static class Default
    implements ISession {
        @Override
        public void generateChallenge() throws RemoteException {
        }

        @Override
        public void revokeChallenge(long challenge) throws RemoteException {
        }

        @Override
        public EnrollmentStageConfig[] getEnrollmentConfig(byte enrollmentType) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal enroll(HardwareAuthToken hat, byte type, byte[] features, NativeHandle previewSurface) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal authenticate(long operationId) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal detectInteraction() throws RemoteException {
            return null;
        }

        @Override
        public void enumerateEnrollments() throws RemoteException {
        }

        @Override
        public void removeEnrollments(int[] enrollmentIds) throws RemoteException {
        }

        @Override
        public void getFeatures() throws RemoteException {
        }

        @Override
        public void setFeature(HardwareAuthToken hat, byte feature, boolean enabled) throws RemoteException {
        }

        @Override
        public void getAuthenticatorId() throws RemoteException {
        }

        @Override
        public void invalidateAuthenticatorId() throws RemoteException {
        }

        @Override
        public void resetLockout(HardwareAuthToken hat) throws RemoteException {
        }

        @Override
        public void close() throws RemoteException {
        }

        @Override
        public ICancellationSignal authenticateWithContext(long operationId, OperationContext context) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal enrollWithContext(HardwareAuthToken hat, byte type, byte[] features, NativeHandle previewSurface, OperationContext context) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal detectInteractionWithContext(OperationContext context) throws RemoteException {
            return null;
        }

        @Override
        public void onContextChanged(OperationContext context) throws RemoteException {
        }

        @Override
        public ICancellationSignal enrollWithOptions(FaceEnrollOptions options) throws RemoteException {
            return null;
        }

        @Override
        public int getInterfaceVersion() {
            return 0;
        }

        @Override
        public String getInterfaceHash() {
            return "";
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

