/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics.events;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.biometrics.BiometricRequestConstants;
import android.hardware.biometrics.BiometricSourceType;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class AuthenticationErrorInfo
implements Parcelable {
    @NonNull
    private final BiometricSourceType mBiometricSourceType;
    private final int mRequestReason;
    @Nullable
    private final String mErrString;
    private final int mErrCode;
    @NonNull
    public static final Parcelable.Creator<AuthenticationErrorInfo> CREATOR = new Parcelable.Creator<AuthenticationErrorInfo>(){

        public AuthenticationErrorInfo[] newArray(int size) {
            return new AuthenticationErrorInfo[size];
        }

        @Override
        public AuthenticationErrorInfo createFromParcel(@NonNull Parcel in) {
            return new AuthenticationErrorInfo(in);
        }
    };

    AuthenticationErrorInfo(@NonNull BiometricSourceType biometricSourceType, int requestReason, @Nullable String errString, int errCode) {
        this.mBiometricSourceType = biometricSourceType;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
        this.mRequestReason = requestReason;
        AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
        this.mErrString = errString;
        this.mErrCode = errCode;
    }

    @NonNull
    public BiometricSourceType getBiometricSourceType() {
        return this.mBiometricSourceType;
    }

    public int getRequestReason() {
        return this.mRequestReason;
    }

    @Nullable
    public String getErrString() {
        return this.mErrString;
    }

    public int getErrCode() {
        return this.mErrCode;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationErrorInfo that = (AuthenticationErrorInfo)o;
        return Objects.equals(this.mBiometricSourceType, that.mBiometricSourceType) && this.mRequestReason == that.mRequestReason && Objects.equals(this.mErrString, that.mErrString) && this.mErrCode == that.mErrCode;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mBiometricSourceType);
        _hash = 31 * _hash + this.mRequestReason;
        _hash = 31 * _hash + Objects.hashCode(this.mErrString);
        _hash = 31 * _hash + this.mErrCode;
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mErrString != null) {
            flg = (byte)(flg | 4);
        }
        dest.writeByte(flg);
        dest.writeTypedObject(this.mBiometricSourceType, flags);
        dest.writeInt(this.mRequestReason);
        if (this.mErrString != null) {
            dest.writeString(this.mErrString);
        }
        dest.writeInt(this.mErrCode);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    AuthenticationErrorInfo(@NonNull Parcel in) {
        byte flg = in.readByte();
        BiometricSourceType biometricSourceType = in.readTypedObject(BiometricSourceType.CREATOR);
        int requestReason = in.readInt();
        String errString = (flg & 4) == 0 ? null : in.readString();
        int errCode = in.readInt();
        this.mBiometricSourceType = biometricSourceType;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
        this.mRequestReason = requestReason;
        AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
        this.mErrString = errString;
        this.mErrCode = errCode;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        @NonNull
        private BiometricSourceType mBiometricSourceType;
        private int mRequestReason;
        @Nullable
        private String mErrString;
        private int mErrCode;
        private long mBuilderFieldsSet = 0L;

        public Builder(@NonNull BiometricSourceType biometricSourceType, int requestReason, @Nullable String errString, int errCode) {
            this.mBiometricSourceType = biometricSourceType;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
            this.mRequestReason = requestReason;
            AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
            this.mErrString = errString;
            this.mErrCode = errCode;
        }

        @NonNull
        public Builder setBiometricSourceType(@NonNull BiometricSourceType value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mBiometricSourceType = value;
            return this;
        }

        @NonNull
        public Builder setRequestReason(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mRequestReason = value;
            return this;
        }

        @NonNull
        public Builder setErrString(@NonNull String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mErrString = value;
            return this;
        }

        @NonNull
        public Builder setErrCode(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mErrCode = value;
            return this;
        }

        @NonNull
        public AuthenticationErrorInfo build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            AuthenticationErrorInfo o = new AuthenticationErrorInfo(this.mBiometricSourceType, this.mRequestReason, this.mErrString, this.mErrCode);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x10L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

