/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.content.DialogInterface;
import android.hardware.biometrics.BiometricPrompt;
import android.hardware.biometrics.PromptContentViewParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.util.concurrent.Executor;

public class PromptContentViewWithMoreOptionsButton
implements PromptContentViewParcelable {
    private static final String TAG = "PromptContentViewWithMoreOptionsButton";
    @VisibleForTesting
    static final int MAX_DESCRIPTION_CHARACTER_NUMBER = 225;
    private final String mDescription;
    private DialogInterface.OnClickListener mListener;
    private BiometricPrompt.ButtonInfo mButtonInfo;
    @NonNull
    public static final Parcelable.Creator<PromptContentViewWithMoreOptionsButton> CREATOR = new Parcelable.Creator<PromptContentViewWithMoreOptionsButton>(){

        @Override
        public PromptContentViewWithMoreOptionsButton createFromParcel(Parcel in) {
            return new PromptContentViewWithMoreOptionsButton(in);
        }

        public PromptContentViewWithMoreOptionsButton[] newArray(int size) {
            return new PromptContentViewWithMoreOptionsButton[size];
        }
    };

    private PromptContentViewWithMoreOptionsButton(@NonNull String description, @NonNull Executor executor, @NonNull DialogInterface.OnClickListener listener) {
        this.mDescription = description;
        this.mListener = listener;
        this.mButtonInfo = new BiometricPrompt.ButtonInfo(executor, listener);
    }

    private PromptContentViewWithMoreOptionsButton(Parcel in) {
        this.mDescription = in.readString();
    }

    @RequiresPermission(value="android.permission.SET_BIOMETRIC_DIALOG_ADVANCED")
    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    @RequiresPermission(value="android.permission.SET_BIOMETRIC_DIALOG_ADVANCED")
    @NonNull
    public DialogInterface.OnClickListener getMoreOptionsButtonListener() {
        return this.mListener;
    }

    BiometricPrompt.ButtonInfo getButtonInfo() {
        return this.mButtonInfo;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mDescription);
    }

    public static class Builder {
        private String mDescription;
        private Executor mExecutor;
        private DialogInterface.OnClickListener mListener;

        @NonNull
        @RequiresPermission(value="android.permission.SET_BIOMETRIC_DIALOG_ADVANCED")
        public Builder setDescription(@NonNull String description) {
            if (description.length() > 225) {
                Log.w(PromptContentViewWithMoreOptionsButton.TAG, "The character number of description exceeds 225");
            }
            this.mDescription = description;
            return this;
        }

        @NonNull
        @RequiresPermission(value="android.permission.SET_BIOMETRIC_DIALOG_ADVANCED")
        public Builder setMoreOptionsButtonListener(@NonNull Executor executor, @NonNull DialogInterface.OnClickListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
            return this;
        }

        @NonNull
        @RequiresPermission(value="android.permission.SET_BIOMETRIC_DIALOG_ADVANCED")
        public PromptContentViewWithMoreOptionsButton build() {
            if (this.mExecutor == null) {
                throw new IllegalArgumentException("The executor for the listener of more options button on prompt content must be set and non-null if PromptContentViewWithMoreOptionsButton is used.");
            }
            if (this.mListener == null) {
                throw new IllegalArgumentException("The listener of more options button on prompt content must be set and non-null if PromptContentViewWithMoreOptionsButton is used.");
            }
            return new PromptContentViewWithMoreOptionsButton(this.mDescription, this.mExecutor, this.mListener);
        }
    }
}

