/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.hardware.LutProperties;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.tools.layoutlib.create.OverrideMethod;
import libcore.util.NativeAllocationRegistry;

@FlaggedApi(value="android.hardware.flags.overlayproperties_class_api")
public class OverlayProperties
implements Parcelable {
    private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(OverlayProperties.class.getClassLoader(), OverlayProperties.nGetDestructor());
    private long mNativeObject;
    private static OverlayProperties sDefaultOverlayProperties;
    private Runnable mCloser;
    private LutProperties[] mLutProperties;
    @FlaggedApi(value="android.hardware.flags.overlayproperties_class_api")
    @NonNull
    public static final Parcelable.Creator<OverlayProperties> CREATOR;

    private OverlayProperties(long nativeObject) {
        if (nativeObject != 0L) {
            this.mCloser = sRegistry.registerNativeAllocation(this, nativeObject);
        }
        this.mNativeObject = nativeObject;
    }

    public static OverlayProperties getDefault() {
        if (sDefaultOverlayProperties == null) {
            sDefaultOverlayProperties = new OverlayProperties(OverlayProperties.nCreateDefault());
        }
        return sDefaultOverlayProperties;
    }

    @FlaggedApi(value="android.hardware.flags.luts_api")
    @SuppressLint(value={"ArrayReturn"})
    @NonNull
    public LutProperties[] getLutProperties() {
        if (this.mNativeObject == 0L) {
            return null;
        }
        if (this.mLutProperties == null) {
            this.mLutProperties = OverlayProperties.nGetLutProperties(this.mNativeObject);
        }
        return this.mLutProperties;
    }

    @FlaggedApi(value="android.hardware.flags.overlayproperties_class_api")
    public boolean isCombinationSupported(int dataspace, int format) {
        if (this.mNativeObject == 0L) {
            return false;
        }
        return OverlayProperties.nIsCombinationSupported(this.mNativeObject, dataspace, format);
    }

    @FlaggedApi(value="android.hardware.flags.overlayproperties_class_api")
    public boolean isMixedColorSpacesSupported() {
        if (this.mNativeObject == 0L) {
            return false;
        }
        return OverlayProperties.nSupportMixedColorSpaces(this.mNativeObject);
    }

    @Override
    @FlaggedApi(value="android.hardware.flags.overlayproperties_class_api")
    public int describeContents() {
        return 0;
    }

    @Override
    @FlaggedApi(value="android.hardware.flags.overlayproperties_class_api")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        if (this.mNativeObject == 0L) {
            dest.writeInt(0);
            return;
        }
        dest.writeInt(1);
        OverlayProperties.nWriteOverlayPropertiesToParcel(this.mNativeObject, dest);
    }

    private static long nGetDestructor() {
        return OverrideMethod.invokeL("android.hardware.OverlayProperties#nGetDestructor()J", true, null);
    }

    private static long nCreateDefault() {
        return OverrideMethod.invokeL("android.hardware.OverlayProperties#nCreateDefault()J", true, null);
    }

    private static boolean nSupportMixedColorSpaces(long l) {
        return OverrideMethod.invokeI("android.hardware.OverlayProperties#nSupportMixedColorSpaces(J)Z", true, null) != 0;
    }

    private static boolean nIsCombinationSupported(long l, int n, int n2) {
        return OverrideMethod.invokeI("android.hardware.OverlayProperties#nIsCombinationSupported(JII)Z", true, null) != 0;
    }

    private static void nWriteOverlayPropertiesToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.hardware.OverlayProperties#nWriteOverlayPropertiesToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static long nReadOverlayPropertiesFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("android.hardware.OverlayProperties#nReadOverlayPropertiesFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    private static LutProperties[] nGetLutProperties(long l) {
        return (LutProperties[])OverrideMethod.invokeA("android.hardware.OverlayProperties#nGetLutProperties(J)[Landroid/hardware/LutProperties;", true, null);
    }

    static {
        CREATOR = new Parcelable.Creator<OverlayProperties>(){

            @Override
            public OverlayProperties createFromParcel(Parcel in) {
                if (in.readInt() != 0) {
                    return new OverlayProperties(OverlayProperties.nReadOverlayPropertiesFromParcel(in));
                }
                return null;
            }

            public OverlayProperties[] newArray(int size) {
                return new OverlayProperties[size];
            }
        };
    }
}

