/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.annotation.FlaggedApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class DataSpace {
    private static final int STANDARD_MASK = 0x3F0000;
    public static final int STANDARD_UNSPECIFIED = 0;
    public static final int STANDARD_BT709 = 65536;
    public static final int STANDARD_BT601_625 = 131072;
    public static final int STANDARD_BT601_625_UNADJUSTED = 196608;
    public static final int STANDARD_BT601_525 = 262144;
    public static final int STANDARD_BT601_525_UNADJUSTED = 327680;
    public static final int STANDARD_BT2020 = 393216;
    public static final int STANDARD_BT2020_CONSTANT_LUMINANCE = 458752;
    public static final int STANDARD_BT470M = 524288;
    public static final int STANDARD_FILM = 589824;
    public static final int STANDARD_DCI_P3 = 655360;
    public static final int STANDARD_ADOBE_RGB = 720896;
    private static final int TRANSFER_MASK = 0x7C00000;
    public static final int TRANSFER_UNSPECIFIED = 0;
    public static final int TRANSFER_LINEAR = 0x400000;
    public static final int TRANSFER_SRGB = 0x800000;
    public static final int TRANSFER_SMPTE_170M = 0xC00000;
    public static final int TRANSFER_GAMMA2_2 = 0x1000000;
    public static final int TRANSFER_GAMMA2_6 = 0x1400000;
    public static final int TRANSFER_GAMMA2_8 = 0x1800000;
    public static final int TRANSFER_ST2084 = 0x1C00000;
    public static final int TRANSFER_HLG = 0x2000000;
    private static final int RANGE_MASK = 0x38000000;
    public static final int RANGE_UNSPECIFIED = 0;
    public static final int RANGE_FULL = 0x8000000;
    public static final int RANGE_LIMITED = 0x10000000;
    public static final int RANGE_EXTENDED = 0x18000000;
    public static final int DATASPACE_DEPTH = 4096;
    public static final int DATASPACE_DYNAMIC_DEPTH = 4098;
    public static final int DATASPACE_HEIF = 4100;
    public static final int DATASPACE_JPEG_R = 4101;
    @FlaggedApi(value="com.android.internal.camera.flags.camera_heif_gainmap")
    public static final int DATASPACE_HEIF_ULTRAHDR = 4102;
    public static final int DATASPACE_UNKNOWN = 0;
    public static final int DATASPACE_SCRGB_LINEAR = 406913024;
    public static final int DATASPACE_SRGB = 0x8810000;
    public static final int DATASPACE_SCRGB = 0x18810000;
    public static final int DATASPACE_DISPLAY_P3 = 0x88A0000;
    public static final int DATASPACE_BT2020_HLG = 0xA060000;
    public static final int DATASPACE_BT2020_PQ = 163971072;
    public static final int DATASPACE_ADOBE_RGB = 0x90B0000;
    public static final int DATASPACE_JFIF = 146931712;
    public static final int DATASPACE_BT601_625 = 281149440;
    public static final int DATASPACE_BT601_525 = 281280512;
    public static final int DATASPACE_BT2020 = 147193856;
    public static final int DATASPACE_BT709 = 0x10C10000;
    public static final int DATASPACE_DCI_P3 = 155844608;
    public static final int DATASPACE_SRGB_LINEAR = 138477568;
    @FlaggedApi(value="com.android.graphics.flags.display_bt2020_colorspace")
    public static final int DATASPACE_DISPLAY_BT2020 = 0x8860000;

    private DataSpace() {
    }

    public static int pack(int standard, int transfer, int range) {
        if ((standard & 0x3F0000) != standard) {
            throw new IllegalArgumentException("Invalid standard " + standard);
        }
        if ((transfer & 0x7C00000) != transfer) {
            throw new IllegalArgumentException("Invalid transfer " + transfer);
        }
        if ((range & 0x38000000) != range) {
            throw new IllegalArgumentException("Invalid range " + range);
        }
        return standard | transfer | range;
    }

    public static int getStandard(int dataSpace) {
        int standard = dataSpace & 0x3F0000;
        return standard;
    }

    public static int getTransfer(int dataSpace) {
        int transfer = dataSpace & 0x7C00000;
        return transfer;
    }

    public static int getRange(int dataSpace) {
        int range = dataSpace & 0x38000000;
        return range;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NamedDataSpace {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorDataSpace {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataSpaceRange {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataSpaceTransfer {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataSpaceStandard {
    }
}

