/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.graphics.fonts.FontFamilyUpdateRequest;
import android.graphics.fonts.FontFileUpdateRequest;
import android.graphics.fonts.FontUpdateRequest;
import android.os.RemoteException;
import android.text.FontConfig;
import com.android.internal.graphics.fonts.IFontManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class FontManager {
    private static final String TAG = "FontManager";
    @NonNull
    private final IFontManager mIFontManager;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_ERROR_FAILED_TO_WRITE_FONT_FILE = -1;
    public static final int RESULT_ERROR_VERIFICATION_FAILURE = -2;
    public static final int RESULT_ERROR_INVALID_FONT_FILE = -3;
    public static final int RESULT_ERROR_INVALID_FONT_NAME = -4;
    public static final int RESULT_ERROR_DOWNGRADING = -5;
    public static final int RESULT_ERROR_FAILED_UPDATE_CONFIG = -6;
    public static final int RESULT_ERROR_FONT_UPDATER_DISABLED = -7;
    public static final int RESULT_ERROR_VERSION_MISMATCH = -8;
    public static final int RESULT_ERROR_FONT_NOT_FOUND = -9;
    public static final int RESULT_ERROR_FAILED_TO_OPEN_FONT_FILE = -10001;
    public static final int RESULT_ERROR_FAILED_TO_OPEN_SIGNATURE_FILE = -10002;
    public static final int RESULT_ERROR_INVALID_SHELL_ARGUMENT = -10003;
    public static final int RESULT_ERROR_INVALID_SIGNATURE_FILE = -10004;
    public static final int RESULT_ERROR_SIGNATURE_TOO_LARGE = -10005;
    public static final int RESULT_ERROR_FAILED_TO_OPEN_XML_FILE = -10006;
    public static final int RESULT_ERROR_INVALID_XML = -10007;
    public static final int RESULT_ERROR_INVALID_DEBUG_CERTIFICATE = -10008;

    private FontManager(@NonNull IFontManager iFontManager) {
        this.mIFontManager = iFontManager;
    }

    @RequiresPermission(value="android.permission.UPDATE_FONTS")
    @NonNull
    public FontConfig getFontConfig() {
        try {
            return this.mIFontManager.getFontConfig();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_FONTS")
    public int updateFontFamily(@NonNull FontFamilyUpdateRequest request, int baseVersion) {
        ArrayList<FontUpdateRequest> requests = new ArrayList<FontUpdateRequest>();
        List<FontFileUpdateRequest> fontFileUpdateRequests = request.getFontFileUpdateRequests();
        for (int i = 0; i < fontFileUpdateRequests.size(); ++i) {
            FontFileUpdateRequest fontFile = fontFileUpdateRequests.get(i);
            requests.add(new FontUpdateRequest(fontFile.getParcelFileDescriptor(), fontFile.getSignature()));
        }
        List<FontFamilyUpdateRequest.FontFamily> fontFamilies = request.getFontFamilies();
        for (int i = 0; i < fontFamilies.size(); ++i) {
            FontFamilyUpdateRequest.FontFamily fontFamily = fontFamilies.get(i);
            requests.add(new FontUpdateRequest(fontFamily.getName(), fontFamily.getFonts()));
        }
        try {
            return this.mIFontManager.updateFontFamily(requests, baseVersion);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static FontManager create(@NonNull IFontManager iFontManager) {
        Objects.requireNonNull(iFontManager);
        return new FontManager(iFontManager);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResultCode {
    }
}

