/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.fonts.FontVariationAxis;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArraySet;
import dalvik.annotation.optimization.FastNative;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Set;

@RavenwoodKeepWholeClass
public class FontFileUtil {
    private static final int SFNT_VERSION_1 = 65536;
    private static final int SFNT_VERSION_OTTO = 0x4F54544F;
    private static final int TTC_TAG = 1953784678;
    private static final int OS2_TABLE_TAG = 1330851634;
    private static final int FVAR_TABLE_TAG = 1719034226;
    private static final int ANALYZE_ERROR = -1;

    private FontFileUtil() {
    }

    public static int unpackWeight(int packed) {
        return packed & 0xFFFF;
    }

    public static boolean unpackItalic(int packed) {
        return (packed & 0x10000) != 0;
    }

    public static boolean isSuccess(int packed) {
        return packed != -1;
    }

    private static int pack(int weight, boolean italic) {
        return weight | (italic ? 65536 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int analyzeStyle(@NonNull ByteBuffer buffer, int ttcIndex, @Nullable FontVariationAxis[] varSettings) {
        int weight = -1;
        int italic = -1;
        if (varSettings != null) {
            for (FontVariationAxis axis : varSettings) {
                if ("wght".equals(axis.getTag())) {
                    weight = (int)axis.getStyleValue();
                    continue;
                }
                if (!"ital".equals(axis.getTag())) continue;
                italic = axis.getStyleValue() == 1.0f ? 1 : 0;
            }
        }
        if (weight != -1 && italic != -1) {
            return FontFileUtil.pack(weight, italic == 1);
        }
        ByteOrder originalOrder = buffer.order();
        buffer.order(ByteOrder.BIG_ENDIAN);
        try {
            int i;
            int sfntVersion;
            int fontFileOffset = 0;
            int magicNumber = buffer.getInt(0);
            if (magicNumber == 1953784678) {
                if (ttcIndex >= buffer.getInt(8)) {
                    int axis = -1;
                    return axis;
                }
                fontFileOffset = buffer.getInt(12 + 4 * ttcIndex);
            }
            if ((sfntVersion = buffer.getInt(fontFileOffset)) != 65536 && sfntVersion != 0x4F54544F) {
                int n = -1;
                return n;
            }
            int numTables = buffer.getShort(fontFileOffset + 4);
            int os2TableOffset = -1;
            for (i = 0; i < numTables; ++i) {
                int tableOffset = fontFileOffset + 12 + i * 16;
                if (buffer.getInt(tableOffset) != 1330851634) continue;
                os2TableOffset = buffer.getInt(tableOffset + 8);
                break;
            }
            if (os2TableOffset == -1) {
                i = FontFileUtil.pack(400, false);
                return i;
            }
            int weightFromOS2 = buffer.getShort(os2TableOffset + 4);
            boolean italicFromOS2 = (buffer.getShort(os2TableOffset + 62) & 1) != 0;
            int n = FontFileUtil.pack(weight == -1 ? weightFromOS2 : weight, italic == -1 ? italicFromOS2 : italic == 1);
            return n;
        }
        finally {
            buffer.order(originalOrder);
        }
    }

    public static long getRevision(@NonNull ByteBuffer buffer, int index) {
        return FontFileUtil.nGetFontRevision(buffer, index);
    }

    public static String getPostScriptName(@NonNull ByteBuffer buffer, int index) {
        return FontFileUtil.nGetFontPostScriptName(buffer, index);
    }

    public static int isPostScriptType1Font(@NonNull ByteBuffer buffer, int index) {
        return FontFileUtil.nIsPostScriptType1Font(buffer, index);
    }

    public static int isCollectionFont(@NonNull ByteBuffer buffer) {
        ByteBuffer copied = buffer.slice();
        copied.order(ByteOrder.BIG_ENDIAN);
        int magicNumber = copied.getInt(0);
        if (magicNumber == 1953784678) {
            return 1;
        }
        if (magicNumber == 65536 || magicNumber == 0x4F54544F) {
            return 0;
        }
        return -1;
    }

    private static int getUInt16(ByteBuffer buffer, int offset) {
        return buffer.getShort(offset) & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Integer> getSupportedAxes(@NonNull ByteBuffer buffer, int index) {
        ByteOrder originalOrder = buffer.order();
        buffer.order(ByteOrder.BIG_ENDIAN);
        try {
            int sfntVersion;
            int fontFileOffset = 0;
            int magicNumber = buffer.getInt(0);
            if (magicNumber == 1953784678) {
                if (index >= buffer.getInt(8)) {
                    Set set = Collections.EMPTY_SET;
                    return set;
                }
                fontFileOffset = buffer.getInt(12 + 4 * index);
            }
            if ((sfntVersion = buffer.getInt(fontFileOffset)) != 65536 && sfntVersion != 0x4F54544F) {
                Set set = Collections.EMPTY_SET;
                return set;
            }
            int numTables = buffer.getShort(fontFileOffset + 4);
            int fvarTableOffset = -1;
            for (int i = 0; i < numTables; ++i) {
                int tableOffset = fontFileOffset + 12 + i * 16;
                if (buffer.getInt(tableOffset) != 1719034226) continue;
                fvarTableOffset = buffer.getInt(tableOffset + 8);
                break;
            }
            if (fvarTableOffset == -1) {
                Set i = Collections.EMPTY_SET;
                return i;
            }
            if (buffer.getShort(fvarTableOffset) != 1 || buffer.getShort(fvarTableOffset + 2) != 0) {
                Set i = Collections.EMPTY_SET;
                return i;
            }
            int axesArrayOffset = FontFileUtil.getUInt16(buffer, fvarTableOffset + 4);
            int axisCount = FontFileUtil.getUInt16(buffer, fvarTableOffset + 8);
            int axisSize = FontFileUtil.getUInt16(buffer, fvarTableOffset + 10);
            ArraySet<Integer> axes = new ArraySet<Integer>();
            for (int i = 0; i < axisCount; ++i) {
                axes.add(buffer.getInt(fvarTableOffset + axesArrayOffset + axisSize * i));
            }
            ArraySet<Integer> arraySet = axes;
            return arraySet;
        }
        finally {
            buffer.order(originalOrder);
        }
    }

    @FastNative
    private static native long nGetFontRevision(@NonNull ByteBuffer var0, int var1);

    @FastNative
    private static native String nGetFontPostScriptName(@NonNull ByteBuffer var0, int var1);

    @FastNative
    private static native int nIsPostScriptType1Font(@NonNull ByteBuffer var0, int var1);
}

