/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorSpace;
import android.graphics.RuntimeXfermode;
import android.graphics.Shader;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;

@FlaggedApi(value="com.android.graphics.hwui.flags.runtime_color_filters_blenders")
@RavenwoodKeepWholeClass
public class RuntimeColorFilter
extends ColorFilter {
    private String mAgsl;

    public RuntimeColorFilter(@NonNull String agsl) {
        if (agsl == null) {
            throw new NullPointerException("RuntimeColorFilter requires a non-null AGSL string");
        }
        this.mAgsl = agsl;
        this.getNativeInstance();
    }

    public void setColorUniform(@NonNull String uniformName, int color2) {
        this.setUniform(uniformName, Color.valueOf(color2).getComponents(), true);
    }

    public void setColorUniform(@NonNull String uniformName, long color2) {
        Color exSRGB = Color.valueOf(color2).convert(ColorSpace.get(ColorSpace.Named.EXTENDED_SRGB));
        this.setUniform(uniformName, exSRGB.getComponents(), true);
    }

    public void setColorUniform(@NonNull String uniformName, @NonNull Color color2) {
        if (color2 == null) {
            throw new NullPointerException("The color parameter must not be null");
        }
        Color exSRGB = color2.convert(ColorSpace.get(ColorSpace.Named.EXTENDED_SRGB));
        this.setUniform(uniformName, exSRGB.getComponents(), true);
    }

    public void setFloatUniform(@NonNull String uniformName, float value) {
        this.setFloatUniform(uniformName, value, 0.0f, 0.0f, 0.0f, 1);
    }

    public void setFloatUniform(@NonNull String uniformName, float value1, float value2) {
        this.setFloatUniform(uniformName, value1, value2, 0.0f, 0.0f, 2);
    }

    public void setFloatUniform(@NonNull String uniformName, float value1, float value2, float value3) {
        this.setFloatUniform(uniformName, value1, value2, value3, 0.0f, 3);
    }

    public void setFloatUniform(@NonNull String uniformName, float value1, float value2, float value3, float value4) {
        this.setFloatUniform(uniformName, value1, value2, value3, value4, 4);
    }

    public void setFloatUniform(@NonNull String uniformName, @NonNull float[] values) {
        this.setUniform(uniformName, values, false);
    }

    private void setFloatUniform(@NonNull String uniformName, float value1, float value2, float value3, float value4, int count) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        RuntimeColorFilter.nativeUpdateUniforms(this.getNativeInstance(), uniformName, value1, value2, value3, value4, count);
    }

    private void setUniform(@NonNull String uniformName, @NonNull float[] values, boolean isColor) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        if (values == null) {
            throw new NullPointerException("The uniform values parameter must not be null");
        }
        RuntimeColorFilter.nativeUpdateUniforms(this.getNativeInstance(), uniformName, values, isColor);
    }

    public void setIntUniform(@NonNull String uniformName, int value) {
        this.setIntUniform(uniformName, value, 0, 0, 0, 1);
    }

    public void setIntUniform(@NonNull String uniformName, int value1, int value2) {
        this.setIntUniform(uniformName, value1, value2, 0, 0, 2);
    }

    public void setIntUniform(@NonNull String uniformName, int value1, int value2, int value3) {
        this.setIntUniform(uniformName, value1, value2, value3, 0, 3);
    }

    public void setIntUniform(@NonNull String uniformName, int value1, int value2, int value3, int value4) {
        this.setIntUniform(uniformName, value1, value2, value3, value4, 4);
    }

    public void setIntUniform(@NonNull String uniformName, @NonNull int[] values) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        if (values == null) {
            throw new NullPointerException("The uniform values parameter must not be null");
        }
        RuntimeColorFilter.nativeUpdateUniforms(this.getNativeInstance(), uniformName, values);
    }

    private void setIntUniform(@NonNull String uniformName, int value1, int value2, int value3, int value4, int count) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        RuntimeColorFilter.nativeUpdateUniforms(this.getNativeInstance(), uniformName, value1, value2, value3, value4, count);
    }

    public void setInputShader(@NonNull String shaderName, @NonNull Shader shader) {
        if (shaderName == null) {
            throw new NullPointerException("The shaderName parameter must not be null");
        }
        if (shader == null) {
            throw new NullPointerException("The shader parameter must not be null");
        }
        RuntimeColorFilter.nativeUpdateChild(this.getNativeInstance(), shaderName, shader.getNativeInstance());
    }

    public void setInputColorFilter(@NonNull String filterName, @NonNull ColorFilter colorFilter) {
        if (filterName == null) {
            throw new NullPointerException("The filterName parameter must not be null");
        }
        if (colorFilter == null) {
            throw new NullPointerException("The colorFilter parameter must not be null");
        }
        RuntimeColorFilter.nativeUpdateInputColorFilter(this.getNativeInstance(), filterName, colorFilter.getNativeInstance());
    }

    public void setInputXfermode(@NonNull String xfermodeName, @NonNull RuntimeXfermode xfermode) {
        if (xfermodeName == null) {
            throw new NullPointerException("The xfermodeName parameter must not be null");
        }
        if (xfermode == null) {
            throw new NullPointerException("The xfermode parameter must not be null");
        }
        RuntimeColorFilter.nativeUpdateChild(this.getNativeInstance(), xfermodeName, xfermode.createNativeInstance());
    }

    @Override
    protected long createNativeInstance() {
        return RuntimeColorFilter.nativeCreateRuntimeColorFilter(this.mAgsl);
    }

    private static native long nativeCreateRuntimeColorFilter(String var0);

    private static native void nativeUpdateUniforms(long var0, String var2, float[] var3, boolean var4);

    private static native void nativeUpdateUniforms(long var0, String var2, float var3, float var4, float var5, float var6, int var7);

    private static native void nativeUpdateUniforms(long var0, String var2, int[] var3);

    private static native void nativeUpdateUniforms(long var0, String var2, int var3, int var4, int var5, int var6, int var7);

    private static native void nativeUpdateChild(long var0, String var2, long var3);

    private static native void nativeUpdateInputColorFilter(long var0, String var2, long var3);
}

