/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.graphics.RectF;
import android.ravenwood.annotation.RavenwoodClassLoadHook;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.io.PrintWriter;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
@RavenwoodClassLoadHook(value="com.android.platform.test.ravenwood.runtimehelper.ClassLoadHook.onClassLoaded")
public class Matrix {
    public static final int MSCALE_X = 0;
    public static final int MSKEW_X = 1;
    public static final int MTRANS_X = 2;
    public static final int MSKEW_Y = 3;
    public static final int MSCALE_Y = 4;
    public static final int MTRANS_Y = 5;
    public static final int MPERSP_0 = 6;
    public static final int MPERSP_1 = 7;
    public static final int MPERSP_2 = 8;
    @NonNull
    public static final Matrix IDENTITY_MATRIX = new Matrix(){

        void oops() {
            throw new IllegalStateException("Matrix can not be modified");
        }

        @Override
        public void set(Matrix src) {
            this.oops();
        }

        @Override
        public void reset() {
            this.oops();
        }

        @Override
        public void setTranslate(float dx, float dy) {
            this.oops();
        }

        @Override
        public void setScale(float sx, float sy, float px, float py) {
            this.oops();
        }

        @Override
        public void setScale(float sx, float sy) {
            this.oops();
        }

        @Override
        public void setRotate(float degrees, float px, float py) {
            this.oops();
        }

        @Override
        public void setRotate(float degrees) {
            this.oops();
        }

        @Override
        public void setSinCos(float sinValue, float cosValue, float px, float py) {
            this.oops();
        }

        @Override
        public void setSinCos(float sinValue, float cosValue) {
            this.oops();
        }

        @Override
        public void setSkew(float kx, float ky, float px, float py) {
            this.oops();
        }

        @Override
        public void setSkew(float kx, float ky) {
            this.oops();
        }

        @Override
        public boolean setConcat(Matrix a, Matrix b) {
            this.oops();
            return false;
        }

        @Override
        public boolean preTranslate(float dx, float dy) {
            this.oops();
            return false;
        }

        @Override
        public boolean preScale(float sx, float sy, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean preScale(float sx, float sy) {
            this.oops();
            return false;
        }

        @Override
        public boolean preRotate(float degrees, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean preRotate(float degrees) {
            this.oops();
            return false;
        }

        @Override
        public boolean preSkew(float kx, float ky, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean preSkew(float kx, float ky) {
            this.oops();
            return false;
        }

        @Override
        public boolean preConcat(Matrix other) {
            this.oops();
            return false;
        }

        @Override
        public boolean postTranslate(float dx, float dy) {
            this.oops();
            return false;
        }

        @Override
        public boolean postScale(float sx, float sy, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean postScale(float sx, float sy) {
            this.oops();
            return false;
        }

        @Override
        public boolean postRotate(float degrees, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean postRotate(float degrees) {
            this.oops();
            return false;
        }

        @Override
        public boolean postSkew(float kx, float ky, float px, float py) {
            this.oops();
            return false;
        }

        @Override
        public boolean postSkew(float kx, float ky) {
            this.oops();
            return false;
        }

        @Override
        public boolean postConcat(Matrix other) {
            this.oops();
            return false;
        }

        @Override
        public boolean setRectToRect(RectF src, RectF dst, ScaleToFit stf) {
            this.oops();
            return false;
        }

        @Override
        public boolean setPolyToPoly(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
            this.oops();
            return false;
        }

        @Override
        public void setValues(float[] values) {
            this.oops();
        }
    };
    private final long native_instance;

    public Matrix() {
        this.native_instance = ExtraNatives.nCreate(0L);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.native_instance);
    }

    public Matrix(Matrix src) {
        this.native_instance = ExtraNatives.nCreate(src != null ? src.native_instance : 0L);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.native_instance);
    }

    public boolean isIdentity() {
        return Matrix.nIsIdentity(this.native_instance);
    }

    public boolean isAffine() {
        return Matrix.nIsAffine(this.native_instance);
    }

    public boolean rectStaysRect() {
        return Matrix.nRectStaysRect(this.native_instance);
    }

    public void set(Matrix src) {
        if (src == null) {
            this.reset();
        } else {
            Matrix.nSet(this.native_instance, src.native_instance);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Matrix)) {
            return false;
        }
        return Matrix.nEquals(this.native_instance, ((Matrix)obj).native_instance);
    }

    public int hashCode() {
        return 44;
    }

    public void reset() {
        Matrix.nReset(this.native_instance);
    }

    public void setTranslate(float dx, float dy) {
        Matrix.nSetTranslate(this.native_instance, dx, dy);
    }

    public void setScale(float sx, float sy, float px, float py) {
        Matrix.nSetScale(this.native_instance, sx, sy, px, py);
    }

    public void setScale(float sx, float sy) {
        Matrix.nSetScale(this.native_instance, sx, sy);
    }

    public void setRotate(float degrees, float px, float py) {
        Matrix.nSetRotate(this.native_instance, degrees, px, py);
    }

    public void setRotate(float degrees) {
        Matrix.nSetRotate(this.native_instance, degrees);
    }

    public void setSinCos(float sinValue, float cosValue, float px, float py) {
        Matrix.nSetSinCos(this.native_instance, sinValue, cosValue, px, py);
    }

    public void setSinCos(float sinValue, float cosValue) {
        Matrix.nSetSinCos(this.native_instance, sinValue, cosValue);
    }

    public void setSkew(float kx, float ky, float px, float py) {
        Matrix.nSetSkew(this.native_instance, kx, ky, px, py);
    }

    public void setSkew(float kx, float ky) {
        Matrix.nSetSkew(this.native_instance, kx, ky);
    }

    public boolean setConcat(Matrix a, Matrix b) {
        Matrix.nSetConcat(this.native_instance, a.native_instance, b.native_instance);
        return true;
    }

    public boolean preTranslate(float dx, float dy) {
        Matrix.nPreTranslate(this.native_instance, dx, dy);
        return true;
    }

    public boolean preScale(float sx, float sy, float px, float py) {
        Matrix.nPreScale(this.native_instance, sx, sy, px, py);
        return true;
    }

    public boolean preScale(float sx, float sy) {
        Matrix.nPreScale(this.native_instance, sx, sy);
        return true;
    }

    public boolean preRotate(float degrees, float px, float py) {
        Matrix.nPreRotate(this.native_instance, degrees, px, py);
        return true;
    }

    public boolean preRotate(float degrees) {
        Matrix.nPreRotate(this.native_instance, degrees);
        return true;
    }

    public boolean preSkew(float kx, float ky, float px, float py) {
        Matrix.nPreSkew(this.native_instance, kx, ky, px, py);
        return true;
    }

    public boolean preSkew(float kx, float ky) {
        Matrix.nPreSkew(this.native_instance, kx, ky);
        return true;
    }

    public boolean preConcat(Matrix other) {
        Matrix.nPreConcat(this.native_instance, other.native_instance);
        return true;
    }

    public boolean postTranslate(float dx, float dy) {
        Matrix.nPostTranslate(this.native_instance, dx, dy);
        return true;
    }

    public boolean postScale(float sx, float sy, float px, float py) {
        Matrix.nPostScale(this.native_instance, sx, sy, px, py);
        return true;
    }

    public boolean postScale(float sx, float sy) {
        Matrix.nPostScale(this.native_instance, sx, sy);
        return true;
    }

    public boolean postRotate(float degrees, float px, float py) {
        Matrix.nPostRotate(this.native_instance, degrees, px, py);
        return true;
    }

    public boolean postRotate(float degrees) {
        Matrix.nPostRotate(this.native_instance, degrees);
        return true;
    }

    public boolean postSkew(float kx, float ky, float px, float py) {
        Matrix.nPostSkew(this.native_instance, kx, ky, px, py);
        return true;
    }

    public boolean postSkew(float kx, float ky) {
        Matrix.nPostSkew(this.native_instance, kx, ky);
        return true;
    }

    public boolean postConcat(Matrix other) {
        Matrix.nPostConcat(this.native_instance, other.native_instance);
        return true;
    }

    public boolean setRectToRect(RectF src, RectF dst, ScaleToFit stf) {
        if (dst == null || src == null) {
            throw new NullPointerException();
        }
        return Matrix.nSetRectToRect(this.native_instance, src, dst, stf.nativeInt);
    }

    private static void checkPointArrays(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
        int srcStop = srcIndex + (pointCount << 1);
        int dstStop = dstIndex + (pointCount << 1);
        if ((pointCount | srcIndex | dstIndex | srcStop | dstStop) < 0 || srcStop > src.length || dstStop > dst.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public boolean setPolyToPoly(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
        if (pointCount > 4) {
            throw new IllegalArgumentException();
        }
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, pointCount);
        return Matrix.nSetPolyToPoly(this.native_instance, src, srcIndex, dst, dstIndex, pointCount);
    }

    public boolean invert(Matrix inverse) {
        return Matrix.nInvert(this.native_instance, inverse.native_instance);
    }

    public void mapPoints(float[] dst, int dstIndex, float[] src, int srcIndex, int pointCount) {
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, pointCount);
        Matrix.nMapPoints(this.native_instance, dst, dstIndex, src, srcIndex, pointCount, true);
    }

    public void mapVectors(float[] dst, int dstIndex, float[] src, int srcIndex, int vectorCount) {
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, vectorCount);
        Matrix.nMapPoints(this.native_instance, dst, dstIndex, src, srcIndex, vectorCount, false);
    }

    public void mapPoints(float[] dst, float[] src) {
        if (dst.length != src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mapPoints(dst, 0, src, 0, dst.length >> 1);
    }

    public void mapVectors(float[] dst, float[] src) {
        if (dst.length != src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mapVectors(dst, 0, src, 0, dst.length >> 1);
    }

    public void mapPoints(float[] pts) {
        this.mapPoints(pts, 0, pts, 0, pts.length >> 1);
    }

    public void mapVectors(float[] vecs) {
        this.mapVectors(vecs, 0, vecs, 0, vecs.length >> 1);
    }

    public boolean mapRect(RectF dst, RectF src) {
        if (dst == null || src == null) {
            throw new NullPointerException();
        }
        return Matrix.nMapRect(this.native_instance, dst, src);
    }

    public boolean mapRect(RectF rect) {
        return this.mapRect(rect, rect);
    }

    public float mapRadius(float radius) {
        return Matrix.nMapRadius(this.native_instance, radius);
    }

    public void getValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Matrix.nGetValues(this.native_instance, values);
    }

    public void setValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Matrix.nSetValues(this.native_instance, values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Matrix{");
        this.toShortString(sb);
        sb.append('}');
        return sb.toString();
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder(64);
        this.toShortString(sb);
        return sb.toString();
    }

    private void toShortString(StringBuilder sb) {
        float[] values = new float[9];
        this.getValues(values);
        sb.append('[');
        sb.append(values[0]);
        sb.append(", ");
        sb.append(values[1]);
        sb.append(", ");
        sb.append(values[2]);
        sb.append("][");
        sb.append(values[3]);
        sb.append(", ");
        sb.append(values[4]);
        sb.append(", ");
        sb.append(values[5]);
        sb.append("][");
        sb.append(values[6]);
        sb.append(", ");
        sb.append(values[7]);
        sb.append(", ");
        sb.append(values[8]);
        sb.append(']');
    }

    public final void dump(@NonNull PrintWriter pw) {
        float[] values = new float[9];
        this.getValues(values);
        pw.print('[');
        pw.print(values[0]);
        pw.print(", ");
        pw.print(values[1]);
        pw.print(", ");
        pw.print(values[2]);
        pw.print("][");
        pw.print(values[3]);
        pw.print(", ");
        pw.print(values[4]);
        pw.print(", ");
        pw.print(values[5]);
        pw.print("][");
        pw.print(values[6]);
        pw.print(", ");
        pw.print(values[7]);
        pw.print(", ");
        pw.print(values[8]);
        pw.print(']');
    }

    public final long ni() {
        return this.native_instance;
    }

    @FastNative
    private static native boolean nSetRectToRect(long var0, RectF var2, RectF var3, int var4);

    @FastNative
    private static native boolean nSetPolyToPoly(long var0, float[] var2, int var3, float[] var4, int var5, int var6);

    @FastNative
    private static native void nMapPoints(long var0, float[] var2, int var3, float[] var4, int var5, int var6, boolean var7);

    @FastNative
    private static native boolean nMapRect(long var0, RectF var2, RectF var3);

    @FastNative
    private static native void nGetValues(long var0, float[] var2);

    @FastNative
    private static native void nSetValues(long var0, float[] var2);

    @CriticalNative
    private static native boolean nIsIdentity(long var0);

    @CriticalNative
    private static native boolean nIsAffine(long var0);

    @CriticalNative
    private static native boolean nRectStaysRect(long var0);

    @CriticalNative
    private static native void nReset(long var0);

    @CriticalNative
    private static native void nSet(long var0, long var2);

    @CriticalNative
    private static native void nSetTranslate(long var0, float var2, float var3);

    @CriticalNative
    private static native void nSetScale(long var0, float var2, float var3, float var4, float var5);

    @CriticalNative
    private static native void nSetScale(long var0, float var2, float var3);

    @CriticalNative
    private static native void nSetRotate(long var0, float var2, float var3, float var4);

    @CriticalNative
    private static native void nSetRotate(long var0, float var2);

    @CriticalNative
    private static native void nSetSinCos(long var0, float var2, float var3, float var4, float var5);

    @CriticalNative
    private static native void nSetSinCos(long var0, float var2, float var3);

    @CriticalNative
    private static native void nSetSkew(long var0, float var2, float var3, float var4, float var5);

    @CriticalNative
    private static native void nSetSkew(long var0, float var2, float var3);

    @CriticalNative
    private static native void nSetConcat(long var0, long var2, long var4);

    @CriticalNative
    private static native void nPreTranslate(long var0, float var2, float var3);

    @CriticalNative
    private static native void nPreScale(long var0, float var2, float var3, float var4, float var5);

    @CriticalNative
    private static native void nPreScale(long var0, float var2, float var3);

    @CriticalNative
    private static native void nPreRotate(long var0, float var2, float var3, float var4);

    @CriticalNative
    private static native void nPreRotate(long var0, float var2);

    @CriticalNative
    private static native void nPreSkew(long var0, float var2, float var3, float var4, float var5);

    @CriticalNative
    private static native void nPreSkew(long var0, float var2, float var3);

    @CriticalNative
    private static native void nPreConcat(long var0, long var2);

    @CriticalNative
    private static native void nPostTranslate(long var0, float var2, float var3);

    @CriticalNative
    private static native void nPostScale(long var0, float var2, float var3, float var4, float var5);

    @CriticalNative
    private static native void nPostScale(long var0, float var2, float var3);

    @CriticalNative
    private static native void nPostRotate(long var0, float var2, float var3, float var4);

    @CriticalNative
    private static native void nPostRotate(long var0, float var2);

    @CriticalNative
    private static native void nPostSkew(long var0, float var2, float var3, float var4, float var5);

    @CriticalNative
    private static native void nPostSkew(long var0, float var2, float var3);

    @CriticalNative
    private static native void nPostConcat(long var0, long var2);

    @CriticalNative
    private static native boolean nInvert(long var0, long var2);

    @CriticalNative
    private static native float nMapRadius(long var0, float var2);

    @CriticalNative
    private static native boolean nEquals(long var0, long var2);

    private static class ExtraNatives {
        private ExtraNatives() {
        }

        static native long nCreate(long var0);

        static native long nGetNativeFinalizer();
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(Matrix.class.getClassLoader(), ExtraNatives.nGetNativeFinalizer());

        private NoImagePreloadHolder() {
        }
    }

    public static enum ScaleToFit {
        FILL(0),
        START(1),
        CENTER(2),
        END(3);

        final int nativeInt;

        private ScaleToFit(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

