/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.fonts.FontCustomizationParser;
import android.graphics.fonts.FontStyle;
import android.graphics.fonts.FontVariationAxis;
import android.os.LocaleList;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.FontConfig;
import android.util.ArraySet;
import android.util.Xml;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@RavenwoodKeepWholeClass
public class FontListParser {
    private static final String TAG = "FontListParser";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_LANG = "lang";
    private static final String ATTR_VARIANT = "variant";
    private static final String TAG_FONT = "font";
    private static final String VARIANT_COMPACT = "compact";
    private static final String VARIANT_ELEGANT = "elegant";
    public static final String ATTR_SUPPORTED_AXES = "supportedAxes";
    public static final String ATTR_INDEX = "index";
    public static final String ATTR_WEIGHT = "weight";
    public static final String ATTR_POSTSCRIPT_NAME = "postScriptName";
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_FALLBACK_FOR = "fallbackFor";
    public static final String STYLE_ITALIC = "italic";
    public static final String STYLE_NORMAL = "normal";
    public static final String TAG_AXIS = "axis";
    public static final String ATTR_TAG = "tag";
    public static final String ATTR_STYLEVALUE = "stylevalue";
    private static final String TAG_WGHT = "wght";
    private static final String TAG_ITAL = "ital";
    private static final Pattern FILENAME_WHITESPACE_PATTERN = Pattern.compile("^[ \\n\\r\\t]+|[ \\n\\r\\t]+$");

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static FontConfig parse(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, null);
        parser.nextTag();
        return FontListParser.readFamilies(parser, "/system/fonts/", new FontCustomizationParser.Result(), null, 0L, 0, true);
    }

    public static FontConfig parse(@NonNull String fontsXmlPath, @NonNull String systemFontDir, @Nullable String oemCustomizationXmlPath, @Nullable String productFontDir, @Nullable Map<String, File> updatableFontMap, long lastModifiedDate, int configVersion) throws IOException, XmlPullParserException {
        FontCustomizationParser.Result oemCustomization;
        FileInputStream is;
        if (oemCustomizationXmlPath != null) {
            try {
                is = new FileInputStream(oemCustomizationXmlPath);
                try {
                    oemCustomization = FontCustomizationParser.parse(is, productFontDir, updatableFontMap);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                oemCustomization = new FontCustomizationParser.Result();
            }
        } else {
            oemCustomization = new FontCustomizationParser.Result();
        }
        is = new FileInputStream(fontsXmlPath);
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)is, null);
            parser.nextTag();
            FontConfig fontConfig = FontListParser.readFamilies(parser, systemFontDir, oemCustomization, updatableFontMap, lastModifiedDate, configVersion, false);
            return fontConfig;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static FontConfig readFamilies(@NonNull XmlPullParser parser, @NonNull String fontDir, @NonNull FontCustomizationParser.Result customization, @Nullable Map<String, File> updatableFontMap, long lastModifiedDate, int configVersion, boolean allowNonExistingFile) throws XmlPullParserException, IOException {
        ArrayList<FontConfig.FontFamily> families = new ArrayList<FontConfig.FontFamily>();
        ArrayList<FontConfig.NamedFamilyList> resultNamedFamilies = new ArrayList<FontConfig.NamedFamilyList>();
        ArrayList<FontConfig.Alias> aliases = new ArrayList<FontConfig.Alias>(customization.getAdditionalAliases());
        Map<String, FontConfig.NamedFamilyList> oemNamedFamilies = customization.getAdditionalNamedFamilies();
        boolean firstFamily = true;
        parser.require(2, null, "familyset");
        while (FontListParser.keepReading(parser)) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("family")) {
                String name = parser.getAttributeValue(null, ATTR_NAME);
                if (name == null) {
                    FontConfig.FontFamily family = FontListParser.readFamily(parser, fontDir, updatableFontMap, allowNonExistingFile);
                    if (family == null) continue;
                    families.add(family);
                } else {
                    FontConfig.NamedFamilyList namedFamilyList = FontListParser.readNamedFamily(parser, fontDir, updatableFontMap, allowNonExistingFile);
                    if (namedFamilyList == null) continue;
                    if (!oemNamedFamilies.containsKey(name)) {
                        resultNamedFamilies.add(namedFamilyList);
                    }
                    if (firstFamily) {
                        families.addAll(namedFamilyList.getFamilies());
                    }
                }
                firstFamily = false;
                continue;
            }
            if (tag.equals("family-list")) {
                FontConfig.NamedFamilyList namedFamilyList = FontListParser.readNamedFamilyList(parser, fontDir, updatableFontMap, allowNonExistingFile);
                if (namedFamilyList == null) continue;
                if (!oemNamedFamilies.containsKey(namedFamilyList.getName())) {
                    resultNamedFamilies.add(namedFamilyList);
                }
                if (firstFamily) {
                    families.addAll(namedFamilyList.getFamilies());
                }
                firstFamily = false;
                continue;
            }
            if (tag.equals("alias")) {
                aliases.add(FontListParser.readAlias(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        resultNamedFamilies.addAll(oemNamedFamilies.values());
        ArraySet<String> namedFamilies = new ArraySet<String>();
        for (int i = 0; i < resultNamedFamilies.size(); ++i) {
            String name = ((FontConfig.NamedFamilyList)resultNamedFamilies.get(i)).getName();
            if (name == null) continue;
            namedFamilies.add(name);
        }
        ArrayList<FontConfig.Alias> filtered = new ArrayList<FontConfig.Alias>();
        for (int i = 0; i < aliases.size(); ++i) {
            FontConfig.Alias alias = (FontConfig.Alias)aliases.get(i);
            if (!namedFamilies.contains(alias.getOriginal())) continue;
            filtered.add(alias);
        }
        return new FontConfig(families, filtered, resultNamedFamilies, customization.getLocaleFamilyCustomizations(), lastModifiedDate, configVersion);
    }

    private static boolean keepReading(XmlPullParser parser) throws XmlPullParserException, IOException {
        int next = parser.next();
        return next != 3 && next != 1;
    }

    @Nullable
    public static FontConfig.FontFamily readFamily(XmlPullParser parser, String fontDir, @Nullable Map<String, File> updatableFontMap, boolean allowNonExistingFile) throws XmlPullParserException, IOException {
        boolean skip;
        String lang = parser.getAttributeValue("", ATTR_LANG);
        String variant = parser.getAttributeValue(null, ATTR_VARIANT);
        String ignore = parser.getAttributeValue(null, "ignore");
        ArrayList<FontConfig.Font> fonts = new ArrayList<FontConfig.Font>();
        while (FontListParser.keepReading(parser)) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals(TAG_FONT)) {
                FontConfig.Font font = FontListParser.readFont(parser, fontDir, updatableFontMap, allowNonExistingFile);
                if (font == null) continue;
                fonts.add(font);
                continue;
            }
            FontListParser.skip(parser);
        }
        int intVariant = 0;
        if (variant != null) {
            if (variant.equals(VARIANT_COMPACT)) {
                intVariant = 1;
            } else if (variant.equals(VARIANT_ELEGANT)) {
                intVariant = 2;
            }
        }
        boolean bl = skip = ignore != null && (ignore.equals("true") || ignore.equals("1"));
        if (skip || fonts.isEmpty()) {
            return null;
        }
        return new FontConfig.FontFamily(fonts, LocaleList.forLanguageTags(lang), intVariant);
    }

    private static void throwIfAttributeExists(String attrName, XmlPullParser parser) {
        if (parser.getAttributeValue(null, attrName) != null) {
            throw new IllegalArgumentException(attrName + " cannot be used in FontFamily inside  family or family-list with name attribute.");
        }
    }

    @Nullable
    public static FontConfig.NamedFamilyList readNamedFamily(@NonNull XmlPullParser parser, @NonNull String fontDir, @Nullable Map<String, File> updatableFontMap, boolean allowNonExistingFile) throws XmlPullParserException, IOException {
        String name = parser.getAttributeValue(null, ATTR_NAME);
        FontListParser.throwIfAttributeExists(ATTR_LANG, parser);
        FontListParser.throwIfAttributeExists(ATTR_VARIANT, parser);
        FontListParser.throwIfAttributeExists("ignore", parser);
        FontConfig.FontFamily family = FontListParser.readFamily(parser, fontDir, updatableFontMap, allowNonExistingFile);
        if (family == null) {
            return null;
        }
        return new FontConfig.NamedFamilyList(Collections.singletonList(family), name);
    }

    @Nullable
    public static FontConfig.NamedFamilyList readNamedFamilyList(@NonNull XmlPullParser parser, @NonNull String fontDir, @Nullable Map<String, File> updatableFontMap, boolean allowNonExistingFile) throws XmlPullParserException, IOException {
        String name = parser.getAttributeValue(null, ATTR_NAME);
        ArrayList<FontConfig.FontFamily> familyList = new ArrayList<FontConfig.FontFamily>();
        while (FontListParser.keepReading(parser)) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("family")) {
                FontListParser.throwIfAttributeExists(ATTR_NAME, parser);
                FontListParser.throwIfAttributeExists(ATTR_LANG, parser);
                FontListParser.throwIfAttributeExists(ATTR_VARIANT, parser);
                FontListParser.throwIfAttributeExists("ignore", parser);
                FontConfig.FontFamily family = FontListParser.readFamily(parser, fontDir, updatableFontMap, allowNonExistingFile);
                if (family == null) continue;
                familyList.add(family);
                continue;
            }
            FontListParser.skip(parser);
        }
        if (familyList.isEmpty()) {
            return null;
        }
        return new FontConfig.NamedFamilyList(familyList, name);
    }

    @Nullable
    private static FontConfig.Font readFont(@NonNull XmlPullParser parser, @NonNull String fontDir, @Nullable Map<String, File> updatableFontMap, boolean allowNonExistingFile) throws XmlPullParserException, IOException {
        String originalPath;
        String filePath;
        String updatedName;
        String indexStr = parser.getAttributeValue(null, ATTR_INDEX);
        int index = indexStr == null ? 0 : Integer.parseInt(indexStr);
        ArrayList<FontVariationAxis> axes = new ArrayList<FontVariationAxis>();
        String weightStr = parser.getAttributeValue(null, ATTR_WEIGHT);
        int weight = weightStr == null ? 400 : Integer.parseInt(weightStr);
        boolean isItalic = STYLE_ITALIC.equals(parser.getAttributeValue(null, ATTR_STYLE));
        String fallbackFor = parser.getAttributeValue(null, ATTR_FALLBACK_FOR);
        String postScriptName = parser.getAttributeValue(null, ATTR_POSTSCRIPT_NAME);
        String supportedAxes = parser.getAttributeValue(null, ATTR_SUPPORTED_AXES);
        StringBuilder filename = new StringBuilder();
        while (FontListParser.keepReading(parser)) {
            if (parser.getEventType() == 4) {
                filename.append(parser.getText());
            }
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals(TAG_AXIS)) {
                axes.add(FontListParser.readAxis(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        String sanitizedName = FILENAME_WHITESPACE_PATTERN.matcher(filename).replaceAll("");
        int varTypeAxes = 0;
        if (supportedAxes != null) {
            for (String tag : supportedAxes.split(",")) {
                String strippedTag = tag.strip();
                if (strippedTag.equals(TAG_WGHT)) {
                    varTypeAxes |= 1;
                    continue;
                }
                if (!strippedTag.equals(TAG_ITAL)) continue;
                varTypeAxes |= 2;
            }
        }
        if (postScriptName == null) {
            postScriptName = sanitizedName.substring(0, sanitizedName.length() - 4);
        }
        if ((updatedName = FontListParser.findUpdatedFontFile(postScriptName, updatableFontMap)) != null) {
            filePath = updatedName;
            originalPath = fontDir + sanitizedName;
        } else {
            filePath = fontDir + sanitizedName;
            originalPath = null;
        }
        String varSettings = axes.isEmpty() ? "" : FontVariationAxis.toFontVariationSettings(axes.toArray(new FontVariationAxis[0]));
        File file = new File(filePath);
        if (!allowNonExistingFile && !file.isFile()) {
            return null;
        }
        return new FontConfig.Font(file, originalPath == null ? null : new File(originalPath), postScriptName, new FontStyle(weight, isItalic ? 1 : 0), index, varSettings, fallbackFor, varTypeAxes);
    }

    private static String findUpdatedFontFile(String psName, @Nullable Map<String, File> updatableFontMap) {
        File updatedFile;
        if (updatableFontMap != null && (updatedFile = updatableFontMap.get(psName)) != null) {
            return updatedFile.getAbsolutePath();
        }
        return null;
    }

    private static FontVariationAxis readAxis(XmlPullParser parser) throws XmlPullParserException, IOException {
        String tagStr = parser.getAttributeValue(null, ATTR_TAG);
        String styleValueStr = parser.getAttributeValue(null, ATTR_STYLEVALUE);
        FontListParser.skip(parser);
        return new FontVariationAxis(tagStr, Float.parseFloat(styleValueStr));
    }

    public static FontConfig.Alias readAlias(XmlPullParser parser) throws XmlPullParserException, IOException {
        String name = parser.getAttributeValue(null, ATTR_NAME);
        String toName = parser.getAttributeValue(null, "to");
        String weightStr = parser.getAttributeValue(null, ATTR_WEIGHT);
        int weight = weightStr == null ? 400 : Integer.parseInt(weightStr);
        FontListParser.skip(parser);
        return new FontConfig.Alias(name, toName, weight);
    }

    public static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        int depth = 1;
        while (depth > 0) {
            switch (parser.next()) {
                case 2: {
                    ++depth;
                    break;
                }
                case 3: {
                    --depth;
                    break;
                }
                case 1: {
                    return;
                }
            }
        }
    }
}

