/*
 * Decompiled with CFR 0.152.
 */
package android.credentials.selection;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.app.slice.Slice;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;

@SystemApi
@FlaggedApi(value="android.credentials.flags.configurable_selector_ui_enabled")
public class Entry
implements Parcelable {
    @NonNull
    private final String mKey;
    @NonNull
    private final String mSubkey;
    @Nullable
    private PendingIntent mPendingIntent;
    @Nullable
    private Intent mFrameworkExtrasIntent;
    @NonNull
    private final Slice mSlice;
    @NonNull
    public static final Parcelable.Creator<Entry> CREATOR = new Parcelable.Creator<Entry>(){

        @Override
        public Entry createFromParcel(@NonNull Parcel in) {
            return new Entry(in);
        }

        public Entry[] newArray(int size) {
            return new Entry[size];
        }
    };

    private Entry(@NonNull Parcel in) {
        String key = in.readString8();
        String subkey = in.readString8();
        Slice slice = in.readTypedObject(Slice.CREATOR);
        this.mKey = key;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mKey);
        this.mSubkey = subkey;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSubkey);
        this.mSlice = slice;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSlice);
        this.mPendingIntent = in.readTypedObject(PendingIntent.CREATOR);
        this.mFrameworkExtrasIntent = in.readTypedObject(Intent.CREATOR);
    }

    public Entry(@NonNull String key, @NonNull String subkey, @NonNull Slice slice, @NonNull Intent intent) {
        this.mKey = key;
        this.mSubkey = subkey;
        this.mSlice = slice;
        this.mFrameworkExtrasIntent = intent;
    }

    @NonNull
    public String getKey() {
        return this.mKey;
    }

    @NonNull
    public String getSubkey() {
        return this.mSubkey;
    }

    @NonNull
    public Slice getSlice() {
        return this.mSlice;
    }

    @Nullable
    @SuppressLint(value={"IntentBuilderName"})
    public Intent getFrameworkExtrasIntent() {
        return this.mFrameworkExtrasIntent;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mKey);
        dest.writeString8(this.mSubkey);
        dest.writeTypedObject(this.mSlice, flags);
        dest.writeTypedObject(this.mPendingIntent, flags);
        dest.writeTypedObject(this.mFrameworkExtrasIntent, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

