/*
 * Decompiled with CFR 0.152.
 */
package android.credentials;

import android.annotation.Hide;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.app.ActivityOptions;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.IntentSender;
import android.credentials.ClearCredentialStateException;
import android.credentials.ClearCredentialStateRequest;
import android.credentials.CreateCredentialException;
import android.credentials.CreateCredentialRequest;
import android.credentials.CreateCredentialResponse;
import android.credentials.CredentialProviderInfo;
import android.credentials.GetCandidateCredentialsException;
import android.credentials.GetCandidateCredentialsResponse;
import android.credentials.GetCredentialException;
import android.credentials.GetCredentialRequest;
import android.credentials.GetCredentialResponse;
import android.credentials.IClearCredentialStateCallback;
import android.credentials.ICreateCredentialCallback;
import android.credentials.ICredentialManager;
import android.credentials.IGetCandidateCredentialsCallback;
import android.credentials.IGetCredentialCallback;
import android.credentials.IPrepareGetCredentialCallback;
import android.credentials.ISetEnabledProvidersCallback;
import android.credentials.PrepareGetCredentialResponse;
import android.credentials.PrepareGetCredentialResponseInternal;
import android.credentials.RegisterCredentialDescriptionRequest;
import android.credentials.SetEnabledProvidersException;
import android.credentials.UnregisterCredentialDescriptionRequest;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.provider.DeviceConfig;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class CredentialManager {
    @Hide
    public static final String TAG = "CredentialManager";
    private static final Bundle OPTIONS_SENDER_BAL_OPTIN = ActivityOptions.makeBasic().setPendingIntentBackgroundActivityStartMode(1).toBundle();
    public static final int PROVIDER_FILTER_ALL_PROVIDERS = 0;
    public static final int PROVIDER_FILTER_SYSTEM_PROVIDERS_ONLY = 1;
    public static final int PROVIDER_FILTER_USER_PROVIDERS_ONLY = 2;
    public static final int PROVIDER_FILTER_USER_PROVIDERS_INCLUDING_HIDDEN = 3;
    private final Context mContext;
    private final ICredentialManager mService;
    public static final String DEVICE_CONFIG_ENABLE_CREDENTIAL_MANAGER = "enable_credential_manager";
    private static final String DEVICE_CONFIG_ENABLE_CREDENTIAL_DESC_API = "enable_credential_description_api";
    @Hide
    public static final String EXTRA_AUTOFILL_RESULT_RECEIVER = "android.credentials.AUTOFILL_RESULT_RECEIVER";

    public CredentialManager(Context context, ICredentialManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @Hide
    public void getCandidateCredentials(@NonNull GetCredentialRequest request, @NonNull String callingPackage, @Nullable CancellationSignal cancellationSignal, @NonNull Executor executor, @NonNull OutcomeReceiver<GetCandidateCredentialsResponse, GetCandidateCredentialsException> callback, @NonNull IBinder clientCallback) {
        Objects.requireNonNull(request, "request must not be null");
        Objects.requireNonNull(callingPackage, "callingPackage must not be null");
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        if (cancellationSignal != null && cancellationSignal.isCanceled()) {
            Log.w(TAG, "getCandidateCredentials already canceled");
            return;
        }
        ICancellationSignal cancelRemote = null;
        try {
            cancelRemote = this.mService.getCandidateCredentials(request, new GetCandidateCredentialsTransport(executor, callback), clientCallback, callingPackage);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        if (cancellationSignal != null && cancelRemote != null) {
            cancellationSignal.setRemote(cancelRemote);
        }
    }

    public void getCredential(@NonNull Context context, @NonNull GetCredentialRequest request, @Nullable CancellationSignal cancellationSignal, @NonNull Executor executor, @NonNull OutcomeReceiver<GetCredentialResponse, GetCredentialException> callback) {
        Objects.requireNonNull(request, "request must not be null");
        Objects.requireNonNull(context, "context must not be null");
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        if (cancellationSignal != null && cancellationSignal.isCanceled()) {
            Log.w(TAG, "getCredential already canceled");
            return;
        }
        ICancellationSignal cancelRemote = null;
        try {
            cancelRemote = this.mService.executeGetCredential(request, new GetCredentialTransport(context, executor, callback), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        if (cancellationSignal != null && cancelRemote != null) {
            cancellationSignal.setRemote(cancelRemote);
        }
    }

    public void getCredential(@NonNull Context context, @NonNull PrepareGetCredentialResponse.PendingGetCredentialHandle pendingGetCredentialHandle, @Nullable CancellationSignal cancellationSignal, @NonNull Executor executor, @NonNull OutcomeReceiver<GetCredentialResponse, GetCredentialException> callback) {
        Objects.requireNonNull(pendingGetCredentialHandle, "pendingGetCredentialHandle must not be null");
        Objects.requireNonNull(context, "context must not be null");
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        if (cancellationSignal != null && cancellationSignal.isCanceled()) {
            Log.w(TAG, "getCredential already canceled");
            return;
        }
        pendingGetCredentialHandle.show(context, cancellationSignal, executor, callback);
    }

    public void prepareGetCredential(@NonNull GetCredentialRequest request, @Nullable CancellationSignal cancellationSignal, @NonNull Executor executor, @NonNull OutcomeReceiver<PrepareGetCredentialResponse, GetCredentialException> callback) {
        Objects.requireNonNull(request, "request must not be null");
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        if (cancellationSignal != null && cancellationSignal.isCanceled()) {
            Log.w(TAG, "prepareGetCredential already canceled");
            return;
        }
        ICancellationSignal cancelRemote = null;
        GetCredentialTransportPendingUseCase getCredentialTransport = new GetCredentialTransportPendingUseCase();
        try {
            cancelRemote = this.mService.executePrepareGetCredential(request, new PrepareGetCredentialTransport(executor, callback, getCredentialTransport), getCredentialTransport, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        if (cancellationSignal != null && cancelRemote != null) {
            cancellationSignal.setRemote(cancelRemote);
        }
    }

    public void createCredential(@NonNull Context context, @NonNull CreateCredentialRequest request, @Nullable CancellationSignal cancellationSignal, @NonNull Executor executor, @NonNull OutcomeReceiver<CreateCredentialResponse, CreateCredentialException> callback) {
        Objects.requireNonNull(request, "request must not be null");
        Objects.requireNonNull(context, "context must not be null");
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        if (cancellationSignal != null && cancellationSignal.isCanceled()) {
            Log.w(TAG, "createCredential already canceled");
            return;
        }
        ICancellationSignal cancelRemote = null;
        try {
            cancelRemote = this.mService.executeCreateCredential(request, new CreateCredentialTransport(context, executor, callback), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        if (cancellationSignal != null && cancelRemote != null) {
            cancellationSignal.setRemote(cancelRemote);
        }
    }

    public void clearCredentialState(@NonNull ClearCredentialStateRequest request, @Nullable CancellationSignal cancellationSignal, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, ClearCredentialStateException> callback) {
        Objects.requireNonNull(request, "request must not be null");
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        if (cancellationSignal != null && cancellationSignal.isCanceled()) {
            Log.w(TAG, "clearCredentialState already canceled");
            return;
        }
        ICancellationSignal cancelRemote = null;
        try {
            cancelRemote = this.mService.clearCredentialState(request, new ClearCredentialStateTransport(executor, callback), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        if (cancellationSignal != null && cancelRemote != null) {
            cancellationSignal.setRemote(cancelRemote);
        }
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setEnabledProviders(@NonNull List<String> primaryProviders, @NonNull List<String> providers, int userId, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, SetEnabledProvidersException> callback) {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        Objects.requireNonNull(providers, "providers must not be null");
        Objects.requireNonNull(primaryProviders, "primaryProviders must not be null");
        try {
            this.mService.setEnabledProviders(primaryProviders, providers, userId, new SetEnabledProvidersTransport(executor, callback));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public boolean isEnabledCredentialProviderService(@NonNull ComponentName componentName) {
        Objects.requireNonNull(componentName, "componentName must not be null");
        try {
            return this.mService.isEnabledCredentialProviderService(componentName, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    @RequiresPermission(anyOf={"android.permission.QUERY_ALL_PACKAGES", "android.permission.LIST_ENABLED_CREDENTIAL_PROVIDERS"})
    public List<CredentialProviderInfo> getCredentialProviderServicesForTesting(int providerFilter) {
        try {
            return this.mService.getCredentialProviderServicesForTesting(providerFilter);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    @RequiresPermission(anyOf={"android.permission.QUERY_ALL_PACKAGES", "android.permission.LIST_ENABLED_CREDENTIAL_PROVIDERS"})
    public List<CredentialProviderInfo> getCredentialProviderServices(int userId, int providerFilter) {
        try {
            return this.mService.getCredentialProviderServices(userId, providerFilter);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean isServiceEnabled(@NonNull Context context) {
        Objects.requireNonNull(context, "context must not be null");
        if (context == null) {
            return false;
        }
        CredentialManager credentialManager = (CredentialManager)context.getSystemService("credential");
        if (credentialManager != null) {
            return credentialManager.isServiceEnabled();
        }
        return false;
    }

    private boolean isServiceEnabled() {
        try {
            return this.mService.isServiceEnabled();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public static boolean isCredentialDescriptionApiEnabled(Context context) {
        if (context == null) {
            return false;
        }
        CredentialManager credentialManager = (CredentialManager)context.getSystemService("credential");
        if (credentialManager != null) {
            return credentialManager.isCredentialDescriptionApiEnabled();
        }
        return false;
    }

    private boolean isCredentialDescriptionApiEnabled() {
        return DeviceConfig.getBoolean("credential_manager", DEVICE_CONFIG_ENABLE_CREDENTIAL_DESC_API, false);
    }

    public void registerCredentialDescription(@NonNull RegisterCredentialDescriptionRequest request) {
        Objects.requireNonNull(request, "request must not be null");
        try {
            this.mService.registerCredentialDescription(request, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void unregisterCredentialDescription(@NonNull UnregisterCredentialDescriptionRequest request) {
        Objects.requireNonNull(request, "request must not be null");
        try {
            this.mService.unregisterCredentialDescription(request, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    private static class GetCandidateCredentialsTransport
    extends IGetCandidateCredentialsCallback.Stub {
        private final Executor mExecutor;
        private final OutcomeReceiver<GetCandidateCredentialsResponse, GetCandidateCredentialsException> mCallback;

        private GetCandidateCredentialsTransport(Executor executor, OutcomeReceiver<GetCandidateCredentialsResponse, GetCandidateCredentialsException> callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponse(GetCandidateCredentialsResponse response) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onResult(response));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(String errorType, String message) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onError(new GetCandidateCredentialsException(errorType, message)));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private static class GetCredentialTransport
    extends IGetCredentialCallback.Stub {
        private final Context mContext;
        private final Executor mExecutor;
        private final OutcomeReceiver<GetCredentialResponse, GetCredentialException> mCallback;

        private GetCredentialTransport(Context context, Executor executor, OutcomeReceiver<GetCredentialResponse, GetCredentialException> callback) {
            this.mContext = context;
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPendingIntent(PendingIntent pendingIntent) {
            try {
                this.mContext.startIntentSender(pendingIntent.getIntentSender(), null, 0, 0, 0, OPTIONS_SENDER_BAL_OPTIN);
            }
            catch (IntentSender.SendIntentException e) {
                Log.e(CredentialManager.TAG, "startIntentSender() failed for intent:" + pendingIntent.getIntentSender(), e);
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallback.onError(new GetCredentialException("android.credentials.GetCredentialException.TYPE_UNKNOWN")));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponse(GetCredentialResponse response) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onResult(response));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(String errorType, String message) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onError(new GetCredentialException(errorType, message)));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    protected static class GetCredentialTransportPendingUseCase
    extends IGetCredentialCallback.Stub {
        @Nullable
        private PrepareGetCredentialResponse.GetPendingCredentialInternalCallback mCallback = null;

        private GetCredentialTransportPendingUseCase() {
        }

        public void setCallback(PrepareGetCredentialResponse.GetPendingCredentialInternalCallback callback) {
            if (this.mCallback != null) {
                throw new IllegalStateException("callback has already been set once");
            }
            this.mCallback = callback;
        }

        @Override
        public void onPendingIntent(PendingIntent pendingIntent) {
            if (this.mCallback != null) {
                this.mCallback.onPendingIntent(pendingIntent);
            } else {
                Log.d(CredentialManager.TAG, "Unexpected onPendingIntent call before the show invocation");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponse(GetCredentialResponse response) {
            if (this.mCallback != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mCallback.onResponse(response);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            } else {
                Log.d(CredentialManager.TAG, "Unexpected onResponse call before the show invocation");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(String errorType, String message) {
            if (this.mCallback != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mCallback.onError(errorType, message);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            } else {
                Log.d(CredentialManager.TAG, "Unexpected onError call before the show invocation");
            }
        }
    }

    private static class PrepareGetCredentialTransport
    extends IPrepareGetCredentialCallback.Stub {
        private final Executor mExecutor;
        private final OutcomeReceiver<PrepareGetCredentialResponse, GetCredentialException> mCallback;
        private final GetCredentialTransportPendingUseCase mGetCredentialTransport;

        private PrepareGetCredentialTransport(Executor executor, OutcomeReceiver<PrepareGetCredentialResponse, GetCredentialException> callback, GetCredentialTransportPendingUseCase getCredentialTransport) {
            this.mExecutor = executor;
            this.mCallback = callback;
            this.mGetCredentialTransport = getCredentialTransport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponse(PrepareGetCredentialResponseInternal response) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onResult(new PrepareGetCredentialResponse(response, this.mGetCredentialTransport)));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(String errorType, String message) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onError(new GetCredentialException(errorType, message)));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private static class CreateCredentialTransport
    extends ICreateCredentialCallback.Stub {
        private final Context mContext;
        private final Executor mExecutor;
        private final OutcomeReceiver<CreateCredentialResponse, CreateCredentialException> mCallback;

        private CreateCredentialTransport(Context context, Executor executor, OutcomeReceiver<CreateCredentialResponse, CreateCredentialException> callback) {
            this.mContext = context;
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPendingIntent(PendingIntent pendingIntent) {
            try {
                this.mContext.startIntentSender(pendingIntent.getIntentSender(), null, 0, 0, 0, OPTIONS_SENDER_BAL_OPTIN);
            }
            catch (IntentSender.SendIntentException e) {
                Log.e(CredentialManager.TAG, "startIntentSender() failed for intent:" + pendingIntent.getIntentSender(), e);
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallback.onError(new CreateCredentialException("android.credentials.CreateCredentialException.TYPE_UNKNOWN")));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponse(CreateCredentialResponse response) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onResult(response));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(String errorType, String message) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onError(new CreateCredentialException(errorType, message)));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private static class ClearCredentialStateTransport
    extends IClearCredentialStateCallback.Stub {
        private final Executor mExecutor;
        private final OutcomeReceiver<Void, ClearCredentialStateException> mCallback;

        private ClearCredentialStateTransport(Executor executor, OutcomeReceiver<Void, ClearCredentialStateException> callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onSuccess() {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mCallback.onResult(null);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(String errorType, String message) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onError(new ClearCredentialStateException(errorType, message)));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private static class SetEnabledProvidersTransport
    extends ISetEnabledProvidersCallback.Stub {
        private final Executor mExecutor;
        private final OutcomeReceiver<Void, SetEnabledProvidersException> mCallback;

        private SetEnabledProvidersTransport(Executor executor, OutcomeReceiver<Void, SetEnabledProvidersException> callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(Void result) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onResult(result));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public void onResponse() {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onResult(null));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(String errorType, String message) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onError(new SetEnabledProvidersException(errorType, message)));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProviderFilter {
    }
}

