/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.Insets;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Parcel;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.DisplayMetrics;
import android.util.MergedConfiguration;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.MotionEvent;
import android.view.WindowManager;

@RavenwoodKeepWholeClass
public class CompatibilityInfo
implements Parcelable {
    @UnsupportedAppUsage
    public static final CompatibilityInfo DEFAULT_COMPATIBILITY_INFO = new CompatibilityInfo(){};
    public static final int DEFAULT_NORMAL_SHORT_DIMENSION = 320;
    public static final float MAXIMUM_ASPECT_RATIO = 1.7791667f;
    private final int mCompatibilityFlags;
    private static final int SCALING_REQUIRED = 1;
    private static final int ALWAYS_NEEDS_COMPAT = 2;
    private static final int NEVER_NEEDS_COMPAT = 4;
    private static final int NEEDS_SCREEN_COMPAT = 8;
    private static final int NEEDS_COMPAT_RES = 16;
    private static final int HAS_OVERRIDE_SCALING = 32;
    public final int applicationDensity;
    @UnsupportedAppUsage
    public final float applicationScale;
    public final float applicationInvertedScale;
    public final float applicationDensityScale;
    public final float applicationDensityInvertedScale;
    public int applicationDisplayRotation = -1;
    private static float sOverrideInvertedScale = 1.0f;
    private static float sOverrideDensityInvertScale = 1.0f;
    private static int sOverrideDisplayRotation = -1;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    @NonNull
    public static final Parcelable.Creator<CompatibilityInfo> CREATOR = new Parcelable.Creator<CompatibilityInfo>(){

        @Override
        public CompatibilityInfo createFromParcel(Parcel source) {
            return new CompatibilityInfo(source);
        }

        public CompatibilityInfo[] newArray(int size) {
            return new CompatibilityInfo[size];
        }
    };

    @Deprecated
    @UnsupportedAppUsage
    public CompatibilityInfo(ApplicationInfo appInfo, int screenLayout, int sw, boolean forceCompat) {
        this(appInfo, screenLayout, sw, forceCompat, 1.0f);
    }

    public CompatibilityInfo(ApplicationInfo appInfo, int screenLayout, int sw, boolean forceCompat, float scaleFactor) {
        this(appInfo, screenLayout, sw, forceCompat, scaleFactor, scaleFactor);
    }

    public CompatibilityInfo(ApplicationInfo appInfo, int screenLayout, int sw, boolean forceCompat, float scaleFactor, float densityScaleFactor) {
        int compatFlags = 0;
        if (appInfo.targetSdkVersion < 26) {
            compatFlags |= 0x10;
        }
        if (scaleFactor != 1.0f || densityScaleFactor != 1.0f) {
            this.applicationScale = scaleFactor;
            this.applicationInvertedScale = 1.0f / scaleFactor;
            this.applicationDensityScale = densityScaleFactor;
            this.applicationDensityInvertedScale = 1.0f / densityScaleFactor;
            this.applicationDensity = (int)((float)DisplayMetrics.DENSITY_DEVICE_STABLE * this.applicationDensityInvertedScale + 0.5f);
            this.mCompatibilityFlags = 36;
            return;
        }
        if (appInfo.requiresSmallestWidthDp != 0 || appInfo.compatibleWidthLimitDp != 0 || appInfo.largestWidthLimitDp != 0) {
            int compat;
            int required;
            int n = required = appInfo.requiresSmallestWidthDp != 0 ? appInfo.requiresSmallestWidthDp : appInfo.compatibleWidthLimitDp;
            if (required == 0) {
                required = appInfo.largestWidthLimitDp;
            }
            int n2 = compat = appInfo.compatibleWidthLimitDp != 0 ? appInfo.compatibleWidthLimitDp : required;
            if (compat < required) {
                compat = required;
            }
            int largest = appInfo.largestWidthLimitDp;
            if (required > 320) {
                compatFlags |= 4;
            } else if (largest != 0 && sw > largest) {
                compatFlags |= 0xA;
            } else if (compat >= sw) {
                compatFlags |= 4;
            } else if (forceCompat) {
                compatFlags |= 8;
            }
            this.applicationDensity = DisplayMetrics.DENSITY_DEVICE;
            this.applicationScale = 1.0f;
            this.applicationInvertedScale = 1.0f;
            this.applicationDensityScale = 1.0f;
            this.applicationDensityInvertedScale = 1.0f;
        } else {
            int EXPANDABLE = 2;
            int LARGE_SCREENS = 8;
            int XLARGE_SCREENS = 32;
            int sizeInfo = 0;
            boolean anyResizeable = false;
            if ((appInfo.flags & 0x800) != 0) {
                sizeInfo |= 8;
                anyResizeable = true;
                if (!forceCompat) {
                    sizeInfo |= 0x22;
                }
            }
            if ((appInfo.flags & 0x80000) != 0) {
                anyResizeable = true;
                if (!forceCompat) {
                    sizeInfo |= 0x22;
                }
            }
            if ((appInfo.flags & 0x1000) != 0) {
                anyResizeable = true;
                sizeInfo |= 2;
            }
            if (forceCompat) {
                sizeInfo &= 0xFFFFFFFD;
            }
            compatFlags |= 8;
            switch (screenLayout & 0xF) {
                case 4: {
                    if ((sizeInfo & 0x20) != 0) {
                        compatFlags &= 0xFFFFFFF7;
                    }
                    if ((appInfo.flags & 0x80000) == 0) break;
                    compatFlags |= 4;
                    break;
                }
                case 3: {
                    if ((sizeInfo & 8) != 0) {
                        compatFlags &= 0xFFFFFFF7;
                    }
                    if ((appInfo.flags & 0x800) == 0) break;
                    compatFlags |= 4;
                }
            }
            if ((screenLayout & 0x10000000) != 0) {
                if ((sizeInfo & 2) != 0) {
                    compatFlags &= 0xFFFFFFF7;
                } else if (!anyResizeable) {
                    compatFlags |= 2;
                }
            } else {
                compatFlags &= 0xFFFFFFF7;
                compatFlags |= 4;
            }
            if ((appInfo.flags & 0x2000) != 0) {
                this.applicationDensity = DisplayMetrics.DENSITY_DEVICE;
                this.applicationScale = 1.0f;
                this.applicationInvertedScale = 1.0f;
                this.applicationDensityScale = 1.0f;
                this.applicationDensityInvertedScale = 1.0f;
            } else {
                this.applicationDensity = 160;
                this.applicationScale = (float)DisplayMetrics.DENSITY_DEVICE / 160.0f;
                this.applicationInvertedScale = 1.0f / this.applicationScale;
                this.applicationDensityScale = (float)DisplayMetrics.DENSITY_DEVICE / 160.0f;
                this.applicationDensityInvertedScale = 1.0f / this.applicationDensityScale;
                compatFlags |= 1;
            }
        }
        this.mCompatibilityFlags = compatFlags;
    }

    private CompatibilityInfo(int compFlags, int dens, float scale, float invertedScale) {
        this.mCompatibilityFlags = compFlags;
        this.applicationDensity = dens;
        this.applicationScale = scale;
        this.applicationInvertedScale = invertedScale;
        this.applicationDensityScale = (float)DisplayMetrics.DENSITY_DEVICE_STABLE / (float)dens;
        this.applicationDensityInvertedScale = 1.0f / this.applicationDensityScale;
    }

    @UnsupportedAppUsage
    private CompatibilityInfo() {
        this(4, DisplayMetrics.DENSITY_DEVICE, 1.0f, 1.0f);
    }

    @UnsupportedAppUsage
    public boolean isScalingRequired() {
        return (this.mCompatibilityFlags & 1) != 0;
    }

    public boolean hasOverrideScaling() {
        return (this.mCompatibilityFlags & 0x20) != 0;
    }

    public boolean isOverrideDisplayRotationRequired() {
        return this.applicationDisplayRotation != -1;
    }

    @UnsupportedAppUsage
    public boolean supportsScreen() {
        return (this.mCompatibilityFlags & 8) == 0;
    }

    public boolean neverSupportsScreen() {
        return (this.mCompatibilityFlags & 2) != 0;
    }

    public boolean alwaysSupportsScreen() {
        return (this.mCompatibilityFlags & 4) != 0;
    }

    public boolean needsCompatResources() {
        return (this.mCompatibilityFlags & 0x10) != 0;
    }

    @UnsupportedAppUsage
    public Translator getTranslator() {
        return (this.mCompatibilityFlags & 1) != 0 ? new Translator(this) : null;
    }

    public void applyDisplayMetricsIfNeeded(DisplayMetrics inoutDm, boolean applyToSize) {
        if (CompatibilityInfo.hasOverrideScale()) {
            CompatibilityInfo.scaleDisplayMetrics(sOverrideInvertedScale, sOverrideDensityInvertScale, inoutDm, applyToSize);
            return;
        }
        if (!this.equals(DEFAULT_COMPATIBILITY_INFO)) {
            this.applyToDisplayMetrics(inoutDm);
        }
    }

    public void applyToDisplayMetrics(DisplayMetrics inoutDm) {
        if (CompatibilityInfo.hasOverrideScale()) {
            return;
        }
        if (!this.supportsScreen()) {
            CompatibilityInfo.computeCompatibleScaling(inoutDm, inoutDm);
        } else {
            inoutDm.widthPixels = inoutDm.noncompatWidthPixels;
            inoutDm.heightPixels = inoutDm.noncompatHeightPixels;
        }
        if (this.isScalingRequired()) {
            CompatibilityInfo.scaleDisplayMetrics(this.applicationInvertedScale, this.applicationDensityInvertedScale, inoutDm, true);
        }
    }

    private static void scaleDisplayMetrics(float invertScale, float densityInvertScale, DisplayMetrics inoutDm, boolean applyToSize) {
        inoutDm.density = inoutDm.noncompatDensity * densityInvertScale;
        inoutDm.densityDpi = (int)((float)inoutDm.noncompatDensityDpi * densityInvertScale + 0.5f);
        inoutDm.scaledDensity = inoutDm.noncompatScaledDensity * densityInvertScale;
        inoutDm.xdpi = inoutDm.noncompatXdpi * densityInvertScale;
        inoutDm.ydpi = inoutDm.noncompatYdpi * densityInvertScale;
        if (applyToSize) {
            inoutDm.widthPixels = (int)((float)inoutDm.widthPixels * invertScale + 0.5f);
            inoutDm.heightPixels = (int)((float)inoutDm.heightPixels * invertScale + 0.5f);
        }
    }

    public void applyToConfiguration(int displayDensity, Configuration inoutConfig) {
        if (CompatibilityInfo.hasOverrideDisplayRotation()) {
            CompatibilityInfo.applyDisplayRotationConfiguration(sOverrideDisplayRotation, inoutConfig);
        }
        if (CompatibilityInfo.hasOverrideScale()) {
            return;
        }
        if (!this.supportsScreen()) {
            inoutConfig.screenLayout = inoutConfig.screenLayout & 0xFFFFFFF0 | 2;
            inoutConfig.screenWidthDp = inoutConfig.compatScreenWidthDp;
            inoutConfig.screenHeightDp = inoutConfig.compatScreenHeightDp;
            inoutConfig.smallestScreenWidthDp = inoutConfig.compatSmallestScreenWidthDp;
        }
        inoutConfig.densityDpi = displayDensity;
        if (this.isScalingRequired()) {
            CompatibilityInfo.scaleConfiguration(this.applicationInvertedScale, this.applicationDensityInvertedScale, inoutConfig);
        }
    }

    public static void scaleConfiguration(float invertScale, Configuration inoutConfig) {
        CompatibilityInfo.scaleConfiguration(invertScale, invertScale, inoutConfig);
    }

    public static void scaleConfiguration(float invertScale, float densityInvertScale, Configuration inoutConfig) {
        inoutConfig.densityDpi = (int)((float)inoutConfig.densityDpi * densityInvertScale + 0.5f);
        inoutConfig.windowConfiguration.scale(invertScale);
    }

    public static void applyDisplayRotationConfiguration(int displayRotation, Configuration inoutConfig) {
        if (displayRotation != -1) {
            inoutConfig.windowConfiguration.setDisplayRotation(displayRotation);
        }
    }

    public static void applyOverrideIfNeeded(Configuration config) {
        if (CompatibilityInfo.hasOverrideDisplayRotation()) {
            CompatibilityInfo.applyDisplayRotationConfiguration(sOverrideDisplayRotation, config);
        }
        if (CompatibilityInfo.hasOverrideScale()) {
            CompatibilityInfo.scaleConfiguration(sOverrideInvertedScale, sOverrideDensityInvertScale, config);
        }
    }

    public static void applyOverrideIfNeeded(MergedConfiguration mergedConfig) {
        if (CompatibilityInfo.hasOverrideDisplayRotation()) {
            CompatibilityInfo.applyDisplayRotationConfiguration(sOverrideDisplayRotation, mergedConfig.getGlobalConfiguration());
            CompatibilityInfo.applyDisplayRotationConfiguration(sOverrideDisplayRotation, mergedConfig.getOverrideConfiguration());
            CompatibilityInfo.applyDisplayRotationConfiguration(sOverrideDisplayRotation, mergedConfig.getMergedConfiguration());
        }
        if (CompatibilityInfo.hasOverrideScale()) {
            CompatibilityInfo.scaleConfiguration(sOverrideInvertedScale, sOverrideDensityInvertScale, mergedConfig.getGlobalConfiguration());
            CompatibilityInfo.scaleConfiguration(sOverrideInvertedScale, sOverrideDensityInvertScale, mergedConfig.getOverrideConfiguration());
            CompatibilityInfo.scaleConfiguration(sOverrideInvertedScale, sOverrideDensityInvertScale, mergedConfig.getMergedConfiguration());
        }
    }

    private static boolean hasOverrideScale() {
        return sOverrideInvertedScale != 1.0f || sOverrideDensityInvertScale != 1.0f;
    }

    public static void setOverrideInvertedScale(float invertScale) {
        CompatibilityInfo.setOverrideInvertedScale(invertScale, invertScale);
    }

    public static void setOverrideInvertedScale(float invertScale, float densityInvertScale) {
        sOverrideInvertedScale = invertScale;
        sOverrideDensityInvertScale = densityInvertScale;
    }

    public static float getOverrideInvertedScale() {
        return sOverrideInvertedScale;
    }

    public static float getOverrideDensityInvertedScale() {
        return sOverrideDensityInvertScale;
    }

    private static boolean hasOverrideDisplayRotation() {
        return sOverrideDisplayRotation != -1;
    }

    public static void setOverrideDisplayRotation(int displayRotation) {
        sOverrideDisplayRotation = displayRotation;
    }

    public static int getOverrideDisplayRotation() {
        return sOverrideDisplayRotation;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static float computeCompatibleScaling(DisplayMetrics dm, DisplayMetrics outDm) {
        float scale;
        int newHeight;
        int newWidth;
        int longSize;
        int shortSize;
        int width = dm.noncompatWidthPixels;
        int height = dm.noncompatHeightPixels;
        if (width < height) {
            shortSize = width;
            longSize = height;
        } else {
            shortSize = height;
            longSize = width;
        }
        int newShortSize = (int)(320.0f * dm.density + 0.5f);
        float aspect = (float)longSize / (float)shortSize;
        if (aspect > 1.7791667f) {
            aspect = 1.7791667f;
        }
        int newLongSize = (int)((float)newShortSize * aspect + 0.5f);
        if (width < height) {
            newWidth = newShortSize;
            newHeight = newLongSize;
        } else {
            newWidth = newLongSize;
            newHeight = newShortSize;
        }
        float sw = (float)width / (float)newWidth;
        float sh = (float)height / (float)newHeight;
        float f = scale = sw < sh ? sw : sh;
        if (scale < 1.0f) {
            scale = 1.0f;
        }
        if (outDm != null) {
            outDm.widthPixels = newWidth;
            outDm.heightPixels = newHeight;
        }
        return scale;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompatibilityInfo)) {
            return false;
        }
        CompatibilityInfo oc = (CompatibilityInfo)o;
        if (!this.isCompatibilityFlagsEqual(oc)) {
            return false;
        }
        if (!this.isScaleEqual(oc)) {
            return false;
        }
        return this.isDisplayRotationEqual(oc);
    }

    public int getCompatibilityChangesForConfig(@Nullable CompatibilityInfo o) {
        int changes = 0;
        if (!this.isDisplayRotationEqual(o)) {
            changes |= 0x20000000;
        }
        if (!this.isScaleEqual(o) || !this.isCompatibilityFlagsEqual(o)) {
            changes |= 0xD00;
        }
        return changes;
    }

    private boolean isScaleEqual(@Nullable CompatibilityInfo oc) {
        if (oc == null) {
            return false;
        }
        if (this.applicationDensity != oc.applicationDensity) {
            return false;
        }
        if (this.applicationScale != oc.applicationScale) {
            return false;
        }
        if (this.applicationInvertedScale != oc.applicationInvertedScale) {
            return false;
        }
        if (this.applicationDensityScale != oc.applicationDensityScale) {
            return false;
        }
        return this.applicationDensityInvertedScale == oc.applicationDensityInvertedScale;
    }

    private boolean isDisplayRotationEqual(@Nullable CompatibilityInfo oc) {
        return oc != null && oc.applicationDisplayRotation == this.applicationDisplayRotation;
    }

    private boolean isCompatibilityFlagsEqual(@Nullable CompatibilityInfo oc) {
        return oc != null && oc.mCompatibilityFlags == this.mCompatibilityFlags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("{");
        sb.append(this.applicationDensity);
        sb.append("dpi");
        if (this.isScalingRequired()) {
            sb.append(" ");
            sb.append(this.applicationScale);
            sb.append("x");
        }
        if (this.hasOverrideScaling()) {
            sb.append(" overrideInvScale=");
            sb.append(this.applicationInvertedScale);
            sb.append(" overrideDensityInvScale=");
            sb.append(this.applicationDensityInvertedScale);
        }
        if (this.isOverrideDisplayRotationRequired()) {
            sb.append(" overrideDisplayRotation=");
            sb.append(this.applicationDisplayRotation);
        }
        if (!this.supportsScreen()) {
            sb.append(" resizing");
        }
        if (this.neverSupportsScreen()) {
            sb.append(" never-compat");
        }
        if (this.alwaysSupportsScreen()) {
            sb.append(" always-compat");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.mCompatibilityFlags;
        result = 31 * result + this.applicationDensity;
        result = 31 * result + Float.floatToIntBits(this.applicationScale);
        result = 31 * result + Float.floatToIntBits(this.applicationInvertedScale);
        result = 31 * result + Float.floatToIntBits(this.applicationDensityScale);
        result = 31 * result + Float.floatToIntBits(this.applicationDensityInvertedScale);
        result = 31 * result + this.applicationDisplayRotation;
        return result;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mCompatibilityFlags);
        dest.writeInt(this.applicationDensity);
        dest.writeFloat(this.applicationScale);
        dest.writeFloat(this.applicationInvertedScale);
        dest.writeFloat(this.applicationDensityScale);
        dest.writeFloat(this.applicationDensityInvertedScale);
        dest.writeInt(this.applicationDisplayRotation);
    }

    private CompatibilityInfo(Parcel source) {
        this.mCompatibilityFlags = source.readInt();
        this.applicationDensity = source.readInt();
        this.applicationScale = source.readFloat();
        this.applicationInvertedScale = source.readFloat();
        this.applicationDensityScale = source.readFloat();
        this.applicationDensityInvertedScale = source.readFloat();
        this.applicationDisplayRotation = source.readInt();
    }

    public class Translator {
        @UnsupportedAppUsage
        public final float applicationScale;
        @UnsupportedAppUsage
        public final float applicationInvertedScale;
        private Rect mContentInsetsBuffer = null;
        private Rect mVisibleInsetsBuffer = null;
        private Region mTouchableAreaBuffer = null;

        Translator(CompatibilityInfo this$0, float applicationScale, float applicationInvertedScale) {
            this.applicationScale = applicationScale;
            this.applicationInvertedScale = applicationInvertedScale;
        }

        Translator(CompatibilityInfo this$0) {
            this(this$0, this$0.applicationScale, this$0.applicationInvertedScale);
        }

        @UnsupportedAppUsage
        public void translateRegionInWindowToScreen(Region transparentRegion) {
            transparentRegion.scale(this.applicationScale);
        }

        @UnsupportedAppUsage
        public void translateCanvas(Canvas canvas) {
            if (this.applicationScale == 1.5f) {
                float tinyOffset = 0.0026143792f;
                canvas.translate(0.0026143792f, 0.0026143792f);
            }
            canvas.scale(this.applicationScale, this.applicationScale);
        }

        @UnsupportedAppUsage
        public void translateEventInScreenToAppWindow(MotionEvent event) {
            event.scale(this.applicationInvertedScale);
        }

        @UnsupportedAppUsage
        public void translateWindowLayout(WindowManager.LayoutParams params) {
            params.scale(this.applicationScale);
        }

        public float translateLengthInAppWindowToScreen(float length) {
            return length * this.applicationScale;
        }

        @UnsupportedAppUsage
        public void translateRectInAppWindowToScreen(Rect rect) {
            rect.scale(this.applicationScale);
        }

        @UnsupportedAppUsage
        public void translateRectInScreenToAppWindow(@Nullable Rect rect) {
            if (rect == null) {
                return;
            }
            rect.scale(this.applicationInvertedScale);
        }

        public void translateInsetsStateInScreenToAppWindow(InsetsState state) {
            state.scale(this.applicationInvertedScale);
        }

        public void translateSourceControlsInScreenToAppWindow(InsetsSourceControl[] controls) {
            if (controls == null) {
                return;
            }
            float scale = this.applicationInvertedScale;
            if (scale == 1.0f) {
                return;
            }
            for (InsetsSourceControl control : controls) {
                if (control == null) continue;
                Insets hint = control.getInsetsHint();
                control.setInsetsHint((int)(scale * (float)hint.left), (int)(scale * (float)hint.top), (int)(scale * (float)hint.right), (int)(scale * (float)hint.bottom));
            }
        }

        public void translatePointInScreenToAppWindow(PointF point) {
            float scale = this.applicationInvertedScale;
            if (scale != 1.0f) {
                point.x *= scale;
                point.y *= scale;
            }
        }

        public void translateLayoutParamsInAppWindowToScreen(WindowManager.LayoutParams params) {
            params.scale(this.applicationScale);
        }

        @UnsupportedAppUsage
        public Rect getTranslatedContentInsets(Rect contentInsets) {
            if (this.mContentInsetsBuffer == null) {
                this.mContentInsetsBuffer = new Rect();
            }
            this.mContentInsetsBuffer.set(contentInsets);
            this.translateRectInAppWindowToScreen(this.mContentInsetsBuffer);
            return this.mContentInsetsBuffer;
        }

        public Rect getTranslatedVisibleInsets(Rect visibleInsets) {
            if (this.mVisibleInsetsBuffer == null) {
                this.mVisibleInsetsBuffer = new Rect();
            }
            this.mVisibleInsetsBuffer.set(visibleInsets);
            this.translateRectInAppWindowToScreen(this.mVisibleInsetsBuffer);
            return this.mVisibleInsetsBuffer;
        }

        public Region getTranslatedTouchableArea(Region touchableArea) {
            if (this.mTouchableAreaBuffer == null) {
                this.mTouchableAreaBuffer = new Region();
            }
            this.mTouchableAreaBuffer.set(touchableArea);
            this.mTouchableAreaBuffer.scale(this.applicationScale);
            return this.mTouchableAreaBuffer;
        }
    }

    public static class CompatScale {
        public final float mScaleFactor;
        public final float mDensityScaleFactor;

        public CompatScale(float scaleFactor) {
            this(scaleFactor, scaleFactor);
        }

        public CompatScale(float scaleFactor, float densityScaleFactor) {
            this.mScaleFactor = scaleFactor;
            this.mDensityScaleFactor = densityScaleFactor;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CompatScale)) {
                return false;
            }
            try {
                CompatScale oc = (CompatScale)o;
                if (this.mScaleFactor != oc.mScaleFactor) {
                    return false;
                }
                return this.mDensityScaleFactor == oc.mDensityScaleFactor;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("mScaleFactor= ");
            sb.append(this.mScaleFactor);
            sb.append(" mDensityScaleFactor= ");
            sb.append(this.mDensityScaleFactor);
            return sb.toString();
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + Float.floatToIntBits(this.mScaleFactor);
            result = 31 * result + Float.floatToIntBits(this.mDensityScaleFactor);
            return result;
        }
    }
}

