/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ResourcesManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ActivityInfo;
import android.content.res.ApkAssets;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager_Delegate;
import android.content.res.Configuration;
import android.content.res.Validator;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.content.res.loader.ResourcesLoader;
import android.os.ParcelFileDescriptor;
import android.os._Original_Build;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.ravenwood.annotation.RavenwoodThrow;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.om.OverlayConfig;
import com.android.internal.hidden_from_bootclasspath.android.content.res.Flags;
import com.android.internal.ravenwood.RavenwoodEnvironment;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

@RavenwoodKeepWholeClass
public class AssetManager
implements AutoCloseable {
    private static final String TAG = "AssetManager";
    private static final boolean DEBUG_REFS = false;
    public static final String FRAMEWORK_APK_PATH = AssetManager.getFrameworkApkPath();
    private static final String FRAMEWORK_APK_PATH_DEVICE = "/system/framework/framework-res.apk";
    private static final String FRAMEWORK_APK_PATH_RAVENWOOD = "ravenwood-data/framework-res.apk";
    private static final Object sSync = new Object();
    private static final ApkAssets[] sEmptyApkAssets = new ApkAssets[0];
    @UnsupportedAppUsage
    @GuardedBy(value={"sSync"})
    static AssetManager sSystem = null;
    @GuardedBy(value={"sSync"})
    private static ApkAssets[] sSystemApkAssets = new ApkAssets[0];
    @GuardedBy(value={"sSync"})
    private static ArraySet<ApkAssets> sSystemApkAssetsSet;
    public static final int COOKIE_UNKNOWN = -1;
    public static final int ACCESS_UNKNOWN = 0;
    public static final int ACCESS_RANDOM = 1;
    public static final int ACCESS_STREAMING = 2;
    public static final int ACCESS_BUFFER = 3;
    @GuardedBy(value={"this"})
    private final TypedValue mValue = new TypedValue();
    @GuardedBy(value={"this"})
    private final long[] mOffsets = new long[2];
    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    private long mObject;
    @GuardedBy(value={"this"})
    private ApkAssets[] mApkAssets;
    @GuardedBy(value={"this"})
    private boolean mOpen = true;
    private AtomicInteger mNumRefs = new AtomicInteger(1);
    @GuardedBy(value={"this"})
    private HashMap<Long, RuntimeException> mRefStacks;
    private ResourcesLoader[] mLoaders;

    @RavenwoodReplace
    private static String getFrameworkApkPath() {
        return FRAMEWORK_APK_PATH_DEVICE;
    }

    private static String getFrameworkApkPath$ravenwood() {
        return RavenwoodEnvironment.getInstance().getRavenwoodRuntimePath() + FRAMEWORK_APK_PATH_RAVENWOOD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public AssetManager() {
        ApkAssets[] assets;
        Object object = sSync;
        synchronized (object) {
            AssetManager.createSystemAssetsInZygoteLocked(false, FRAMEWORK_APK_PATH);
            assets = sSystemApkAssets;
        }
        this.mObject = AssetManager.nativeCreate();
        this.setApkAssets(assets, false);
    }

    private AssetManager(boolean sentinel) {
        this.mObject = AssetManager.nativeCreate();
    }

    @GuardedBy(value={"sSync"})
    @VisibleForTesting
    public static void createSystemAssetsInZygoteLocked_Original(boolean reinitialize, String frameworkPath) {
        if (sSystem != null && !reinitialize) {
            return;
        }
        try {
            String[] systemIdmapPaths;
            ArrayList<ApkAssets> apkAssets = new ArrayList<ApkAssets>();
            apkAssets.add(ApkAssets.loadFromPath(frameworkPath, 1));
            for (String idmapPath : systemIdmapPaths = RavenwoodEnvironment.getInstance().isRunningOnRavenwood() ? new String[]{} : OverlayConfig.getZygoteInstance().createImmutableFrameworkIdmapsInZygote()) {
                apkAssets.add(ApkAssets.loadOverlayFromPath(idmapPath, 1));
            }
            sSystemApkAssetsSet = new ArraySet(apkAssets);
            sSystemApkAssets = apkAssets.toArray(new ApkAssets[0]);
            if (sSystem == null) {
                sSystem = new AssetManager(true);
            }
            sSystem.setApkAssets(sSystemApkAssets, false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create system AssetManager", e);
        }
    }

    @LayoutlibDelegate
    public static void createSystemAssetsInZygoteLocked(boolean bl, String string2) {
        AssetManager_Delegate.createSystemAssetsInZygoteLocked(bl, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static AssetManager getSystem() {
        Object object = sSync;
        synchronized (object) {
            AssetManager.createSystemAssetsInZygoteLocked(false, FRAMEWORK_APK_PATH);
            return sSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                return;
            }
            this.mOpen = false;
            this.decRefs(this.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApkAssets(@NonNull ApkAssets[] apkAssets, boolean invalidateCaches) {
        Objects.requireNonNull(apkAssets, "apkAssets");
        ApkAssets[] newApkAssets = new ApkAssets[sSystemApkAssets.length + apkAssets.length];
        System.arraycopy(sSystemApkAssets, 0, newApkAssets, 0, sSystemApkAssets.length);
        int newLength = sSystemApkAssets.length;
        for (ApkAssets apkAsset : apkAssets) {
            if (sSystemApkAssetsSet.contains(apkAsset)) continue;
            newApkAssets[newLength++] = apkAsset;
        }
        if (newLength != newApkAssets.length) {
            newApkAssets = Arrays.copyOf(newApkAssets, newLength);
        }
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            this.mApkAssets = newApkAssets;
            AssetManager.nativeSetApkAssets(this.mObject, this.mApkAssets, invalidateCaches, false);
            if (invalidateCaches) {
                this.invalidateCachesLocked(-1);
            }
        }
    }

    @RavenwoodThrow(blockedBy={ResourcesLoader.class})
    void setLoaders(@NonNull List<ResourcesLoader> newLoaders) {
        Objects.requireNonNull(newLoaders, "newLoaders");
        ArrayList<ApkAssets> apkAssets = new ArrayList<ApkAssets>();
        for (int i = 0; i < this.mApkAssets.length; ++i) {
            if (this.mApkAssets[i].isForLoader()) continue;
            apkAssets.add(this.mApkAssets[i]);
        }
        if (!newLoaders.isEmpty()) {
            int loaderStartIndex = apkAssets.size();
            ArraySet<ApkAssets> uniqueLoaderApkAssets = new ArraySet<ApkAssets>();
            for (int i = newLoaders.size() - 1; i >= 0; --i) {
                List<ApkAssets> currentLoaderApkAssets = newLoaders.get(i).getApkAssets();
                for (int j = currentLoaderApkAssets.size() - 1; j >= 0; --j) {
                    ApkAssets loaderApkAssets = currentLoaderApkAssets.get(j);
                    if (!uniqueLoaderApkAssets.add(loaderApkAssets)) continue;
                    apkAssets.add(loaderStartIndex, loaderApkAssets);
                }
            }
        }
        this.mLoaders = newLoaders.toArray(new ResourcesLoader[0]);
        this.setApkAssets(apkAssets.toArray(new ApkAssets[0]), true);
    }

    private void invalidateCachesLocked(int diff) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @NonNull
    public ApkAssets[] getApkAssets() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (this.mOpen) {
                return this.mApkAssets;
            }
        }
        return sEmptyApkAssets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public String[] getApkPaths() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (this.mOpen) {
                String[] paths = new String[this.mApkAssets.length];
                int count = this.mApkAssets.length;
                for (int i = 0; i < count; ++i) {
                    paths[i] = this.mApkAssets[i].getAssetPath();
                }
                return paths;
            }
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findCookieForPath(@NonNull String path) {
        Objects.requireNonNull(path, "path");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int count = this.mApkAssets.length;
            for (int i = 0; i < count; ++i) {
                if (!path.equals(this.mApkAssets[i].getAssetPath())) continue;
                return i + 1;
            }
        }
        return 0;
    }

    @Deprecated
    @UnsupportedAppUsage
    public int addAssetPath(String path) {
        return this.addAssetPathInternal(List.of(new ResourcesManager.ApkKey(path, false, false)), false);
    }

    @Deprecated
    @UnsupportedAppUsage
    public int addAssetPathAsSharedLibrary(String path) {
        return this.addAssetPathInternal(List.of(new ResourcesManager.ApkKey(path, true, false)), false);
    }

    @Deprecated
    @UnsupportedAppUsage
    public int addOverlayPath(String path) {
        return this.addAssetPathInternal(List.of(new ResourcesManager.ApkKey(path, false, true)), false);
    }

    public void addApkKeys(@NonNull List<ResourcesManager.ApkKey> keys, boolean presetAssets) {
        this.addAssetPathInternal(keys, presetAssets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addAssetPathInternal(List<ResourcesManager.ApkKey> apkKeys, boolean presetAssets) {
        Objects.requireNonNull(apkKeys, "apkKeys");
        if (apkKeys.isEmpty()) {
            return 0;
        }
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            int originalAssetsCount = this.mApkAssets.length;
            ArrayMap<String, Integer> assetPaths = new ArrayMap<String, Integer>(originalAssetsCount);
            for (int i = 0; i < originalAssetsCount; ++i) {
                assetPaths.put(this.mApkAssets[i].getAssetPath(), i);
            }
            ArrayList<ResourcesManager.ApkKey> newKeys = new ArrayList<ResourcesManager.ApkKey>(apkKeys.size());
            int lastFoundIndex = -1;
            int pathsSize = apkKeys.size();
            for (int i = 0; i < pathsSize; ++i) {
                ResourcesManager.ApkKey key = apkKeys.get(i);
                Integer index = (Integer)assetPaths.get(key.path);
                if (index == null) {
                    newKeys.add(key);
                    continue;
                }
                lastFoundIndex = index;
            }
            if (newKeys.isEmpty()) {
                return lastFoundIndex + 1;
            }
            ArrayList<ApkAssets> newAssets = AssetManager.loadAssets(newKeys);
            if (newAssets.isEmpty()) {
                return 0;
            }
            this.mApkAssets = this.makeNewAssetsArrayLocked(newAssets);
            AssetManager.nativeSetApkAssets(this.mObject, this.mApkAssets, true, presetAssets);
            this.invalidateCachesLocked(-1);
            return originalAssetsCount + 1;
        }
    }

    @GuardedBy(value={"this"})
    @NonNull
    private ApkAssets[] makeNewAssetsArrayLocked(@NonNull ArrayList<ApkAssets> newNonLoaderAssets) {
        int originalAssetsCount;
        int firstLoaderIndex = originalAssetsCount = this.mApkAssets.length;
        for (int i = 0; i < originalAssetsCount; ++i) {
            if (!this.mApkAssets[i].isForLoader()) continue;
            firstLoaderIndex = i;
            break;
        }
        int newAssetsSize = newNonLoaderAssets.size();
        ApkAssets[] newAssetsArray = new ApkAssets[originalAssetsCount + newAssetsSize];
        if (firstLoaderIndex > 0) {
            System.arraycopy(this.mApkAssets, 0, newAssetsArray, 0, firstLoaderIndex);
        }
        for (int i = 0; i < newAssetsSize; ++i) {
            newAssetsArray[firstLoaderIndex + i] = newNonLoaderAssets.get(i);
        }
        if (originalAssetsCount > firstLoaderIndex) {
            System.arraycopy(this.mApkAssets, firstLoaderIndex, newAssetsArray, firstLoaderIndex + newAssetsSize, originalAssetsCount - firstLoaderIndex);
        }
        return newAssetsArray;
    }

    @NonNull
    private static ArrayList<ApkAssets> loadAssets(@NonNull ArrayList<ResourcesManager.ApkKey> keys) {
        int pathsSize = keys.size();
        ArrayList<ApkAssets> loadedAssets = new ArrayList<ApkAssets>(pathsSize);
        ResourcesManager resourcesManager = ResourcesManager.getInstance();
        for (int i = 0; i < pathsSize; ++i) {
            ResourcesManager.ApkKey key = keys.get(i);
            try {
                loadedAssets.add(resourcesManager.loadApkAssets(key));
                continue;
            }
            catch (IOException e) {
                Log.w(TAG, "Failed to load asset, key = " + key, e);
            }
        }
        return loadedAssets;
    }

    @NonNull
    @RavenwoodThrow(blockedBy={ResourcesLoader.class})
    public List<ResourcesLoader> getLoaders() {
        return this.mLoaders == null ? Collections.emptyList() : Arrays.asList(this.mLoaders);
    }

    @GuardedBy(value={"this"})
    private void ensureValidLocked() {
        if (this.mObject == 0L) {
            throw new RuntimeException("AssetManager has been destroyed");
        }
    }

    @GuardedBy(value={"this"})
    private void ensureOpenLocked() {
        if (!this.mOpen) {
            throw new RuntimeException("AssetManager has been closed");
        }
        if (this.mObject == 0L) {
            throw new RuntimeException("AssetManager is open but the native object is gone");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    boolean getResourceValue(int resId, int densityDpi, @NonNull TypedValue outValue, boolean resolveRefs) {
        Objects.requireNonNull(outValue, "outValue");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int cookie = AssetManager.nativeGetResourceValue(this.mObject, resId, (short)densityDpi, outValue, resolveRefs);
            if (cookie <= 0) {
                return false;
            }
            outValue.changingConfigurations = ActivityInfo.activityInfoConfigNativeToJava(outValue.changingConfigurations);
            return outValue.type != 3 || (outValue.string = this.getPooledStringForCookie(cookie, outValue.data)) != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @Nullable
    CharSequence getResourceText(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            TypedValue outValue = this.mValue;
            if (this.getResourceValue(resId, 0, outValue, true)) {
                return outValue.coerceToString();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @Nullable
    CharSequence getResourceBagText(int resId, int bagEntryId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            TypedValue outValue = this.mValue;
            int cookie = AssetManager.nativeGetResourceBagValue(this.mObject, resId, bagEntryId, outValue);
            if (cookie <= 0) {
                return null;
            }
            outValue.changingConfigurations = ActivityInfo.activityInfoConfigNativeToJava(outValue.changingConfigurations);
            if (outValue.type == 3) {
                return this.getPooledStringForCookie(cookie, outValue.data);
            }
            return outValue.coerceToString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getResourceArraySize(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceArraySize(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getResourceArray(int resId, @NonNull int[] outData) {
        Objects.requireNonNull(outData, "outData");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceArray(this.mObject, resId, outData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String[] getResourceStringArray(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceStringArray(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CharSequence[] getResourceTextArray(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int[] rawInfoArray = AssetManager.nativeGetResourceStringArrayInfo(this.mObject, resId);
            if (rawInfoArray == null) {
                return null;
            }
            int rawInfoArrayLen = rawInfoArray.length;
            int infoArrayLen = rawInfoArrayLen / 2;
            CharSequence[] retArray = new CharSequence[infoArrayLen];
            int i = 0;
            int j = 0;
            while (i < rawInfoArrayLen) {
                int cookie = rawInfoArray[i];
                int index = rawInfoArray[i + 1];
                retArray[j] = index >= 0 && cookie > 0 ? this.getPooledStringForCookie(cookie, index) : null;
                i += 2;
                ++j;
            }
            return retArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    int[] getResourceIntArray(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceIntArray(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getStyleAttributes(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetStyleAttributes(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getThemeValue(long theme, int resId, @NonNull TypedValue outValue, boolean resolveRefs) {
        Objects.requireNonNull(outValue, "outValue");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int cookie = AssetManager.nativeThemeGetAttributeValue(this.mObject, theme, resId, outValue, resolveRefs);
            if (cookie <= 0) {
                return false;
            }
            outValue.changingConfigurations = ActivityInfo.activityInfoConfigNativeToJava(outValue.changingConfigurations);
            return outValue.type != 3 || (outValue.string = this.getPooledStringForCookie(cookie, outValue.data)) != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpTheme(long theme, int priority, String tag, String prefix) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeThemeDump(this.mObject, theme, priority, tag, prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @Nullable
    String getResourceName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @Nullable
    String getResourcePackageName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourcePackageName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @Nullable
    String getResourceTypeName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceTypeName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @Nullable
    String getResourceEntryName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceEntryName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    int getResourceIdentifier(@NonNull String name, @Nullable String defType, @Nullable String defPackage) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceIdentifier(this.mObject, name, defType, defPackage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getParentThemeIdentifier(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetParentThemeIdentifier(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceResolutionLoggingEnabled(boolean enabled) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeSetResourceResolutionLoggingEnabled(this.mObject, enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLastResourceResolution() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetLastResourceResolution(this.mObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAllocatedTable() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeContainsAllocatedTable(this.mObject);
        }
    }

    @Nullable
    CharSequence getPooledStringForCookie(int cookie, int id2) {
        return this.getApkAssets()[cookie - 1].getStringFromPool(id2);
    }

    @NonNull
    public InputStream open(@NonNull String fileName) throws IOException {
        return this.open(fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public InputStream open(@NonNull String fileName, int accessMode) throws IOException {
        Objects.requireNonNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            long asset = AssetManager.nativeOpenAsset(this.mObject, fileName, accessMode);
            if (asset == 0L) {
                throw new FileNotFoundException("Asset file: " + fileName);
            }
            AssetInputStream assetInputStream = new AssetInputStream(asset);
            this.incRefsLocked(assetInputStream.hashCode());
            return assetInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public AssetFileDescriptor openFd(@NonNull String fileName) throws IOException {
        Objects.requireNonNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            ParcelFileDescriptor pfd = AssetManager.nativeOpenAssetFd(this.mObject, fileName, this.mOffsets);
            if (pfd == null) {
                throw new FileNotFoundException("Asset file: " + fileName);
            }
            return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String[] list(@NonNull String path) throws IOException {
        Objects.requireNonNull(path, "path");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeList(this.mObject, path);
        }
    }

    @UnsupportedAppUsage
    @NonNull
    public InputStream openNonAsset(@NonNull String fileName) throws IOException {
        return this.openNonAsset(0, fileName, 2);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @NonNull
    public InputStream openNonAsset(@NonNull String fileName, int accessMode) throws IOException {
        return this.openNonAsset(0, fileName, accessMode);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @NonNull
    public InputStream openNonAsset(int cookie, @NonNull String fileName) throws IOException {
        return this.openNonAsset(cookie, fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @NonNull
    public InputStream openNonAsset(int cookie, @NonNull String fileName, int accessMode) throws IOException {
        Objects.requireNonNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            long asset = AssetManager.nativeOpenNonAsset(this.mObject, cookie, fileName, accessMode);
            if (asset == 0L) {
                throw new FileNotFoundException("Asset absolute file: " + fileName);
            }
            AssetInputStream assetInputStream = new AssetInputStream(asset);
            this.incRefsLocked(assetInputStream.hashCode());
            return assetInputStream;
        }
    }

    @NonNull
    public AssetFileDescriptor openNonAssetFd(@NonNull String fileName) throws IOException {
        return this.openNonAssetFd(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public AssetFileDescriptor openNonAssetFd(int cookie, @NonNull String fileName) throws IOException {
        Objects.requireNonNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            ParcelFileDescriptor pfd = AssetManager.nativeOpenNonAssetFd(this.mObject, cookie, fileName, this.mOffsets);
            if (pfd == null) {
                throw new FileNotFoundException("Asset absolute file: " + fileName);
            }
            return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
        }
    }

    @NonNull
    public XmlResourceParser openXmlResourceParser(@NonNull String fileName) throws IOException {
        return this.openXmlResourceParser(0, fileName);
    }

    @NonNull
    public XmlResourceParser openXmlResourceParser(int cookie, @NonNull String fileName) throws IOException {
        return this.openXmlResourceParser(cookie, fileName, true);
    }

    @NonNull
    public XmlResourceParser openXmlResourceParser(int cookie, @NonNull String fileName, boolean hasFlags) throws IOException {
        try (XmlBlock block = this.openXmlBlockAsset(cookie, fileName, hasFlags);){
            XmlResourceParser parser = block.newParser(0, new Validator());
            if (parser == null) {
                throw new AssertionError((Object)"block.newParser() returned a null parser");
            }
            XmlResourceParser xmlResourceParser = parser;
            return xmlResourceParser;
        }
    }

    @NonNull
    XmlBlock openXmlBlockAsset(@NonNull String fileName) throws IOException {
        return this.openXmlBlockAsset(0, fileName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    XmlBlock openXmlBlockAsset(int cookie, @NonNull String fileName, boolean usesFeatureFlags) throws IOException {
        Objects.requireNonNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            long xmlBlock = AssetManager.nativeOpenXmlAsset(this.mObject, cookie, fileName);
            if (xmlBlock == 0L) {
                throw new FileNotFoundException("Asset XML file: " + fileName);
            }
            XmlBlock block = new XmlBlock(this, xmlBlock, usesFeatureFlags);
            this.incRefsLocked(block.hashCode());
            return block;
        }
    }

    void xmlBlockGone(int id2) {
        this.decRefs(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RavenwoodReplace
    void applyStyle(long themePtr, int defStyleAttr, int defStyleRes, @Nullable XmlBlock.Parser parser, @NonNull int[] inAttrs, long outValuesAddress, long outIndicesAddress) {
        Objects.requireNonNull(inAttrs, "inAttrs");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeApplyStyle(this.mObject, themePtr, defStyleAttr, defStyleRes, parser != null ? parser.mParseState : 0L, inAttrs, outValuesAddress, outIndicesAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getAttributeResolutionStack(long themePtr, int defStyleAttr, int defStyleRes, int xmlStyle) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeAttributeResolutionStack(this.mObject, themePtr, xmlStyle, defStyleAttr, defStyleRes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    boolean resolveAttrs(long themePtr, int defStyleAttr, int defStyleRes, @Nullable int[] inValues, @NonNull int[] inAttrs, @NonNull int[] outValues, @NonNull int[] outIndices) {
        Objects.requireNonNull(inAttrs, "inAttrs");
        Objects.requireNonNull(outValues, "outValues");
        Objects.requireNonNull(outIndices, "outIndices");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeResolveAttrs(this.mObject, themePtr, defStyleAttr, defStyleRes, inValues, inAttrs, outValues, outIndices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    boolean retrieveAttributes(@NonNull XmlBlock.Parser parser, @NonNull int[] inAttrs, @NonNull int[] outValues, @NonNull int[] outIndices) {
        Objects.requireNonNull(parser, "parser");
        Objects.requireNonNull(inAttrs, "inAttrs");
        Objects.requireNonNull(outValues, "outValues");
        Objects.requireNonNull(outIndices, "outIndices");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeRetrieveAttributes(this.mObject, parser.mParseState, inAttrs, outValues, outIndices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    long createTheme() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            long themePtr = AssetManager.nativeThemeCreate(this.mObject);
            this.incRefsLocked(themePtr);
            return themePtr;
        }
    }

    void releaseTheme(long themePtr) {
        this.decRefs(themePtr);
    }

    static long getThemeFreeFunction() {
        return AssetManager.nativeGetThemeFreeFunction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyStyleToTheme(long themePtr, int resId, boolean force) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeThemeApplyStyle(this.mObject, themePtr, resId, force);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AssetManager rebaseTheme(long themePtr, @NonNull AssetManager newAssetManager, int[] styleIds, boolean[] force, int count) {
        AssetManager assetManager;
        if (this != newAssetManager) {
            assetManager = this;
            synchronized (assetManager) {
                this.ensureValidLocked();
                this.decRefs(themePtr);
            }
            assetManager = newAssetManager;
            synchronized (assetManager) {
                newAssetManager.ensureValidLocked();
                newAssetManager.incRefsLocked(themePtr);
            }
        }
        try {
            assetManager = newAssetManager;
            synchronized (assetManager) {
                newAssetManager.ensureValidLocked();
                AssetManager.nativeThemeRebase(newAssetManager.mObject, themePtr, styleIds, force, count);
            }
        }
        finally {
            Reference.reachabilityFence(newAssetManager);
        }
        return newAssetManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    void setThemeTo(long dstThemePtr, @NonNull AssetManager srcAssetManager, long srcThemePtr) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager assetManager2 = srcAssetManager;
            synchronized (assetManager2) {
                srcAssetManager.ensureValidLocked();
                AssetManager.nativeThemeCopy(this.mObject, dstThemePtr, srcAssetManager.mObject, srcThemePtr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (this.mObject != 0L) {
                AssetManager.nativeDestroy(this.mObject);
                this.mObject = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public boolean isUpToDate() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                return false;
            }
            for (ApkAssets apkAssets : this.mApkAssets) {
                if (apkAssets.isUpToDate()) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLocales() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetLocales(this.mObject, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNonSystemLocales() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetLocales(this.mObject, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Configuration[] getSizeConfigurations() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetSizeConfigurations(this.mObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Configuration[] getSizeAndUiModeConfigurations() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetSizeAndUiModeConfigurations(this.mObject);
        }
    }

    @UnsupportedAppUsage
    public void setConfiguration(int mcc, int mnc, String defaultLocale, String[] locales, int orientation, int touchscreen, int density, int keyboard, int keyboardHidden, int navigation, int screenWidth, int screenHeight, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, int screenLayout, int uiMode, int colorMode, int grammaticalGender, int sdkVersionFull) {
        this.setConfigurationInternal(mcc, mnc, defaultLocale, locales, orientation, touchscreen, density, keyboard, keyboardHidden, navigation, screenWidth, screenHeight, smallestScreenWidthDp, screenWidthDp, screenHeightDp, screenLayout, uiMode, colorMode, grammaticalGender, sdkVersionFull, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConfigurationInternal(int mcc, int mnc, String defaultLocale, String[] locales, int orientation, int touchscreen, int density, int keyboard, int keyboardHidden, int navigation, int screenWidth, int screenHeight, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, int screenLayout, int uiMode, int colorMode, int grammaticalGender, int sdkVersionFull, boolean forceRefresh) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int majorVersion = _Original_Build.getMajorSdkVersion(sdkVersionFull);
            int minorVersion = Flags.resourcesMinorVersionSupport() ? _Original_Build.getMinorSdkVersion(sdkVersionFull) : 0;
            AssetManager.nativeSetConfiguration(this.mObject, mcc, mnc, defaultLocale, locales, orientation, touchscreen, density, keyboard, keyboardHidden, navigation, screenWidth, screenHeight, smallestScreenWidthDp, screenWidthDp, screenHeightDp, screenLayout, uiMode, colorMode, grammaticalGender, majorVersion, minorVersion, forceRefresh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverlayConstraints(int displayId, int deviceId) {
        if (!Flags.rroConstraints()) {
            return;
        }
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeSetOverlayConstraints(this.mObject, displayId, deviceId);
        }
    }

    @UnsupportedAppUsage
    public SparseArray<String> getAssignedPackageIdentifiers_Original() {
        return this.getAssignedPackageIdentifiers(true, true);
    }

    @LayoutlibDelegate
    public SparseArray<String> getAssignedPackageIdentifiers() {
        return AssetManager_Delegate.getAssignedPackageIdentifiers(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparseArray<String> getAssignedPackageIdentifiers_Original(boolean includeOverlays, boolean includeLoaders) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetAssignedPackageIdentifiers(this.mObject, includeOverlays, includeLoaders);
        }
    }

    @LayoutlibDelegate
    public SparseArray<String> getAssignedPackageIdentifiers(boolean bl, boolean bl2) {
        return AssetManager_Delegate.getAssignedPackageIdentifiers(this, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"this"})
    @Nullable
    public Map<String, String> getOverlayableMap(String packageName) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetOverlayableMap(this.mObject, packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"this"})
    @Nullable
    public String getOverlayablesToString(String packageName) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetOverlayablesToString(this.mObject, packageName);
        }
    }

    @GuardedBy(value={"this"})
    private void incRefsLocked(long id2) {
        this.mNumRefs.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decRefs(long id2) {
        if (this.mNumRefs.decrementAndGet() == 0) {
            AssetManager assetManager = this;
            synchronized (assetManager) {
                if (this.mNumRefs.get() == 0 && this.mObject != 0L) {
                    AssetManager.nativeDestroy(this.mObject);
                    this.mObject = 0L;
                    this.mApkAssets = sEmptyApkAssets;
                }
            }
        }
    }

    synchronized void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "class=" + this.getClass());
        pw.println(prefix + "apkAssets=");
        for (int i = 0; i < this.mApkAssets.length; ++i) {
            pw.println(prefix + i);
            this.mApkAssets[i].dump(pw, prefix + "  ");
        }
    }

    @LayoutlibDelegate
    private static long nativeCreate() {
        return AssetManager_Delegate.nativeCreate();
    }

    @LayoutlibDelegate
    private static void nativeDestroy(long l) {
        AssetManager_Delegate.nativeDestroy(l);
    }

    private static void nativeSetApkAssets(long l, @NonNull ApkAssets[] apkAssetsArray, boolean bl, boolean bl2) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeSetApkAssets(J[Landroid/content/res/ApkAssets;ZZ)V", true, null);
    }

    private static void nativeSetConfiguration(long l, int n, int n2, @Nullable String string2, @NonNull String[] stringArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19, boolean bl) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeSetConfiguration(JIILjava/lang/String;[Ljava/lang/String;IIIIIIIIIIIIIIIIIZ)V", true, null);
    }

    private static void nativeSetOverlayConstraints(long l, int n, int n2) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeSetOverlayConstraints(JII)V", true, null);
    }

    @NonNull
    private static SparseArray<String> nativeGetAssignedPackageIdentifiers(long l, boolean bl, boolean bl2) {
        return (SparseArray)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetAssignedPackageIdentifiers(JZZ)Landroid/util/SparseArray;", true, null);
    }

    private static boolean nativeContainsAllocatedTable(long l) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeContainsAllocatedTable(J)Z", true, null) != 0;
    }

    @Nullable
    private static String[] nativeList(long l, @NonNull String string2) throws IOException {
        return (String[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeList(JLjava/lang/String;)[Ljava/lang/String;", true, null);
    }

    private static long nativeOpenAsset(long l, @NonNull String string2, int n) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#nativeOpenAsset(JLjava/lang/String;I)J", true, null);
    }

    @Nullable
    private static ParcelFileDescriptor nativeOpenAssetFd(long l, @NonNull String string2, long[] lArray) throws IOException {
        return (ParcelFileDescriptor)OverrideMethod.invokeA("android.content.res.AssetManager#nativeOpenAssetFd(JLjava/lang/String;[J)Landroid/os/ParcelFileDescriptor;", true, null);
    }

    private static long nativeOpenNonAsset(long l, int n, @NonNull String string2, int n2) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#nativeOpenNonAsset(JILjava/lang/String;I)J", true, null);
    }

    @Nullable
    private static ParcelFileDescriptor nativeOpenNonAssetFd(long l, int n, @NonNull String string2, @NonNull long[] lArray) throws IOException {
        return (ParcelFileDescriptor)OverrideMethod.invokeA("android.content.res.AssetManager#nativeOpenNonAssetFd(JILjava/lang/String;[J)Landroid/os/ParcelFileDescriptor;", true, null);
    }

    private static long nativeOpenXmlAsset(long l, int n, @NonNull String string2) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#nativeOpenXmlAsset(JILjava/lang/String;)J", true, null);
    }

    private static long nativeOpenXmlAssetFd(long l, int n, @NonNull FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#nativeOpenXmlAssetFd(JILjava/io/FileDescriptor;)J", true, null);
    }

    private static int nativeGetResourceValue(long l, int n, short s, @NonNull TypedValue typedValue, boolean bl) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeGetResourceValue(JISLandroid/util/TypedValue;Z)I", true, null);
    }

    private static int nativeGetResourceBagValue(long l, int n, int n2, @NonNull TypedValue typedValue) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeGetResourceBagValue(JIILandroid/util/TypedValue;)I", true, null);
    }

    @Nullable
    private static int[] nativeGetStyleAttributes(long l, int n) {
        return (int[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetStyleAttributes(JI)[I", true, null);
    }

    @Nullable
    private static String[] nativeGetResourceStringArray(long l, int n) {
        return (String[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetResourceStringArray(JI)[Ljava/lang/String;", true, null);
    }

    @Nullable
    private static int[] nativeGetResourceStringArrayInfo(long l, int n) {
        return (int[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetResourceStringArrayInfo(JI)[I", true, null);
    }

    @Nullable
    private static int[] nativeGetResourceIntArray(long l, int n) {
        return (int[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetResourceIntArray(JI)[I", true, null);
    }

    private static int nativeGetResourceArraySize(long l, int n) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeGetResourceArraySize(JI)I", true, null);
    }

    private static int nativeGetResourceArray(long l, int n, @NonNull int[] nArray) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeGetResourceArray(JI[I)I", true, null);
    }

    private static int nativeGetResourceIdentifier(long l, @NonNull String string2, @Nullable String string3, @Nullable String string4) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeGetResourceIdentifier(JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)I", true, null);
    }

    @Nullable
    private static String nativeGetResourceName(long l, int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetResourceName(JI)Ljava/lang/String;", true, null);
    }

    @Nullable
    private static String nativeGetResourcePackageName(long l, int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetResourcePackageName(JI)Ljava/lang/String;", true, null);
    }

    @Nullable
    private static String nativeGetResourceTypeName(long l, int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetResourceTypeName(JI)Ljava/lang/String;", true, null);
    }

    @Nullable
    private static String nativeGetResourceEntryName(long l, int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetResourceEntryName(JI)Ljava/lang/String;", true, null);
    }

    @Nullable
    private static String[] nativeGetLocales(long l, boolean bl) {
        return (String[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetLocales(JZ)[Ljava/lang/String;", true, null);
    }

    @Nullable
    private static Configuration[] nativeGetSizeConfigurations(long l) {
        return (Configuration[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetSizeConfigurations(J)[Landroid/content/res/Configuration;", true, null);
    }

    @Nullable
    private static Configuration[] nativeGetSizeAndUiModeConfigurations(long l) {
        return (Configuration[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetSizeAndUiModeConfigurations(J)[Landroid/content/res/Configuration;", true, null);
    }

    private static void nativeSetResourceResolutionLoggingEnabled(long l, boolean bl) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeSetResourceResolutionLoggingEnabled(JZ)V", true, null);
    }

    @Nullable
    private static String nativeGetLastResourceResolution(long l) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetLastResourceResolution(J)Ljava/lang/String;", true, null);
    }

    private static int[] nativeAttributeResolutionStack(long l, long l2, int n, int n2, int n3) {
        return (int[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeAttributeResolutionStack(JJIII)[I", true, null);
    }

    private static void nativeApplyStyle(long l, long l2, int n, int n2, long l3, @NonNull int[] nArray, long l4, long l5) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeApplyStyle(JJIIJ[IJJ)V", true, null);
    }

    private static boolean nativeResolveAttrs(long l, long l2, int n, int n2, @Nullable int[] nArray, @NonNull int[] nArray2, @NonNull int[] nArray3, @NonNull int[] nArray4) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeResolveAttrs(JJII[I[I[I[I)Z", true, null) != 0;
    }

    private static boolean nativeRetrieveAttributes(long l, long l2, @NonNull int[] nArray, @NonNull int[] nArray2, @NonNull int[] nArray3) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeRetrieveAttributes(JJ[I[I[I)Z", true, null) != 0;
    }

    @LayoutlibDelegate
    private static long nativeThemeCreate(long l) {
        return AssetManager_Delegate.nativeThemeCreate(l);
    }

    @LayoutlibDelegate
    private static long nativeGetThemeFreeFunction() {
        return AssetManager_Delegate.nativeGetThemeFreeFunction();
    }

    private static void nativeThemeApplyStyle(long l, long l2, int n, boolean bl) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeThemeApplyStyle(JJIZ)V", true, null);
    }

    private static void nativeThemeRebase(long l, long l2, @NonNull int[] nArray, @NonNull boolean[] blArray, int n) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeThemeRebase(JJ[I[ZI)V", true, null);
    }

    private static void nativeThemeCopy(long l, long l2, long l3, long l4) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeThemeCopy(JJJJ)V", true, null);
    }

    private static int nativeThemeGetAttributeValue(long l, long l2, int n, @NonNull TypedValue typedValue, boolean bl) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeThemeGetAttributeValue(JJILandroid/util/TypedValue;Z)I", true, null);
    }

    private static void nativeThemeDump(long l, long l2, int n, String string2, String string3) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeThemeDump(JJILjava/lang/String;Ljava/lang/String;)V", true, null);
    }

    static int nativeThemeGetChangingConfigurations(long l) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeThemeGetChangingConfigurations(J)I", true, null);
    }

    private static int nativeGetParentThemeIdentifier(long l, int n) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeGetParentThemeIdentifier(JI)I", true, null);
    }

    private static void nativeAssetDestroy(long l) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeAssetDestroy(J)V", true, null);
    }

    private static int nativeAssetReadChar(long l) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeAssetReadChar(J)I", true, null);
    }

    private static int nativeAssetRead(long l, byte[] byArray, int n, int n2) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeAssetRead(J[BII)I", true, null);
    }

    private static long nativeAssetSeek(long l, long l2, int n) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#nativeAssetSeek(JJI)J", true, null);
    }

    private static long nativeAssetGetLength(long l) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#nativeAssetGetLength(J)J", true, null);
    }

    private static long nativeAssetGetRemainingLength(long l) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#nativeAssetGetRemainingLength(J)J", true, null);
    }

    @Nullable
    private static Map nativeGetOverlayableMap(long l, @NonNull String string2) {
        return (Map)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetOverlayableMap(JLjava/lang/String;)Ljava/util/Map;", true, null);
    }

    @Nullable
    private static String nativeGetOverlayablesToString(long l, @NonNull String string2) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetOverlayablesToString(JLjava/lang/String;)Ljava/lang/String;", true, null);
    }

    @UnsupportedAppUsage
    public static int getGlobalAssetCount() {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getGlobalAssetCount()I", true, null);
    }

    public static String getAssetAllocations() {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#getAssetAllocations()Ljava/lang/String;", true, null);
    }

    @UnsupportedAppUsage
    public static int getGlobalAssetManagerCount() {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getGlobalAssetManagerCount()I", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyStyle$ravenwood(long themePtr, int defStyleAttr, int defStyleRes, @Nullable XmlBlock.Parser parser, @NonNull int[] inAttrs, long outValuesAddress, long outIndicesAddress) {
        Objects.requireNonNull(inAttrs, "inAttrs");
        RavenwoodEnvironment runtime = RavenwoodEnvironment.getInstance();
        int[] outValues = (int[])runtime.fromAddress(outValuesAddress);
        int[] outIndices = (int[])runtime.fromAddress(outIndicesAddress);
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeApplyStyleWithArray(this.mObject, themePtr, defStyleAttr, defStyleRes, parser != null ? parser.mParseState : 0L, inAttrs, outValues, outIndices);
        }
    }

    private static void nativeApplyStyleWithArray(long l, long l2, int n, int n2, long l3, @NonNull int[] nArray, int[] nArray2, int[] nArray3) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeApplyStyleWithArray(JJIIJ[I[I[I)V", true, null);
    }

    public class AssetInputStream
    extends InputStream {
        private long mAssetNativePtr;
        private long mLength;
        private long mMarkPos;

        @UnsupportedAppUsage
        public int getAssetInt() {
            throw new UnsupportedOperationException();
        }

        @UnsupportedAppUsage
        public long getNativeAsset() {
            return this.mAssetNativePtr;
        }

        private AssetInputStream(long assetNativePtr) {
            this.mAssetNativePtr = assetNativePtr;
            this.mLength = AssetManager.nativeAssetGetLength(assetNativePtr);
        }

        @Override
        public int read() throws IOException {
            this.ensureOpen();
            return AssetManager.nativeAssetReadChar(this.mAssetNativePtr);
        }

        @Override
        public int read(@NonNull byte[] b) throws IOException {
            this.ensureOpen();
            Objects.requireNonNull(b, "b");
            return AssetManager.nativeAssetRead(this.mAssetNativePtr, b, 0, b.length);
        }

        @Override
        public int read(@NonNull byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            Objects.requireNonNull(b, "b");
            return AssetManager.nativeAssetRead(this.mAssetNativePtr, b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            this.ensureOpen();
            long pos = AssetManager.nativeAssetSeek(this.mAssetNativePtr, 0L, 0);
            if (pos + n > this.mLength) {
                n = this.mLength - pos;
            }
            if (n > 0L) {
                AssetManager.nativeAssetSeek(this.mAssetNativePtr, n, 0);
            }
            return n;
        }

        @Override
        public int available() throws IOException {
            this.ensureOpen();
            long len = AssetManager.nativeAssetGetRemainingLength(this.mAssetNativePtr);
            return len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)len;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readlimit) {
            this.ensureOpen();
            this.mMarkPos = AssetManager.nativeAssetSeek(this.mAssetNativePtr, 0L, 0);
        }

        @Override
        public void reset() throws IOException {
            this.ensureOpen();
            AssetManager.nativeAssetSeek(this.mAssetNativePtr, this.mMarkPos, -1);
        }

        @Override
        public void close() throws IOException {
            if (this.mAssetNativePtr != 0L) {
                AssetManager.nativeAssetDestroy(this.mAssetNativePtr);
                this.mAssetNativePtr = 0L;
                AssetManager.this.decRefs(this.hashCode());
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        private void ensureOpen() {
            if (this.mAssetNativePtr == 0L) {
                throw new IllegalStateException("AssetInputStream is closed");
            }
        }
    }

    public static class Builder {
        private final ArrayList<ApkAssets> mUserApkAssets = new ArrayList();
        private final ArrayList<ResourcesLoader> mLoaders = new ArrayList();
        private boolean mNoInit = false;

        public Builder addApkAssets(ApkAssets apkAssets) {
            this.mUserApkAssets.add(apkAssets);
            return this;
        }

        @RavenwoodThrow(blockedBy={ResourcesLoader.class})
        public Builder addLoader(ResourcesLoader loader) {
            this.mLoaders.add(loader);
            return this;
        }

        public Builder setNoInit() {
            this.mNoInit = true;
            return this;
        }

        public AssetManager build() {
            int i;
            ApkAssets[] systemApkAssets = AssetManager.getSystem().getApkAssets();
            ArrayList<ApkAssets> loaderApkAssets = new ArrayList<ApkAssets>();
            ArraySet<ApkAssets> uniqueLoaderApkAssets = new ArraySet<ApkAssets>();
            for (int i2 = this.mLoaders.size() - 1; i2 >= 0; --i2) {
                List<ApkAssets> currentLoaderApkAssets = this.mLoaders.get(i2).getApkAssets();
                for (int j = currentLoaderApkAssets.size() - 1; j >= 0; --j) {
                    ApkAssets apkAssets = currentLoaderApkAssets.get(j);
                    if (!uniqueLoaderApkAssets.add(apkAssets)) continue;
                    loaderApkAssets.add(0, apkAssets);
                }
            }
            int totalApkAssetCount = systemApkAssets.length + this.mUserApkAssets.size() + loaderApkAssets.size();
            ApkAssets[] apkAssets = new ApkAssets[totalApkAssetCount];
            System.arraycopy(systemApkAssets, 0, apkAssets, 0, systemApkAssets.length);
            int n = this.mUserApkAssets.size();
            for (i = 0; i < n; ++i) {
                apkAssets[i + systemApkAssets.length] = this.mUserApkAssets.get(i);
            }
            n = loaderApkAssets.size();
            for (i = 0; i < n; ++i) {
                apkAssets[i + systemApkAssets.length + this.mUserApkAssets.size()] = (ApkAssets)loaderApkAssets.get(i);
            }
            AssetManager assetManager = new AssetManager(false);
            assetManager.mApkAssets = apkAssets;
            AssetManager.nativeSetApkAssets(assetManager.mObject, apkAssets, false, this.mNoInit);
            assetManager.mLoaders = this.mLoaders.isEmpty() ? null : this.mLoaders.toArray(new ResourcesLoader[0]);
            return assetManager;
        }
    }
}

