/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.om.OverlayableInfo;
import android.content.res.StringBlock;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.content.res.loader.AssetsProvider;
import android.ravenwood.annotation.RavenwoodClassLoadHook;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.TextUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@RavenwoodKeepWholeClass
@RavenwoodClassLoadHook(value="com.android.platform.test.ravenwood.runtimehelper.ClassLoadHook.onClassLoaded")
public class ApkAssets {
    private static final boolean DEBUG = false;
    public static final int PROPERTY_SYSTEM = 1;
    public static final int PROPERTY_DYNAMIC = 2;
    public static final int PROPERTY_LOADER = 4;
    private static final int PROPERTY_OVERLAY = 8;
    public static final int PROPERTY_DISABLE_INCREMENTAL_HARDENING = 16;
    public static final int PROPERTY_ONLY_OVERLAYABLES = 32;
    private static final int FORMAT_APK = 0;
    private static final int FORMAT_IDMAP = 1;
    private static final int FORMAT_ARSC = 2;
    private static final int FORMAT_DIR = 3;
    @GuardedBy(value={"this"})
    private long mNativePtr;
    @Nullable
    @GuardedBy(value={"this"})
    private StringBlock mStringBlock;
    private final int mFlags;
    private final boolean mIsOverlay;
    @Nullable
    private final AssetsProvider mAssets;
    @NonNull
    private String mName;
    private static final int UPTODATE_FALSE = 0;
    private static final int UPTODATE_TRUE = 1;
    private static final int UPTODATE_ALWAYS_TRUE = 2;
    private int mPreviousUpToDateResult = 1;

    @NonNull
    public static ApkAssets loadFromPath(@NonNull String path) throws IOException {
        return ApkAssets.loadFromPath(path, 0);
    }

    @NonNull
    public static ApkAssets loadFromPath(@NonNull String path, int flags) throws IOException {
        return new ApkAssets(0, path, flags, null);
    }

    @NonNull
    public static ApkAssets loadFromPath(@NonNull String path, int flags, @Nullable AssetsProvider assets) throws IOException {
        return new ApkAssets(0, path, flags, assets);
    }

    @NonNull
    public static ApkAssets loadFromFd(@NonNull FileDescriptor fd, @NonNull String friendlyName, int flags, @Nullable AssetsProvider assets) throws IOException {
        return new ApkAssets(0, fd, friendlyName, flags, assets);
    }

    @NonNull
    public static ApkAssets loadFromFd(@NonNull FileDescriptor fd, @NonNull String friendlyName, long offset, long length, int flags, @Nullable AssetsProvider assets) throws IOException {
        return new ApkAssets(0, fd, friendlyName, offset, length, flags, assets);
    }

    @NonNull
    public static ApkAssets loadOverlayFromPath(@NonNull String idmapPath, int flags) throws IOException {
        return new ApkAssets(1, idmapPath, flags, null);
    }

    @NonNull
    public static ApkAssets loadTableFromFd(@NonNull FileDescriptor fd, @NonNull String friendlyName, int flags, @Nullable AssetsProvider assets) throws IOException {
        return new ApkAssets(2, fd, friendlyName, flags, assets);
    }

    @NonNull
    public static ApkAssets loadTableFromFd(@NonNull FileDescriptor fd, @NonNull String friendlyName, long offset, long length, int flags, @Nullable AssetsProvider assets) throws IOException {
        return new ApkAssets(2, fd, friendlyName, offset, length, flags, assets);
    }

    @NonNull
    public static ApkAssets loadFromDir(@NonNull String path, int flags, @Nullable AssetsProvider assets) throws IOException {
        return new ApkAssets(3, path, flags, assets);
    }

    @NonNull
    public static ApkAssets loadEmptyForLoader(int flags, @Nullable AssetsProvider assets) {
        return new ApkAssets(flags, assets);
    }

    private ApkAssets(int format, @NonNull String path, int flags, @Nullable AssetsProvider assets) throws IOException {
        this(format, flags, assets, path);
        Objects.requireNonNull(path, "path");
        this.mNativePtr = ApkAssets.nativeLoad(format, path, flags, assets);
        this.mStringBlock = new StringBlock(ApkAssets.nativeGetStringBlock(this.mNativePtr), true);
    }

    private ApkAssets(int format, @NonNull FileDescriptor fd, @NonNull String friendlyName, int flags, @Nullable AssetsProvider assets) throws IOException {
        this(format, flags, assets, friendlyName);
        Objects.requireNonNull(fd, "fd");
        Objects.requireNonNull(friendlyName, "friendlyName");
        this.mNativePtr = ApkAssets.nativeLoadFd(format, fd, friendlyName, flags, assets);
        this.mStringBlock = new StringBlock(ApkAssets.nativeGetStringBlock(this.mNativePtr), true);
    }

    private ApkAssets(int format, @NonNull FileDescriptor fd, @NonNull String friendlyName, long offset, long length, int flags, @Nullable AssetsProvider assets) throws IOException {
        this(format, flags, assets, friendlyName);
        Objects.requireNonNull(fd, "fd");
        Objects.requireNonNull(friendlyName, "friendlyName");
        this.mNativePtr = ApkAssets.nativeLoadFdOffsets(format, fd, friendlyName, offset, length, flags, assets);
        this.mStringBlock = new StringBlock(ApkAssets.nativeGetStringBlock(this.mNativePtr), true);
    }

    private ApkAssets(int flags, @Nullable AssetsProvider assets) {
        this(0, flags, assets, "empty");
        this.mNativePtr = ApkAssets.nativeLoadEmpty(flags, assets);
        this.mStringBlock = null;
    }

    private ApkAssets(int format, int flags, @Nullable AssetsProvider assets, @NonNull String name) {
        this.mFlags = flags;
        this.mAssets = assets;
        this.mIsOverlay = format == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @NonNull
    public String getAssetPath() {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return TextUtils.emptyIfNull(ApkAssets.nativeGetAssetPath(this.mNativePtr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public String getDebugName() {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return this.mNativePtr == 0L ? "<destroyed>" : ApkAssets.nativeGetDebugName(this.mNativePtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CharSequence getStringFromPool(int idx) {
        if (this.mStringBlock == null) {
            return null;
        }
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return this.mStringBlock.getSequence(idx);
        }
    }

    public boolean isForLoader() {
        return (this.mFlags & 4) != 0;
    }

    @Nullable
    public AssetsProvider getAssetsProvider() {
        return this.mAssets;
    }

    @NonNull
    public XmlResourceParser openXml(@NonNull String fileName) throws IOException {
        Objects.requireNonNull(fileName, "fileName");
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            XmlResourceParser xmlResourceParser;
            long nativeXmlPtr = ApkAssets.nativeOpenXml(this.mNativePtr, fileName);
            try (XmlBlock block = new XmlBlock(null, nativeXmlPtr, true);){
                XmlResourceParser parser = block.newParser();
                if (parser == null) {
                    throw new AssertionError((Object)"block.newParser() returned a null parser");
                }
                xmlResourceParser = parser;
            }
            return xmlResourceParser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OverlayableInfo getOverlayableInfo(String overlayableName) throws IOException {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return ApkAssets.nativeGetOverlayableInfo(this.mNativePtr, overlayableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean definesOverlayable() throws IOException {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return ApkAssets.nativeDefinesOverlayable(this.mNativePtr);
        }
    }

    private static double intervalMs(long beginNs, long endNs) {
        return (double)(endNs - beginNs) / 1000000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpToDate() {
        int res;
        if (this.mPreviousUpToDateResult != 1) {
            return this.mPreviousUpToDateResult == 2;
        }
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            res = ApkAssets.nativeIsUpToDate(this.mNativePtr);
        }
        this.mPreviousUpToDateResult = res;
        return res != 0;
    }

    public boolean isSystem() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isSharedLib() {
        return (this.mFlags & 2) != 0;
    }

    public boolean isOverlay() {
        return this.mIsOverlay;
    }

    public String toString() {
        return "ApkAssets{path=" + this.getDebugName() + "}";
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            if (this.mNativePtr != 0L) {
                if (this.mStringBlock != null) {
                    this.mStringBlock.close();
                }
                ApkAssets.nativeDestroy(this.mNativePtr);
                this.mNativePtr = 0L;
            }
        }
    }

    void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "class=" + this.getClass());
        pw.println(prefix + "debugName=" + this.getDebugName());
        pw.println(prefix + "assetPath=" + this.getAssetPath());
    }

    private static long nativeLoad(int n, @NonNull String string2, int n2, @Nullable AssetsProvider assetsProvider) throws IOException {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeLoad(ILjava/lang/String;ILandroid/content/res/loader/AssetsProvider;)J", true, null);
    }

    private static long nativeLoadEmpty(int n, @Nullable AssetsProvider assetsProvider) {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeLoadEmpty(ILandroid/content/res/loader/AssetsProvider;)J", true, null);
    }

    private static long nativeLoadFd(int n, @NonNull FileDescriptor fileDescriptor, @NonNull String string2, int n2, @Nullable AssetsProvider assetsProvider) throws IOException {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeLoadFd(ILjava/io/FileDescriptor;Ljava/lang/String;ILandroid/content/res/loader/AssetsProvider;)J", true, null);
    }

    private static long nativeLoadFdOffsets(int n, @NonNull FileDescriptor fileDescriptor, @NonNull String string2, long l, long l2, int n2, @Nullable AssetsProvider assetsProvider) throws IOException {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeLoadFdOffsets(ILjava/io/FileDescriptor;Ljava/lang/String;JJILandroid/content/res/loader/AssetsProvider;)J", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.content.res.ApkAssets#nativeDestroy(J)V", true, null);
    }

    @NonNull
    private static String nativeGetAssetPath(long l) {
        return (String)OverrideMethod.invokeA("android.content.res.ApkAssets#nativeGetAssetPath(J)Ljava/lang/String;", true, null);
    }

    @NonNull
    private static String nativeGetDebugName(long l) {
        return (String)OverrideMethod.invokeA("android.content.res.ApkAssets#nativeGetDebugName(J)Ljava/lang/String;", true, null);
    }

    private static long nativeGetStringBlock(long l) {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeGetStringBlock(J)J", true, null);
    }

    @CriticalNative
    private static int nativeIsUpToDate(long l) {
        return OverrideMethod.invokeI("android.content.res.ApkAssets#nativeIsUpToDate(J)I", true, null);
    }

    private static long nativeOpenXml(long l, @NonNull String string2) throws IOException {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeOpenXml(JLjava/lang/String;)J", true, null);
    }

    @Nullable
    private static OverlayableInfo nativeGetOverlayableInfo(long l, String string2) throws IOException {
        return (OverlayableInfo)OverrideMethod.invokeA("android.content.res.ApkAssets#nativeGetOverlayableInfo(JLjava/lang/String;)Landroid/content/om/OverlayableInfo;", true, null);
    }

    private static boolean nativeDefinesOverlayable(long l) throws IOException {
        return OverrideMethod.invokeI("android.content.res.ApkAssets#nativeDefinesOverlayable(J)Z", true, null) != 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FormatType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PropertyFlags {
    }
}

