/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.IShortcutService;
import android.content.pm.ParceledListSlice;
import android.content.pm.ShortcutInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class ShortcutManager {
    private static final String TAG = "ShortcutManager";
    public static final int FLAG_MATCH_MANIFEST = 1;
    public static final int FLAG_MATCH_DYNAMIC = 2;
    public static final int FLAG_MATCH_PINNED = 4;
    public static final int FLAG_MATCH_CACHED = 8;
    private final Context mContext;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final IShortcutService mService;

    public ShortcutManager(Context context, IShortcutService service) {
        this.mContext = context;
        this.mService = service;
    }

    public ShortcutManager(Context context) {
        this(context, IShortcutService.Stub.asInterface(ServiceManager.getService("shortcut")));
    }

    public boolean setDynamicShortcuts(@NonNull List<ShortcutInfo> shortcutInfoList) {
        try {
            return this.mService.setDynamicShortcuts(this.mContext.getPackageName(), new ParceledListSlice<ShortcutInfo>(shortcutInfoList), this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<ShortcutInfo> getDynamicShortcuts() {
        try {
            return this.mService.getShortcuts(this.mContext.getPackageName(), 2, this.injectMyUserId()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<ShortcutInfo> getManifestShortcuts() {
        try {
            return this.mService.getShortcuts(this.mContext.getPackageName(), 1, this.injectMyUserId()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<ShortcutInfo> getShortcuts(int matchFlags) {
        try {
            return this.mService.getShortcuts(this.mContext.getPackageName(), matchFlags, this.injectMyUserId()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean addDynamicShortcuts(@NonNull List<ShortcutInfo> shortcutInfoList) {
        try {
            return this.mService.addDynamicShortcuts(this.mContext.getPackageName(), new ParceledListSlice<ShortcutInfo>(shortcutInfoList), this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeDynamicShortcuts(@NonNull List<String> shortcutIds) {
        try {
            this.mService.removeDynamicShortcuts(this.mContext.getPackageName(), shortcutIds, this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeAllDynamicShortcuts() {
        try {
            this.mService.removeAllDynamicShortcuts(this.mContext.getPackageName(), this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeLongLivedShortcuts(@NonNull List<String> shortcutIds) {
        try {
            this.mService.removeLongLivedShortcuts(this.mContext.getPackageName(), shortcutIds, this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<ShortcutInfo> getPinnedShortcuts() {
        try {
            return this.mService.getShortcuts(this.mContext.getPackageName(), 4, this.injectMyUserId()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean updateShortcuts(@NonNull List<ShortcutInfo> shortcutInfoList) {
        try {
            return this.mService.updateShortcuts(this.mContext.getPackageName(), new ParceledListSlice<ShortcutInfo>(shortcutInfoList), this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void disableShortcuts(@NonNull List<String> shortcutIds) {
        try {
            this.mService.disableShortcuts(this.mContext.getPackageName(), shortcutIds, null, 0, this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void disableShortcuts(@NonNull List<String> shortcutIds, int disabledMessageResId) {
        try {
            this.mService.disableShortcuts(this.mContext.getPackageName(), shortcutIds, null, disabledMessageResId, this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void disableShortcuts(@NonNull List<String> shortcutIds, String disabledMessage) {
        this.disableShortcuts(shortcutIds, (CharSequence)disabledMessage);
    }

    public void disableShortcuts(@NonNull List<String> shortcutIds, CharSequence disabledMessage) {
        try {
            this.mService.disableShortcuts(this.mContext.getPackageName(), shortcutIds, disabledMessage, 0, this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void enableShortcuts(@NonNull List<String> shortcutIds) {
        try {
            this.mService.enableShortcuts(this.mContext.getPackageName(), shortcutIds, this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getMaxShortcutCountForActivity() {
        return this.getMaxShortcutCountPerActivity();
    }

    public int getMaxShortcutCountPerActivity() {
        try {
            return this.mService.getMaxShortcutCountPerActivity(this.mContext.getPackageName(), this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getRemainingCallCount() {
        try {
            return this.mService.getRemainingCallCount(this.mContext.getPackageName(), this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public long getRateLimitResetTime() {
        try {
            return this.mService.getRateLimitResetTime(this.mContext.getPackageName(), this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isRateLimitingActive() {
        try {
            return this.mService.getRemainingCallCount(this.mContext.getPackageName(), this.injectMyUserId()) == 0;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getIconMaxWidth() {
        try {
            return this.mService.getIconMaxDimensions(this.mContext.getPackageName(), this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getIconMaxHeight() {
        try {
            return this.mService.getIconMaxDimensions(this.mContext.getPackageName(), this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportShortcutUsed(String shortcutId) {
        try {
            this.mService.reportShortcutUsed(this.mContext.getPackageName(), shortcutId, this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isRequestPinShortcutSupported() {
        try {
            return this.mService.isRequestPinItemSupported(this.injectMyUserId(), 1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean requestPinShortcut(@NonNull ShortcutInfo shortcut, @Nullable IntentSender resultIntent) {
        try {
            return this.mService.requestPinShortcut(this.mContext.getPackageName(), shortcut, resultIntent, this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Intent createShortcutResultIntent(@NonNull ShortcutInfo shortcut) {
        try {
            Intent result = this.mService.createShortcutResultIntent(this.mContext.getPackageName(), shortcut, this.injectMyUserId());
            if (result != null) {
                result.prepareToEnterProcess(32, this.mContext.getAttributionSource());
            }
            return result;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void onApplicationActive(@NonNull String packageName, int userId) {
        try {
            this.mService.onApplicationActive(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @VisibleForTesting
    protected int injectMyUserId() {
        return this.mContext.getUserId();
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.MANAGE_APP_PREDICTIONS")
    public List<ShareShortcutInfo> getShareTargets(@NonNull IntentFilter filter) {
        try {
            return this.mService.getShareTargets(this.mContext.getPackageName(), filter, this.injectMyUserId()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean hasShareTargets(@NonNull String packageName) {
        try {
            return this.mService.hasShareTargets(this.mContext.getPackageName(), packageName, this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void pushDynamicShortcut(@NonNull ShortcutInfo shortcut) {
        try {
            this.mService.pushDynamicShortcut(this.mContext.getPackageName(), shortcut, this.injectMyUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public static class ShareShortcutInfo
    implements Parcelable {
        private final ShortcutInfo mShortcutInfo;
        private final ComponentName mTargetComponent;
        @NonNull
        public static final Parcelable.Creator<ShareShortcutInfo> CREATOR = new Parcelable.Creator<ShareShortcutInfo>(){

            @Override
            public ShareShortcutInfo createFromParcel(Parcel in) {
                return new ShareShortcutInfo(in);
            }

            public ShareShortcutInfo[] newArray(int size) {
                return new ShareShortcutInfo[size];
            }
        };

        public ShareShortcutInfo(@NonNull ShortcutInfo shortcutInfo, @NonNull ComponentName targetComponent) {
            if (shortcutInfo == null) {
                throw new NullPointerException("shortcut info is null");
            }
            if (targetComponent == null) {
                throw new NullPointerException("target component is null");
            }
            this.mShortcutInfo = shortcutInfo;
            this.mTargetComponent = targetComponent;
        }

        private ShareShortcutInfo(@NonNull Parcel in) {
            this.mShortcutInfo = in.readParcelable(ShortcutInfo.class.getClassLoader(), ShortcutInfo.class);
            this.mTargetComponent = in.readParcelable(ComponentName.class.getClassLoader(), ComponentName.class);
        }

        @NonNull
        public ShortcutInfo getShortcutInfo() {
            return this.mShortcutInfo;
        }

        @NonNull
        public ComponentName getTargetComponent() {
            return this.mTargetComponent;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeParcelable(this.mShortcutInfo, flags);
            dest.writeParcelable(this.mTargetComponent, flags);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShortcutMatchFlags {
    }
}

