/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.content.pm.InstantAppIntentFilter;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;

@SystemApi
public class InstantAppResolveInfo
implements Parcelable {
    private static final String SHA_ALGORITHM = "SHA-256";
    private static final byte[] EMPTY_DIGEST = new byte[0];
    private final InstantAppDigest mDigest;
    private final String mPackageName;
    private final List<InstantAppIntentFilter> mFilters;
    private final long mVersionCode;
    private final Bundle mExtras;
    private final boolean mShouldLetInstallerDecide;
    @NonNull
    public static final Parcelable.Creator<InstantAppResolveInfo> CREATOR = new Parcelable.Creator<InstantAppResolveInfo>(){

        @Override
        public InstantAppResolveInfo createFromParcel(Parcel in) {
            return new InstantAppResolveInfo(in);
        }

        public InstantAppResolveInfo[] newArray(int size) {
            return new InstantAppResolveInfo[size];
        }
    };

    public InstantAppResolveInfo(@NonNull InstantAppDigest digest, @Nullable String packageName, @Nullable List<InstantAppIntentFilter> filters, int versionCode) {
        this(digest, packageName, filters, versionCode, null);
    }

    public InstantAppResolveInfo(@NonNull InstantAppDigest digest, @Nullable String packageName, @Nullable List<InstantAppIntentFilter> filters, long versionCode, @Nullable Bundle extras) {
        this(digest, packageName, filters, versionCode, extras, false);
    }

    public InstantAppResolveInfo(@NonNull String hostName, @Nullable String packageName, @Nullable List<InstantAppIntentFilter> filters) {
        this(new InstantAppDigest(hostName), packageName, filters, -1L, null);
    }

    public InstantAppResolveInfo(@Nullable Bundle extras) {
        this(InstantAppDigest.UNDEFINED, null, null, -1L, extras, true);
    }

    private InstantAppResolveInfo(@NonNull InstantAppDigest digest, @Nullable String packageName, @Nullable List<InstantAppIntentFilter> filters, long versionCode, @Nullable Bundle extras, boolean shouldLetInstallerDecide) {
        if (packageName == null && filters != null && filters.size() != 0 || packageName != null && (filters == null || filters.size() == 0)) {
            throw new IllegalArgumentException();
        }
        this.mDigest = digest;
        if (filters != null) {
            this.mFilters = new ArrayList<InstantAppIntentFilter>(filters.size());
            this.mFilters.addAll(filters);
        } else {
            this.mFilters = null;
        }
        this.mPackageName = packageName;
        this.mVersionCode = versionCode;
        this.mExtras = extras;
        this.mShouldLetInstallerDecide = shouldLetInstallerDecide;
    }

    InstantAppResolveInfo(Parcel in) {
        this.mShouldLetInstallerDecide = in.readBoolean();
        this.mExtras = in.readBundle();
        if (this.mShouldLetInstallerDecide) {
            this.mDigest = InstantAppDigest.UNDEFINED;
            this.mPackageName = null;
            this.mFilters = Collections.emptyList();
            this.mVersionCode = -1L;
        } else {
            this.mDigest = in.readParcelable(null, InstantAppDigest.class);
            this.mPackageName = in.readString();
            this.mFilters = new ArrayList<InstantAppIntentFilter>();
            in.readTypedList(this.mFilters, InstantAppIntentFilter.CREATOR);
            this.mVersionCode = in.readLong();
        }
    }

    public boolean shouldLetInstallerDecide() {
        return this.mShouldLetInstallerDecide;
    }

    public byte[] getDigestBytes() {
        return this.mDigest.mDigestBytes.length > 0 ? this.mDigest.getDigestBytes()[0] : EMPTY_DIGEST;
    }

    public int getDigestPrefix() {
        return this.mDigest.getDigestPrefix()[0];
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public List<InstantAppIntentFilter> getIntentFilters() {
        return this.mFilters;
    }

    @Deprecated
    public int getVersionCode() {
        return (int)(this.mVersionCode & 0xFFFFFFFFFFFFFFFFL);
    }

    public long getLongVersionCode() {
        return this.mVersionCode;
    }

    @Nullable
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeBoolean(this.mShouldLetInstallerDecide);
        out.writeBundle(this.mExtras);
        if (this.mShouldLetInstallerDecide) {
            return;
        }
        out.writeParcelable(this.mDigest, flags);
        out.writeString(this.mPackageName);
        out.writeTypedList(this.mFilters);
        out.writeLong(this.mVersionCode);
    }

    @SystemApi
    public static class InstantAppDigest
    implements Parcelable {
        static final int DIGEST_MASK = -4096;
        public static final InstantAppDigest UNDEFINED = new InstantAppDigest(new byte[0][], new int[0]);
        private static Random sRandom = null;
        private final byte[][] mDigestBytes;
        private final int[] mDigestPrefix;
        private int[] mDigestPrefixSecure;
        @NonNull
        public static final Parcelable.Creator<InstantAppDigest> CREATOR;

        public InstantAppDigest(@NonNull String hostName) {
            this(hostName, -1);
        }

        public InstantAppDigest(@NonNull String hostName, int maxDigests) {
            if (hostName == null) {
                throw new IllegalArgumentException();
            }
            this.mDigestBytes = InstantAppDigest.generateDigest(hostName.toLowerCase(Locale.ENGLISH), maxDigests);
            this.mDigestPrefix = new int[this.mDigestBytes.length];
            for (int i = 0; i < this.mDigestBytes.length; ++i) {
                this.mDigestPrefix[i] = ((this.mDigestBytes[i][0] & 0xFF) << 24 | (this.mDigestBytes[i][1] & 0xFF) << 16 | (this.mDigestBytes[i][2] & 0xFF) << 8 | (this.mDigestBytes[i][3] & 0xFF) << 0) & 0xFFFFF000;
            }
        }

        private InstantAppDigest(byte[][] digestBytes, int[] prefix) {
            this.mDigestPrefix = prefix;
            this.mDigestBytes = digestBytes;
        }

        private static byte[][] generateDigest(String hostName, int maxDigests) {
            ArrayList<byte[]> digests = new ArrayList<byte[]>();
            try {
                MessageDigest digest = MessageDigest.getInstance(InstantAppResolveInfo.SHA_ALGORITHM);
                if (maxDigests <= 0) {
                    byte[] hostBytes = hostName.getBytes();
                    digests.add(digest.digest(hostBytes));
                } else {
                    int prevDot = hostName.lastIndexOf(46);
                    if ((prevDot = hostName.lastIndexOf(46, prevDot - 1)) < 0) {
                        digests.add(digest.digest(hostName.getBytes()));
                    } else {
                        byte[] hostBytes = hostName.substring(prevDot + 1, hostName.length()).getBytes();
                        digests.add(digest.digest(hostBytes));
                        for (int digestCount = 1; prevDot >= 0 && digestCount < maxDigests; ++digestCount) {
                            prevDot = hostName.lastIndexOf(46, prevDot - 1);
                            hostBytes = hostName.substring(prevDot + 1, hostName.length()).getBytes();
                            digests.add(digest.digest(hostBytes));
                        }
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("could not find digest algorithm");
            }
            return (byte[][])digests.toArray((T[])new byte[digests.size()][]);
        }

        InstantAppDigest(Parcel in) {
            int digestCount = in.readInt();
            if (digestCount == -1) {
                this.mDigestBytes = null;
            } else {
                this.mDigestBytes = new byte[digestCount][];
                for (int i = 0; i < digestCount; ++i) {
                    this.mDigestBytes[i] = in.createByteArray();
                }
            }
            this.mDigestPrefix = in.createIntArray();
            this.mDigestPrefixSecure = in.createIntArray();
        }

        public byte[][] getDigestBytes() {
            return this.mDigestBytes;
        }

        public int[] getDigestPrefix() {
            return this.mDigestPrefix;
        }

        public int[] getDigestPrefixSecure() {
            if (this == UNDEFINED) {
                return this.getDigestPrefix();
            }
            if (this.mDigestPrefixSecure == null) {
                int realSize = this.getDigestPrefix().length;
                int manufacturedSize = realSize + 10 + sRandom.nextInt(10);
                this.mDigestPrefixSecure = Arrays.copyOf(this.getDigestPrefix(), manufacturedSize);
                for (int i = realSize; i < manufacturedSize; ++i) {
                    this.mDigestPrefixSecure[i] = sRandom.nextInt() & 0xFFFFF000;
                }
                Arrays.sort(this.mDigestPrefixSecure);
            }
            return this.mDigestPrefixSecure;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            boolean isUndefined = this == UNDEFINED;
            out.writeBoolean(isUndefined);
            if (isUndefined) {
                return;
            }
            if (this.mDigestBytes == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(this.mDigestBytes.length);
                for (int i = 0; i < this.mDigestBytes.length; ++i) {
                    out.writeByteArray(this.mDigestBytes[i]);
                }
            }
            out.writeIntArray(this.mDigestPrefix);
            out.writeIntArray(this.mDigestPrefixSecure);
        }

        static {
            try {
                sRandom = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                sRandom = new Random();
            }
            CREATOR = new Parcelable.Creator<InstantAppDigest>(){

                @Override
                public InstantAppDigest createFromParcel(Parcel in) {
                    if (in.readBoolean()) {
                        return UNDEFINED;
                    }
                    return new InstantAppDigest(in);
                }

                public InstantAppDigest[] newArray(int size) {
                    return new InstantAppDigest[size];
                }
            };
        }
    }
}

