/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IRemoteCallback;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBackgroundInstallControlService
extends IInterface {
    public static final String DESCRIPTOR = "android.content.pm.IBackgroundInstallControlService";

    public ParceledListSlice getBackgroundInstalledPackages(long var1, int var3) throws RemoteException;

    public void registerBackgroundInstallCallback(IRemoteCallback var1) throws RemoteException;

    public void unregisterBackgroundInstallCallback(IRemoteCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBackgroundInstallControlService {
        static final int TRANSACTION_getBackgroundInstalledPackages = 1;
        static final int TRANSACTION_registerBackgroundInstallCallback = 2;
        static final int TRANSACTION_unregisterBackgroundInstallCallback = 3;

        public Stub() {
            this.attachInterface(this, IBackgroundInstallControlService.DESCRIPTOR);
        }

        public static IBackgroundInstallControlService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBackgroundInstallControlService.DESCRIPTOR);
            if (iin != null && iin instanceof IBackgroundInstallControlService) {
                return (IBackgroundInstallControlService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getBackgroundInstalledPackages";
                }
                case 2: {
                    return "registerBackgroundInstallCallback";
                }
                case 3: {
                    return "unregisterBackgroundInstallCallback";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBackgroundInstallControlService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getBackgroundInstalledPackages(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    IRemoteCallback _arg0 = IRemoteCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerBackgroundInstallCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    IRemoteCallback _arg0 = IRemoteCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterBackgroundInstallCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IBackgroundInstallControlService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBackgroundInstallControlService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getBackgroundInstalledPackages(long flags, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBackgroundInstallControlService.DESCRIPTOR);
                    _data.writeLong(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerBackgroundInstallCallback(IRemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBackgroundInstallControlService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterBackgroundInstallCallback(IRemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBackgroundInstallControlService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBackgroundInstallControlService {
        @Override
        public ParceledListSlice getBackgroundInstalledPackages(long flags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void registerBackgroundInstallCallback(IRemoteCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterBackgroundInstallCallback(IRemoteCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

