/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.ArchivedActivityInfo;
import android.content.pm.ArchivedActivityParcel;
import android.content.pm.ArchivedPackageParcel;
import android.content.pm.SigningInfo;
import com.android.internal.util.AnnotationValidations;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@FlaggedApi(value="android.content.pm.archiving")
public class ArchivedPackageInfo {
    @NonNull
    private String mPackageName;
    @NonNull
    private SigningInfo mSigningInfo;
    private int mVersionCode = 0;
    private int mVersionCodeMajor = 0;
    private int mTargetSdkVersion = 0;
    @Nullable
    private String mDefaultToDeviceProtectedStorage;
    @Nullable
    private String mRequestLegacyExternalStorage;
    @Nullable
    private String mUserDataFragile;
    @NonNull
    private List<ArchivedActivityInfo> mLauncherActivities;

    public ArchivedPackageInfo(@NonNull String packageName, @NonNull SigningInfo signingInfo, @NonNull List<ArchivedActivityInfo> launcherActivities) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(signingInfo);
        Objects.requireNonNull(launcherActivities);
        this.mPackageName = packageName;
        this.mSigningInfo = signingInfo;
        this.mLauncherActivities = launcherActivities;
    }

    public ArchivedPackageInfo(@NonNull ArchivedPackageParcel parcel) {
        this.mPackageName = parcel.packageName;
        this.mSigningInfo = new SigningInfo(parcel.signingDetails);
        this.mVersionCode = parcel.versionCode;
        this.mVersionCodeMajor = parcel.versionCodeMajor;
        this.mTargetSdkVersion = parcel.targetSdkVersion;
        this.mDefaultToDeviceProtectedStorage = parcel.defaultToDeviceProtectedStorage;
        this.mRequestLegacyExternalStorage = parcel.requestLegacyExternalStorage;
        this.mUserDataFragile = parcel.userDataFragile;
        this.mLauncherActivities = new ArrayList<ArchivedActivityInfo>();
        if (parcel.archivedActivities != null) {
            for (ArchivedActivityParcel activityParcel : parcel.archivedActivities) {
                this.mLauncherActivities.add(new ArchivedActivityInfo(activityParcel));
            }
        }
    }

    ArchivedPackageParcel getParcel() {
        ArchivedPackageParcel parcel = new ArchivedPackageParcel();
        parcel.packageName = this.mPackageName;
        parcel.signingDetails = this.mSigningInfo.getSigningDetails();
        parcel.versionCode = this.mVersionCode;
        parcel.versionCodeMajor = this.mVersionCodeMajor;
        parcel.targetSdkVersion = this.mTargetSdkVersion;
        parcel.defaultToDeviceProtectedStorage = this.mDefaultToDeviceProtectedStorage;
        parcel.requestLegacyExternalStorage = this.mRequestLegacyExternalStorage;
        parcel.userDataFragile = this.mUserDataFragile;
        parcel.archivedActivities = new ArchivedActivityParcel[this.mLauncherActivities.size()];
        int size = parcel.archivedActivities.length;
        for (int i = 0; i < size; ++i) {
            parcel.archivedActivities[i] = this.mLauncherActivities.get(i).getParcel();
        }
        return parcel;
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public SigningInfo getSigningInfo() {
        return this.mSigningInfo;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int getVersionCodeMajor() {
        return this.mVersionCodeMajor;
    }

    public int getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    @Nullable
    public String getDefaultToDeviceProtectedStorage() {
        return this.mDefaultToDeviceProtectedStorage;
    }

    @Nullable
    public String getRequestLegacyExternalStorage() {
        return this.mRequestLegacyExternalStorage;
    }

    @Nullable
    public String getUserDataFragile() {
        return this.mUserDataFragile;
    }

    @NonNull
    public List<ArchivedActivityInfo> getLauncherActivities() {
        return this.mLauncherActivities;
    }

    @NonNull
    public ArchivedPackageInfo setPackageName(@NonNull String value) {
        this.mPackageName = value;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
        return this;
    }

    @NonNull
    public ArchivedPackageInfo setSigningInfo(@NonNull SigningInfo value) {
        this.mSigningInfo = value;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSigningInfo);
        return this;
    }

    @NonNull
    public ArchivedPackageInfo setVersionCode(int value) {
        this.mVersionCode = value;
        return this;
    }

    @NonNull
    public ArchivedPackageInfo setVersionCodeMajor(int value) {
        this.mVersionCodeMajor = value;
        return this;
    }

    @NonNull
    public ArchivedPackageInfo setTargetSdkVersion(int value) {
        this.mTargetSdkVersion = value;
        return this;
    }

    @NonNull
    public ArchivedPackageInfo setDefaultToDeviceProtectedStorage(@NonNull String value) {
        this.mDefaultToDeviceProtectedStorage = value;
        return this;
    }

    @NonNull
    public ArchivedPackageInfo setRequestLegacyExternalStorage(@NonNull String value) {
        this.mRequestLegacyExternalStorage = value;
        return this;
    }

    @NonNull
    public ArchivedPackageInfo setUserDataFragile(@NonNull String value) {
        this.mUserDataFragile = value;
        return this;
    }

    @NonNull
    public ArchivedPackageInfo setLauncherActivities(@NonNull List<ArchivedActivityInfo> value) {
        this.mLauncherActivities = value;
        AnnotationValidations.validate(NonNull.class, null, this.mLauncherActivities);
        return this;
    }

    @Deprecated
    private void __metadata() {
    }
}

