/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.SharedLibraryInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodThrow;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Printer;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Parcelling;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

@RavenwoodKeepWholeClass
public class ApplicationInfo
extends PackageItemInfo
implements Parcelable {
    private static final Parcelling.BuiltIn.ForBoolean sForBoolean = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForBoolean.class);
    private static final Parcelling.BuiltIn.ForStringSet sForStringSet = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForStringSet.class);
    public String taskAffinity;
    public String permission;
    public String processName;
    public String className;
    public int descriptionRes;
    public int theme;
    public String manageSpaceActivityName;
    public String backupAgentName;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int fullBackupContent = 0;
    public int dataExtractionRulesRes = 0;
    public boolean crossProfile;
    public int uiOptions = 0;
    public static final int FLAG_SYSTEM = 1;
    public static final int FLAG_DEBUGGABLE = 2;
    public static final int FLAG_HAS_CODE = 4;
    public static final int FLAG_PERSISTENT = 8;
    public static final int FLAG_FACTORY_TEST = 16;
    public static final int FLAG_ALLOW_TASK_REPARENTING = 32;
    public static final int FLAG_ALLOW_CLEAR_USER_DATA = 64;
    public static final int FLAG_UPDATED_SYSTEM_APP = 128;
    public static final int FLAG_TEST_ONLY = 256;
    public static final int FLAG_SUPPORTS_SMALL_SCREENS = 512;
    public static final int FLAG_SUPPORTS_NORMAL_SCREENS = 1024;
    public static final int FLAG_SUPPORTS_LARGE_SCREENS = 2048;
    public static final int FLAG_RESIZEABLE_FOR_SCREENS = 4096;
    @Deprecated
    public static final int FLAG_SUPPORTS_SCREEN_DENSITIES = 8192;
    public static final int FLAG_VM_SAFE_MODE = 16384;
    public static final int FLAG_ALLOW_BACKUP = 32768;
    public static final int FLAG_KILL_AFTER_RESTORE = 65536;
    public static final int FLAG_RESTORE_ANY_VERSION = 131072;
    public static final int FLAG_EXTERNAL_STORAGE = 262144;
    public static final int FLAG_SUPPORTS_XLARGE_SCREENS = 524288;
    public static final int FLAG_LARGE_HEAP = 0x100000;
    public static final int FLAG_STOPPED = 0x200000;
    public static final int FLAG_SUPPORTS_RTL = 0x400000;
    public static final int FLAG_INSTALLED = 0x800000;
    public static final int FLAG_IS_DATA_ONLY = 0x1000000;
    @Deprecated
    public static final int FLAG_IS_GAME = 0x2000000;
    public static final int FLAG_FULL_BACKUP_ONLY = 0x4000000;
    public static final int FLAG_USES_CLEARTEXT_TRAFFIC = 0x8000000;
    public static final int FLAG_EXTRACT_NATIVE_LIBS = 0x10000000;
    public static final int FLAG_HARDWARE_ACCELERATED = 0x20000000;
    public static final int FLAG_SUSPENDED = 0x40000000;
    public static final int FLAG_MULTIARCH = Integer.MIN_VALUE;
    public int flags = 0;
    public static final int PRIVATE_FLAG_HIDDEN = 1;
    public static final int PRIVATE_FLAG_CANT_SAVE_STATE = 2;
    @UnsupportedAppUsage
    public static final int PRIVATE_FLAG_PRIVILEGED = 8;
    public static final int PRIVATE_FLAG_HAS_DOMAIN_URLS = 16;
    public static final int PRIVATE_FLAG_DEFAULT_TO_DEVICE_PROTECTED_STORAGE = 32;
    public static final int PRIVATE_FLAG_DIRECT_BOOT_AWARE = 64;
    public static final int PRIVATE_FLAG_INSTANT = 128;
    public static final int PRIVATE_FLAG_PARTIALLY_DIRECT_BOOT_AWARE = 256;
    public static final int PRIVATE_FLAG_REQUIRED_FOR_SYSTEM_USER = 512;
    public static final int PRIVATE_FLAG_ACTIVITIES_RESIZE_MODE_RESIZEABLE = 1024;
    public static final int PRIVATE_FLAG_ACTIVITIES_RESIZE_MODE_UNRESIZEABLE = 2048;
    public static final int PRIVATE_FLAG_ACTIVITIES_RESIZE_MODE_RESIZEABLE_VIA_SDK_VERSION = 4096;
    public static final int PRIVATE_FLAG_BACKUP_IN_FOREGROUND = 8192;
    public static final int PRIVATE_FLAG_STATIC_SHARED_LIBRARY = 16384;
    public static final int PRIVATE_FLAG_ISOLATED_SPLIT_LOADING = 32768;
    public static final int PRIVATE_FLAG_VIRTUAL_PRELOAD = 65536;
    public static final int PRIVATE_FLAG_OEM = 131072;
    public static final int PRIVATE_FLAG_VENDOR = 262144;
    public static final int PRIVATE_FLAG_PRODUCT = 524288;
    public static final int PRIVATE_FLAG_SIGNED_WITH_PLATFORM_KEY = 0x100000;
    public static final int PRIVATE_FLAG_SYSTEM_EXT = 0x200000;
    public static final int PRIVATE_FLAG_USES_NON_SDK_API = 0x400000;
    public static final int PRIVATE_FLAG_PROFILEABLE_BY_SHELL = 0x800000;
    public static final int PRIVATE_FLAG_HAS_FRAGILE_USER_DATA = 0x1000000;
    public static final int PRIVATE_FLAG_USE_EMBEDDED_DEX = 0x2000000;
    public static final int PRIVATE_FLAG_ALLOW_CLEAR_USER_DATA_ON_FAILED_RESTORE = 0x4000000;
    public static final int PRIVATE_FLAG_ALLOW_AUDIO_PLAYBACK_CAPTURE = 0x8000000;
    public static final int PRIVATE_FLAG_IS_RESOURCE_OVERLAY = 0x10000000;
    public static final int PRIVATE_FLAG_REQUEST_LEGACY_EXTERNAL_STORAGE = 0x20000000;
    public static final int PRIVATE_FLAG_ODM = 0x40000000;
    public static final int PRIVATE_FLAG_ALLOW_NATIVE_HEAP_POINTER_TAGGING = Integer.MIN_VALUE;
    public static final int PRIVATE_FLAG_EXT_PROFILEABLE = 1;
    public static final int PRIVATE_FLAG_EXT_REQUEST_FOREGROUND_SERVICE_EXEMPTION = 2;
    public static final int PRIVATE_FLAG_EXT_ATTRIBUTIONS_ARE_USER_VISIBLE = 4;
    public static final int PRIVATE_FLAG_EXT_ENABLE_ON_BACK_INVOKED_CALLBACK = 8;
    public static final int PRIVATE_FLAG_EXT_ALLOWLISTED_FOR_HIDDEN_APIS = 16;
    public static final int PRIVATE_FLAG_EXT_CPU_OVERRIDE = 32;
    public static final int PRIVATE_FLAG_EXT_NOT_LAUNCHED = 64;
    public static final int AUTO_REVOKE_ALLOWED = 0;
    public static final int AUTO_REVOKE_DISCOURAGED = 1;
    public static final int AUTO_REVOKE_DISALLOWED = 2;
    @UnsupportedAppUsage
    public int privateFlags;
    public int privateFlagsExt;
    public static final String METADATA_PRELOADED_FONTS = "preloaded_fonts";
    public int requiresSmallestWidthDp = 0;
    public int compatibleWidthLimitDp = 0;
    public int largestWidthLimitDp = 0;
    public float maxAspectRatio;
    public float minAspectRatio;
    public String volumeUuid;
    public UUID storageUuid;
    @UnsupportedAppUsage
    public String scanSourceDir;
    @UnsupportedAppUsage
    public String scanPublicSourceDir;
    public String sourceDir;
    public String publicSourceDir;
    @Nullable
    public String[] splitNames;
    @Nullable
    public String[] splitSourceDirs;
    @Nullable
    public String[] splitPublicSourceDirs;
    public SparseArray<int[]> splitDependencies;
    @UnsupportedAppUsage
    public String[] resourceDirs;
    public String[] overlayPaths;
    public String seInfo;
    public String seInfoUser;
    public String[] sharedLibraryFiles;
    @Nullable
    public List<SharedLibraryInfo> sharedLibraryInfos;
    @Nullable
    public List<SharedLibraryInfo> optionalSharedLibraryInfos;
    public String dataDir;
    public String deviceProtectedDataDir;
    @SystemApi
    public String credentialProtectedDataDir;
    public String nativeLibraryDir;
    @UnsupportedAppUsage
    public String secondaryNativeLibraryDir;
    @UnsupportedAppUsage
    public String nativeLibraryRootDir;
    public boolean nativeLibraryRootRequiresIsa;
    @UnsupportedAppUsage
    public String primaryCpuAbi;
    @UnsupportedAppUsage
    public String secondaryCpuAbi;
    public int uid;
    public int minSdkVersion;
    public int targetSdkVersion;
    public long longVersionCode;
    @Deprecated
    @UnsupportedAppUsage
    public int versionCode;
    public long createTimestamp;
    public int compileSdkVersion;
    @Nullable
    public String compileSdkVersionCodename;
    public boolean enabled = true;
    @UnsupportedAppUsage
    public int enabledSetting = 0;
    @UnsupportedAppUsage
    public int installLocation = -1;
    public int networkSecurityConfigRes;
    @SystemApi
    public int targetSandboxVersion;
    public String appComponentFactory;
    public int iconRes;
    public int roundIconRes;
    public int category = -1;
    public static final int CATEGORY_UNDEFINED = -1;
    public static final int CATEGORY_GAME = 0;
    public static final int CATEGORY_AUDIO = 1;
    public static final int CATEGORY_VIDEO = 2;
    public static final int CATEGORY_IMAGE = 3;
    public static final int CATEGORY_SOCIAL = 4;
    public static final int CATEGORY_NEWS = 5;
    public static final int CATEGORY_MAPS = 6;
    public static final int CATEGORY_PRODUCTIVITY = 7;
    public static final int CATEGORY_ACCESSIBILITY = 8;
    public static final int PAGE_SIZE_APP_COMPAT_FLAG_ERROR = -1;
    public static final int PAGE_SIZE_APP_COMPAT_FLAG_UNDEFINED = 0;
    public static final int PAGE_SIZE_APP_COMPAT_FLAG_UNCOMPRESSED_LIBS_NOT_ALIGNED = 2;
    public static final int PAGE_SIZE_APP_COMPAT_FLAG_ELF_NOT_ALIGNED = 4;
    public static final int PAGE_SIZE_APP_COMPAT_FLAG_SETTINGS_OVERRIDE_ENABLED = 8;
    public static final int PAGE_SIZE_APP_COMPAT_FLAG_SETTINGS_OVERRIDE_DISABLED = 16;
    public static final int PAGE_SIZE_APP_COMPAT_FLAG_MANIFEST_OVERRIDE_ENABLED = 32;
    public static final int PAGE_SIZE_APP_COMPAT_FLAG_MANIFEST_OVERRIDE_DISABLED = 64;
    public static final int PAGE_SIZE_APP_COMPAT_FLAG_MAX = 128;
    private int mPageSizeAppCompatFlags = 0;
    public String classLoaderName;
    public String[] splitClassLoaderNames;
    public boolean hiddenUntilInstalled;
    public String zygotePreloadName;
    public static final int GWP_ASAN_DEFAULT = -1;
    public static final int GWP_ASAN_NEVER = 0;
    public static final int GWP_ASAN_ALWAYS = 1;
    private int gwpAsanMode = -1;
    public static final int MEMTAG_DEFAULT = -1;
    public static final int MEMTAG_OFF = 0;
    public static final int MEMTAG_ASYNC = 1;
    public static final int MEMTAG_SYNC = 2;
    private int memtagMode = -1;
    public static final int ZEROINIT_DEFAULT = -1;
    public static final int ZEROINIT_DISABLED = 0;
    public static final int ZEROINIT_ENABLED = 1;
    private int nativeHeapZeroInitialized = -1;
    @Nullable
    private Boolean requestRawExternalStorageAccess;
    public boolean allowCrossUidActivitySwitchFromBelow = true;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int HIDDEN_API_ENFORCEMENT_DEFAULT = -1;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int HIDDEN_API_ENFORCEMENT_DISABLED = 0;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int HIDDEN_API_ENFORCEMENT_JUST_WARN = 1;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int HIDDEN_API_ENFORCEMENT_ENABLED = 2;
    private static final int HIDDEN_API_ENFORCEMENT_MIN = -1;
    private static final int HIDDEN_API_ENFORCEMENT_MAX = 2;
    private int mHiddenApiPolicy = -1;
    @Nullable
    private ArrayMap<String, String> mAppClassNamesByProcess;
    private int localeConfigRes;
    @Nullable
    private Set<String> mKnownActivityEmbeddingCerts;
    @NonNull
    public static final Parcelable.Creator<ApplicationInfo> CREATOR = new Parcelable.Creator<ApplicationInfo>(){

        @Override
        public ApplicationInfo createFromParcel(Parcel source) {
            return source.readSquashed(ApplicationInfo::new);
        }

        public ApplicationInfo[] newArray(int size) {
            return new ApplicationInfo[size];
        }
    };
    public static final int RAW_EXTERNAL_STORAGE_ACCESS_DEFAULT = 0;
    public static final int RAW_EXTERNAL_STORAGE_ACCESS_REQUESTED = 1;
    public static final int RAW_EXTERNAL_STORAGE_ACCESS_NOT_REQUESTED = 2;

    @RavenwoodThrow(blockedBy={Resources.class})
    public static CharSequence getCategoryTitle(Context context, int category) {
        switch (category) {
            case 0: {
                return context.getText(17039714);
            }
            case 1: {
                return context.getText(17039713);
            }
            case 2: {
                return context.getText(17039720);
            }
            case 3: {
                return context.getText(17039715);
            }
            case 4: {
                return context.getText(17039719);
            }
            case 5: {
                return context.getText(17039717);
            }
            case 6: {
                return context.getText(17039716);
            }
            case 7: {
                return context.getText(17039718);
            }
            case 8: {
                return context.getText(17039712);
            }
        }
        return null;
    }

    public static boolean isValidHiddenApiEnforcementPolicy(int policy) {
        return policy >= -1 && policy <= 2;
    }

    public void dump(Printer pw, String prefix) {
        this.dump(pw, prefix, 3);
    }

    public void dump(Printer pw, String prefix, int dumpFlags) {
        super.dumpFront(pw, prefix);
        if ((dumpFlags & 1) != 0) {
            if (this.className != null) {
                pw.println(prefix + "className=" + this.className);
            }
            for (int i = 0; i < ArrayUtils.size(this.mAppClassNamesByProcess); ++i) {
                pw.println(prefix + "  process=" + this.mAppClassNamesByProcess.keyAt(i) + " className=" + this.mAppClassNamesByProcess.valueAt(i));
            }
        }
        if (this.permission != null) {
            pw.println(prefix + "permission=" + this.permission);
        }
        pw.println(prefix + "processName=" + this.processName);
        if ((dumpFlags & 1) != 0) {
            pw.println(prefix + "taskAffinity=" + this.taskAffinity);
        }
        pw.println(prefix + "uid=" + this.uid + " flags=0x" + Integer.toHexString(this.flags) + " privateFlags=0x" + Integer.toHexString(this.privateFlags) + " theme=0x" + Integer.toHexString(this.theme));
        if ((dumpFlags & 1) != 0) {
            pw.println(prefix + "requiresSmallestWidthDp=" + this.requiresSmallestWidthDp + " compatibleWidthLimitDp=" + this.compatibleWidthLimitDp + " largestWidthLimitDp=" + this.largestWidthLimitDp);
        }
        pw.println(prefix + "sourceDir=" + this.sourceDir);
        if (!Objects.equals(this.sourceDir, this.publicSourceDir)) {
            pw.println(prefix + "publicSourceDir=" + this.publicSourceDir);
        }
        if (!ArrayUtils.isEmpty(this.splitSourceDirs)) {
            pw.println(prefix + "splitSourceDirs=" + Arrays.toString(this.splitSourceDirs));
        }
        if (!ArrayUtils.isEmpty(this.splitPublicSourceDirs) && !Arrays.equals(this.splitSourceDirs, this.splitPublicSourceDirs)) {
            pw.println(prefix + "splitPublicSourceDirs=" + Arrays.toString(this.splitPublicSourceDirs));
        }
        if (this.resourceDirs != null) {
            pw.println(prefix + "resourceDirs=" + Arrays.toString(this.resourceDirs));
        }
        if (this.overlayPaths != null) {
            pw.println(prefix + "overlayPaths=" + Arrays.toString(this.overlayPaths));
        }
        if ((dumpFlags & 1) != 0 && this.seInfo != null) {
            pw.println(prefix + "seinfo=" + this.seInfo);
            pw.println(prefix + "seinfoUser=" + this.seInfoUser);
        }
        pw.println(prefix + "dataDir=" + this.dataDir);
        if ((dumpFlags & 1) != 0) {
            pw.println(prefix + "deviceProtectedDataDir=" + this.deviceProtectedDataDir);
            pw.println(prefix + "credentialProtectedDataDir=" + this.credentialProtectedDataDir);
            if (this.sharedLibraryFiles != null) {
                pw.println(prefix + "sharedLibraryFiles=" + Arrays.toString(this.sharedLibraryFiles));
            }
        }
        if (this.classLoaderName != null) {
            pw.println(prefix + "classLoaderName=" + this.classLoaderName);
        }
        if (!ArrayUtils.isEmpty(this.splitClassLoaderNames)) {
            pw.println(prefix + "splitClassLoaderNames=" + Arrays.toString(this.splitClassLoaderNames));
        }
        pw.println(prefix + "enabled=" + this.enabled + " minSdkVersion=" + this.minSdkVersion + " targetSdkVersion=" + this.targetSdkVersion + " versionCode=" + this.longVersionCode + " targetSandboxVersion=" + this.targetSandboxVersion);
        if ((dumpFlags & 1) != 0) {
            if (this.manageSpaceActivityName != null) {
                pw.println(prefix + "manageSpaceActivityName=" + this.manageSpaceActivityName);
            }
            if (this.descriptionRes != 0) {
                pw.println(prefix + "description=0x" + Integer.toHexString(this.descriptionRes));
            }
            if (this.uiOptions != 0) {
                pw.println(prefix + "uiOptions=0x" + Integer.toHexString(this.uiOptions));
            }
            pw.println(prefix + "supportsRtl=" + (this.hasRtlSupport() ? "true" : "false"));
            if (this.fullBackupContent > 0) {
                pw.println(prefix + "fullBackupContent=@xml/" + this.fullBackupContent);
            } else {
                pw.println(prefix + "fullBackupContent=" + (this.fullBackupContent < 0 ? "false" : "true"));
            }
            if (this.dataExtractionRulesRes != 0) {
                pw.println(prefix + "dataExtractionRules=@xml/" + this.dataExtractionRulesRes);
            }
            pw.println(prefix + "crossProfile=" + (this.crossProfile ? "true" : "false"));
            if (this.networkSecurityConfigRes != 0) {
                pw.println(prefix + "networkSecurityConfigRes=0x" + Integer.toHexString(this.networkSecurityConfigRes));
            }
            if (this.category != -1) {
                pw.println(prefix + "category=" + this.category);
            }
            pw.println(prefix + "HiddenApiEnforcementPolicy=" + this.getHiddenApiEnforcementPolicy());
            pw.println(prefix + "usesNonSdkApi=" + this.usesNonSdkApi());
            pw.println(prefix + "allowsPlaybackCapture=" + (this.isAudioPlaybackCaptureAllowed() ? "true" : "false"));
            if (this.gwpAsanMode != -1) {
                pw.println(prefix + "gwpAsanMode=" + this.gwpAsanMode);
            }
            if (this.memtagMode != -1) {
                pw.println(prefix + "memtagMode=" + this.memtagMode);
            }
            if (this.nativeHeapZeroInitialized != -1) {
                pw.println(prefix + "nativeHeapZeroInitialized=" + this.nativeHeapZeroInitialized);
            }
            if (this.requestRawExternalStorageAccess != null) {
                pw.println(prefix + "requestRawExternalStorageAccess=" + this.requestRawExternalStorageAccess);
            }
            if (this.localeConfigRes != 0) {
                pw.println(prefix + "localeConfigRes=0x" + Integer.toHexString(this.localeConfigRes));
            }
            pw.println(prefix + "enableOnBackInvokedCallback=" + this.isOnBackInvokedCallbackEnabled());
            pw.println(prefix + "allowCrossUidActivitySwitchFromBelow=" + this.allowCrossUidActivitySwitchFromBelow);
            pw.println(prefix + "mPageSizeAppCompatFlags=" + this.mPageSizeAppCompatFlags);
        }
        pw.println(prefix + "createTimestamp=" + this.createTimestamp);
        if (this.mKnownActivityEmbeddingCerts != null) {
            pw.println(prefix + "knownActivityEmbeddingCerts=" + this.mKnownActivityEmbeddingCerts);
        }
        super.dumpBack(pw, prefix);
    }

    @Override
    public void dumpDebug(ProtoOutputStream proto, long fieldId, int dumpFlags) {
        long token = proto.start(fieldId);
        super.dumpDebug(proto, 0x10B00000001L, dumpFlags);
        proto.write(1138166333442L, this.permission);
        proto.write(1138166333443L, this.processName);
        proto.write(1120986464260L, this.uid);
        proto.write(0x10500000005L, this.flags);
        proto.write(1120986464262L, this.privateFlags);
        proto.write(1120986464263L, this.theme);
        proto.write(1138166333448L, this.sourceDir);
        if (!Objects.equals(this.sourceDir, this.publicSourceDir)) {
            proto.write(0x10900000009L, this.publicSourceDir);
        }
        if (!ArrayUtils.isEmpty(this.splitSourceDirs)) {
            for (String dir : this.splitSourceDirs) {
                proto.write(2237677961226L, dir);
            }
        }
        if (!ArrayUtils.isEmpty(this.splitPublicSourceDirs) && !Arrays.equals(this.splitSourceDirs, this.splitPublicSourceDirs)) {
            for (String dir : this.splitPublicSourceDirs) {
                proto.write(2237677961227L, dir);
            }
        }
        if (this.resourceDirs != null) {
            for (String dir : this.resourceDirs) {
                proto.write(2237677961228L, dir);
            }
        }
        if (this.overlayPaths != null) {
            for (String dir : this.overlayPaths) {
                proto.write(2237677961234L, dir);
            }
        }
        proto.write(1138166333453L, this.dataDir);
        proto.write(1138166333454L, this.classLoaderName);
        if (!ArrayUtils.isEmpty(this.splitClassLoaderNames)) {
            for (String name : this.splitClassLoaderNames) {
                proto.write(2237677961231L, name);
            }
        }
        long versionToken = proto.start(0x10B00000010L);
        proto.write(0x10800000001L, this.enabled);
        proto.write(1120986464258L, this.minSdkVersion);
        proto.write(1120986464259L, this.targetSdkVersion);
        proto.write(1120986464260L, this.longVersionCode);
        proto.write(0x10500000005L, this.targetSandboxVersion);
        proto.end(versionToken);
        if ((dumpFlags & 1) != 0) {
            long detailToken = proto.start(0x10B00000011L);
            if (this.className != null) {
                proto.write(0x10900000001L, this.className);
            }
            proto.write(1138166333442L, this.taskAffinity);
            proto.write(1120986464259L, this.requiresSmallestWidthDp);
            proto.write(1120986464260L, this.compatibleWidthLimitDp);
            proto.write(0x10500000005L, this.largestWidthLimitDp);
            if (this.seInfo != null) {
                proto.write(1138166333446L, this.seInfo);
                proto.write(1138166333447L, this.seInfoUser);
            }
            proto.write(1138166333448L, this.deviceProtectedDataDir);
            proto.write(0x10900000009L, this.credentialProtectedDataDir);
            if (this.sharedLibraryFiles != null) {
                for (String f : this.sharedLibraryFiles) {
                    proto.write(2237677961226L, f);
                }
            }
            if (this.manageSpaceActivityName != null) {
                proto.write(1138166333451L, this.manageSpaceActivityName);
            }
            if (this.descriptionRes != 0) {
                proto.write(1120986464268L, this.descriptionRes);
            }
            if (this.uiOptions != 0) {
                proto.write(1120986464269L, this.uiOptions);
            }
            proto.write(1133871366158L, this.hasRtlSupport());
            if (this.fullBackupContent > 0) {
                proto.write(1138166333455L, "@xml/" + this.fullBackupContent);
            } else {
                proto.write(0x10800000010L, this.fullBackupContent == 0);
            }
            if (this.networkSecurityConfigRes != 0) {
                proto.write(0x10500000011L, this.networkSecurityConfigRes);
            }
            if (this.category != -1) {
                proto.write(1120986464274L, this.category);
            }
            if (this.gwpAsanMode != -1) {
                proto.write(1120986464275L, this.gwpAsanMode);
            }
            if (this.memtagMode != -1) {
                proto.write(1120986464276L, this.memtagMode);
            }
            if (this.nativeHeapZeroInitialized != -1) {
                proto.write(1133871366165L, this.nativeHeapZeroInitialized);
            }
            proto.write(1133871366166L, this.allowCrossUidActivitySwitchFromBelow);
            proto.write(1120986464279L, this.mPageSizeAppCompatFlags);
            proto.end(detailToken);
        }
        if (!ArrayUtils.isEmpty(this.mKnownActivityEmbeddingCerts)) {
            for (String knownCert : this.mKnownActivityEmbeddingCerts) {
                proto.write(2237677961235L, knownCert);
            }
        }
        proto.end(token);
    }

    @UnsupportedAppUsage
    public boolean hasRtlSupport() {
        return (this.flags & 0x400000) == 0x400000;
    }

    public boolean hasCode() {
        return (this.flags & 4) != 0;
    }

    public ApplicationInfo() {
        this.createTimestamp = SystemClock.uptimeMillis();
    }

    public ApplicationInfo(ApplicationInfo orig) {
        super(orig);
        this.taskAffinity = orig.taskAffinity;
        this.permission = orig.permission;
        this.mKnownActivityEmbeddingCerts = orig.mKnownActivityEmbeddingCerts;
        this.processName = orig.processName;
        this.className = orig.className;
        this.theme = orig.theme;
        this.flags = orig.flags;
        this.privateFlags = orig.privateFlags;
        this.privateFlagsExt = orig.privateFlagsExt;
        this.requiresSmallestWidthDp = orig.requiresSmallestWidthDp;
        this.compatibleWidthLimitDp = orig.compatibleWidthLimitDp;
        this.largestWidthLimitDp = orig.largestWidthLimitDp;
        this.volumeUuid = orig.volumeUuid;
        this.storageUuid = orig.storageUuid;
        this.scanSourceDir = orig.scanSourceDir;
        this.scanPublicSourceDir = orig.scanPublicSourceDir;
        this.sourceDir = orig.sourceDir;
        this.publicSourceDir = orig.publicSourceDir;
        this.splitNames = orig.splitNames;
        this.splitSourceDirs = orig.splitSourceDirs;
        this.splitPublicSourceDirs = orig.splitPublicSourceDirs;
        this.splitDependencies = orig.splitDependencies;
        this.nativeLibraryDir = orig.nativeLibraryDir;
        this.secondaryNativeLibraryDir = orig.secondaryNativeLibraryDir;
        this.nativeLibraryRootDir = orig.nativeLibraryRootDir;
        this.nativeLibraryRootRequiresIsa = orig.nativeLibraryRootRequiresIsa;
        this.primaryCpuAbi = orig.primaryCpuAbi;
        this.secondaryCpuAbi = orig.secondaryCpuAbi;
        this.resourceDirs = orig.resourceDirs;
        this.overlayPaths = orig.overlayPaths;
        this.seInfo = orig.seInfo;
        this.seInfoUser = orig.seInfoUser;
        this.sharedLibraryFiles = orig.sharedLibraryFiles;
        this.sharedLibraryInfos = orig.sharedLibraryInfos;
        this.optionalSharedLibraryInfos = orig.optionalSharedLibraryInfos;
        this.dataDir = orig.dataDir;
        this.deviceProtectedDataDir = orig.deviceProtectedDataDir;
        this.credentialProtectedDataDir = orig.credentialProtectedDataDir;
        this.uid = orig.uid;
        this.minSdkVersion = orig.minSdkVersion;
        this.targetSdkVersion = orig.targetSdkVersion;
        this.setVersionCode(orig.longVersionCode);
        this.enabled = orig.enabled;
        this.enabledSetting = orig.enabledSetting;
        this.installLocation = orig.installLocation;
        this.manageSpaceActivityName = orig.manageSpaceActivityName;
        this.descriptionRes = orig.descriptionRes;
        this.uiOptions = orig.uiOptions;
        this.backupAgentName = orig.backupAgentName;
        this.fullBackupContent = orig.fullBackupContent;
        this.dataExtractionRulesRes = orig.dataExtractionRulesRes;
        this.crossProfile = orig.crossProfile;
        this.networkSecurityConfigRes = orig.networkSecurityConfigRes;
        this.category = orig.category;
        this.targetSandboxVersion = orig.targetSandboxVersion;
        this.classLoaderName = orig.classLoaderName;
        this.splitClassLoaderNames = orig.splitClassLoaderNames;
        this.appComponentFactory = orig.appComponentFactory;
        this.iconRes = orig.iconRes;
        this.roundIconRes = orig.roundIconRes;
        this.compileSdkVersion = orig.compileSdkVersion;
        this.compileSdkVersionCodename = orig.compileSdkVersionCodename;
        this.mHiddenApiPolicy = orig.mHiddenApiPolicy;
        this.hiddenUntilInstalled = orig.hiddenUntilInstalled;
        this.zygotePreloadName = orig.zygotePreloadName;
        this.gwpAsanMode = orig.gwpAsanMode;
        this.memtagMode = orig.memtagMode;
        this.nativeHeapZeroInitialized = orig.nativeHeapZeroInitialized;
        this.requestRawExternalStorageAccess = orig.requestRawExternalStorageAccess;
        this.localeConfigRes = orig.localeConfigRes;
        this.allowCrossUidActivitySwitchFromBelow = orig.allowCrossUidActivitySwitchFromBelow;
        this.createTimestamp = SystemClock.uptimeMillis();
        this.mPageSizeAppCompatFlags = orig.mPageSizeAppCompatFlags;
    }

    public String toString() {
        return "ApplicationInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        if (dest.maybeWriteSquashed(this)) {
            return;
        }
        super.writeToParcel(dest, parcelableFlags);
        dest.writeString8(this.taskAffinity);
        dest.writeString8(this.permission);
        dest.writeString8(this.processName);
        dest.writeString8(this.className);
        dest.writeInt(this.theme);
        dest.writeInt(this.flags);
        dest.writeInt(this.privateFlags);
        dest.writeInt(this.privateFlagsExt);
        dest.writeInt(this.requiresSmallestWidthDp);
        dest.writeInt(this.compatibleWidthLimitDp);
        dest.writeInt(this.largestWidthLimitDp);
        if (this.storageUuid != null) {
            dest.writeInt(1);
            dest.writeLong(this.storageUuid.getMostSignificantBits());
            dest.writeLong(this.storageUuid.getLeastSignificantBits());
        } else {
            dest.writeInt(0);
        }
        dest.writeString8(this.scanSourceDir);
        dest.writeString8(this.scanPublicSourceDir);
        dest.writeString8(this.sourceDir);
        dest.writeString8(this.publicSourceDir);
        dest.writeString8Array(this.splitNames);
        dest.writeString8Array(this.splitSourceDirs);
        dest.writeString8Array(this.splitPublicSourceDirs);
        dest.writeSparseArray(this.splitDependencies);
        dest.writeString8(this.nativeLibraryDir);
        dest.writeString8(this.secondaryNativeLibraryDir);
        dest.writeString8(this.nativeLibraryRootDir);
        dest.writeInt(this.nativeLibraryRootRequiresIsa ? 1 : 0);
        dest.writeString8(this.primaryCpuAbi);
        dest.writeString8(this.secondaryCpuAbi);
        dest.writeString8Array(this.resourceDirs);
        dest.writeString8Array(this.overlayPaths);
        dest.writeString8(this.seInfo);
        dest.writeString8(this.seInfoUser);
        dest.writeString8Array(this.sharedLibraryFiles);
        dest.writeTypedList(this.sharedLibraryInfos);
        dest.writeTypedList(this.optionalSharedLibraryInfos);
        dest.writeString8(this.dataDir);
        dest.writeString8(this.deviceProtectedDataDir);
        dest.writeString8(this.credentialProtectedDataDir);
        dest.writeInt(this.uid);
        dest.writeInt(this.minSdkVersion);
        dest.writeInt(this.targetSdkVersion);
        dest.writeLong(this.longVersionCode);
        dest.writeInt(this.enabled ? 1 : 0);
        dest.writeInt(this.enabledSetting);
        dest.writeInt(this.installLocation);
        dest.writeString8(this.manageSpaceActivityName);
        dest.writeString8(this.backupAgentName);
        dest.writeInt(this.descriptionRes);
        dest.writeInt(this.uiOptions);
        dest.writeInt(this.fullBackupContent);
        dest.writeInt(this.dataExtractionRulesRes);
        dest.writeBoolean(this.crossProfile);
        dest.writeInt(this.networkSecurityConfigRes);
        dest.writeInt(this.category);
        dest.writeInt(this.targetSandboxVersion);
        dest.writeString8(this.classLoaderName);
        dest.writeString8Array(this.splitClassLoaderNames);
        dest.writeInt(this.compileSdkVersion);
        dest.writeString8(this.compileSdkVersionCodename);
        dest.writeString8(this.appComponentFactory);
        dest.writeInt(this.iconRes);
        dest.writeInt(this.roundIconRes);
        dest.writeInt(this.mHiddenApiPolicy);
        dest.writeInt(this.hiddenUntilInstalled ? 1 : 0);
        dest.writeString8(this.zygotePreloadName);
        dest.writeInt(this.gwpAsanMode);
        dest.writeInt(this.memtagMode);
        dest.writeInt(this.nativeHeapZeroInitialized);
        sForBoolean.parcel(this.requestRawExternalStorageAccess, dest, parcelableFlags);
        dest.writeLong(this.createTimestamp);
        if (this.mAppClassNamesByProcess == null) {
            dest.writeInt(0);
        } else {
            int size = this.mAppClassNamesByProcess.size();
            dest.writeInt(size);
            for (int i = 0; i < size; ++i) {
                dest.writeString(this.mAppClassNamesByProcess.keyAt(i));
                dest.writeString(this.mAppClassNamesByProcess.valueAt(i));
            }
        }
        dest.writeInt(this.localeConfigRes);
        dest.writeInt(this.allowCrossUidActivitySwitchFromBelow ? 1 : 0);
        dest.writeInt(this.mPageSizeAppCompatFlags);
        sForStringSet.parcel(this.mKnownActivityEmbeddingCerts, dest, this.flags);
    }

    private ApplicationInfo(Parcel source) {
        super(source);
        this.taskAffinity = source.readString8();
        this.permission = source.readString8();
        this.processName = source.readString8();
        this.className = source.readString8();
        this.theme = source.readInt();
        this.flags = source.readInt();
        this.privateFlags = source.readInt();
        this.privateFlagsExt = source.readInt();
        this.requiresSmallestWidthDp = source.readInt();
        this.compatibleWidthLimitDp = source.readInt();
        this.largestWidthLimitDp = source.readInt();
        if (source.readInt() != 0) {
            this.storageUuid = new UUID(source.readLong(), source.readLong());
            this.volumeUuid = StorageManager.convert(this.storageUuid);
        }
        this.scanSourceDir = source.readString8();
        this.scanPublicSourceDir = source.readString8();
        this.sourceDir = source.readString8();
        this.publicSourceDir = source.readString8();
        this.splitNames = source.createString8Array();
        this.splitSourceDirs = source.createString8Array();
        this.splitPublicSourceDirs = source.createString8Array();
        this.splitDependencies = source.readSparseArray(null, int[].class);
        this.nativeLibraryDir = source.readString8();
        this.secondaryNativeLibraryDir = source.readString8();
        this.nativeLibraryRootDir = source.readString8();
        this.nativeLibraryRootRequiresIsa = source.readInt() != 0;
        this.primaryCpuAbi = source.readString8();
        this.secondaryCpuAbi = source.readString8();
        this.resourceDirs = source.createString8Array();
        this.overlayPaths = source.createString8Array();
        this.seInfo = source.readString8();
        this.seInfoUser = source.readString8();
        this.sharedLibraryFiles = source.createString8Array();
        this.sharedLibraryInfos = source.createTypedArrayList(SharedLibraryInfo.CREATOR);
        this.optionalSharedLibraryInfos = source.createTypedArrayList(SharedLibraryInfo.CREATOR);
        this.dataDir = source.readString8();
        this.deviceProtectedDataDir = source.readString8();
        this.credentialProtectedDataDir = source.readString8();
        this.uid = source.readInt();
        this.minSdkVersion = source.readInt();
        this.targetSdkVersion = source.readInt();
        this.setVersionCode(source.readLong());
        this.enabled = source.readInt() != 0;
        this.enabledSetting = source.readInt();
        this.installLocation = source.readInt();
        this.manageSpaceActivityName = source.readString8();
        this.backupAgentName = source.readString8();
        this.descriptionRes = source.readInt();
        this.uiOptions = source.readInt();
        this.fullBackupContent = source.readInt();
        this.dataExtractionRulesRes = source.readInt();
        this.crossProfile = source.readBoolean();
        this.networkSecurityConfigRes = source.readInt();
        this.category = source.readInt();
        this.targetSandboxVersion = source.readInt();
        this.classLoaderName = source.readString8();
        this.splitClassLoaderNames = source.createString8Array();
        this.compileSdkVersion = source.readInt();
        this.compileSdkVersionCodename = source.readString8();
        this.appComponentFactory = source.readString8();
        this.iconRes = source.readInt();
        this.roundIconRes = source.readInt();
        this.mHiddenApiPolicy = source.readInt();
        this.hiddenUntilInstalled = source.readInt() != 0;
        this.zygotePreloadName = source.readString8();
        this.gwpAsanMode = source.readInt();
        this.memtagMode = source.readInt();
        this.nativeHeapZeroInitialized = source.readInt();
        this.requestRawExternalStorageAccess = sForBoolean.unparcel(source);
        this.createTimestamp = source.readLong();
        int allClassesSize = source.readInt();
        if (allClassesSize > 0) {
            this.mAppClassNamesByProcess = new ArrayMap(allClassesSize);
            for (int i = 0; i < allClassesSize; ++i) {
                this.mAppClassNamesByProcess.put(source.readString(), source.readString());
            }
        }
        this.localeConfigRes = source.readInt();
        this.allowCrossUidActivitySwitchFromBelow = source.readInt() != 0;
        this.mPageSizeAppCompatFlags = source.readInt();
        this.mKnownActivityEmbeddingCerts = sForStringSet.unparcel(source);
        if (this.mKnownActivityEmbeddingCerts.isEmpty()) {
            this.mKnownActivityEmbeddingCerts = null;
        }
    }

    @RavenwoodThrow(blockedBy={Resources.class})
    public CharSequence loadDescription(PackageManager pm) {
        CharSequence label;
        if (this.descriptionRes != 0 && (label = pm.getText(this.packageName, this.descriptionRes, this)) != null) {
            return label;
        }
        return null;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void disableCompatibilityMode() {
        this.flags |= 0x83E00;
    }

    public boolean usesCompatibilityMode() {
        return this.targetSdkVersion < 4 || (this.flags & 0x83E00) == 0;
    }

    @RavenwoodThrow(blockedBy={Environment.class})
    public void initForUser(int userId) {
        this.uid = UserHandle.getUid(userId, UserHandle.getAppId(this.uid));
        if ("android".equals(this.packageName)) {
            this.dataDir = Environment.getDataSystemDirectory().getAbsolutePath();
            return;
        }
        this.deviceProtectedDataDir = Environment.getDataUserDePackageDirectory(this.volumeUuid, userId, this.packageName).getAbsolutePath();
        this.credentialProtectedDataDir = Environment.getDataUserCePackageDirectory(this.volumeUuid, userId, this.packageName).getAbsolutePath();
        this.dataDir = (this.privateFlags & 0x20) != 0 ? this.deviceProtectedDataDir : this.credentialProtectedDataDir;
    }

    private boolean isPackageWhitelistedForHiddenApis() {
        return (this.privateFlagsExt & 0x10) != 0;
    }

    public boolean usesNonSdkApi() {
        return (this.privateFlags & 0x400000) != 0;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.DELETE_PACKAGES")
    public boolean hasFragileUserData() {
        return (this.privateFlags & 0x1000000) != 0;
    }

    @FlaggedApi(value="android.content.pm.audio_playback_capture_allowance")
    public boolean isAudioPlaybackCaptureAllowed() {
        return (this.privateFlags & 0x8000000) != 0;
    }

    public boolean hasRequestedLegacyExternalStorage() {
        return (this.privateFlags & 0x20000000) != 0;
    }

    public int getRequestRawExternalStorageAccess() {
        if (this.requestRawExternalStorageAccess == null) {
            return 0;
        }
        return this.requestRawExternalStorageAccess != false ? 1 : 2;
    }

    public boolean allowsNativeHeapPointerTagging() {
        return (this.privateFlags & Integer.MIN_VALUE) != 0;
    }

    private boolean isAllowedToUseHiddenApis() {
        if (this.isSignedWithPlatformKey()) {
            return true;
        }
        if (this.isSystemApp() || this.isUpdatedSystemApp()) {
            return this.usesNonSdkApi() || this.isPackageWhitelistedForHiddenApis();
        }
        return false;
    }

    public int getHiddenApiEnforcementPolicy() {
        if (this.isAllowedToUseHiddenApis()) {
            return 0;
        }
        if (this.mHiddenApiPolicy != -1) {
            return this.mHiddenApiPolicy;
        }
        return 2;
    }

    public void setHiddenApiEnforcementPolicy(int policy) {
        if (!ApplicationInfo.isValidHiddenApiEnforcementPolicy(policy)) {
            throw new IllegalArgumentException("Invalid API enforcement policy: " + policy);
        }
        this.mHiddenApiPolicy = policy;
    }

    public void maybeUpdateHiddenApiEnforcementPolicy(int policy) {
        if (this.isPackageWhitelistedForHiddenApis()) {
            return;
        }
        this.setHiddenApiEnforcementPolicy(policy);
    }

    public void setVersionCode(long newVersionCode) {
        this.longVersionCode = newVersionCode;
        this.versionCode = (int)newVersionCode;
    }

    @Override
    @RavenwoodThrow(blockedBy={Resources.class})
    public Drawable loadDefaultIcon(PackageManager pm) {
        if ((this.flags & 0x40000) != 0 && this.isPackageUnavailable(pm)) {
            return Resources.getSystem().getDrawable(17304101);
        }
        return pm.getDefaultActivityIcon();
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    @RavenwoodThrow(blockedBy={PackageManager.class})
    private boolean isPackageUnavailable(PackageManager pm) {
        try {
            return pm.getPackageInfo(this.packageName, 0) == null;
        }
        catch (PackageManager.NameNotFoundException ex) {
            return true;
        }
    }

    public boolean isDefaultToDeviceProtectedStorage() {
        return (this.privateFlags & 0x20) != 0;
    }

    public boolean isDirectBootAware() {
        return (this.privateFlags & 0x40) != 0;
    }

    @SystemApi
    public boolean isEncryptionAware() {
        return this.isDirectBootAware() || this.isPartiallyDirectBootAware();
    }

    public boolean isExternal() {
        return (this.flags & 0x40000) != 0;
    }

    @SystemApi
    public boolean isInstantApp() {
        return (this.privateFlags & 0x80) != 0;
    }

    public boolean isInternal() {
        return (this.flags & 0x40000) == 0;
    }

    @SystemApi
    public boolean isOem() {
        return (this.privateFlags & 0x20000) != 0;
    }

    public boolean isOdm() {
        return (this.privateFlags & 0x40000000) != 0;
    }

    public boolean isPartiallyDirectBootAware() {
        return (this.privateFlags & 0x100) != 0;
    }

    public boolean isSignedWithPlatformKey() {
        return (this.privateFlags & 0x100000) != 0;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.INSTALL_PACKAGES")
    public boolean isPrivilegedApp() {
        return (this.privateFlags & 8) != 0;
    }

    public boolean isRequiredForSystemUser() {
        return (this.privateFlags & 0x200) != 0;
    }

    public boolean isStaticSharedLibrary() {
        return (this.privateFlags & 0x4000) != 0;
    }

    public boolean isSystemApp() {
        return (this.flags & 1) != 0;
    }

    public boolean isUpdatedSystemApp() {
        return (this.flags & 0x80) != 0;
    }

    @SystemApi
    public boolean isVendor() {
        return (this.privateFlags & 0x40000) != 0;
    }

    @SystemApi
    public boolean isProduct() {
        return (this.privateFlags & 0x80000) != 0;
    }

    public boolean isSystemExt() {
        return (this.privateFlags & 0x200000) != 0;
    }

    public boolean isEmbeddedDexUsed() {
        return (this.privateFlags & 0x2000000) != 0;
    }

    public boolean isVirtualPreload() {
        return (this.privateFlags & 0x10000) != 0;
    }

    public boolean isProfileableByShell() {
        return (this.privateFlags & 0x800000) != 0;
    }

    public boolean isProfileable() {
        return (this.privateFlagsExt & 1) != 0;
    }

    public boolean areAttributionsUserVisible() {
        return (this.privateFlagsExt & 4) != 0;
    }

    public boolean requestsIsolatedSplitLoading() {
        return (this.privateFlags & 0x8000) != 0;
    }

    public boolean isResourceOverlay() {
        return (this.privateFlags & 0x10000000) != 0;
    }

    public boolean isStopped() {
        return (this.flags & 0x200000) != 0;
    }

    public boolean isNotLaunched() {
        return (this.privateFlagsExt & 0x40) != 0;
    }

    public boolean isChangeEnabled(long changeId) {
        return CompatChanges.isChangeEnabled(changeId, this.packageName, UserHandle.getUserHandleForUid(this.uid));
    }

    public boolean hasRequestForegroundServiceExemption() {
        return (this.privateFlagsExt & 2) != 0;
    }

    public boolean isOnBackInvokedCallbackEnabled() {
        return (this.privateFlagsExt & 8) != 0;
    }

    @Override
    public ApplicationInfo getApplicationInfo() {
        return this;
    }

    public String[] getAllApkPaths() {
        String[][] inputLists = new String[][]{this.splitSourceDirs, this.sharedLibraryFiles, this.resourceDirs, this.overlayPaths};
        ArrayList<String> output = new ArrayList<String>(10);
        if (this.sourceDir != null) {
            output.add(this.sourceDir);
        }
        for (String[] inputList : inputLists) {
            if (inputList == null) continue;
            for (String input : inputList) {
                output.add(input);
            }
        }
        return output.toArray(new String[output.size()]);
    }

    public void setCodePath(String codePath) {
        this.scanSourceDir = codePath;
    }

    public void setBaseCodePath(String baseCodePath) {
        this.sourceDir = baseCodePath;
    }

    public void setSplitCodePaths(String[] splitCodePaths) {
        this.splitSourceDirs = splitCodePaths;
    }

    public void setResourcePath(String resourcePath) {
        this.scanPublicSourceDir = resourcePath;
    }

    public void setBaseResourcePath(String baseResourcePath) {
        this.publicSourceDir = baseResourcePath;
    }

    public void setSplitResourcePaths(String[] splitResourcePaths) {
        this.splitPublicSourceDirs = splitResourcePaths;
    }

    public void setGwpAsanMode(int value) {
        this.gwpAsanMode = value;
    }

    public void setMemtagMode(int value) {
        this.memtagMode = value;
    }

    public void setNativeHeapZeroInitialized(int value) {
        this.nativeHeapZeroInitialized = value;
    }

    public void setRequestRawExternalStorageAccess(@Nullable Boolean value) {
        this.requestRawExternalStorageAccess = value;
    }

    public void setPageSizeAppCompatFlags(int value) {
        this.mPageSizeAppCompatFlags |= value;
    }

    public void setAppClassNamesByProcess(@Nullable ArrayMap<String, String> value) {
        this.mAppClassNamesByProcess = ArrayUtils.size(value) == 0 ? null : value;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public String getCodePath() {
        return this.scanSourceDir;
    }

    public String getBaseCodePath() {
        return this.sourceDir;
    }

    public String[] getSplitCodePaths() {
        return this.splitSourceDirs;
    }

    public String getResourcePath() {
        return this.scanPublicSourceDir;
    }

    @UnsupportedAppUsage
    public String getBaseResourcePath() {
        return this.publicSourceDir;
    }

    public String[] getSplitResourcePaths() {
        return this.splitPublicSourceDirs;
    }

    public int getGwpAsanMode() {
        return this.gwpAsanMode;
    }

    public int getMemtagMode() {
        return this.memtagMode;
    }

    public int getNativeHeapZeroInitialized() {
        return this.nativeHeapZeroInitialized;
    }

    @Nullable
    public String getCustomApplicationClassNameForProcess(String processName) {
        String byProcess;
        if (this.mAppClassNamesByProcess != null && (byProcess = this.mAppClassNamesByProcess.get(processName)) != null) {
            return byProcess;
        }
        return this.className;
    }

    public void setLocaleConfigRes(int value) {
        this.localeConfigRes = value;
    }

    public int getLocaleConfigRes() {
        return this.localeConfigRes;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public List<SharedLibraryInfo> getSharedLibraryInfos() {
        if (this.sharedLibraryInfos == null) {
            return Collections.EMPTY_LIST;
        }
        return this.sharedLibraryInfos;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    @FlaggedApi(value="android.content.pm.sdk_lib_independence")
    public List<SharedLibraryInfo> getOptionalSharedLibraryInfos() {
        if (this.optionalSharedLibraryInfos == null) {
            return Collections.EMPTY_LIST;
        }
        return this.optionalSharedLibraryInfos;
    }

    @NonNull
    public Set<String> getKnownActivityEmbeddingCerts() {
        return this.mKnownActivityEmbeddingCerts == null ? Collections.emptySet() : this.mKnownActivityEmbeddingCerts;
    }

    public void setKnownActivityEmbeddingCerts(@NonNull Set<String> knownActivityEmbeddingCerts) {
        this.mKnownActivityEmbeddingCerts = new ArraySet<String>();
        for (String knownCert : knownActivityEmbeddingCerts) {
            this.mKnownActivityEmbeddingCerts.add(knownCert.toUpperCase(Locale.US));
        }
    }

    public void setEnableOnBackInvokedCallback(boolean isEnable) {
        this.privateFlagsExt = isEnable ? (this.privateFlagsExt |= 8) : (this.privateFlagsExt &= 0xFFFFFFF7);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RawExternalStorage {
    }

    public static class DisplayNameComparator
    implements Comparator<ApplicationInfo> {
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        private final Collator sCollator = Collator.getInstance();
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        private final PackageManager mPM;

        public DisplayNameComparator(PackageManager pm) {
            this.mPM = pm;
        }

        @Override
        public int compare(ApplicationInfo aa, ApplicationInfo ab) {
            CharSequence sb;
            CharSequence sa = this.mPM.getApplicationLabel(aa);
            if (sa == null) {
                sa = aa.packageName;
            }
            if ((sb = this.mPM.getApplicationLabel(ab)) == null) {
                sb = ab.packageName;
            }
            return this.sCollator.compare(sa.toString(), sb.toString());
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HiddenApiEnforcementPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NativeHeapZeroInitialized {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MemtagMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GwpAsanMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PageSizeAppCompatFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Category {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApplicationInfoPrivateFlagsExt {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApplicationInfoPrivateFlags {
    }
}

