/*
 * Decompiled with CFR 0.152.
 */
package android.content.om;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.om.OverlayIdentifier;
import android.content.res.AssetFileDescriptor;
import android.os.FabricatedOverlayInternal;
import android.os.FabricatedOverlayInternalEntry;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.TypedValue;
import com.android.internal.content.om.OverlayManagerImpl;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Objects;

public class FabricatedOverlay {
    final FabricatedOverlayInternal mOverlay;

    @NonNull
    public OverlayIdentifier getIdentifier() {
        return new OverlayIdentifier(this.mOverlay.packageName, TextUtils.nullIfEmpty(this.mOverlay.overlayName));
    }

    private static FabricatedOverlayInternal generateFabricatedOverlayInternal(@NonNull String owningPackage, @NonNull String overlayName, @NonNull String targetPackageName, @Nullable String targetOverlayable, @NonNull ArrayList<FabricatedOverlayInternalEntry> entries) {
        FabricatedOverlayInternal overlay = new FabricatedOverlayInternal();
        overlay.packageName = owningPackage;
        overlay.overlayName = overlayName;
        overlay.targetPackageName = targetPackageName;
        overlay.targetOverlayable = TextUtils.emptyIfNull(targetOverlayable);
        overlay.entries = new ArrayList<FabricatedOverlayInternalEntry>();
        overlay.entries.addAll(entries);
        return overlay;
    }

    private FabricatedOverlay(FabricatedOverlayInternal overlay) {
        this.mOverlay = overlay;
    }

    public FabricatedOverlay(@NonNull String overlayName, @NonNull String targetPackage) {
        this(FabricatedOverlay.generateFabricatedOverlayInternal("", OverlayManagerImpl.checkOverlayNameValid(overlayName), Preconditions.checkStringNotEmpty(targetPackage, "'targetPackage' must not be empty nor null"), null, new ArrayList<FabricatedOverlayInternalEntry>()));
    }

    public void setOwningPackage(@NonNull String owningPackage) {
        this.mOverlay.packageName = owningPackage;
    }

    public void setTargetOverlayable(@Nullable String targetOverlayable) {
        this.mOverlay.targetOverlayable = TextUtils.emptyIfNull(targetOverlayable);
    }

    @Nullable
    public String getTargetOverlayable() {
        return this.mOverlay.targetOverlayable;
    }

    private static String ensureValidResourceName(@NonNull String name) {
        Objects.requireNonNull(name);
        int slashIndex = name.indexOf(47);
        int colonIndex = name.indexOf(58);
        Preconditions.checkArgument(slashIndex >= 0 && colonIndex != 0 && slashIndex - colonIndex > 2, "\"%s\" is invalid resource name", name);
        return name;
    }

    @NonNull
    private static FabricatedOverlayInternalEntry generateFabricatedOverlayInternalEntry(@NonNull String resourceName, int dataType, int value, @Nullable String configuration) {
        FabricatedOverlayInternalEntry entry = new FabricatedOverlayInternalEntry();
        entry.resourceName = resourceName;
        entry.dataType = Preconditions.checkArgumentInRange(dataType, 16, 31, "dataType");
        entry.data = value;
        entry.configuration = configuration;
        return entry;
    }

    @NonNull
    private static FabricatedOverlayInternalEntry generateFabricatedOverlayInternalEntry(@NonNull String resourceName, int dataType, @NonNull String value, @Nullable String configuration) {
        FabricatedOverlayInternalEntry entry = new FabricatedOverlayInternalEntry();
        entry.resourceName = resourceName;
        entry.dataType = Preconditions.checkArgumentInRange(dataType, 3, 6, "dataType");
        entry.stringData = Objects.requireNonNull(value);
        entry.configuration = configuration;
        return entry;
    }

    @NonNull
    private static FabricatedOverlayInternalEntry generateFabricatedOverlayInternalEntry(@NonNull String resourceName, @NonNull ParcelFileDescriptor parcelFileDescriptor, @Nullable String configuration, boolean isNinePatch) {
        FabricatedOverlayInternalEntry entry = new FabricatedOverlayInternalEntry();
        entry.resourceName = resourceName;
        entry.binaryData = Objects.requireNonNull(parcelFileDescriptor);
        entry.configuration = configuration;
        entry.binaryDataOffset = 0L;
        entry.binaryDataSize = parcelFileDescriptor.getStatSize();
        entry.isNinePatch = isNinePatch;
        return entry;
    }

    @NonNull
    private static FabricatedOverlayInternalEntry generateFabricatedOverlayInternalEntry(@NonNull String resourceName, @NonNull AssetFileDescriptor assetFileDescriptor, @Nullable String configuration) {
        FabricatedOverlayInternalEntry entry = new FabricatedOverlayInternalEntry();
        entry.resourceName = resourceName;
        entry.binaryData = Objects.requireNonNull(assetFileDescriptor.getParcelFileDescriptor());
        entry.binaryDataOffset = assetFileDescriptor.getStartOffset();
        entry.binaryDataSize = assetFileDescriptor.getLength();
        entry.configuration = configuration;
        return entry;
    }

    @NonNull
    private static FabricatedOverlayInternalEntry generateFabricatedOverlayInternalEntry(@NonNull String resourceName, float dimensionValue, int dimensionUnit, @Nullable String configuration) {
        FabricatedOverlayInternalEntry entry = new FabricatedOverlayInternalEntry();
        entry.resourceName = resourceName;
        entry.dataType = 5;
        Preconditions.checkArgumentInRange(dimensionUnit, 0, 5, "dimensionUnit");
        entry.data = TypedValue.createComplexDimension(dimensionValue, dimensionUnit);
        entry.configuration = configuration;
        return entry;
    }

    @NonNull
    private static FabricatedOverlayInternalEntry generateFabricatedOverlayInternalEntry(@NonNull String resourceName, float value, @Nullable String configuration) {
        FabricatedOverlayInternalEntry entry = new FabricatedOverlayInternalEntry();
        entry.resourceName = resourceName;
        entry.dataType = 4;
        entry.data = Float.floatToIntBits(value);
        entry.configuration = configuration;
        return entry;
    }

    @NonNull
    public void setResourceValue(@NonNull String resourceName, int dataType, int value, @Nullable String configuration) {
        FabricatedOverlay.ensureValidResourceName(resourceName);
        this.mOverlay.entries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, dataType, value, configuration));
    }

    @NonNull
    public void setResourceValue(@NonNull String resourceName, int dataType, @NonNull String value, @Nullable String configuration) {
        FabricatedOverlay.ensureValidResourceName(resourceName);
        this.mOverlay.entries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, dataType, value, configuration));
    }

    @NonNull
    public void setResourceValue(@NonNull String resourceName, @NonNull ParcelFileDescriptor value, @Nullable String configuration) {
        FabricatedOverlay.ensureValidResourceName(resourceName);
        this.mOverlay.entries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, value, configuration, false));
    }

    @NonNull
    @FlaggedApi(value="android.content.res.nine_patch_frro")
    public void setNinePatchResourceValue(@NonNull String resourceName, @NonNull ParcelFileDescriptor value, @Nullable String configuration) {
        FabricatedOverlay.ensureValidResourceName(resourceName);
        this.mOverlay.entries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, value, configuration, true));
    }

    @NonNull
    @FlaggedApi(value="android.content.res.asset_file_descriptor_frro")
    public void setResourceValue(@NonNull String resourceName, @NonNull AssetFileDescriptor value, @Nullable String configuration) {
        FabricatedOverlay.ensureValidResourceName(resourceName);
        this.mOverlay.entries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, value, configuration));
    }

    @FlaggedApi(value="android.content.res.dimension_frro")
    public void setResourceValue(@NonNull String resourceName, float dimensionValue, int dimensionUnit, @Nullable String configuration) {
        FabricatedOverlay.ensureValidResourceName(resourceName);
        this.mOverlay.entries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, dimensionValue, dimensionUnit, configuration));
    }

    @FlaggedApi(value="android.content.res.dimension_frro")
    public void setResourceValue(@NonNull String resourceName, float value, @Nullable String configuration) {
        FabricatedOverlay.ensureValidResourceName(resourceName);
        this.mOverlay.entries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, value, configuration));
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StringTypeOverlayResource {
    }

    public static class Builder {
        private final String mOwningPackage;
        private final String mName;
        private final String mTargetPackage;
        private String mTargetOverlayable = "";
        private final ArrayList<FabricatedOverlayInternalEntry> mEntries = new ArrayList();

        public Builder(@NonNull String owningPackage, @NonNull String name, @NonNull String targetPackage) {
            Preconditions.checkStringNotEmpty(owningPackage, "'owningPackage' must not be empty nor null");
            Preconditions.checkStringNotEmpty(name, "'name'' must not be empty nor null");
            Preconditions.checkStringNotEmpty(targetPackage, "'targetPackage' must not be empty nor null");
            this.mOwningPackage = owningPackage;
            this.mName = name;
            this.mTargetPackage = targetPackage;
        }

        @NonNull
        public Builder setTargetOverlayable(@Nullable String targetOverlayable) {
            this.mTargetOverlayable = TextUtils.emptyIfNull(targetOverlayable);
            return this;
        }

        @Deprecated(since="Please use FabricatedOverlay#setResourceValue instead")
        @NonNull
        public Builder setResourceValue(@NonNull String resourceName, int dataType, int value) {
            return this.setResourceValue(resourceName, dataType, value, null);
        }

        @Deprecated(since="Please use FabricatedOverlay#setResourceValue instead")
        @NonNull
        public Builder setResourceValue(@NonNull String resourceName, int dataType, int value, @Nullable String configuration) {
            FabricatedOverlay.ensureValidResourceName(resourceName);
            this.mEntries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, dataType, value, configuration));
            return this;
        }

        @Deprecated(since="Please use FabricatedOverlay#setResourceValue instead")
        @NonNull
        public Builder setResourceValue(@NonNull String resourceName, int dataType, @NonNull String value) {
            return this.setResourceValue(resourceName, dataType, value, null);
        }

        @Deprecated(since="Please use FabricatedOverlay#setResourceValue instead")
        @NonNull
        public Builder setResourceValue(@NonNull String resourceName, int dataType, @NonNull String value, @Nullable String configuration) {
            FabricatedOverlay.ensureValidResourceName(resourceName);
            this.mEntries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, dataType, value, configuration));
            return this;
        }

        @Deprecated(since="Please use FabricatedOverlay#setResourceValue instead")
        @NonNull
        public Builder setResourceValue(@NonNull String resourceName, @NonNull ParcelFileDescriptor value, @Nullable String configuration) {
            FabricatedOverlay.ensureValidResourceName(resourceName);
            this.mEntries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, value, configuration, false));
            return this;
        }

        @Deprecated(since="Please use FabricatedOverlay#setResourceValue instead")
        @NonNull
        public Builder setResourceValue(@NonNull String resourceName, @NonNull AssetFileDescriptor value, @Nullable String configuration) {
            FabricatedOverlay.ensureValidResourceName(resourceName);
            this.mEntries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, value, configuration));
            return this;
        }

        @NonNull
        public FabricatedOverlay build() {
            return new FabricatedOverlay(FabricatedOverlay.generateFabricatedOverlayInternal(this.mOwningPackage, this.mName, this.mTargetPackage, this.mTargetOverlayable, this.mEntries));
        }
    }
}

