/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.BroadcastOptions;
import android.app.IApplicationThread;
import android.app.IServiceConnection;
import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.AutofillOptions;
import android.content.BroadcastReceiver;
import android.content.ComponentCallbacks;
import android.content.ComponentName;
import android.content.ContentCaptureOptions;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextParams;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.UserHandle;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodThrow;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.autofill.AutofillManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;

@RavenwoodKeepWholeClass
public class ContextWrapper
extends Context {
    @UnsupportedAppUsage
    Context mBase;
    @GuardedBy(value={"mLock"})
    @VisibleForTesting
    public List<ComponentCallbacks> mCallbacksRegisteredToSuper;
    private final Object mLock = new Object();

    public ContextWrapper(Context base) {
        this.mBase = base;
    }

    protected void attachBaseContext(Context base) {
        if (this.mBase != null) {
            throw new IllegalStateException("Base context already set");
        }
        this.mBase = base;
    }

    public Context getBaseContext() {
        return this.mBase;
    }

    @Override
    public AssetManager getAssets() {
        return this.mBase.getAssets();
    }

    @Override
    public Resources getResources() {
        return this.mBase.getResources();
    }

    @Override
    public PackageManager getPackageManager() {
        return this.mBase.getPackageManager();
    }

    @Override
    public ContentResolver getContentResolver() {
        return this.mBase.getContentResolver();
    }

    @Override
    public Looper getMainLooper() {
        return this.mBase.getMainLooper();
    }

    @Override
    public Executor getMainExecutor() {
        return this.mBase.getMainExecutor();
    }

    @Override
    public Context getApplicationContext() {
        return this.mBase.getApplicationContext();
    }

    @Override
    public void setTheme(int resid) {
        this.mBase.setTheme(resid);
    }

    @Override
    @UnsupportedAppUsage
    public int getThemeResId() {
        return this.mBase.getThemeResId();
    }

    @Override
    public Resources.Theme getTheme() {
        return this.mBase.getTheme();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.mBase.getClassLoader();
    }

    @Override
    public String getPackageName() {
        return this.mBase.getPackageName();
    }

    @Override
    @UnsupportedAppUsage
    public String getBasePackageName() {
        return this.mBase.getBasePackageName();
    }

    @Override
    public String getOpPackageName() {
        return this.mBase.getOpPackageName();
    }

    @Override
    @Nullable
    public String getAttributionTag() {
        return this.mBase.getAttributionTag();
    }

    @Override
    @Nullable
    public ContextParams getParams() {
        return this.mBase.getParams();
    }

    @Override
    public ApplicationInfo getApplicationInfo() {
        return this.mBase.getApplicationInfo();
    }

    @Override
    public String getPackageResourcePath() {
        return this.mBase.getPackageResourcePath();
    }

    @Override
    public String getPackageCodePath() {
        return this.mBase.getPackageCodePath();
    }

    @Override
    public SharedPreferences getSharedPreferences(String name, int mode) {
        return this.mBase.getSharedPreferences(name, mode);
    }

    @Override
    public SharedPreferences getSharedPreferences(File file, int mode) {
        return this.mBase.getSharedPreferences(file, mode);
    }

    @Override
    public void reloadSharedPreferences() {
        this.mBase.reloadSharedPreferences();
    }

    @Override
    public boolean moveSharedPreferencesFrom(Context sourceContext, String name) {
        return this.mBase.moveSharedPreferencesFrom(sourceContext, name);
    }

    @Override
    public boolean deleteSharedPreferences(String name) {
        return this.mBase.deleteSharedPreferences(name);
    }

    @Override
    public FileInputStream openFileInput(String name) throws FileNotFoundException {
        return this.mBase.openFileInput(name);
    }

    @Override
    public FileOutputStream openFileOutput(String name, int mode) throws FileNotFoundException {
        return this.mBase.openFileOutput(name, mode);
    }

    @Override
    public boolean deleteFile(String name) {
        return this.mBase.deleteFile(name);
    }

    @Override
    public File getFileStreamPath(String name) {
        return this.mBase.getFileStreamPath(name);
    }

    @Override
    public File getSharedPreferencesPath(String name) {
        return this.mBase.getSharedPreferencesPath(name);
    }

    @Override
    public String[] fileList() {
        return this.mBase.fileList();
    }

    @Override
    public File getDataDir() {
        return this.mBase.getDataDir();
    }

    @Override
    public File getFilesDir() {
        return this.mBase.getFilesDir();
    }

    @Override
    @NonNull
    public File getCrateDir(@NonNull String cratedId) {
        return this.mBase.getCrateDir(cratedId);
    }

    @Override
    public File getNoBackupFilesDir() {
        return this.mBase.getNoBackupFilesDir();
    }

    @Override
    @Nullable
    public File getExternalFilesDir(@Nullable String type) {
        return this.mBase.getExternalFilesDir(type);
    }

    @Override
    public File[] getExternalFilesDirs(String type) {
        return this.mBase.getExternalFilesDirs(type);
    }

    @Override
    public File getObbDir() {
        return this.mBase.getObbDir();
    }

    @Override
    public File[] getObbDirs() {
        return this.mBase.getObbDirs();
    }

    @Override
    public File getCacheDir() {
        return this.mBase.getCacheDir();
    }

    @Override
    public File getCodeCacheDir() {
        return this.mBase.getCodeCacheDir();
    }

    @Override
    @Nullable
    public File getExternalCacheDir() {
        return this.mBase.getExternalCacheDir();
    }

    @Override
    public File[] getExternalCacheDirs() {
        return this.mBase.getExternalCacheDirs();
    }

    @Override
    public File[] getExternalMediaDirs() {
        return this.mBase.getExternalMediaDirs();
    }

    @Override
    public File getDir(String name, int mode) {
        return this.mBase.getDir(name, mode);
    }

    @Override
    @Nullable
    public File getPreloadsFileCache() {
        return this.mBase.getPreloadsFileCache();
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
        return this.mBase.openOrCreateDatabase(name, mode, factory);
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, @Nullable DatabaseErrorHandler errorHandler) {
        return this.mBase.openOrCreateDatabase(name, mode, factory, errorHandler);
    }

    @Override
    public boolean moveDatabaseFrom(Context sourceContext, String name) {
        return this.mBase.moveDatabaseFrom(sourceContext, name);
    }

    @Override
    public boolean deleteDatabase(String name) {
        return this.mBase.deleteDatabase(name);
    }

    @Override
    public File getDatabasePath(String name) {
        return this.mBase.getDatabasePath(name);
    }

    @Override
    public String[] databaseList() {
        return this.mBase.databaseList();
    }

    @Override
    @Deprecated
    public Drawable getWallpaper() {
        return this.mBase.getWallpaper();
    }

    @Override
    @Deprecated
    public Drawable peekWallpaper() {
        return this.mBase.peekWallpaper();
    }

    @Override
    @Deprecated
    public int getWallpaperDesiredMinimumWidth() {
        return this.mBase.getWallpaperDesiredMinimumWidth();
    }

    @Override
    @Deprecated
    public int getWallpaperDesiredMinimumHeight() {
        return this.mBase.getWallpaperDesiredMinimumHeight();
    }

    @Override
    @Deprecated
    public void setWallpaper(Bitmap bitmap) throws IOException {
        this.mBase.setWallpaper(bitmap);
    }

    @Override
    @Deprecated
    public void setWallpaper(InputStream data) throws IOException {
        this.mBase.setWallpaper(data);
    }

    @Override
    @Deprecated
    public void clearWallpaper() throws IOException {
        this.mBase.clearWallpaper();
    }

    @Override
    public void startActivity(Intent intent) {
        this.mBase.startActivity(intent);
    }

    @Override
    public void startActivityAsUser(Intent intent, UserHandle user) {
        this.mBase.startActivityAsUser(intent, user);
    }

    @Override
    public void startActivityForResult(String who, Intent intent, int requestCode, @Nullable Bundle options) {
        this.mBase.startActivityForResult(who, intent, requestCode, options);
    }

    @Override
    public boolean canStartActivityForResult() {
        return this.mBase.canStartActivityForResult();
    }

    @Override
    public void startActivity(Intent intent, @Nullable Bundle options) {
        this.mBase.startActivity(intent, options);
    }

    @Override
    public void startActivityAsUser(Intent intent, @Nullable Bundle options, UserHandle user) {
        this.mBase.startActivityAsUser(intent, options, user);
    }

    @Override
    public void startActivities(Intent[] intents) {
        this.mBase.startActivities(intents);
    }

    @Override
    public void startActivities(Intent[] intents, @Nullable Bundle options) {
        this.mBase.startActivities(intents, options);
    }

    @Override
    public int startActivitiesAsUser(Intent[] intents, @Nullable Bundle options, UserHandle userHandle) {
        return this.mBase.startActivitiesAsUser(intents, options, userHandle);
    }

    @Override
    public void startIntentSender(IntentSender intent, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags) throws IntentSender.SendIntentException {
        this.mBase.startIntentSender(intent, fillInIntent, flagsMask, flagsValues, extraFlags);
    }

    @Override
    public void startIntentSender(IntentSender intent, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, @Nullable Bundle options) throws IntentSender.SendIntentException {
        this.mBase.startIntentSender(intent, fillInIntent, flagsMask, flagsValues, extraFlags, options);
    }

    @Override
    public void sendBroadcast(Intent intent) {
        this.mBase.sendBroadcast(intent);
    }

    @Override
    public void sendBroadcast(Intent intent, @Nullable String receiverPermission) {
        this.mBase.sendBroadcast(intent, receiverPermission);
    }

    @Override
    public void sendBroadcastMultiplePermissions(@NonNull Intent intent, @NonNull String[] receiverPermissions) {
        this.mBase.sendBroadcastMultiplePermissions(intent, receiverPermissions);
    }

    @Override
    public void sendBroadcastMultiplePermissions(@NonNull Intent intent, @NonNull String[] receiverPermissions, @Nullable String[] excludedPermissions, @Nullable String[] excludedPackages, @Nullable BroadcastOptions options) {
        this.mBase.sendBroadcastMultiplePermissions(intent, receiverPermissions, excludedPermissions, excludedPackages, options);
    }

    @Override
    public void sendBroadcastMultiplePermissions(@NonNull Intent intent, @NonNull String[] receiverPermissions, @Nullable Bundle options) {
        this.mBase.sendBroadcastMultiplePermissions(intent, receiverPermissions, options);
    }

    @Override
    public void sendBroadcastAsUserMultiplePermissions(Intent intent, UserHandle user, String[] receiverPermissions) {
        this.mBase.sendBroadcastAsUserMultiplePermissions(intent, user, receiverPermissions);
    }

    @Override
    public void sendBroadcast(@NonNull Intent intent, @Nullable String receiverPermission, @Nullable Bundle options) {
        this.mBase.sendBroadcast(intent, receiverPermission, options);
    }

    @Override
    public void sendBroadcast(Intent intent, @Nullable String receiverPermission, int appOp) {
        this.mBase.sendBroadcast(intent, receiverPermission, appOp);
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, @Nullable String receiverPermission) {
        this.mBase.sendOrderedBroadcast(intent, receiverPermission);
    }

    @Override
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public void sendOrderedBroadcast(@NonNull Intent intent, @Nullable String receiverPermission, @Nullable Bundle options) {
        this.mBase.sendOrderedBroadcast(intent, receiverPermission, options);
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, @Nullable String receiverPermission, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
        this.mBase.sendOrderedBroadcast(intent, receiverPermission, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    @Override
    public void sendOrderedBroadcast(@NonNull Intent intent, @Nullable String receiverPermission, @Nullable Bundle options, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
        this.mBase.sendOrderedBroadcast(intent, receiverPermission, options, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, @Nullable String receiverPermission, int appOp, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
        this.mBase.sendOrderedBroadcast(intent, receiverPermission, appOp, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle user) {
        this.mBase.sendBroadcastAsUser(intent, user);
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission) {
        this.mBase.sendBroadcastAsUser(intent, user, receiverPermission);
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle user, @Nullable String receiverPermission, @Nullable Bundle options) {
        this.mBase.sendBroadcastAsUser(intent, user, receiverPermission, options);
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle user, @Nullable String receiverPermission, int appOp) {
        this.mBase.sendBroadcastAsUser(intent, user, receiverPermission, appOp);
    }

    @Override
    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle user, @Nullable String receiverPermission, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
        this.mBase.sendOrderedBroadcastAsUser(intent, user, receiverPermission, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    @Override
    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle user, @Nullable String receiverPermission, int appOp, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
        this.mBase.sendOrderedBroadcastAsUser(intent, user, receiverPermission, appOp, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    @Override
    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle user, @Nullable String receiverPermission, int appOp, @Nullable Bundle options, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
        this.mBase.sendOrderedBroadcastAsUser(intent, user, receiverPermission, appOp, options, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    @Override
    public void sendOrderedBroadcastAsUserMultiplePermissions(Intent intent, UserHandle user, @Nullable String[] receiverPermission, int appOp, @Nullable Bundle options, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
        this.mBase.sendOrderedBroadcastAsUserMultiplePermissions(intent, user, receiverPermission, appOp, options, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    @Override
    public void sendOrderedBroadcast(@RequiresPermission @NonNull Intent intent, @Nullable String receiverPermission, @Nullable String receiverAppOp, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
        this.mBase.sendOrderedBroadcast(intent, receiverPermission, receiverAppOp, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    @Override
    public void sendOrderedBroadcastMultiplePermissions(@NonNull Intent intent, @NonNull String[] receiverPermissions, @Nullable String receiverAppOp, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras, @Nullable Bundle options) {
        this.mBase.sendOrderedBroadcastMultiplePermissions(intent, receiverPermissions, receiverAppOp, resultReceiver, scheduler, initialCode, initialData, initialExtras, options);
    }

    @Override
    public void sendOrderedBroadcast(@RequiresPermission @NonNull Intent intent, int initialCode, @Nullable String receiverPermission, @Nullable String receiverAppOp, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, @Nullable String initialData, @Nullable Bundle initialExtras, @Nullable Bundle options) {
        this.mBase.sendOrderedBroadcast(intent, initialCode, receiverPermission, receiverAppOp, resultReceiver, scheduler, initialData, initialExtras, options);
    }

    @Override
    @Deprecated
    public void sendStickyBroadcast(Intent intent) {
        this.mBase.sendStickyBroadcast(intent);
    }

    @Override
    @Deprecated
    public void sendStickyBroadcast(@NonNull Intent intent, @Nullable Bundle options) {
        this.mBase.sendStickyBroadcast(intent, options);
    }

    @Override
    @Deprecated
    public void sendStickyOrderedBroadcast(Intent intent, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
        this.mBase.sendStickyOrderedBroadcast(intent, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    @Override
    @Deprecated
    public void removeStickyBroadcast(Intent intent) {
        this.mBase.removeStickyBroadcast(intent);
    }

    @Override
    @Deprecated
    public void sendStickyBroadcastAsUser(Intent intent, UserHandle user) {
        this.mBase.sendStickyBroadcastAsUser(intent, user);
    }

    @Override
    @Deprecated
    public void sendStickyBroadcastAsUser(Intent intent, UserHandle user, @Nullable Bundle options) {
        this.mBase.sendStickyBroadcastAsUser(intent, user, options);
    }

    @Override
    @Deprecated
    public void sendStickyOrderedBroadcastAsUser(Intent intent, UserHandle user, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
        this.mBase.sendStickyOrderedBroadcastAsUser(intent, user, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    @Override
    @Deprecated
    public void removeStickyBroadcastAsUser(Intent intent, UserHandle user) {
        this.mBase.removeStickyBroadcastAsUser(intent, user);
    }

    @Override
    public Intent registerReceiver(@Nullable BroadcastReceiver receiver, IntentFilter filter) {
        return this.mBase.registerReceiver(receiver, filter);
    }

    @Override
    public Intent registerReceiver(@Nullable BroadcastReceiver receiver, IntentFilter filter, int flags) {
        return this.mBase.registerReceiver(receiver, filter, flags);
    }

    @Override
    public Intent registerReceiver(@Nullable BroadcastReceiver receiver, IntentFilter filter, @Nullable String broadcastPermission, @Nullable Handler scheduler) {
        return this.mBase.registerReceiver(receiver, filter, broadcastPermission, scheduler);
    }

    @Override
    public Intent registerReceiver(@Nullable BroadcastReceiver receiver, IntentFilter filter, @Nullable String broadcastPermission, @Nullable Handler scheduler, int flags) {
        return this.mBase.registerReceiver(receiver, filter, broadcastPermission, scheduler, flags);
    }

    @Override
    @Nullable
    public Intent registerReceiverForAllUsers(@Nullable BroadcastReceiver receiver, @NonNull IntentFilter filter, @Nullable String broadcastPermission, @Nullable Handler scheduler) {
        return this.mBase.registerReceiverForAllUsers(receiver, filter, broadcastPermission, scheduler);
    }

    @Override
    @Nullable
    public Intent registerReceiverForAllUsers(@Nullable BroadcastReceiver receiver, @NonNull IntentFilter filter, @Nullable String broadcastPermission, @Nullable Handler scheduler, int flags) {
        return this.mBase.registerReceiverForAllUsers(receiver, filter, broadcastPermission, scheduler, flags);
    }

    @Override
    @UnsupportedAppUsage
    public Intent registerReceiverAsUser(@Nullable BroadcastReceiver receiver, UserHandle user, IntentFilter filter, @Nullable String broadcastPermission, @Nullable Handler scheduler) {
        return this.mBase.registerReceiverAsUser(receiver, user, filter, broadcastPermission, scheduler);
    }

    @Override
    @UnsupportedAppUsage
    public Intent registerReceiverAsUser(@Nullable BroadcastReceiver receiver, UserHandle user, IntentFilter filter, @Nullable String broadcastPermission, @Nullable Handler scheduler, int flags) {
        return this.mBase.registerReceiverAsUser(receiver, user, filter, broadcastPermission, scheduler, flags);
    }

    @Override
    public void unregisterReceiver(BroadcastReceiver receiver) {
        this.mBase.unregisterReceiver(receiver);
    }

    @Override
    @NonNull
    public List<IntentFilter> getRegisteredIntentFilters(@NonNull BroadcastReceiver receiver) {
        return this.mBase.getRegisteredIntentFilters(receiver);
    }

    @Override
    @Nullable
    public ComponentName startService(Intent service) {
        return this.mBase.startService(service);
    }

    @Override
    @Nullable
    public ComponentName startForegroundService(Intent service) {
        return this.mBase.startForegroundService(service);
    }

    @Override
    public boolean stopService(Intent name) {
        return this.mBase.stopService(name);
    }

    @Override
    @UnsupportedAppUsage
    @Nullable
    public ComponentName startServiceAsUser(Intent service, UserHandle user) {
        return this.mBase.startServiceAsUser(service, user);
    }

    @Override
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @Nullable
    public ComponentName startForegroundServiceAsUser(Intent service, UserHandle user) {
        return this.mBase.startForegroundServiceAsUser(service, user);
    }

    @Override
    public boolean stopServiceAsUser(Intent name, UserHandle user) {
        return this.mBase.stopServiceAsUser(name, user);
    }

    @Override
    public boolean bindService(Intent service, ServiceConnection conn, int flags) {
        return this.mBase.bindService(service, conn, flags);
    }

    @Override
    public boolean bindService(@NonNull Intent service, @NonNull ServiceConnection conn, @NonNull Context.BindServiceFlags flags) {
        return this.mBase.bindService(service, conn, flags);
    }

    @Override
    public boolean bindService(Intent service, int flags, Executor executor, ServiceConnection conn) {
        return this.mBase.bindService(service, flags, executor, conn);
    }

    @Override
    public boolean bindService(@NonNull Intent service, @NonNull Context.BindServiceFlags flags, @NonNull Executor executor, @NonNull ServiceConnection conn) {
        return this.mBase.bindService(service, flags, executor, conn);
    }

    @Override
    public boolean bindIsolatedService(Intent service, int flags, String instanceName, Executor executor, ServiceConnection conn) {
        return this.mBase.bindIsolatedService(service, flags, instanceName, executor, conn);
    }

    @Override
    public boolean bindServiceAsUser(Intent service, ServiceConnection conn, int flags, UserHandle user) {
        return this.mBase.bindServiceAsUser(service, conn, flags, user);
    }

    @Override
    public boolean bindServiceAsUser(Intent service, ServiceConnection conn, @NonNull Context.BindServiceFlags flags, UserHandle user) {
        return this.mBase.bindServiceAsUser(service, conn, flags, user);
    }

    @Override
    public boolean bindServiceAsUser(Intent service, ServiceConnection conn, int flags, Handler handler, UserHandle user) {
        return this.mBase.bindServiceAsUser(service, conn, flags, handler, user);
    }

    @Override
    public boolean bindServiceAsUser(Intent service, ServiceConnection conn, @NonNull Context.BindServiceFlags flags, Handler handler, UserHandle user) {
        return this.mBase.bindServiceAsUser(service, conn, flags, handler, user);
    }

    @Override
    public void updateServiceGroup(ServiceConnection conn, int group, int importance) {
        this.mBase.updateServiceGroup(conn, group, importance);
    }

    @Override
    public void unbindService(ServiceConnection conn) {
        this.mBase.unbindService(conn);
    }

    @Override
    public boolean startInstrumentation(ComponentName className, @Nullable String profileFile, @Nullable Bundle arguments) {
        return this.mBase.startInstrumentation(className, profileFile, arguments);
    }

    @Override
    public Object getSystemService(String name) {
        return this.mBase.getSystemService(name);
    }

    @Override
    public String getSystemServiceName(Class<?> serviceClass) {
        return this.mBase.getSystemServiceName(serviceClass);
    }

    @Override
    public int checkPermission(String permission2, int pid, int uid) {
        return this.mBase.checkPermission(permission2, pid, uid);
    }

    @Override
    public int checkPermission(String permission2, int pid, int uid, IBinder callerToken) {
        return this.mBase.checkPermission(permission2, pid, uid, callerToken);
    }

    @Override
    public int checkCallingPermission(String permission2) {
        return this.mBase.checkCallingPermission(permission2);
    }

    @Override
    public int checkCallingOrSelfPermission(String permission2) {
        return this.mBase.checkCallingOrSelfPermission(permission2);
    }

    @Override
    public int checkSelfPermission(String permission2) {
        return this.mBase.checkSelfPermission(permission2);
    }

    @Override
    public void enforcePermission(String permission2, int pid, int uid, @Nullable String message) {
        this.mBase.enforcePermission(permission2, pid, uid, message);
    }

    @Override
    public void enforceCallingPermission(String permission2, @Nullable String message) {
        this.mBase.enforceCallingPermission(permission2, message);
    }

    @Override
    public void enforceCallingOrSelfPermission(String permission2, @Nullable String message) {
        this.mBase.enforceCallingOrSelfPermission(permission2, message);
    }

    @Override
    public int getPermissionRequestState(String permission2) {
        return this.mBase.getPermissionRequestState(permission2);
    }

    @Override
    public void grantUriPermission(String toPackage, Uri uri, int modeFlags) {
        this.mBase.grantUriPermission(toPackage, uri, modeFlags);
    }

    @Override
    public void revokeUriPermission(Uri uri, int modeFlags) {
        this.mBase.revokeUriPermission(uri, modeFlags);
    }

    @Override
    public void revokeUriPermission(String targetPackage, Uri uri, int modeFlags) {
        this.mBase.revokeUriPermission(targetPackage, uri, modeFlags);
    }

    @Override
    public int checkUriPermission(Uri uri, int pid, int uid, int modeFlags) {
        return this.mBase.checkUriPermission(uri, pid, uid, modeFlags);
    }

    @Override
    @FlaggedApi(value="android.security.content_uri_permission_apis")
    public int checkContentUriPermissionFull(@NonNull Uri uri, int pid, int uid, int modeFlags) {
        return this.mBase.checkContentUriPermissionFull(uri, pid, uid, modeFlags);
    }

    @Override
    @NonNull
    public int[] checkUriPermissions(@NonNull List<Uri> uris, int pid, int uid, int modeFlags) {
        return this.mBase.checkUriPermissions(uris, pid, uid, modeFlags);
    }

    @Override
    public int checkUriPermission(Uri uri, int pid, int uid, int modeFlags, IBinder callerToken) {
        return this.mBase.checkUriPermission(uri, pid, uid, modeFlags, callerToken);
    }

    @Override
    public int checkCallingUriPermission(Uri uri, int modeFlags) {
        return this.mBase.checkCallingUriPermission(uri, modeFlags);
    }

    @Override
    @NonNull
    public int[] checkCallingUriPermissions(@NonNull List<Uri> uris, int modeFlags) {
        return this.mBase.checkCallingUriPermissions(uris, modeFlags);
    }

    @Override
    public int checkCallingOrSelfUriPermission(Uri uri, int modeFlags) {
        return this.mBase.checkCallingOrSelfUriPermission(uri, modeFlags);
    }

    @Override
    @NonNull
    public int[] checkCallingOrSelfUriPermissions(@NonNull List<Uri> uris, int modeFlags) {
        return this.mBase.checkCallingOrSelfUriPermissions(uris, modeFlags);
    }

    @Override
    public int checkUriPermission(@Nullable Uri uri, @Nullable String readPermission, @Nullable String writePermission, int pid, int uid, int modeFlags) {
        return this.mBase.checkUriPermission(uri, readPermission, writePermission, pid, uid, modeFlags);
    }

    @Override
    public void enforceUriPermission(Uri uri, int pid, int uid, int modeFlags, String message) {
        this.mBase.enforceUriPermission(uri, pid, uid, modeFlags, message);
    }

    @Override
    public void enforceCallingUriPermission(Uri uri, int modeFlags, String message) {
        this.mBase.enforceCallingUriPermission(uri, modeFlags, message);
    }

    @Override
    public void enforceCallingOrSelfUriPermission(Uri uri, int modeFlags, String message) {
        this.mBase.enforceCallingOrSelfUriPermission(uri, modeFlags, message);
    }

    @Override
    public void enforceUriPermission(@Nullable Uri uri, @Nullable String readPermission, @Nullable String writePermission, int pid, int uid, int modeFlags, @Nullable String message) {
        this.mBase.enforceUriPermission(uri, readPermission, writePermission, pid, uid, modeFlags, message);
    }

    @Override
    public void revokeSelfPermissionsOnKill(@NonNull Collection<String> permissions) {
        this.mBase.revokeSelfPermissionsOnKill(permissions);
    }

    @Override
    public Context createPackageContext(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return this.mBase.createPackageContext(packageName, flags);
    }

    @Override
    public Context createPackageContextAsUser(String packageName, int flags, UserHandle user) throws PackageManager.NameNotFoundException {
        return this.mBase.createPackageContextAsUser(packageName, flags, user);
    }

    @Override
    public Context createContextAsUser(UserHandle user, int flags) {
        return this.mBase.createContextAsUser(user, flags);
    }

    @Override
    @UnsupportedAppUsage(trackingBug=175981568L)
    public Context createApplicationContext(ApplicationInfo application, int flags) throws PackageManager.NameNotFoundException {
        return this.mBase.createApplicationContext(application, flags);
    }

    @Override
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public Context createContextForSdkInSandbox(@NonNull ApplicationInfo sdkInfo, int flags) throws PackageManager.NameNotFoundException {
        return this.mBase.createContextForSdkInSandbox(sdkInfo, flags);
    }

    @Override
    public Context createContextForSplit(String splitName) throws PackageManager.NameNotFoundException {
        return this.mBase.createContextForSplit(splitName);
    }

    @Override
    public int getUserId() {
        return this.mBase.getUserId();
    }

    @Override
    public UserHandle getUser() {
        return this.mBase.getUser();
    }

    @Override
    public Context createConfigurationContext(Configuration overrideConfiguration) {
        return this.mBase.createConfigurationContext(overrideConfiguration);
    }

    @Override
    public Context createDisplayContext(Display display) {
        return this.mBase.createDisplayContext(display);
    }

    @Override
    @NonNull
    public Context createDeviceContext(int deviceId) {
        return this.mBase.createDeviceContext(deviceId);
    }

    @Override
    @NonNull
    public Context createWindowContext(int type, @Nullable Bundle options) {
        return this.mBase.createWindowContext(type, options);
    }

    @Override
    @NonNull
    public Context createWindowContext(@NonNull Display display, int type, @Nullable Bundle options) {
        return this.mBase.createWindowContext(display, type, options);
    }

    @Override
    @NonNull
    public Context createContext(@NonNull ContextParams contextParams) {
        return this.mBase.createContext(contextParams);
    }

    @Override
    @NonNull
    public Context createAttributionContext(@Nullable String attributionTag) {
        return this.mBase.createAttributionContext(attributionTag);
    }

    @Override
    @NonNull
    public AttributionSource getAttributionSource() {
        return this.mBase.getAttributionSource();
    }

    @Override
    public boolean isRestricted() {
        return this.mBase.isRestricted();
    }

    @Override
    public DisplayAdjustments getDisplayAdjustments(int displayId) {
        return this.mBase.getDisplayAdjustments(displayId);
    }

    @Override
    @Nullable
    public Display getDisplay() {
        return this.mBase.getDisplay();
    }

    @Override
    @Nullable
    public Display getDisplayNoVerify() {
        return this.mBase.getDisplayNoVerify();
    }

    @Override
    public int getDisplayId() {
        return this.mBase.getDisplayId();
    }

    @Override
    public int getAssociatedDisplayId() {
        return this.mBase.getAssociatedDisplayId();
    }

    @Override
    public void updateDisplay(int displayId) {
        this.mBase.updateDisplay(displayId);
    }

    @Override
    public void updateDeviceId(int deviceId) {
        this.mBase.updateDeviceId(deviceId);
    }

    @Override
    public int getDeviceId() {
        return this.mBase.getDeviceId();
    }

    @Override
    public void registerDeviceIdChangeListener(@NonNull Executor executor, @NonNull IntConsumer listener) {
        this.mBase.registerDeviceIdChangeListener(executor, listener);
    }

    @Override
    public void unregisterDeviceIdChangeListener(@NonNull IntConsumer listener) {
        this.mBase.unregisterDeviceIdChangeListener(listener);
    }

    @Override
    public Context createDeviceProtectedStorageContext() {
        return this.mBase.createDeviceProtectedStorageContext();
    }

    @Override
    @SystemApi
    public Context createCredentialProtectedStorageContext() {
        return this.mBase.createCredentialProtectedStorageContext();
    }

    @Override
    @NonNull
    public Context createTokenContext(@NonNull IBinder token, @NonNull Display display) {
        return this.mBase.createTokenContext(token, display);
    }

    @Override
    public boolean isDeviceProtectedStorage() {
        return this.mBase.isDeviceProtectedStorage();
    }

    @Override
    @SystemApi
    public boolean isCredentialProtectedStorage() {
        return this.mBase.isCredentialProtectedStorage();
    }

    @Override
    public boolean canLoadUnsafeResources() {
        return this.mBase.canLoadUnsafeResources();
    }

    @Override
    @Nullable
    public IBinder getActivityToken() {
        return this.mBase.getActivityToken();
    }

    @Override
    @Nullable
    public IBinder getWindowContextToken() {
        return this.mBase != null ? this.mBase.getWindowContextToken() : null;
    }

    @Override
    @Nullable
    public IServiceConnection getServiceDispatcher(ServiceConnection conn, Handler handler, long flags) {
        return this.mBase.getServiceDispatcher(conn, handler, flags);
    }

    @Override
    public IApplicationThread getIApplicationThread() {
        return this.mBase.getIApplicationThread();
    }

    @Override
    public IBinder getProcessToken() {
        return this.mBase.getProcessToken();
    }

    @Override
    public Handler getMainThreadHandler() {
        return this.mBase.getMainThreadHandler();
    }

    @Override
    public int getNextAutofillId() {
        return this.mBase.getNextAutofillId();
    }

    @Override
    public AutofillManager.AutofillClient getAutofillClient() {
        return this.mBase.getAutofillClient();
    }

    @Override
    public void setAutofillClient(AutofillManager.AutofillClient client) {
        this.mBase.setAutofillClient(client);
    }

    @Override
    public AutofillOptions getAutofillOptions() {
        return this.mBase == null ? null : this.mBase.getAutofillOptions();
    }

    @Override
    public void setAutofillOptions(AutofillOptions options) {
        if (this.mBase != null) {
            this.mBase.setAutofillOptions(options);
        }
    }

    @Override
    @Nullable
    public ContentCaptureOptions getContentCaptureOptions() {
        return this.mBase == null ? null : this.mBase.getContentCaptureOptions();
    }

    @Override
    public void setContentCaptureOptions(@Nullable ContentCaptureOptions options) {
        if (this.mBase != null) {
            this.mBase.setContentCaptureOptions(options);
        }
    }

    @Override
    public boolean isUiContext() {
        if (this.mBase == null) {
            return false;
        }
        return this.mBase.isUiContext();
    }

    @Override
    public boolean isConfigurationContext() {
        if (this.mBase == null) {
            return false;
        }
        return this.mBase.isConfigurationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RavenwoodThrow
    public void registerComponentCallbacks(ComponentCallbacks callback) {
        if (this.mBase != null) {
            this.mBase.registerComponentCallbacks(callback);
        } else if (!CompatChanges.isChangeEnabled(193247900L)) {
            super.registerComponentCallbacks(callback);
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCallbacksRegisteredToSuper == null) {
                    this.mCallbacksRegisteredToSuper = new ArrayList<ComponentCallbacks>();
                }
                this.mCallbacksRegisteredToSuper.add(callback);
            }
        } else {
            throw new IllegalStateException("ComponentCallbacks must be registered after this ContextWrapper is attached to a base Context.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RavenwoodThrow
    public void unregisterComponentCallbacks(ComponentCallbacks callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallbacksRegisteredToSuper != null && this.mCallbacksRegisteredToSuper.contains(callback)) {
                super.unregisterComponentCallbacks(callback);
                this.mCallbacksRegisteredToSuper.remove(callback);
            } else if (this.mBase != null) {
                this.mBase.unregisterComponentCallbacks(callback);
            } else if (CompatChanges.isChangeEnabled(193247900L)) {
                throw new IllegalStateException("ComponentCallbacks must be unregistered after this ContextWrapper is attached to a base Context.");
            }
        }
    }

    @Override
    @RequiresPermission(value="android.permission.BROADCAST_CLOSE_SYSTEM_DIALOGS")
    public void closeSystemDialogs() {
        this.mBase.closeSystemDialogs();
    }
}

