/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.companion.virtual.ViewConfigurationParams;
import android.companion.virtual.sensor.IVirtualSensorCallback;
import android.companion.virtual.sensor.VirtualSensor;
import android.companion.virtual.sensor.VirtualSensorCallback;
import android.companion.virtual.sensor.VirtualSensorConfig;
import android.companion.virtual.sensor.VirtualSensorDirectChannelCallback;
import android.content.ComponentName;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SharedMemory;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.hidden_from_bootclasspath.android.companion.virtualdevice.flags.Flags;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@SystemApi
public class VirtualDeviceParams
implements Parcelable {
    public static final int LOCK_STATE_DEFAULT = 0;
    public static final int LOCK_STATE_ALWAYS_UNLOCKED = 1;
    @Deprecated
    public static final int ACTIVITY_POLICY_DEFAULT_ALLOWED = 0;
    @Deprecated
    public static final int ACTIVITY_POLICY_DEFAULT_BLOCKED = 1;
    @Deprecated
    public static final int NAVIGATION_POLICY_DEFAULT_ALLOWED = 0;
    @Deprecated
    public static final int NAVIGATION_POLICY_DEFAULT_BLOCKED = 1;
    public static final int DEVICE_POLICY_DEFAULT = 0;
    public static final int DEVICE_POLICY_CUSTOM = 1;
    public static final int POLICY_TYPE_SENSORS = 0;
    public static final int POLICY_TYPE_AUDIO = 1;
    public static final int POLICY_TYPE_RECENTS = 2;
    public static final int POLICY_TYPE_ACTIVITY = 3;
    public static final int POLICY_TYPE_CLIPBOARD = 4;
    public static final int POLICY_TYPE_CAMERA = 5;
    @FlaggedApi(value="android.companion.virtualdevice.flags.activity_control_api")
    public static final int POLICY_TYPE_BLOCKED_ACTIVITY = 6;
    @FlaggedApi(value="android.companion.virtualdevice.flags.default_device_camera_access_policy")
    public static final int POLICY_TYPE_DEFAULT_DEVICE_CAMERA_ACCESS = 7;
    private final int mLockState;
    @NonNull
    private final ArraySet<UserHandle> mUsersWithMatchingAccounts;
    private final int mDefaultNavigationPolicy;
    @NonNull
    private final ArraySet<ComponentName> mCrossTaskNavigationExemptions;
    private final int mDefaultActivityPolicy;
    @NonNull
    private final ArraySet<ComponentName> mActivityPolicyExemptions;
    @Nullable
    private final String mName;
    @NonNull
    private final SparseIntArray mDevicePolicies;
    @Nullable
    private final ComponentName mHomeComponent;
    @Nullable
    private final ComponentName mInputMethodComponent;
    @NonNull
    private final List<VirtualSensorConfig> mVirtualSensorConfigs;
    @Nullable
    private final IVirtualSensorCallback mVirtualSensorCallback;
    private final int mAudioPlaybackSessionId;
    private final int mAudioRecordingSessionId;
    private final long mDimDuration;
    private final long mScreenOffTimeout;
    @Nullable
    private final ViewConfigurationParams mViewConfigurationParams;
    @NonNull
    public static final Parcelable.Creator<VirtualDeviceParams> CREATOR = new Parcelable.Creator<VirtualDeviceParams>(){

        @Override
        public VirtualDeviceParams createFromParcel(Parcel in) {
            return new VirtualDeviceParams(in);
        }

        public VirtualDeviceParams[] newArray(int size) {
            return new VirtualDeviceParams[size];
        }
    };

    private VirtualDeviceParams(int lockState, @NonNull Set<UserHandle> usersWithMatchingAccounts, int defaultNavigationPolicy, @NonNull Set<ComponentName> crossTaskNavigationExemptions, int defaultActivityPolicy, @NonNull Set<ComponentName> activityPolicyExemptions, @Nullable String name, @NonNull SparseIntArray devicePolicies, @Nullable ComponentName homeComponent, @Nullable ComponentName inputMethodComponent, @NonNull List<VirtualSensorConfig> virtualSensorConfigs, @Nullable IVirtualSensorCallback virtualSensorCallback, int audioPlaybackSessionId, int audioRecordingSessionId, long dimDuration, long screenOffTimeout, @Nullable ViewConfigurationParams viewConfigurationParams) {
        this.mLockState = lockState;
        this.mUsersWithMatchingAccounts = new ArraySet(Objects.requireNonNull(usersWithMatchingAccounts));
        this.mDefaultNavigationPolicy = defaultNavigationPolicy;
        this.mCrossTaskNavigationExemptions = new ArraySet(Objects.requireNonNull(crossTaskNavigationExemptions));
        this.mDefaultActivityPolicy = defaultActivityPolicy;
        this.mActivityPolicyExemptions = new ArraySet(Objects.requireNonNull(activityPolicyExemptions));
        this.mName = name;
        this.mDevicePolicies = Objects.requireNonNull(devicePolicies);
        this.mHomeComponent = homeComponent;
        this.mInputMethodComponent = inputMethodComponent;
        this.mVirtualSensorConfigs = Objects.requireNonNull(virtualSensorConfigs);
        this.mVirtualSensorCallback = virtualSensorCallback;
        this.mAudioPlaybackSessionId = audioPlaybackSessionId;
        this.mAudioRecordingSessionId = audioRecordingSessionId;
        this.mDimDuration = dimDuration;
        this.mScreenOffTimeout = screenOffTimeout;
        this.mViewConfigurationParams = viewConfigurationParams;
    }

    private VirtualDeviceParams(Parcel parcel) {
        this.mLockState = parcel.readInt();
        this.mUsersWithMatchingAccounts = parcel.readArraySet(null);
        this.mDefaultNavigationPolicy = parcel.readInt();
        this.mCrossTaskNavigationExemptions = parcel.readArraySet(null);
        this.mDefaultActivityPolicy = parcel.readInt();
        this.mActivityPolicyExemptions = parcel.readArraySet(null);
        this.mName = parcel.readString8();
        this.mDevicePolicies = parcel.readSparseIntArray();
        this.mVirtualSensorConfigs = new ArrayList<VirtualSensorConfig>();
        parcel.readTypedList(this.mVirtualSensorConfigs, VirtualSensorConfig.CREATOR);
        this.mVirtualSensorCallback = IVirtualSensorCallback.Stub.asInterface(parcel.readStrongBinder());
        this.mAudioPlaybackSessionId = parcel.readInt();
        this.mAudioRecordingSessionId = parcel.readInt();
        this.mHomeComponent = parcel.readTypedObject(ComponentName.CREATOR);
        this.mInputMethodComponent = parcel.readTypedObject(ComponentName.CREATOR);
        this.mDimDuration = parcel.readLong();
        this.mScreenOffTimeout = parcel.readLong();
        this.mViewConfigurationParams = Flags.viewconfigurationApis() ? parcel.readTypedObject(ViewConfigurationParams.CREATOR) : null;
    }

    public int getLockState() {
        return this.mLockState;
    }

    @FlaggedApi(value="android.companion.virtualdevice.flags.device_aware_display_power")
    @NonNull
    public Duration getDimDuration() {
        return Duration.ofMillis(this.mDimDuration);
    }

    @FlaggedApi(value="android.companion.virtualdevice.flags.device_aware_display_power")
    @NonNull
    public Duration getScreenOffTimeout() {
        return Duration.ofMillis(this.mScreenOffTimeout);
    }

    @Nullable
    public ComponentName getHomeComponent() {
        return this.mHomeComponent;
    }

    @Nullable
    public ComponentName getInputMethodComponent() {
        return this.mInputMethodComponent;
    }

    @NonNull
    public Set<UserHandle> getUsersWithMatchingAccounts() {
        return Collections.unmodifiableSet(this.mUsersWithMatchingAccounts);
    }

    @Deprecated
    @NonNull
    public Set<ComponentName> getAllowedCrossTaskNavigations() {
        return this.mDefaultNavigationPolicy == 0 ? Collections.emptySet() : Collections.unmodifiableSet(this.mCrossTaskNavigationExemptions);
    }

    @Deprecated
    @NonNull
    public Set<ComponentName> getBlockedCrossTaskNavigations() {
        return this.mDefaultNavigationPolicy == 1 ? Collections.emptySet() : Collections.unmodifiableSet(this.mCrossTaskNavigationExemptions);
    }

    @Deprecated
    public int getDefaultNavigationPolicy() {
        return this.mDefaultNavigationPolicy;
    }

    @Deprecated
    @NonNull
    public Set<ComponentName> getAllowedActivities() {
        return this.mDefaultActivityPolicy == 0 ? Collections.emptySet() : Collections.unmodifiableSet(this.mActivityPolicyExemptions);
    }

    @Deprecated
    @NonNull
    public Set<ComponentName> getBlockedActivities() {
        return this.mDefaultActivityPolicy == 1 ? Collections.emptySet() : Collections.unmodifiableSet(this.mActivityPolicyExemptions);
    }

    @Deprecated
    public int getDefaultActivityPolicy() {
        return this.mDefaultActivityPolicy;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    public int getDevicePolicy(int policyType) {
        return this.mDevicePolicies.get(policyType, 0);
    }

    @NonNull
    public SparseIntArray getDevicePolicies() {
        return this.mDevicePolicies;
    }

    @NonNull
    public List<VirtualSensorConfig> getVirtualSensorConfigs() {
        return this.mVirtualSensorConfigs;
    }

    @Nullable
    public IVirtualSensorCallback getVirtualSensorCallback() {
        return this.mVirtualSensorCallback;
    }

    public int getAudioPlaybackSessionId() {
        return this.mAudioPlaybackSessionId;
    }

    public int getAudioRecordingSessionId() {
        return this.mAudioRecordingSessionId;
    }

    @Nullable
    @FlaggedApi(value="android.companion.virtualdevice.flags.viewconfiguration_apis")
    public ViewConfigurationParams getViewConfigurationParams() {
        return this.mViewConfigurationParams;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mLockState);
        dest.writeArraySet(this.mUsersWithMatchingAccounts);
        dest.writeInt(this.mDefaultNavigationPolicy);
        dest.writeArraySet(this.mCrossTaskNavigationExemptions);
        dest.writeInt(this.mDefaultActivityPolicy);
        dest.writeArraySet(this.mActivityPolicyExemptions);
        dest.writeString8(this.mName);
        dest.writeSparseIntArray(this.mDevicePolicies);
        dest.writeTypedList(this.mVirtualSensorConfigs);
        dest.writeStrongBinder(this.mVirtualSensorCallback != null ? this.mVirtualSensorCallback.asBinder() : null);
        dest.writeInt(this.mAudioPlaybackSessionId);
        dest.writeInt(this.mAudioRecordingSessionId);
        dest.writeTypedObject(this.mHomeComponent, flags);
        dest.writeTypedObject(this.mInputMethodComponent, flags);
        dest.writeLong(this.mDimDuration);
        dest.writeLong(this.mScreenOffTimeout);
        if (Flags.viewconfigurationApis()) {
            dest.writeTypedObject(this.mViewConfigurationParams, flags);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualDeviceParams)) {
            return false;
        }
        VirtualDeviceParams that = (VirtualDeviceParams)o;
        int devicePoliciesCount = this.mDevicePolicies.size();
        if (devicePoliciesCount != that.mDevicePolicies.size()) {
            return false;
        }
        for (int i = 0; i < devicePoliciesCount; ++i) {
            if (this.mDevicePolicies.keyAt(i) != that.mDevicePolicies.keyAt(i)) {
                return false;
            }
            if (this.mDevicePolicies.valueAt(i) == that.mDevicePolicies.valueAt(i)) continue;
            return false;
        }
        return this.mLockState == that.mLockState && this.mUsersWithMatchingAccounts.equals(that.mUsersWithMatchingAccounts) && Objects.equals(this.mCrossTaskNavigationExemptions, that.mCrossTaskNavigationExemptions) && this.mDefaultNavigationPolicy == that.mDefaultNavigationPolicy && Objects.equals(this.mActivityPolicyExemptions, that.mActivityPolicyExemptions) && this.mDefaultActivityPolicy == that.mDefaultActivityPolicy && Objects.equals(this.mName, that.mName) && Objects.equals(this.mHomeComponent, that.mHomeComponent) && Objects.equals(this.mInputMethodComponent, that.mInputMethodComponent) && this.mAudioPlaybackSessionId == that.mAudioPlaybackSessionId && this.mAudioRecordingSessionId == that.mAudioRecordingSessionId && this.mDimDuration == that.mDimDuration && this.mScreenOffTimeout == that.mScreenOffTimeout && Objects.equals(this.mViewConfigurationParams, that.mViewConfigurationParams);
    }

    public int hashCode() {
        int hashCode = Objects.hash(this.mLockState, this.mUsersWithMatchingAccounts, this.mCrossTaskNavigationExemptions, this.mDefaultNavigationPolicy, this.mActivityPolicyExemptions, this.mDefaultActivityPolicy, this.mName, this.mDevicePolicies, this.mHomeComponent, this.mInputMethodComponent, this.mAudioPlaybackSessionId, this.mAudioRecordingSessionId, this.mDimDuration, this.mScreenOffTimeout, this.mViewConfigurationParams);
        for (int i = 0; i < this.mDevicePolicies.size(); ++i) {
            hashCode = 31 * hashCode + this.mDevicePolicies.keyAt(i);
            hashCode = 31 * hashCode + this.mDevicePolicies.valueAt(i);
        }
        return hashCode;
    }

    @NonNull
    public String toString() {
        return "VirtualDeviceParams( mLockState=" + this.mLockState + " mUsersWithMatchingAccounts=" + this.mUsersWithMatchingAccounts + " mDefaultNavigationPolicy=" + this.mDefaultNavigationPolicy + " mCrossTaskNavigationExemptions=" + this.mCrossTaskNavigationExemptions + " mDefaultActivityPolicy=" + this.mDefaultActivityPolicy + " mActivityPolicyExemptions=" + this.mActivityPolicyExemptions + " mName=" + this.mName + " mDevicePolicies=" + this.mDevicePolicies + " mHomeComponent=" + this.mHomeComponent + " mInputMethodComponent=" + this.mInputMethodComponent + " mAudioPlaybackSessionId=" + this.mAudioPlaybackSessionId + " mAudioRecordingSessionId=" + this.mAudioRecordingSessionId + " mDimDuration=" + this.mDimDuration + " mScreenOffTimeout=" + this.mScreenOffTimeout + " mViewConfigurationParams=" + this.mViewConfigurationParams + ")";
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "mName=" + this.mName);
        pw.println(prefix + "mLockState=" + this.mLockState);
        pw.println(prefix + "mUsersWithMatchingAccounts=" + this.mUsersWithMatchingAccounts);
        pw.println(prefix + "mDefaultNavigationPolicy=" + this.mDefaultNavigationPolicy);
        pw.println(prefix + "mCrossTaskNavigationExemptions=" + this.mCrossTaskNavigationExemptions);
        pw.println(prefix + "mDefaultActivityPolicy=" + this.mDefaultActivityPolicy);
        pw.println(prefix + "mActivityPolicyExemptions=" + this.mActivityPolicyExemptions);
        pw.println(prefix + "mDevicePolicies=" + this.mDevicePolicies);
        pw.println(prefix + "mVirtualSensorConfigs=" + this.mVirtualSensorConfigs);
        pw.println(prefix + "mHomeComponent=" + this.mHomeComponent);
        pw.println(prefix + "mInputMethodComponent=" + this.mInputMethodComponent);
        pw.println(prefix + "mAudioPlaybackSessionId=" + this.mAudioPlaybackSessionId);
        pw.println(prefix + "mAudioRecordingSessionId=" + this.mAudioRecordingSessionId);
        pw.println(prefix + "mDimDuration=" + this.mDimDuration);
        pw.println(prefix + "mScreenOffTimeout=" + this.mScreenOffTimeout);
        pw.println(prefix + "mViewConfigurationParams=" + this.mViewConfigurationParams);
    }

    public static class Builder {
        private static final Duration INFINITE_TIMEOUT = Duration.ofDays(365000L);
        private int mLockState = 0;
        @NonNull
        private Set<UserHandle> mUsersWithMatchingAccounts = Collections.emptySet();
        @NonNull
        private Set<ComponentName> mCrossTaskNavigationExemptions = Collections.emptySet();
        private int mDefaultNavigationPolicy = 0;
        private boolean mDefaultNavigationPolicyConfigured = false;
        @NonNull
        private Set<ComponentName> mActivityPolicyExemptions = Collections.emptySet();
        private int mDefaultActivityPolicy = 0;
        private boolean mDefaultActivityPolicyConfigured = false;
        @Nullable
        private String mName;
        @NonNull
        private final SparseIntArray mDevicePolicies = new SparseIntArray();
        private int mAudioPlaybackSessionId = 0;
        private int mAudioRecordingSessionId = 0;
        @NonNull
        private final List<VirtualSensorConfig> mVirtualSensorConfigs = new ArrayList<VirtualSensorConfig>();
        @Nullable
        private Executor mVirtualSensorCallbackExecutor;
        @Nullable
        private VirtualSensorCallback mVirtualSensorCallback;
        @Nullable
        private Executor mVirtualSensorDirectChannelCallbackExecutor;
        @Nullable
        private VirtualSensorDirectChannelCallback mVirtualSensorDirectChannelCallback;
        @Nullable
        private ComponentName mHomeComponent;
        @Nullable
        private ComponentName mInputMethodComponent;
        private Duration mDimDuration = Duration.ZERO;
        private Duration mScreenOffTimeout = Duration.ZERO;
        @Nullable
        private ViewConfigurationParams mViewConfigurationParams;

        @RequiresPermission(value="android.permission.ADD_ALWAYS_UNLOCKED_DISPLAY", conditional=true)
        @NonNull
        public Builder setLockState(int lockState) {
            this.mLockState = lockState;
            return this;
        }

        @FlaggedApi(value="android.companion.virtualdevice.flags.device_aware_display_power")
        @NonNull
        public Builder setDimDuration(@NonNull Duration dimDuration) {
            if (Objects.requireNonNull(dimDuration).compareTo(Duration.ZERO) < 0) {
                throw new IllegalArgumentException("The dim duration cannot be negative");
            }
            this.mDimDuration = dimDuration;
            return this;
        }

        @FlaggedApi(value="android.companion.virtualdevice.flags.device_aware_display_power")
        @NonNull
        public Builder setScreenOffTimeout(@NonNull Duration screenOffTimeout) {
            if (Objects.requireNonNull(screenOffTimeout).compareTo(Duration.ZERO) < 0) {
                throw new IllegalArgumentException("The screen off timeout cannot be negative");
            }
            this.mScreenOffTimeout = screenOffTimeout;
            return this;
        }

        @NonNull
        public Builder setHomeComponent(@Nullable ComponentName homeComponent) {
            this.mHomeComponent = homeComponent;
            return this;
        }

        @NonNull
        public Builder setInputMethodComponent(@Nullable ComponentName inputMethodComponent) {
            this.mInputMethodComponent = inputMethodComponent;
            return this;
        }

        @NonNull
        public Builder setUsersWithMatchingAccounts(@NonNull Set<UserHandle> usersWithMatchingAccounts) {
            this.mUsersWithMatchingAccounts = Objects.requireNonNull(usersWithMatchingAccounts);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setAllowedCrossTaskNavigations(@NonNull Set<ComponentName> allowedCrossTaskNavigations) {
            if (this.mDefaultNavigationPolicyConfigured && this.mDefaultNavigationPolicy != 1) {
                throw new IllegalArgumentException("Allowed cross task navigations and blocked cross task navigations cannot  both be set.");
            }
            this.mDefaultNavigationPolicy = 1;
            this.mDefaultNavigationPolicyConfigured = true;
            this.mCrossTaskNavigationExemptions = Objects.requireNonNull(allowedCrossTaskNavigations);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setBlockedCrossTaskNavigations(@NonNull Set<ComponentName> blockedCrossTaskNavigations) {
            if (this.mDefaultNavigationPolicyConfigured && this.mDefaultNavigationPolicy != 0) {
                throw new IllegalArgumentException("Allowed cross task navigation and blocked task navigation cannot  be set.");
            }
            this.mDefaultNavigationPolicy = 0;
            this.mDefaultNavigationPolicyConfigured = true;
            this.mCrossTaskNavigationExemptions = Objects.requireNonNull(blockedCrossTaskNavigations);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setAllowedActivities(@NonNull Set<ComponentName> allowedActivities) {
            if (this.mDefaultActivityPolicyConfigured && this.mDefaultActivityPolicy != 1) {
                throw new IllegalArgumentException("Allowed activities and Blocked activities cannot both be set.");
            }
            this.mDefaultActivityPolicy = 1;
            this.mDefaultActivityPolicyConfigured = true;
            this.mActivityPolicyExemptions = Objects.requireNonNull(allowedActivities);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setBlockedActivities(@NonNull Set<ComponentName> blockedActivities) {
            if (this.mDefaultActivityPolicyConfigured && this.mDefaultActivityPolicy != 0) {
                throw new IllegalArgumentException("Allowed activities and Blocked activities cannot both be set.");
            }
            this.mDefaultActivityPolicy = 0;
            this.mDefaultActivityPolicyConfigured = true;
            this.mActivityPolicyExemptions = Objects.requireNonNull(blockedActivities);
            return this;
        }

        @NonNull
        public Builder setName(@NonNull String name) {
            this.mName = name;
            return this;
        }

        @NonNull
        public Builder setDevicePolicy(int policyType, int devicePolicy) {
            this.mDevicePolicies.put(policyType, devicePolicy);
            return this;
        }

        @NonNull
        public Builder addVirtualSensorConfig(@NonNull VirtualSensorConfig virtualSensorConfig) {
            this.mVirtualSensorConfigs.add(Objects.requireNonNull(virtualSensorConfig));
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setVirtualSensorCallback(@NonNull Executor executor, @NonNull VirtualSensorCallback callback) {
            this.mVirtualSensorCallbackExecutor = Objects.requireNonNull(executor);
            this.mVirtualSensorCallback = Objects.requireNonNull(callback);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setVirtualSensorDirectChannelCallback(@NonNull Executor executor, @NonNull VirtualSensorDirectChannelCallback callback) {
            this.mVirtualSensorDirectChannelCallbackExecutor = Objects.requireNonNull(executor);
            this.mVirtualSensorDirectChannelCallback = Objects.requireNonNull(callback);
            return this;
        }

        @NonNull
        public Builder setAudioPlaybackSessionId(int playbackSessionId) {
            if (playbackSessionId < 0) {
                throw new IllegalArgumentException("Invalid playback audio session id");
            }
            this.mAudioPlaybackSessionId = playbackSessionId;
            return this;
        }

        @NonNull
        public Builder setAudioRecordingSessionId(int recordingSessionId) {
            if (recordingSessionId < 0) {
                throw new IllegalArgumentException("Invalid recording audio session id");
            }
            this.mAudioRecordingSessionId = recordingSessionId;
            return this;
        }

        @NonNull
        @FlaggedApi(value="android.companion.virtualdevice.flags.viewconfiguration_apis")
        public Builder setViewConfigurationParams(@Nullable ViewConfigurationParams viewConfigurationParams) {
            this.mViewConfigurationParams = viewConfigurationParams;
            return this;
        }

        @NonNull
        public VirtualDeviceParams build() {
            VirtualSensorCallbackDelegate virtualSensorCallbackDelegate = null;
            if (!this.mVirtualSensorConfigs.isEmpty()) {
                if (this.mDevicePolicies.get(0, 0) != 1) {
                    throw new IllegalArgumentException("DEVICE_POLICY_CUSTOM for POLICY_TYPE_SENSORS is required for creating virtual sensors.");
                }
                if (this.mVirtualSensorCallback == null) {
                    throw new IllegalArgumentException("VirtualSensorCallback is required for creating virtual sensors.");
                }
                for (int i = 0; i < this.mVirtualSensorConfigs.size(); ++i) {
                    if (this.mVirtualSensorConfigs.get(i).getDirectChannelTypesSupported() <= 0) continue;
                    if (this.mVirtualSensorDirectChannelCallback != null) break;
                    throw new IllegalArgumentException("VirtualSensorDirectChannelCallback is required for creating virtual sensors that support direct channel.");
                }
                virtualSensorCallbackDelegate = new VirtualSensorCallbackDelegate(this.mVirtualSensorCallbackExecutor, this.mVirtualSensorCallback, this.mVirtualSensorDirectChannelCallbackExecutor, this.mVirtualSensorDirectChannelCallback);
            }
            switch (this.mDevicePolicies.get(3, -1)) {
                case 0: {
                    if (!this.mDefaultActivityPolicyConfigured || this.mDefaultActivityPolicy != 1) break;
                    throw new IllegalArgumentException("DEVICE_POLICY_DEFAULT is explicitly configured for POLICY_TYPE_ACTIVITY, which is exclusive with setAllowedActivities.");
                }
                case 1: {
                    if (!this.mDefaultActivityPolicyConfigured || this.mDefaultActivityPolicy != 0) break;
                    throw new IllegalArgumentException("DEVICE_POLICY_CUSTOM is explicitly configured for POLICY_TYPE_ACTIVITY, which is exclusive with setBlockedActivities.");
                }
                default: {
                    if (!this.mDefaultActivityPolicyConfigured || this.mDefaultActivityPolicy != 1) break;
                    this.mDevicePolicies.put(3, 1);
                }
            }
            if (this.mDimDuration.compareTo(this.mScreenOffTimeout) > 0) {
                throw new IllegalArgumentException("The dim duration cannot be greater than the screen off timeout.");
            }
            if (this.mScreenOffTimeout.compareTo(Duration.ZERO) == 0) {
                this.mScreenOffTimeout = INFINITE_TIMEOUT;
            }
            if (!Flags.defaultDeviceCameraAccessPolicy()) {
                this.mDevicePolicies.delete(7);
            }
            if (!Flags.activityControlApi()) {
                this.mDevicePolicies.delete(6);
            }
            if ((this.mAudioPlaybackSessionId != 0 || this.mAudioRecordingSessionId != 0) && this.mDevicePolicies.get(1, 0) != 1) {
                throw new IllegalArgumentException("DEVICE_POLICY_CUSTOM for POLICY_TYPE_AUDIO is required for configuration of device-specific audio session ids.");
            }
            SparseArray<Set> sensorNameByType = new SparseArray<Set>();
            for (int i = 0; i < this.mVirtualSensorConfigs.size(); ++i) {
                VirtualSensorConfig config = this.mVirtualSensorConfigs.get(i);
                Set sensorNames = sensorNameByType.get(config.getType(), new ArraySet());
                if (!sensorNames.add(config.getName())) {
                    throw new IllegalArgumentException("Sensor names must be unique for a particular sensor type.");
                }
                sensorNameByType.put(config.getType(), sensorNames);
            }
            return new VirtualDeviceParams(this.mLockState, this.mUsersWithMatchingAccounts, this.mDefaultNavigationPolicy, this.mCrossTaskNavigationExemptions, this.mDefaultActivityPolicy, this.mActivityPolicyExemptions, this.mName, this.mDevicePolicies, this.mHomeComponent, this.mInputMethodComponent, this.mVirtualSensorConfigs, virtualSensorCallbackDelegate, this.mAudioPlaybackSessionId, this.mAudioRecordingSessionId, this.mDimDuration.toMillis(), this.mScreenOffTimeout.toMillis(), this.mViewConfigurationParams);
        }

        private static class VirtualSensorCallbackDelegate
        extends IVirtualSensorCallback.Stub {
            @NonNull
            private final Executor mExecutor;
            @NonNull
            private final VirtualSensorCallback mCallback;
            @Nullable
            private final Executor mDirectChannelExecutor;
            @Nullable
            private final VirtualSensorDirectChannelCallback mDirectChannelCallback;

            VirtualSensorCallbackDelegate(@NonNull Executor executor, @NonNull VirtualSensorCallback callback, @Nullable Executor directChannelExecutor, @Nullable VirtualSensorDirectChannelCallback directChannelCallback) {
                this.mExecutor = executor;
                this.mCallback = callback;
                this.mDirectChannelExecutor = directChannelExecutor;
                this.mDirectChannelCallback = directChannelCallback;
            }

            @Override
            public void onConfigurationChanged(@NonNull VirtualSensor sensor, boolean enabled, int samplingPeriodMicros, int batchReportLatencyMicros) {
                Duration samplingPeriod = Duration.ofNanos(TimeUnit.MICROSECONDS.toNanos(samplingPeriodMicros));
                Duration batchReportingLatency = Duration.ofNanos(TimeUnit.MICROSECONDS.toNanos(batchReportLatencyMicros));
                this.mExecutor.execute(() -> this.mCallback.onConfigurationChanged(sensor, enabled, samplingPeriod, batchReportingLatency));
            }

            @Override
            public void onDirectChannelCreated(int channelHandle, @NonNull SharedMemory sharedMemory) {
                if (this.mDirectChannelCallback != null && this.mDirectChannelExecutor != null) {
                    this.mDirectChannelExecutor.execute(() -> this.mDirectChannelCallback.onDirectChannelCreated(channelHandle, sharedMemory));
                }
            }

            @Override
            public void onDirectChannelDestroyed(int channelHandle) {
                if (this.mDirectChannelCallback != null && this.mDirectChannelExecutor != null) {
                    this.mDirectChannelExecutor.execute(() -> this.mDirectChannelCallback.onDirectChannelDestroyed(channelHandle));
                }
            }

            @Override
            public void onDirectChannelConfigured(int channelHandle, @NonNull VirtualSensor sensor, int rateLevel, int reportToken) {
                if (this.mDirectChannelCallback != null && this.mDirectChannelExecutor != null) {
                    this.mDirectChannelExecutor.execute(() -> this.mDirectChannelCallback.onDirectChannelConfigured(channelHandle, sensor, rateLevel, reportToken));
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface DynamicDisplayPolicyType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface DynamicPolicyType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface PolicyType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface DevicePolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface NavigationPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface ActivityPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface LockState {
    }
}

