/*
 * Decompiled with CFR 0.152.
 */
package android.companion.datatransfer.continuity;

import android.companion.datatransfer.continuity.RemoteTask;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IRemoteTaskListener
extends IInterface {
    public static final String DESCRIPTOR = "android.companion.datatransfer.continuity.IRemoteTaskListener";

    public void onRemoteTasksChanged(List<RemoteTask> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRemoteTaskListener {
        static final int TRANSACTION_onRemoteTasksChanged = 1;

        public Stub() {
            this.attachInterface(this, IRemoteTaskListener.DESCRIPTOR);
        }

        public static IRemoteTaskListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRemoteTaskListener.DESCRIPTOR);
            if (iin != null && iin instanceof IRemoteTaskListener) {
                return (IRemoteTaskListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onRemoteTasksChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRemoteTaskListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ArrayList<RemoteTask> _arg0 = data.createTypedArrayList(RemoteTask.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRemoteTasksChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IRemoteTaskListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRemoteTaskListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoteTasksChanged(List<RemoteTask> remoteTasks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteTaskListener.DESCRIPTOR);
                    _data.writeTypedList(remoteTasks, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRemoteTaskListener {
        @Override
        public void onRemoteTasksChanged(List<RemoteTask> remoteTasks) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

