/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

@SystemApi
public class DistanceMeasurementResult
implements Parcelable {
    @SystemApi
    public static final int NADM_ATTACK_IS_EXTREMELY_UNLIKELY = 0;
    @SystemApi
    public static final int NADM_ATTACK_IS_VERY_UNLIKELY = 1;
    @SystemApi
    public static final int NADM_ATTACK_IS_UNLIKELY = 2;
    @SystemApi
    public static final int NADM_ATTACK_IS_POSSIBLE = 3;
    @SystemApi
    public static final int NADM_ATTACK_IS_LIKELY = 4;
    @SystemApi
    public static final int NADM_ATTACK_IS_VERY_LIKELY = 5;
    @SystemApi
    public static final int NADM_ATTACK_IS_EXTREMELY_LIKELY = 6;
    @SystemApi
    public static final int NADM_UNKNOWN = 255;
    private final double mMeters;
    private final double mErrorMeters;
    private final double mAzimuthAngle;
    private final double mErrorAzimuthAngle;
    private final double mAltitudeAngle;
    private final double mErrorAltitudeAngle;
    private final double mDelaySpreadMeters;
    private final double mConfidenceLevel;
    private final int mDetectedAttackLevel;
    private final double mVelocityMetersPerSecond;
    private final long mMeasurementTimestampNanos;
    @NonNull
    public static final Parcelable.Creator<DistanceMeasurementResult> CREATOR = new Parcelable.Creator<DistanceMeasurementResult>(){

        @Override
        @NonNull
        public DistanceMeasurementResult createFromParcel(@NonNull Parcel in) {
            return new Builder(in.readDouble(), in.readDouble()).setAzimuthAngle(in.readDouble()).setErrorAzimuthAngle(in.readDouble()).setAltitudeAngle(in.readDouble()).setErrorAltitudeAngle(in.readDouble()).setDelaySpreadMeters(in.readDouble()).setConfidenceLevel(in.readDouble()).setDetectedAttackLevel(in.readInt()).setVelocityMetersPerSecond(in.readDouble()).setMeasurementTimestampNanos(in.readLong()).build();
        }

        @NonNull
        public DistanceMeasurementResult[] newArray(int size) {
            return new DistanceMeasurementResult[size];
        }
    };

    private DistanceMeasurementResult(double meters, double errorMeters, double azimuthAngle, double errorAzimuthAngle, double altitudeAngle, double errorAltitudeAngle, double delaySpreadMeters, double confidenceLevel, int detectedAttackLevel, double velocityMetersPerSecond, long measurementTimestampNanos) {
        this.mMeters = meters;
        this.mErrorMeters = errorMeters;
        this.mAzimuthAngle = azimuthAngle;
        this.mErrorAzimuthAngle = errorAzimuthAngle;
        this.mAltitudeAngle = altitudeAngle;
        this.mErrorAltitudeAngle = errorAltitudeAngle;
        this.mDelaySpreadMeters = delaySpreadMeters;
        this.mConfidenceLevel = confidenceLevel;
        this.mDetectedAttackLevel = detectedAttackLevel;
        this.mVelocityMetersPerSecond = velocityMetersPerSecond;
        this.mMeasurementTimestampNanos = measurementTimestampNanos;
    }

    @SystemApi
    public double getResultMeters() {
        return this.mMeters;
    }

    @SystemApi
    public double getErrorMeters() {
        return this.mErrorMeters;
    }

    @SystemApi
    public double getAzimuthAngle() {
        return this.mAzimuthAngle;
    }

    @SystemApi
    public double getErrorAzimuthAngle() {
        return this.mErrorAzimuthAngle;
    }

    @SystemApi
    public double getAltitudeAngle() {
        return this.mAltitudeAngle;
    }

    @SystemApi
    public double getErrorAltitudeAngle() {
        return this.mErrorAltitudeAngle;
    }

    @SystemApi
    public double getDelaySpreadMeters() {
        return this.mDelaySpreadMeters;
    }

    @SystemApi
    public double getConfidenceLevel() {
        return this.mConfidenceLevel;
    }

    @SystemApi
    public int getDetectedAttackLevel() {
        return this.mDetectedAttackLevel;
    }

    @SystemApi
    public double getVelocityMetersPerSecond() {
        return this.mVelocityMetersPerSecond;
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.channel_sounding_25q2_apis")
    public long getMeasurementTimestampNanos() {
        return this.mMeasurementTimestampNanos;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeDouble(this.mMeters);
        out.writeDouble(this.mErrorMeters);
        out.writeDouble(this.mAzimuthAngle);
        out.writeDouble(this.mErrorAzimuthAngle);
        out.writeDouble(this.mAltitudeAngle);
        out.writeDouble(this.mErrorAltitudeAngle);
        out.writeDouble(this.mDelaySpreadMeters);
        out.writeDouble(this.mConfidenceLevel);
        out.writeInt(this.mDetectedAttackLevel);
        out.writeDouble(this.mVelocityMetersPerSecond);
        out.writeLong(this.mMeasurementTimestampNanos);
    }

    public String toString() {
        return "DistanceMeasurement[meters: " + this.mMeters + ", errorMeters: " + this.mErrorMeters + ", azimuthAngle: " + this.mAzimuthAngle + ", errorAzimuthAngle: " + this.mErrorAzimuthAngle + ", altitudeAngle: " + this.mAltitudeAngle + ", errorAltitudeAngle: " + this.mErrorAltitudeAngle + ", delaySpreadMeters: " + this.mDelaySpreadMeters + ", confidenceLevel: " + this.mConfidenceLevel + ", detectedAttackLevel: " + this.mDetectedAttackLevel + ", velocityMetersPerSecond: " + this.mVelocityMetersPerSecond + ", elapsedRealtimeNanos" + this.mMeasurementTimestampNanos + "]";
    }

    @SystemApi
    public static class Builder {
        private double mMeters = Double.NaN;
        private double mErrorMeters = Double.NaN;
        private double mAzimuthAngle = Double.NaN;
        private double mErrorAzimuthAngle = Double.NaN;
        private double mAltitudeAngle = Double.NaN;
        private double mErrorAltitudeAngle = Double.NaN;
        private double mDelaySpreadMeters = Double.NaN;
        private double mConfidenceLevel = Double.NaN;
        private int mDetectedAttackLevel = 255;
        private double mVelocityMetersPerSecond = Double.NaN;
        private long mMeasurementTimestampNanos = -1L;

        public Builder(double meters, double errorMeters) {
            if (Double.isNaN(meters) || meters < 0.0) {
                throw new IllegalArgumentException("meters must be >= 0.0 and not NaN: " + meters);
            }
            if (Double.isNaN(errorMeters) || errorMeters < 0.0) {
                throw new IllegalArgumentException("errorMeters must be >= 0.0 and not NaN: " + errorMeters);
            }
            this.mMeters = meters;
            this.mErrorMeters = errorMeters;
        }

        @SystemApi
        @NonNull
        public Builder setAzimuthAngle(double angle) {
            if (angle > 360.0 || angle < 0.0) {
                throw new IllegalArgumentException("angle must be in the range from 0.0 to 360.0 : " + angle);
            }
            this.mAzimuthAngle = angle;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setErrorAzimuthAngle(double angle) {
            if (angle > 360.0 || angle < 0.0) {
                throw new IllegalArgumentException("error angle must be in the range from 0.0 to 360.0 : " + angle);
            }
            this.mErrorAzimuthAngle = angle;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setAltitudeAngle(double angle) {
            if (angle > 90.0 || angle < -90.0) {
                throw new IllegalArgumentException("angle must be in the range from -90.0 to 90.0 : " + angle);
            }
            this.mAltitudeAngle = angle;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setErrorAltitudeAngle(double angle) {
            if (angle > 180.0 || angle < 0.0) {
                throw new IllegalArgumentException("error angle must be in the range from 0.0 to 180.0 : " + angle);
            }
            this.mErrorAltitudeAngle = angle;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setDelaySpreadMeters(double delaySpreadMeters) {
            if (delaySpreadMeters < 0.0) {
                throw new IllegalArgumentException("delaySpreadMeters must be > 0.0");
            }
            this.mDelaySpreadMeters = delaySpreadMeters;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setConfidenceLevel(double confidenceLevel) {
            if (confidenceLevel > 1.0 || confidenceLevel < 0.0) {
                throw new IllegalArgumentException("error confidenceLevel must be in the range from 0.0 to 100.0 : " + confidenceLevel);
            }
            this.mConfidenceLevel = confidenceLevel;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setDetectedAttackLevel(int detectedAttackLevel) {
            if (!List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(255)).contains(detectedAttackLevel)) {
                throw new IllegalArgumentException("Invalid value " + detectedAttackLevel);
            }
            this.mDetectedAttackLevel = detectedAttackLevel;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setVelocityMetersPerSecond(double velocityMetersPerSecond) {
            this.mVelocityMetersPerSecond = velocityMetersPerSecond;
            return this;
        }

        @SystemApi
        @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.channel_sounding_25q2_apis")
        @NonNull
        public Builder setMeasurementTimestampNanos(long measurementTimestampNanos) {
            this.mMeasurementTimestampNanos = measurementTimestampNanos;
            return this;
        }

        @SystemApi
        @NonNull
        public DistanceMeasurementResult build() {
            return new DistanceMeasurementResult(this.mMeters, this.mErrorMeters, this.mAzimuthAngle, this.mErrorAzimuthAngle, this.mAltitudeAngle, this.mErrorAltitudeAngle, this.mDelaySpreadMeters, this.mConfidenceLevel, this.mDetectedAttackLevel, this.mVelocityMetersPerSecond, this.mMeasurementTimestampNanos);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Nadm {
    }
}

