/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IDistanceMeasurement;
import android.bluetooth.le.DistanceMeasurementMethod;
import android.bluetooth.le.DistanceMeasurementParams;
import android.bluetooth.le.DistanceMeasurementResult;
import android.bluetooth.le.DistanceMeasurementSession;
import android.bluetooth.le.IDistanceMeasurementCallback;
import android.content.AttributionSource;
import android.os.CancellationSignal;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

@SystemApi
public class DistanceMeasurementManager {
    private static final String TAG = DistanceMeasurementManager.class.getSimpleName();
    private final ConcurrentHashMap<BluetoothDevice, DistanceMeasurementSession> mSessionMap = new ConcurrentHashMap();
    private final BluetoothAdapter mBluetoothAdapter;
    private final AttributionSource mAttributionSource;
    private final ParcelUuid mUuid;
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IDistanceMeasurementCallback mCallbackWrapper = new IDistanceMeasurementCallback.Stub(){

        @Override
        public void onStarted(BluetoothDevice device) {
            DistanceMeasurementSession session = DistanceMeasurementManager.this.mSessionMap.get(device);
            session.onStarted();
        }

        @Override
        public void onStartFail(BluetoothDevice device, int reason) {
            DistanceMeasurementSession session = DistanceMeasurementManager.this.mSessionMap.get(device);
            session.onStartFail(reason);
            DistanceMeasurementManager.this.mSessionMap.remove(device);
        }

        @Override
        public void onStopped(BluetoothDevice device, int reason) {
            DistanceMeasurementSession session = DistanceMeasurementManager.this.mSessionMap.get(device);
            session.onStopped(reason);
            DistanceMeasurementManager.this.mSessionMap.remove(device);
        }

        @Override
        public void onResult(BluetoothDevice device, DistanceMeasurementResult result) {
            DistanceMeasurementSession session = DistanceMeasurementManager.this.mSessionMap.get(device);
            session.onResult(device, result);
        }
    };

    public DistanceMeasurementManager(BluetoothAdapter bluetoothAdapter) {
        this.mBluetoothAdapter = Objects.requireNonNull(bluetoothAdapter);
        this.mAttributionSource = this.mBluetoothAdapter.getAttributionSource();
        this.mUuid = new ParcelUuid(UUID.randomUUID());
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @NonNull
    public List<DistanceMeasurementMethod> getSupportedMethods() {
        ArrayList<DistanceMeasurementMethod> supportedMethods = new ArrayList<DistanceMeasurementMethod>();
        try {
            IDistanceMeasurement distanceMeasurement = this.mBluetoothAdapter.getDistanceMeasurement();
            if (distanceMeasurement == null) {
                Log.e(TAG, "Distance Measurement is null");
                return supportedMethods;
            }
            return distanceMeasurement.getSupportedDistanceMeasurementMethods(this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get supported methods - ", e);
            return supportedMethods;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @Nullable
    public CancellationSignal startMeasurementSession(@NonNull DistanceMeasurementParams params, @NonNull Executor executor, @NonNull DistanceMeasurementSession.Callback callback) {
        Objects.requireNonNull(params);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            IDistanceMeasurement distanceMeasurement = this.mBluetoothAdapter.getDistanceMeasurement();
            if (distanceMeasurement == null) {
                Log.e(TAG, "Distance Measurement is null");
                return null;
            }
            DistanceMeasurementSession session = new DistanceMeasurementSession(distanceMeasurement, this.mUuid, params, executor, this.mAttributionSource, callback);
            CancellationSignal cancellationSignal = new CancellationSignal();
            cancellationSignal.setOnCancelListener(() -> session.stopSession());
            if (this.mSessionMap.containsKey(params.getDevice())) {
                throw new IllegalStateException(params.getDevice().getAnonymizedAddress() + " already registered");
            }
            this.mSessionMap.put(params.getDevice(), session);
            distanceMeasurement.startDistanceMeasurement(this.mUuid, params, this.mCallbackWrapper, this.mAttributionSource);
            return cancellationSignal;
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            return null;
        }
    }

    @Deprecated
    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.channel_sounding_25q2_apis")
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getChannelSoundingMaxSupportedSecurityLevel(@NonNull BluetoothDevice remoteDevice) {
        Objects.requireNonNull(remoteDevice);
        boolean defaultValue = false;
        try {
            IDistanceMeasurement distanceMeasurement = this.mBluetoothAdapter.getDistanceMeasurement();
            if (distanceMeasurement == null) {
                Log.e(TAG, "Distance Measurement is null");
                return 0;
            }
            return distanceMeasurement.getChannelSoundingMaxSupportedSecurityLevel(remoteDevice, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get supported security Level - ", e);
            return 0;
        }
    }

    @Deprecated
    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.channel_sounding_25q2_apis")
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getLocalChannelSoundingMaxSupportedSecurityLevel() {
        boolean defaultValue = false;
        try {
            IDistanceMeasurement distanceMeasurement = this.mBluetoothAdapter.getDistanceMeasurement();
            if (distanceMeasurement == null) {
                Log.e(TAG, "Distance Measurement is null");
                return 0;
            }
            return distanceMeasurement.getLocalChannelSoundingMaxSupportedSecurityLevel(this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get supported security Level - ", e);
            return 0;
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.channel_sounding_25q2_apis")
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @NonNull
    public Set<Integer> getChannelSoundingSupportedSecurityLevels() {
        try {
            IDistanceMeasurement distanceMeasurement = this.mBluetoothAdapter.getDistanceMeasurement();
            if (distanceMeasurement == null) {
                Log.e(TAG, "Distance Measurement is null");
                return Collections.emptySet();
            }
            return Arrays.stream(distanceMeasurement.getChannelSoundingSupportedSecurityLevels(this.mAttributionSource)).boxed().collect(Collectors.toUnmodifiableSet());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get supported security Level - ", e);
            return Collections.emptySet();
        }
    }

    @RequiresNoPermission
    public void cleanup() {
        this.mSessionMap.clear();
    }
}

