/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.IBluetooth;
import android.os.RemoteException;
import android.util.Log;

class SocketMetrics {
    private static final String TAG = SocketMetrics.class.getSimpleName();
    static final int SOCKET_NO_ERROR = -1;
    private static final int RESULT_L2CAP_CONN_UNKNOWN = 0;
    static final int RESULT_L2CAP_CONN_SUCCESS = 1;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_SOCKET_CONNECTION_FAILED = 1000;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_SOCKET_CONNECTION_CLOSED = 1001;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_UNABLE_TO_SEND_RPC = 1002;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_NULL_BLUETOOTH_DEVICE = 1003;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_GET_SOCKET_MANAGER_FAILED = 1004;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_NULL_FILE_DESCRIPTOR = 1005;
    static final int RESULT_L2CAP_CONN_SERVER_FAILURE = 2000;

    SocketMetrics() {
    }

    static void logSocketConnect(int socketExceptionCode, long socketConnectionTimeNanos, int connType, BluetoothDevice device, int port, boolean auth, long socketCreationTimeNanos, long socketCreationLatencyNanos) {
        IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService();
        if (bluetoothProxy == null) {
            Log.w(TAG, "logSocketConnect: bluetoothProxy is null");
            return;
        }
        if (connType == 4) {
            try {
                bluetoothProxy.logL2capcocClientConnection(device, port, auth, SocketMetrics.getL2capLeConnectStatusCode(socketExceptionCode), socketCreationTimeNanos, socketCreationLatencyNanos, socketConnectionTimeNanos);
            }
            catch (RemoteException e) {
                Log.w(TAG, "logL2capcocServerConnection failed", e);
            }
        } else {
            Log.d(TAG, "No metrics for connection type " + connType);
        }
    }

    static void logSocketAccept(BluetoothSocket acceptedSocket, BluetoothSocket socket, int connType, int channel, int timeout, int result, long socketCreationTimeMillis, long socketCreationLatencyMillis, long socketConnectionTimeMillis) {
        if (connType != 4) {
            return;
        }
        IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService();
        if (bluetoothProxy == null) {
            Log.w(TAG, "logSocketConnect: bluetoothProxy is null");
            return;
        }
        try {
            bluetoothProxy.logL2capcocServerConnection(acceptedSocket == null ? null : acceptedSocket.getRemoteDevice(), channel, socket.isAuth(), result, socketCreationTimeMillis, socketCreationLatencyMillis, socketConnectionTimeMillis, timeout);
        }
        catch (RemoteException e) {
            Log.w(TAG, "logL2capcocServerConnection failed", e);
        }
    }

    private static int getL2capLeConnectStatusCode(int socketExceptionCode) {
        int n;
        switch (socketExceptionCode) {
            case -1: {
                n = 1;
                break;
            }
            case 19: {
                n = 1003;
                break;
            }
            case 16: {
                n = 1004;
                break;
            }
            case 17: {
                n = 1001;
                break;
            }
            case 18: {
                n = 1000;
                break;
            }
            case 20: {
                n = 1002;
                break;
            }
            case 21: {
                n = 1005;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }
}

