/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattService;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBluetoothGattServerCallback
extends IInterface {
    public void onServerRegistered(int var1) throws RemoteException;

    public void onServerConnectionState(int var1, boolean var2, BluetoothDevice var3) throws RemoteException;

    public void onServiceAdded(int var1, BluetoothGattService var2) throws RemoteException;

    public void onCharacteristicReadRequest(BluetoothDevice var1, int var2, int var3, boolean var4, int var5) throws RemoteException;

    public void onDescriptorReadRequest(BluetoothDevice var1, int var2, int var3, boolean var4, int var5) throws RemoteException;

    public void onCharacteristicWriteRequest(BluetoothDevice var1, int var2, int var3, int var4, boolean var5, boolean var6, int var7, byte[] var8) throws RemoteException;

    public void onDescriptorWriteRequest(BluetoothDevice var1, int var2, int var3, int var4, boolean var5, boolean var6, int var7, byte[] var8) throws RemoteException;

    public void onExecuteWrite(BluetoothDevice var1, int var2, boolean var3) throws RemoteException;

    public void onNotificationSent(BluetoothDevice var1, int var2) throws RemoteException;

    public void onMtuChanged(BluetoothDevice var1, int var2) throws RemoteException;

    public void onPhyUpdate(BluetoothDevice var1, int var2, int var3, int var4) throws RemoteException;

    public void onPhyRead(BluetoothDevice var1, int var2, int var3, int var4) throws RemoteException;

    public void onConnectionUpdated(BluetoothDevice var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public void onSubrateChange(BluetoothDevice var1, int var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothGattServerCallback {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetoothGattServerCallback";
        static final int TRANSACTION_onServerRegistered = 1;
        static final int TRANSACTION_onServerConnectionState = 2;
        static final int TRANSACTION_onServiceAdded = 3;
        static final int TRANSACTION_onCharacteristicReadRequest = 4;
        static final int TRANSACTION_onDescriptorReadRequest = 5;
        static final int TRANSACTION_onCharacteristicWriteRequest = 6;
        static final int TRANSACTION_onDescriptorWriteRequest = 7;
        static final int TRANSACTION_onExecuteWrite = 8;
        static final int TRANSACTION_onNotificationSent = 9;
        static final int TRANSACTION_onMtuChanged = 10;
        static final int TRANSACTION_onPhyUpdate = 11;
        static final int TRANSACTION_onPhyRead = 12;
        static final int TRANSACTION_onConnectionUpdated = 13;
        static final int TRANSACTION_onSubrateChange = 14;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothGattServerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothGattServerCallback) {
                return (IBluetoothGattServerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onServerRegistered";
                }
                case 2: {
                    return "onServerConnectionState";
                }
                case 3: {
                    return "onServiceAdded";
                }
                case 4: {
                    return "onCharacteristicReadRequest";
                }
                case 5: {
                    return "onDescriptorReadRequest";
                }
                case 6: {
                    return "onCharacteristicWriteRequest";
                }
                case 7: {
                    return "onDescriptorWriteRequest";
                }
                case 8: {
                    return "onExecuteWrite";
                }
                case 9: {
                    return "onNotificationSent";
                }
                case 10: {
                    return "onMtuChanged";
                }
                case 11: {
                    return "onPhyUpdate";
                }
                case 12: {
                    return "onPhyRead";
                }
                case 13: {
                    return "onConnectionUpdated";
                }
                case 14: {
                    return "onSubrateChange";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onServerRegistered(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    BluetoothDevice _arg2 = data.readTypedObject(BluetoothDevice.CREATOR);
                    data.enforceNoDataAvail();
                    this.onServerConnectionState(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    BluetoothGattService _arg1 = data.readTypedObject(BluetoothGattService.CREATOR);
                    data.enforceNoDataAvail();
                    this.onServiceAdded(_arg0, _arg1);
                    break;
                }
                case 4: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCharacteristicReadRequest(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 5: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDescriptorReadRequest(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 6: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    boolean _arg4 = data.readBoolean();
                    boolean _arg5 = data.readBoolean();
                    int _arg6 = data.readInt();
                    byte[] _arg7 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onCharacteristicWriteRequest(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 7: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    boolean _arg4 = data.readBoolean();
                    boolean _arg5 = data.readBoolean();
                    int _arg6 = data.readInt();
                    byte[] _arg7 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onDescriptorWriteRequest(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 8: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onExecuteWrite(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onNotificationSent(_arg0, _arg1);
                    break;
                }
                case 10: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onMtuChanged(_arg0, _arg1);
                    break;
                }
                case 11: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPhyUpdate(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 12: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPhyRead(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 13: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onConnectionUpdated(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 14: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSubrateChange(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 13;
        }

        private static class Proxy
        implements IBluetoothGattServerCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServerRegistered(int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServerConnectionState(int status, boolean connected, BluetoothDevice device) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeBoolean(connected);
                    _data.writeTypedObject(device, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceAdded(int status, BluetoothGattService service) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeTypedObject(service, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCharacteristicReadRequest(BluetoothDevice device, int transId, int offset, boolean isLong, int handle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(transId);
                    _data.writeInt(offset);
                    _data.writeBoolean(isLong);
                    _data.writeInt(handle);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDescriptorReadRequest(BluetoothDevice device, int transId, int offset, boolean isLong, int handle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(transId);
                    _data.writeInt(offset);
                    _data.writeBoolean(isLong);
                    _data.writeInt(handle);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCharacteristicWriteRequest(BluetoothDevice device, int transId, int offset, int length, boolean isPrep, boolean needRsp, int handle, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(transId);
                    _data.writeInt(offset);
                    _data.writeInt(length);
                    _data.writeBoolean(isPrep);
                    _data.writeBoolean(needRsp);
                    _data.writeInt(handle);
                    _data.writeByteArray(value);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDescriptorWriteRequest(BluetoothDevice device, int transId, int offset, int length, boolean isPrep, boolean needRsp, int handle, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(transId);
                    _data.writeInt(offset);
                    _data.writeInt(length);
                    _data.writeBoolean(isPrep);
                    _data.writeBoolean(needRsp);
                    _data.writeInt(handle);
                    _data.writeByteArray(value);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onExecuteWrite(BluetoothDevice device, int transId, boolean execWrite) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(transId);
                    _data.writeBoolean(execWrite);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationSent(BluetoothDevice device, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMtuChanged(BluetoothDevice device, int mtu) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(mtu);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPhyUpdate(BluetoothDevice device, int txPhy, int rxPhy, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(txPhy);
                    _data.writeInt(rxPhy);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPhyRead(BluetoothDevice device, int txPhy, int rxPhy, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(txPhy);
                    _data.writeInt(rxPhy);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectionUpdated(BluetoothDevice device, int interval, int latency, int timeout, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(interval);
                    _data.writeInt(latency);
                    _data.writeInt(timeout);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubrateChange(BluetoothDevice device, int subrateMode, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(subrateMode);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothGattServerCallback {
        @Override
        public void onServerRegistered(int status) throws RemoteException {
        }

        @Override
        public void onServerConnectionState(int status, boolean connected, BluetoothDevice device) throws RemoteException {
        }

        @Override
        public void onServiceAdded(int status, BluetoothGattService service) throws RemoteException {
        }

        @Override
        public void onCharacteristicReadRequest(BluetoothDevice device, int transId, int offset, boolean isLong, int handle) throws RemoteException {
        }

        @Override
        public void onDescriptorReadRequest(BluetoothDevice device, int transId, int offset, boolean isLong, int handle) throws RemoteException {
        }

        @Override
        public void onCharacteristicWriteRequest(BluetoothDevice device, int transId, int offset, int length, boolean isPrep, boolean needRsp, int handle, byte[] value) throws RemoteException {
        }

        @Override
        public void onDescriptorWriteRequest(BluetoothDevice device, int transId, int offset, int length, boolean isPrep, boolean needRsp, int handle, byte[] value) throws RemoteException {
        }

        @Override
        public void onExecuteWrite(BluetoothDevice device, int transId, boolean execWrite) throws RemoteException {
        }

        @Override
        public void onNotificationSent(BluetoothDevice device, int status) throws RemoteException {
        }

        @Override
        public void onMtuChanged(BluetoothDevice device, int mtu) throws RemoteException {
        }

        @Override
        public void onPhyUpdate(BluetoothDevice device, int txPhy, int rxPhy, int status) throws RemoteException {
        }

        @Override
        public void onPhyRead(BluetoothDevice device, int txPhy, int rxPhy, int status) throws RemoteException {
        }

        @Override
        public void onConnectionUpdated(BluetoothDevice device, int interval, int latency, int timeout, int status) throws RemoteException {
        }

        @Override
        public void onSubrateChange(BluetoothDevice device, int subrateMode, int status) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

