/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class BluetoothSinkAudioPolicy
implements Parcelable {
    @SystemApi
    public static final int POLICY_UNCONFIGURED = 0;
    @SystemApi
    public static final int POLICY_ALLOWED = 1;
    @SystemApi
    public static final int POLICY_NOT_ALLOWED = 2;
    public static final String HFP_SET_SINK_AUDIO_POLICY_ID = "SINKAUDIOPOLICY";
    private final int mCallEstablishPolicy;
    private final int mConnectingTimePolicy;
    private final int mInBandRingtonePolicy;
    @NonNull
    public static final Parcelable.Creator<BluetoothSinkAudioPolicy> CREATOR = new Parcelable.Creator<BluetoothSinkAudioPolicy>(){

        @Override
        public BluetoothSinkAudioPolicy createFromParcel(@NonNull Parcel in) {
            return new BluetoothSinkAudioPolicy(in.readInt(), in.readInt(), in.readInt());
        }

        public BluetoothSinkAudioPolicy[] newArray(int size) {
            return new BluetoothSinkAudioPolicy[size];
        }
    };

    public BluetoothSinkAudioPolicy(int callEstablishPolicy, int connectingTimePolicy, int inBandRingtonePolicy) {
        this.mCallEstablishPolicy = callEstablishPolicy;
        this.mConnectingTimePolicy = connectingTimePolicy;
        this.mInBandRingtonePolicy = inBandRingtonePolicy;
    }

    @SystemApi
    public int getCallEstablishPolicy() {
        return this.mCallEstablishPolicy;
    }

    @SystemApi
    public int getActiveDevicePolicyAfterConnection() {
        return this.mConnectingTimePolicy;
    }

    @SystemApi
    public int getInBandRingtonePolicy() {
        return this.mInBandRingtonePolicy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BluetoothSinkAudioPolicy{");
        builder.append("mCallEstablishPolicy: ");
        builder.append(this.mCallEstablishPolicy);
        builder.append(", mConnectingTimePolicy: ");
        builder.append(this.mConnectingTimePolicy);
        builder.append(", mInBandRingtonePolicy: ");
        builder.append(this.mInBandRingtonePolicy);
        builder.append("}");
        return builder.toString();
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mCallEstablishPolicy);
        out.writeInt(this.mConnectingTimePolicy);
        out.writeInt(this.mInBandRingtonePolicy);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof BluetoothSinkAudioPolicy) {
            BluetoothSinkAudioPolicy other = (BluetoothSinkAudioPolicy)o;
            return other.mCallEstablishPolicy == this.mCallEstablishPolicy && other.mConnectingTimePolicy == this.mConnectingTimePolicy && other.mInBandRingtonePolicy == this.mInBandRingtonePolicy;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mCallEstablishPolicy, this.mConnectingTimePolicy, this.mInBandRingtonePolicy);
    }

    public static class Builder {
        private int mCallEstablishPolicy = 0;
        private int mConnectingTimePolicy = 0;
        private int mInBandRingtonePolicy = 0;

        public Builder() {
        }

        public Builder(@NonNull BluetoothSinkAudioPolicy policies) {
            this.mCallEstablishPolicy = policies.mCallEstablishPolicy;
            this.mConnectingTimePolicy = policies.mConnectingTimePolicy;
            this.mInBandRingtonePolicy = policies.mInBandRingtonePolicy;
        }

        @SystemApi
        @NonNull
        public Builder setCallEstablishPolicy(int callEstablishPolicy) {
            this.mCallEstablishPolicy = callEstablishPolicy;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setActiveDevicePolicyAfterConnection(int connectingTimePolicy) {
            this.mConnectingTimePolicy = connectingTimePolicy;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setInBandRingtonePolicy(int inBandRingtonePolicy) {
            this.mInBandRingtonePolicy = inBandRingtonePolicy;
            return this;
        }

        @SystemApi
        @NonNull
        public BluetoothSinkAudioPolicy build() {
            return new BluetoothSinkAudioPolicy(this.mCallEstablishPolicy, this.mConnectingTimePolicy, this.mInBandRingtonePolicy);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AudioPolicyValues {
    }
}

