/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.NonNull;
import android.annotation.RequiresNoPermission;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.SocketMetrics;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.ParcelUuid;
import android.util.Log;
import com.android.internal.lang.System_Delegate;
import java.io.Closeable;
import java.io.IOException;

public class BluetoothServerSocket
implements Closeable {
    private static final String TAG = BluetoothServerSocket.class.getSimpleName();
    private static final boolean DBG = Log.isLoggable("bluetooth", 3);
    @UnsupportedAppUsage(publicAlternatives="Use public {@link BluetoothServerSocket} API instead.")
    final BluetoothSocket mSocket;
    private int mChannel;
    private long mSocketCreationTimeMillis = System_Delegate.currentTimeMillis();
    private long mSocketCreationLatencyMillis = 0L;
    private final int mType;

    BluetoothServerSocket(int type, boolean auth, boolean encrypt, int port) throws IOException {
        this.mType = type;
        this.mChannel = port;
        this.mSocket = new BluetoothSocket(type, auth, encrypt, port, null);
        if (port == -2) {
            this.mSocket.setExcludeSdp(true);
        }
        this.mSocketCreationLatencyMillis = System_Delegate.currentTimeMillis() - this.mSocketCreationTimeMillis;
    }

    BluetoothServerSocket(int type, boolean auth, boolean encrypt, int port, boolean pitm, boolean min16DigitPin) throws IOException {
        this.mType = type;
        this.mChannel = port;
        this.mSocket = new BluetoothSocket(type, auth, encrypt, port, null, pitm, min16DigitPin);
        if (port == -2) {
            this.mSocket.setExcludeSdp(true);
        }
        this.mSocketCreationLatencyMillis = System_Delegate.currentTimeMillis() - this.mSocketCreationTimeMillis;
    }

    BluetoothServerSocket(int type, boolean auth, boolean encrypt, ParcelUuid uuid) throws IOException {
        this.mType = type;
        this.mSocket = new BluetoothSocket(type, auth, encrypt, -1, uuid);
        this.mChannel = this.mSocket.getPort();
        this.mSocketCreationLatencyMillis = System_Delegate.currentTimeMillis() - this.mSocketCreationTimeMillis;
    }

    BluetoothServerSocket(int type, boolean auth, boolean encrypt, int port, ParcelUuid uuid, boolean pitm, boolean min16DigitPin, int dataPath, @NonNull String socketName, long hubId, long endpointId, int maximumPacketSize) throws IOException {
        this.mType = type;
        this.mChannel = port;
        this.mSocket = new BluetoothSocket(type, auth, encrypt, port, uuid, pitm, min16DigitPin, dataPath, socketName, hubId, endpointId, maximumPacketSize);
        if (port == -2) {
            this.mSocket.setExcludeSdp(true);
        }
        this.mSocketCreationLatencyMillis = System_Delegate.currentTimeMillis() - this.mSocketCreationTimeMillis;
    }

    @RequiresNoPermission
    public BluetoothSocket accept() throws IOException {
        return this.accept(-1);
    }

    @RequiresNoPermission
    public BluetoothSocket accept(int timeout) throws IOException {
        long socketConnectionTime = System_Delegate.currentTimeMillis();
        BluetoothSocket acceptedSocket = null;
        try {
            acceptedSocket = this.mSocket.accept(timeout);
            SocketMetrics.logSocketAccept(acceptedSocket, this.mSocket, this.mType, this.mChannel, timeout, 1, this.mSocketCreationTimeMillis, this.mSocketCreationLatencyMillis, socketConnectionTime);
            return acceptedSocket;
        }
        catch (IOException e) {
            SocketMetrics.logSocketAccept(acceptedSocket, this.mSocket, this.mType, this.mChannel, timeout, 2000, this.mSocketCreationTimeMillis, this.mSocketCreationLatencyMillis, socketConnectionTime);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (DBG) {
            Log.d(TAG, "BluetoothServerSocket:close() called. mChannel=" + this.mChannel);
        }
        this.mSocket.close();
    }

    void setServiceName(String serviceName) {
        this.mSocket.setServiceName(serviceName);
    }

    @RequiresNoPermission
    public int getChannel() {
        return this.mChannel;
    }

    @RequiresNoPermission
    public int getPsm() {
        return this.mChannel;
    }

    void setChannel(int newChannel) {
        if (this.mSocket != null && this.mSocket.getPort() != newChannel) {
            Log.w(TAG, "The port set is different that the underlying port. mSocket.getPort(): " + this.mSocket.getPort() + " requested newChannel: " + newChannel);
        }
        this.mChannel = newChannel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ServerSocket: Type: ");
        switch (this.mSocket.getConnectionType()) {
            case 1: {
                sb.append("TYPE_RFCOMM");
                break;
            }
            case 3: {
                sb.append("TYPE_L2CAP");
                break;
            }
            case 4: {
                sb.append("TYPE_L2CAP_LE");
                break;
            }
            case 2: {
                sb.append("TYPE_SCO");
                break;
            }
        }
        sb.append(" Channel: ").append(this.mChannel);
        return sb.toString();
    }
}

