/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothLeCall;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetoothLeCallControl;
import android.bluetooth.IBluetoothLeCallControlCallback;
import android.content.AttributionSource;
import android.content.Context;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;

public class BluetoothLeCallControl
implements BluetoothProfile {
    private static final String TAG = BluetoothLeCallControl.class.getSimpleName();
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private int mCcid = 0;
    private String mToken;
    private Callback mCallback = null;
    private IBluetoothLeCallControl mService;

    BluetoothLeCallControl(Context context, BluetoothAdapter adapter) {
        this.mAdapter = adapter;
        this.mAttributionSource = this.mAdapter.getAttributionSource();
        this.mService = null;
    }

    public void close() {
        Log.v(TAG, "close()");
        this.mAdapter.closeProfileProxy(this);
    }

    @Override
    @RequiresNoPermission
    public void onServiceConnected(IBinder service) {
        this.mService = IBluetoothLeCallControl.Stub.asInterface(service);
    }

    @Override
    @RequiresNoPermission
    public void onServiceDisconnected() {
        this.mService = null;
    }

    private IBluetoothLeCallControl getService() {
        return this.mService;
    }

    @Override
    @RequiresNoPermission
    public BluetoothAdapter getAdapter() {
        return this.mAdapter;
    }

    @Override
    @RequiresNoPermission
    public int getConnectionState(@Nullable BluetoothDevice device) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    @RequiresNoPermission
    @NonNull
    public List<BluetoothDevice> getConnectedDevices() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    @RequiresNoPermission
    @NonNull
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(@NonNull int[] states) {
        throw new UnsupportedOperationException("not supported");
    }

    @SuppressLint(value={"ExecutorRegistration"})
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean registerBearer(@Nullable String uci, @NonNull List<String> uriSchemes, int capabilities, @NonNull String provider, int technology, @NonNull Executor executor, @NonNull Callback callback) {
        Log.d(TAG, "registerBearer");
        if (callback == null) {
            throw new IllegalArgumentException("null parameter: " + callback);
        }
        if (this.mCcid != 0) {
            Log.e(TAG, "Ccid is already set to " + this.mCcid);
            return false;
        }
        this.mToken = uci;
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return false;
        }
        if (this.mCallback != null) {
            Log.e(TAG, "Bearer can be opened only once");
            return false;
        }
        this.mCallback = callback;
        try {
            CallbackWrapper callbackWrapper = new CallbackWrapper(executor, callback);
            service.registerBearer(this.mToken, callbackWrapper, uci, uriSchemes, capabilities, provider, technology, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            this.mCallback = null;
            return false;
        }
        if (this.mCcid == 0) {
            this.mCallback = null;
            return false;
        }
        return true;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void unregisterBearer() {
        Log.d(TAG, "unregisterBearer");
        if (this.mCcid == 0) {
            return;
        }
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
        this.mCcid = 0;
        this.mCallback = null;
        try {
            service.unregisterBearer(this.mToken, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void onCallAdded(@NonNull BluetoothLeCall call) {
        Log.d(TAG, "onCallAdded: call=" + call);
        if (this.mCcid == 0) {
            return;
        }
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
        try {
            service.callAdded(this.mCcid, call, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void onCallRemoved(@NonNull UUID callId, int reason) {
        Log.d(TAG, "callRemoved: callId=" + callId);
        if (this.mCcid == 0) {
            return;
        }
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
        try {
            service.callRemoved(this.mCcid, new ParcelUuid(callId), reason, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void onCallStateChanged(@NonNull UUID callId, int state) {
        Log.d(TAG, "callStateChanged: callId=" + callId + " state=" + state);
        if (this.mCcid == 0) {
            return;
        }
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
        try {
            service.callStateChanged(this.mCcid, new ParcelUuid(callId), state, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void currentCallsList(@NonNull List<BluetoothLeCall> calls) {
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
        try {
            service.currentCallsList(this.mCcid, calls, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void requestResult(int requestId, int result) {
        Log.d(TAG, "requestResult: requestId=" + requestId + " result=" + result);
        if (this.mCcid == 0) {
            return;
        }
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
        try {
            service.requestResult(this.mCcid, requestId, result, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
    }

    public static abstract class Callback {
        private static final String TAG = TAG + "." + Callback.class.getSimpleName();

        public abstract void onAcceptCall(int var1, @NonNull UUID var2);

        public abstract void onTerminateCall(int var1, @NonNull UUID var2);

        public void onHoldCall(int requestId, @NonNull UUID callId) {
            Log.e(TAG, "onHoldCall: unimplemented, however CAPABILITY_HOLD_CALL is set!");
        }

        public void onUnholdCall(int requestId, @NonNull UUID callId) {
            Log.e(TAG, "onUnholdCall: unimplemented, however CAPABILITY_HOLD_CALL is set!");
        }

        public abstract void onPlaceCall(int var1, @NonNull UUID var2, @NonNull String var3);

        public void onJoinCalls(int requestId, @NonNull List<UUID> callIds) {
            Log.e(TAG, "onJoinCalls: unimplemented, however CAPABILITY_JOIN_CALLS is set!");
        }
    }

    private class CallbackWrapper
    extends IBluetoothLeCallControlCallback.Stub {
        private final Executor mExecutor;
        private final Callback mCallback;

        CallbackWrapper(Executor executor, Callback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onBearerRegistered(int ccid) {
            if (this.mCallback != null) {
                Log.d(TAG, "onBearerRegistered: ccid is " + ccid);
                BluetoothLeCallControl.this.mCcid = ccid;
            } else {
                Log.e(TAG, "onBearerRegistered: mCallback is null");
            }
        }

        @Override
        public void onAcceptCall(int requestId, ParcelUuid uuid) {
            BluetoothUtils.executeFromBinder(this.mExecutor, () -> this.mCallback.onAcceptCall(requestId, uuid.getUuid()));
        }

        @Override
        public void onTerminateCall(int requestId, ParcelUuid uuid) {
            BluetoothUtils.executeFromBinder(this.mExecutor, () -> this.mCallback.onTerminateCall(requestId, uuid.getUuid()));
        }

        @Override
        public void onHoldCall(int requestId, ParcelUuid uuid) {
            BluetoothUtils.executeFromBinder(this.mExecutor, () -> this.mCallback.onHoldCall(requestId, uuid.getUuid()));
        }

        @Override
        public void onUnholdCall(int requestId, ParcelUuid uuid) {
            BluetoothUtils.executeFromBinder(this.mExecutor, () -> this.mCallback.onUnholdCall(requestId, uuid.getUuid()));
        }

        @Override
        public void onPlaceCall(int requestId, ParcelUuid uuid, String uri) {
            BluetoothUtils.executeFromBinder(this.mExecutor, () -> this.mCallback.onPlaceCall(requestId, uuid.getUuid(), uri));
        }

        @Override
        public void onJoinCalls(int requestId, List<ParcelUuid> parcelUuids) {
            ArrayList<UUID> uuids = new ArrayList<UUID>();
            for (ParcelUuid parcelUuid : parcelUuids) {
                uuids.add(parcelUuid.getUuid());
            }
            BluetoothUtils.executeFromBinder(this.mExecutor, () -> this.mCallback.onJoinCalls(requestId, uuids));
        }
    }
}

