/*
 * Decompiled with CFR 0.152.
 */
package android.app.wallpapereffectsgeneration;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class TexturedMesh
implements Parcelable {
    @NonNull
    private Bitmap mBitmap;
    @NonNull
    private int[] mIndices;
    @NonNull
    private float[] mVertices;
    public static final int INDICES_LAYOUT_UNDEFINED = 0;
    public static final int INDICES_LAYOUT_TRIANGLES = 1;
    private int mIndicesLayoutType;
    public static final int VERTICES_LAYOUT_UNDEFINED = 0;
    public static final int VERTICES_LAYOUT_POSITION3_UV2 = 1;
    private int mVerticesLayoutType;
    @NonNull
    public static final Parcelable.Creator<TexturedMesh> CREATOR = new Parcelable.Creator<TexturedMesh>(){

        @Override
        public TexturedMesh createFromParcel(Parcel in) {
            return new TexturedMesh(in);
        }

        public TexturedMesh[] newArray(int size) {
            return new TexturedMesh[size];
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TexturedMesh(Parcel in) {
        this.mIndicesLayoutType = in.readInt();
        this.mVerticesLayoutType = in.readInt();
        this.mBitmap = in.readTypedObject(Bitmap.CREATOR);
        Parcel data = Parcel.obtain();
        try {
            byte[] bytes = in.readBlob();
            data.unmarshall(bytes, 0, bytes.length);
            data.setDataPosition(0);
            this.mIndices = data.createIntArray();
            this.mVertices = data.createFloatArray();
        }
        finally {
            data.recycle();
        }
    }

    private TexturedMesh(@NonNull Bitmap bitmap, @NonNull int[] indices, @NonNull float[] vertices, int indicesLayoutType, int verticesLayoutType) {
        this.mBitmap = bitmap;
        this.mIndices = indices;
        this.mVertices = vertices;
        this.mIndicesLayoutType = indicesLayoutType;
        this.mVerticesLayoutType = verticesLayoutType;
    }

    @NonNull
    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    @NonNull
    public int[] getIndices() {
        return this.mIndices;
    }

    @NonNull
    public float[] getVertices() {
        return this.mVertices;
    }

    @NonNull
    public int getIndicesLayoutType() {
        return this.mIndicesLayoutType;
    }

    @NonNull
    public int getVerticesLayoutType() {
        return this.mVerticesLayoutType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mIndicesLayoutType);
        out.writeInt(this.mVerticesLayoutType);
        out.writeTypedObject(this.mBitmap, flags);
        Parcel data = Parcel.obtain();
        try {
            data.writeIntArray(this.mIndices);
            data.writeFloatArray(this.mVertices);
            out.writeBlob(data.marshall());
        }
        finally {
            data.recycle();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @SystemApi
    public static class Builder {
        private Bitmap mBitmap;
        private int[] mIndices;
        private float[] mVertices;
        private int mIndicesLayoutType;
        private int mVerticesLayouttype;

        @SystemApi
        public Builder(@NonNull Bitmap bitmap) {
            this.mBitmap = bitmap;
        }

        @NonNull
        public Builder setIndices(@NonNull int[] indices) {
            this.mIndices = indices;
            return this;
        }

        @NonNull
        public Builder setVertices(@NonNull float[] vertices) {
            this.mVertices = vertices;
            return this;
        }

        @NonNull
        public Builder setIndicesLayoutType(int indicesLayoutType) {
            this.mIndicesLayoutType = indicesLayoutType;
            return this;
        }

        @NonNull
        public Builder setVerticesLayoutType(int verticesLayoutype) {
            this.mVerticesLayouttype = verticesLayoutype;
            return this;
        }

        @NonNull
        public TexturedMesh build() {
            return new TexturedMesh(this.mBitmap, this.mIndices, this.mVertices, this.mIndicesLayoutType, this.mVerticesLayouttype);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VerticesLayoutType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IndicesLayoutType {
    }
}

