/*
 * Decompiled with CFR 0.152.
 */
package android.app.wallpaper;

import android.annotation.FlaggedApi;
import android.annotation.SystemApi;
import android.app.WallpaperManager;
import android.content.ComponentName;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.text.Html;
import android.text.Spanned;
import android.text.SpannedString;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

@FlaggedApi(value="android.app.live_wallpaper_content_handling")
public class WallpaperDescription
implements Parcelable {
    private static final String TAG = "WallpaperDescription";
    private static final String XML_TAG_CONTENT = "content";
    private static final String XML_TAG_DESCRIPTION = "description";
    @Nullable
    private final ComponentName mComponent;
    @Nullable
    private final String mId;
    @Nullable
    private final Uri mThumbnail;
    @Nullable
    private final CharSequence mTitle;
    @NonNull
    private final List<CharSequence> mDescription;
    @Nullable
    private final Uri mContextUri;
    @Nullable
    private final CharSequence mContextDescription;
    @NonNull
    private final PersistableBundle mContent;
    @NonNull
    private final SparseArray<Rect> mCropHints;
    private final float mSampleSize;
    @NonNull
    public static final Parcelable.Creator<WallpaperDescription> CREATOR = new Parcelable.Creator<WallpaperDescription>(){

        @Override
        public WallpaperDescription createFromParcel(Parcel source) {
            return new WallpaperDescription(source);
        }

        public WallpaperDescription[] newArray(int size) {
            return new WallpaperDescription[size];
        }
    };

    private WallpaperDescription(@Nullable ComponentName component, @Nullable String id2, @Nullable Uri thumbnail, @Nullable CharSequence title, @Nullable List<CharSequence> description, @Nullable Uri contextUri, @Nullable CharSequence contextDescription, @Nullable PersistableBundle content, @NonNull SparseArray<Rect> cropHints, float sampleSize) {
        this.mComponent = component;
        this.mId = id2;
        this.mThumbnail = thumbnail;
        this.mTitle = title;
        this.mDescription = description != null ? description : new ArrayList();
        this.mContextUri = contextUri;
        this.mContextDescription = contextDescription;
        this.mContent = content != null ? content : new PersistableBundle();
        this.mCropHints = cropHints;
        this.mSampleSize = sampleSize;
    }

    @Nullable
    public ComponentName getComponent() {
        return this.mComponent;
    }

    @Nullable
    public String getId() {
        return this.mId;
    }

    @Nullable
    public Uri getThumbnail() {
        return this.mThumbnail;
    }

    @Nullable
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @NonNull
    public List<CharSequence> getDescription() {
        return this.mDescription;
    }

    @Nullable
    public Uri getContextUri() {
        return this.mContextUri;
    }

    @Nullable
    public CharSequence getContextDescription() {
        return this.mContextDescription;
    }

    @NonNull
    public PersistableBundle getContent() {
        return this.mContent;
    }

    @SystemApi
    @NonNull
    public SparseArray<Rect> getCropHints() {
        return this.mCropHints;
    }

    public float getSampleSize() {
        return this.mSampleSize;
    }

    public String toString() {
        String component = this.mComponent != null ? this.mComponent.toString() : "{null}";
        return component + ":" + this.mId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WallpaperDescription)) {
            return false;
        }
        WallpaperDescription that = (WallpaperDescription)o;
        return Objects.equals(this.mComponent, that.mComponent) && Objects.equals(this.mId, that.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mComponent, this.mId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToXml(TypedXmlSerializer out) throws IOException, XmlPullParserException {
        if (this.mComponent != null) {
            out.attribute(null, "component", this.mComponent.flattenToShortString());
        }
        if (this.mId != null) {
            out.attribute(null, "id", this.mId);
        }
        if (this.mThumbnail != null) {
            out.attribute(null, "thumbnail", this.mThumbnail.toString());
        }
        if (this.mTitle != null) {
            out.attribute(null, "title", WallpaperDescription.toHtml(this.mTitle));
        }
        if (this.mContextUri != null) {
            out.attribute(null, "contexturi", this.mContextUri.toString());
        }
        if (this.mContextDescription != null) {
            out.attribute(null, "contextdescription", WallpaperDescription.toHtml(this.mContextDescription));
        }
        for (Pair<Integer, String> pair : WallpaperDescription.screenDimensionPairs()) {
            int orientation = (Integer)pair.first;
            String attrName = (String)pair.second;
            Rect cropHint = this.mCropHints.get(orientation);
            if (cropHint == null) continue;
            out.attributeInt(null, "cropLeft" + attrName, cropHint.left);
            out.attributeInt(null, "cropTop" + attrName, cropHint.top);
            out.attributeInt(null, "cropRight" + attrName, cropHint.right);
            out.attributeInt(null, "cropBottom" + attrName, cropHint.bottom);
        }
        out.attributeFloat(null, "sampleSize", this.mSampleSize);
        out.startTag(null, XML_TAG_DESCRIPTION);
        for (CharSequence s : this.mDescription) {
            out.attribute(null, "descriptionline", WallpaperDescription.toHtml(s));
        }
        out.endTag(null, XML_TAG_DESCRIPTION);
        try {
            out.startTag(null, XML_TAG_CONTENT);
            this.mContent.saveToXml(out);
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "unable to convert wallpaper content to XML");
        }
        finally {
            out.endTag(null, XML_TAG_CONTENT);
        }
    }

    public static WallpaperDescription restoreFromXml(TypedXmlPullParser in) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = in.getDepth();
        String component = in.getAttributeValue(null, "component");
        ComponentName componentName = component != null ? ComponentName.unflattenFromString(component) : null;
        String id2 = in.getAttributeValue(null, "id");
        String thumbnailString = in.getAttributeValue(null, "thumbnail");
        Uri thumbnail = thumbnailString != null ? Uri.parse(thumbnailString) : null;
        CharSequence title = WallpaperDescription.fromHtml(in.getAttributeValue(null, "title"));
        String contextUriString = in.getAttributeValue(null, "contexturi");
        Uri contextUri = contextUriString != null ? Uri.parse(contextUriString) : null;
        CharSequence contextDescription = WallpaperDescription.fromHtml(in.getAttributeValue(null, "contextdescription"));
        SparseArray<Rect> cropHints = new SparseArray<Rect>();
        WallpaperDescription.screenDimensionPairs().forEach(pair -> {
            int orientation = (Integer)pair.first;
            String attrName = (String)pair.second;
            Rect crop = new Rect(in.getAttributeInt(null, "cropLeft" + attrName, 0), in.getAttributeInt(null, "cropTop" + attrName, 0), in.getAttributeInt(null, "cropRight" + attrName, 0), in.getAttributeInt(null, "cropBottom" + attrName, 0));
            if (!crop.isEmpty()) {
                cropHints.put(orientation, crop);
            }
        });
        float sampleSize = in.getAttributeFloat(null, "sampleSize", 1.0f);
        ArrayList<CharSequence> description = new ArrayList<CharSequence>();
        PersistableBundle content = null;
        while ((type = in.next()) != 1 && (type != 3 || in.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String name = in.getName();
            if (XML_TAG_DESCRIPTION.equals(name)) {
                for (int i = 0; i < in.getAttributeCount(); ++i) {
                    description.add(WallpaperDescription.fromHtml(in.getAttributeValue(i)));
                }
                continue;
            }
            if (!XML_TAG_CONTENT.equals(name)) continue;
            content = PersistableBundle.restoreFromXml(in);
        }
        return new WallpaperDescription(componentName, id2, thumbnail, title, description, contextUri, contextDescription, content, cropHints, sampleSize);
    }

    private static String toHtml(@NonNull CharSequence c) {
        Spanned s = c instanceof Spanned ? (Spanned)c : new SpannedString(c);
        return Html.toHtml(s, 1);
    }

    private static CharSequence fromHtml(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return WallpaperDescription.removeTrailingWhitespace(Html.fromHtml(text, 63));
    }

    private static CharSequence removeTrailingWhitespace(CharSequence s) {
        int end;
        if (s == null) {
            return null;
        }
        for (end = s.length(); end > 0 && Character.isWhitespace(s.charAt(end - 1)); --end) {
        }
        return s.subSequence(0, end);
    }

    WallpaperDescription(@NonNull Parcel in) {
        this.mComponent = ComponentName.readFromParcel(in);
        this.mId = in.readString8();
        this.mThumbnail = Uri.CREATOR.createFromParcel(in);
        this.mTitle = in.readCharSequence();
        this.mDescription = Arrays.stream(in.readCharSequenceArray()).toList();
        this.mContextUri = Uri.CREATOR.createFromParcel(in);
        this.mContextDescription = in.readCharSequence();
        this.mContent = PersistableBundle.CREATOR.createFromParcel(in);
        this.mCropHints = new SparseArray();
        WallpaperDescription.screenDimensionPairs().forEach(pair -> {
            int orientation = (Integer)pair.first;
            Rect crop = in.readTypedObject(Rect.CREATOR);
            if (crop != null) {
                this.mCropHints.put(orientation, crop);
            }
        });
        this.mSampleSize = in.readFloat();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        ComponentName.writeToParcel(this.mComponent, dest);
        dest.writeString8(this.mId);
        Uri.writeToParcel(dest, this.mThumbnail);
        dest.writeCharSequence(this.mTitle);
        dest.writeCharSequenceArray(this.mDescription.toArray(new CharSequence[0]));
        Uri.writeToParcel(dest, this.mContextUri);
        dest.writeCharSequence(this.mContextDescription);
        dest.writePersistableBundle(this.mContent);
        WallpaperDescription.screenDimensionPairs().forEach(pair -> {
            int orientation = (Integer)pair.first;
            dest.writeTypedObject(this.mCropHints.get(orientation), flags);
        });
        dest.writeFloat(this.mSampleSize);
    }

    @NonNull
    public Builder toBuilder() {
        return new Builder().setComponent(this.mComponent).setId(this.mId).setThumbnail(this.mThumbnail).setTitle(this.mTitle).setDescription(this.mDescription).setContextUri(this.mContextUri).setContextDescription(this.mContextDescription).setContent(this.mContent).setCropHints(this.mCropHints).setSampleSize(this.mSampleSize);
    }

    private static List<Pair<Integer, String>> screenDimensionPairs() {
        return List.of(new Pair<Integer, String>(-1, "Unknown"), new Pair<Integer, String>(0, "Portrait"), new Pair<Integer, String>(1, "Landscape"), new Pair<Integer, String>(2, "SquarePortrait"), new Pair<Integer, String>(3, "SquareLandscape"));
    }

    public static class Builder {
        @Nullable
        private ComponentName mComponent;
        @Nullable
        private String mId;
        @Nullable
        private Uri mThumbnail;
        @Nullable
        private CharSequence mTitle;
        @NonNull
        private List<CharSequence> mDescription = new ArrayList<CharSequence>();
        @Nullable
        private Uri mContextUri;
        @Nullable
        private CharSequence mContextDescription;
        @NonNull
        private PersistableBundle mContent = new PersistableBundle();
        @NonNull
        private SparseArray<Rect> mCropHints = new SparseArray();
        private float mSampleSize = 1.0f;

        @NonNull
        public Builder setComponent(@Nullable ComponentName component) {
            this.mComponent = component;
            return this;
        }

        @NonNull
        public Builder setId(@Nullable String id2) {
            this.mId = id2;
            return this;
        }

        @NonNull
        public Builder setThumbnail(@Nullable Uri thumbnail) {
            this.mThumbnail = thumbnail;
            return this;
        }

        @NonNull
        public Builder setTitle(@Nullable CharSequence title) {
            this.mTitle = title;
            return this;
        }

        @NonNull
        public Builder setDescription(@NonNull List<CharSequence> description) {
            this.mDescription = description;
            return this;
        }

        @NonNull
        public Builder setContextUri(@Nullable Uri contextUri) {
            this.mContextUri = contextUri;
            return this;
        }

        @NonNull
        public Builder setContextDescription(@Nullable CharSequence contextDescription) {
            this.mContextDescription = contextDescription;
            return this;
        }

        @NonNull
        public Builder setContent(@NonNull PersistableBundle content) {
            this.mContent = content;
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setCropHints(@NonNull Map<Point, Rect> cropHints) {
            this.mCropHints = new SparseArray();
            cropHints.forEach((point, rect) -> this.mCropHints.put(WallpaperManager.getOrientation(point), (Rect)rect));
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setCropHints(@NonNull SparseArray<Rect> cropHints) {
            this.mCropHints = cropHints;
            return this;
        }

        @NonNull
        public Builder setSampleSize(float sampleSize) {
            this.mSampleSize = sampleSize;
            return this;
        }

        @NonNull
        public WallpaperDescription build() {
            return new WallpaperDescription(this.mComponent, this.mId, this.mThumbnail, this.mTitle, this.mDescription, this.mContextUri, this.mContextDescription, this.mContent, this.mCropHints, this.mSampleSize);
        }
    }
}

