/*
 * Decompiled with CFR 0.152.
 */
package android.app.supervision;

import android.annotation.RequiresPermission;
import android.app.supervision.ISupervisionListener;
import android.app.supervision.SupervisionRecoveryInfo;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISupervisionManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.supervision.ISupervisionManager";

    public Intent createConfirmSupervisionCredentialsIntent(int var1) throws RemoteException;

    public boolean isSupervisionEnabledForUser(int var1) throws RemoteException;

    public void setSupervisionEnabledForUser(int var1, boolean var2) throws RemoteException;

    public String getActiveSupervisionAppPackage(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public boolean shouldAllowBypassingSupervisionRoleQualification() throws RemoteException;

    public void setSupervisionRecoveryInfo(SupervisionRecoveryInfo var1) throws RemoteException;

    public SupervisionRecoveryInfo getSupervisionRecoveryInfo() throws RemoteException;

    public boolean hasSupervisionCredentials() throws RemoteException;

    public void registerSupervisionListener(ISupervisionListener var1) throws RemoteException;

    public void unregisterSupervisionListener(ISupervisionListener var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISupervisionManager {
        static final int TRANSACTION_createConfirmSupervisionCredentialsIntent = 1;
        static final int TRANSACTION_isSupervisionEnabledForUser = 2;
        static final int TRANSACTION_setSupervisionEnabledForUser = 3;
        static final int TRANSACTION_getActiveSupervisionAppPackage = 4;
        static final int TRANSACTION_shouldAllowBypassingSupervisionRoleQualification = 5;
        static final int TRANSACTION_setSupervisionRecoveryInfo = 6;
        static final int TRANSACTION_getSupervisionRecoveryInfo = 7;
        static final int TRANSACTION_hasSupervisionCredentials = 8;
        static final int TRANSACTION_registerSupervisionListener = 9;
        static final int TRANSACTION_unregisterSupervisionListener = 10;

        public Stub() {
            this.attachInterface(this, ISupervisionManager.DESCRIPTOR);
        }

        public static ISupervisionManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISupervisionManager.DESCRIPTOR);
            if (iin != null && iin instanceof ISupervisionManager) {
                return (ISupervisionManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createConfirmSupervisionCredentialsIntent";
                }
                case 2: {
                    return "isSupervisionEnabledForUser";
                }
                case 3: {
                    return "setSupervisionEnabledForUser";
                }
                case 4: {
                    return "getActiveSupervisionAppPackage";
                }
                case 5: {
                    return "shouldAllowBypassingSupervisionRoleQualification";
                }
                case 6: {
                    return "setSupervisionRecoveryInfo";
                }
                case 7: {
                    return "getSupervisionRecoveryInfo";
                }
                case 8: {
                    return "hasSupervisionCredentials";
                }
                case 9: {
                    return "registerSupervisionListener";
                }
                case 10: {
                    return "unregisterSupervisionListener";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISupervisionManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Intent _result = this.createConfirmSupervisionCredentialsIntent(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSupervisionEnabledForUser(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSupervisionEnabledForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getActiveSupervisionAppPackage(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 5: {
                    boolean _result = this.shouldAllowBypassingSupervisionRoleQualification();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    SupervisionRecoveryInfo _arg0 = data.readTypedObject(SupervisionRecoveryInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.setSupervisionRecoveryInfo(_arg0);
                    break;
                }
                case 7: {
                    SupervisionRecoveryInfo _result = this.getSupervisionRecoveryInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    boolean _result = this.hasSupervisionCredentials();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    ISupervisionListener _arg0 = ISupervisionListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSupervisionListener(_arg0);
                    break;
                }
                case 10: {
                    ISupervisionListener _arg0 = ISupervisionListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSupervisionListener(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 9;
        }

        private static class Proxy
        implements ISupervisionManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISupervisionManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Intent createConfirmSupervisionCredentialsIntent(int userId) throws RemoteException {
                Intent _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISupervisionManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Intent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSupervisionEnabledForUser(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISupervisionManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSupervisionEnabledForUser(int userId, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISupervisionManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getActiveSupervisionAppPackage(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISupervisionManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldAllowBypassingSupervisionRoleQualification() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISupervisionManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSupervisionRecoveryInfo(SupervisionRecoveryInfo recoveryInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISupervisionManager.DESCRIPTOR);
                    _data.writeTypedObject(recoveryInfo, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SupervisionRecoveryInfo getSupervisionRecoveryInfo() throws RemoteException {
                SupervisionRecoveryInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISupervisionManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SupervisionRecoveryInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasSupervisionCredentials() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISupervisionManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSupervisionListener(ISupervisionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISupervisionManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSupervisionListener(ISupervisionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISupervisionManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISupervisionManager {
        @Override
        public Intent createConfirmSupervisionCredentialsIntent(int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isSupervisionEnabledForUser(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setSupervisionEnabledForUser(int userId, boolean enabled) throws RemoteException {
        }

        @Override
        public String getActiveSupervisionAppPackage(int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean shouldAllowBypassingSupervisionRoleQualification() throws RemoteException {
            return false;
        }

        @Override
        public void setSupervisionRecoveryInfo(SupervisionRecoveryInfo recoveryInfo) throws RemoteException {
        }

        @Override
        public SupervisionRecoveryInfo getSupervisionRecoveryInfo() throws RemoteException {
            return null;
        }

        @Override
        public boolean hasSupervisionCredentials() throws RemoteException {
            return false;
        }

        @Override
        public void registerSupervisionListener(ISupervisionListener listener) throws RemoteException {
        }

        @Override
        public void unregisterSupervisionListener(ISupervisionListener listener) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

