/*
 * Decompiled with CFR 0.152.
 */
package android.app.smartspace;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class SmartspaceConfig
implements Parcelable {
    private final int mSmartspaceTargetCount;
    @NonNull
    private final String mUiSurface;
    @NonNull
    private String mPackageName;
    @Nullable
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<SmartspaceConfig> CREATOR = new Parcelable.Creator<SmartspaceConfig>(){

        @Override
        public SmartspaceConfig createFromParcel(Parcel parcel) {
            return new SmartspaceConfig(parcel);
        }

        public SmartspaceConfig[] newArray(int size) {
            return new SmartspaceConfig[size];
        }
    };

    private SmartspaceConfig(@NonNull String uiSurface, int numPredictedTargets, @NonNull String packageName, @Nullable Bundle extras) {
        this.mUiSurface = uiSurface;
        this.mSmartspaceTargetCount = numPredictedTargets;
        this.mPackageName = packageName;
        this.mExtras = extras;
    }

    private SmartspaceConfig(Parcel parcel) {
        this.mUiSurface = parcel.readString();
        this.mSmartspaceTargetCount = parcel.readInt();
        this.mPackageName = parcel.readString();
        this.mExtras = parcel.readBundle();
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public int getSmartspaceTargetCount() {
        return this.mSmartspaceTargetCount;
    }

    @NonNull
    public String getUiSurface() {
        return this.mUiSurface;
    }

    @Nullable
    @SuppressLint(value={"NullableCollection"})
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mUiSurface);
        dest.writeInt(this.mSmartspaceTargetCount);
        dest.writeString(this.mPackageName);
        dest.writeBundle(this.mExtras);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmartspaceConfig that = (SmartspaceConfig)o;
        return this.mSmartspaceTargetCount == that.mSmartspaceTargetCount && Objects.equals(this.mUiSurface, that.mUiSurface) && Objects.equals(this.mPackageName, that.mPackageName) && Objects.equals(this.mExtras, that.mExtras);
    }

    public int hashCode() {
        return Objects.hash(this.mSmartspaceTargetCount, this.mUiSurface, this.mPackageName, this.mExtras);
    }

    @SystemApi
    public static class Builder {
        @NonNull
        private int mSmartspaceTargetCount = 5;
        @NonNull
        private final String mUiSurface;
        @NonNull
        private final String mPackageName;
        @NonNull
        private Bundle mExtras = Bundle.EMPTY;

        @SystemApi
        public Builder(@NonNull Context context, @NonNull String uiSurface) {
            this.mPackageName = context.getPackageName();
            this.mUiSurface = uiSurface;
        }

        @NonNull
        public Builder setSmartspaceTargetCount(int smartspaceTargetCount) {
            this.mSmartspaceTargetCount = smartspaceTargetCount;
            return this;
        }

        @NonNull
        public Builder setExtras(@SuppressLint(value={"NullableCollection"}) @NonNull Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public SmartspaceConfig build() {
            return new SmartspaceConfig(this.mUiSurface, this.mSmartspaceTargetCount, this.mPackageName, this.mExtras);
        }
    }
}

