/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityClient;
import android.app.ActivityThread;
import android.app.ClientTransactionHandler;
import android.app.servertransaction.ActivityLifecycleItem;
import android.app.servertransaction.PendingTransactionActions;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Trace;

public class PauseActivityItem
extends ActivityLifecycleItem {
    private final boolean mFinished;
    private final boolean mUserLeaving;
    private final boolean mDontReport;
    private final boolean mAutoEnteringPip;
    @NonNull
    public static final Parcelable.Creator<PauseActivityItem> CREATOR = new Parcelable.Creator<PauseActivityItem>(){

        @Override
        public PauseActivityItem createFromParcel(@NonNull Parcel in) {
            return new PauseActivityItem(in);
        }

        public PauseActivityItem[] newArray(int size) {
            return new PauseActivityItem[size];
        }
    };

    public PauseActivityItem(@NonNull IBinder activityToken) {
        this(activityToken, false, false, true, false);
    }

    public PauseActivityItem(@NonNull IBinder activityToken, boolean finished, boolean userLeaving, boolean dontReport, boolean autoEnteringPip) {
        super(activityToken);
        this.mFinished = finished;
        this.mUserLeaving = userLeaving;
        this.mDontReport = dontReport;
        this.mAutoEnteringPip = autoEnteringPip;
    }

    @Override
    public void execute(@NonNull ClientTransactionHandler client, @NonNull ActivityThread.ActivityClientRecord r, @NonNull PendingTransactionActions pendingActions) {
        Trace.traceBegin(64L, "activityPause");
        client.handlePauseActivity(r, this.mFinished, this.mUserLeaving, this.mAutoEnteringPip, pendingActions, "PAUSE_ACTIVITY_ITEM");
        Trace.traceEnd(64L);
    }

    @Override
    public int getTargetState() {
        return 4;
    }

    @Override
    public void postExecute(@NonNull ClientTransactionHandler client, @NonNull PendingTransactionActions pendingActions) {
        if (this.mDontReport) {
            return;
        }
        ActivityClient.getInstance().activityPaused(this.getActivityToken());
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeBoolean(this.mFinished);
        dest.writeBoolean(this.mUserLeaving);
        dest.writeBoolean(this.mDontReport);
        dest.writeBoolean(this.mAutoEnteringPip);
    }

    private PauseActivityItem(@NonNull Parcel in) {
        super(in);
        this.mFinished = in.readBoolean();
        this.mUserLeaving = in.readBoolean();
        this.mDontReport = in.readBoolean();
        this.mAutoEnteringPip = in.readBoolean();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        PauseActivityItem other = (PauseActivityItem)o;
        return this.mFinished == other.mFinished && this.mUserLeaving == other.mUserLeaving && this.mDontReport == other.mDontReport && this.mAutoEnteringPip == other.mAutoEnteringPip;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.mFinished ? 1 : 0);
        result = 31 * result + (this.mUserLeaving ? 1 : 0);
        result = 31 * result + (this.mDontReport ? 1 : 0);
        result = 31 * result + (this.mAutoEnteringPip ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "PauseActivityItem{" + super.toString() + ",finished=" + this.mFinished + ",userLeaving=" + this.mUserLeaving + ",dontReport=" + this.mDontReport + ",autoEnteringPip=" + this.mAutoEnteringPip + "}";
    }
}

