/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.ClientTransactionHandler;
import android.app.ResultInfo;
import android.app.compat.CompatChanges;
import android.app.servertransaction.ActivityTransactionItem;
import android.app.servertransaction.PendingTransactionActions;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Trace;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ActivityResultItem
extends ActivityTransactionItem {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private List<ResultInfo> mResultInfoList;
    public static final long CALL_ACTIVITY_RESULT_BEFORE_RESUME = 78294732L;
    @NonNull
    public static final Parcelable.Creator<ActivityResultItem> CREATOR = new Parcelable.Creator<ActivityResultItem>(){

        @Override
        public ActivityResultItem createFromParcel(@NonNull Parcel in) {
            return new ActivityResultItem(in);
        }

        public ActivityResultItem[] newArray(int size) {
            return new ActivityResultItem[size];
        }
    };

    public ActivityResultItem(@NonNull IBinder activityToken, @NonNull List<ResultInfo> resultInfoList) {
        super(activityToken);
        this.mResultInfoList = new ArrayList<ResultInfo>(resultInfoList);
    }

    @Override
    public int getPostExecutionState() {
        return CompatChanges.isChangeEnabled(78294732L) ? 3 : -1;
    }

    @Override
    public void execute(@NonNull ClientTransactionHandler client, @NonNull ActivityThread.ActivityClientRecord r, @NonNull PendingTransactionActions pendingActions) {
        Trace.traceBegin(64L, "activityDeliverResult");
        client.handleSendResult(r, this.mResultInfoList, "ACTIVITY_RESULT");
        Trace.traceEnd(64L);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeTypedList(this.mResultInfoList, flags);
    }

    private ActivityResultItem(@NonNull Parcel in) {
        super(in);
        this.mResultInfoList = in.createTypedArrayList(ResultInfo.CREATOR);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ActivityResultItem other = (ActivityResultItem)o;
        return Objects.equals(this.mResultInfoList, other.mResultInfoList);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + super.hashCode();
        result = 31 * result + Objects.hashCode(this.mResultInfoList);
        return result;
    }

    @Override
    public String toString() {
        return "ActivityResultItem{" + super.toString() + ",resultInfoList=" + this.mResultInfoList + "}";
    }
}

