/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class SandboxLatencyInfo
implements Parcelable {
    public static final int METHOD_UNSPECIFIED = 0;
    public static final int METHOD_LOAD_SDK = 1;
    public static final int METHOD_REQUEST_SURFACE_PACKAGE = 3;
    public static final int METHOD_GET_SANDBOXED_SDKS = 5;
    public static final int METHOD_SYNC_DATA_FROM_CLIENT = 6;
    public static final int METHOD_UNLOAD_SDK = 7;
    public static final int METHOD_ADD_SDK_SANDBOX_LIFECYCLE_CALLBACK = 8;
    public static final int METHOD_REMOVE_SDK_SANDBOX_LIFECYCLE_CALLBACK = 9;
    public static final int METHOD_GET_SANDBOXED_SDKS_VIA_CONTROLLER = 10;
    public static final int METHOD_REGISTER_APP_OWNED_SDK_SANDBOX_INTERFACE = 11;
    public static final int METHOD_UNREGISTER_APP_OWNED_SDK_SANDBOX_INTERFACE = 12;
    public static final int METHOD_GET_APP_OWNED_SDK_SANDBOX_INTERFACES = 13;
    public static final int METHOD_LOAD_SDK_VIA_CONTROLLER = 14;
    public static final int SANDBOX_STATUS_SUCCESS = 1;
    public static final int SANDBOX_STATUS_FAILED_AT_APP_TO_SYSTEM_SERVER = 2;
    public static final int SANDBOX_STATUS_FAILED_AT_SYSTEM_SERVER_APP_TO_SANDBOX = 3;
    public static final int SANDBOX_STATUS_FAILED_AT_LOAD_SANDBOX = 4;
    public static final int SANDBOX_STATUS_FAILED_AT_SYSTEM_SERVER_TO_SANDBOX = 5;
    public static final int SANDBOX_STATUS_FAILED_AT_SANDBOX = 6;
    public static final int SANDBOX_STATUS_FAILED_AT_SDK = 7;
    public static final int SANDBOX_STATUS_FAILED_AT_SANDBOX_TO_SYSTEM_SERVER = 8;
    public static final int SANDBOX_STATUS_FAILED_AT_SYSTEM_SERVER_SANDBOX_TO_APP = 9;
    public static final int SANDBOX_STATUS_FAILED_AT_SYSTEM_SERVER_TO_APP = 10;
    public static final int RESULT_CODE_UNSPECIFIED = 0;
    public static final int RESULT_CODE_LOAD_SDK_NOT_FOUND = 1;
    public static final int RESULT_CODE_LOAD_SDK_ALREADY_LOADED = 2;
    public static final int RESULT_CODE_LOAD_SDK_SDK_DEFINED_ERROR = 3;
    public static final int RESULT_CODE_LOAD_SDK_SDK_SANDBOX_DISABLED = 4;
    public static final int RESULT_CODE_LOAD_SDK_INTERNAL_ERROR = 5;
    public static final int RESULT_CODE_SDK_SANDBOX_PROCESS_NOT_AVAILABLE = 6;
    private final int mMethod;
    private long mTimeAppCalledSystemServer = -1L;
    private long mTimeSystemServerReceivedCallFromApp = -1L;
    private long mTimeLoadSandboxStarted = -1L;
    private long mTimeSandboxLoaded = -1L;
    private long mTimeSystemServerCallFinished = -1L;
    private long mTimeSandboxReceivedCallFromSystemServer = -1L;
    private long mTimeSandboxCalledSdk = -1L;
    private long mTimeSdkCallCompleted = -1L;
    private long mTimeSandboxCalledSystemServer = -1L;
    private long mTimeSystemServerReceivedCallFromSandbox = -1L;
    private long mTimeSystemServerCalledApp = -1L;
    private long mTimeAppReceivedCallFromSystemServer = -1L;
    private int mSandboxStatus = 1;
    private int mResultCode = 0;
    @NonNull
    public static final Parcelable.Creator<SandboxLatencyInfo> CREATOR = new Parcelable.Creator<SandboxLatencyInfo>(){

        @Override
        public SandboxLatencyInfo createFromParcel(Parcel in) {
            return new SandboxLatencyInfo(in);
        }

        public SandboxLatencyInfo[] newArray(int size) {
            return new SandboxLatencyInfo[size];
        }
    };

    public SandboxLatencyInfo(int method) {
        this.mMethod = method;
    }

    public SandboxLatencyInfo() {
        this.mMethod = 0;
    }

    private SandboxLatencyInfo(Parcel in) {
        this.mMethod = in.readInt();
        this.mTimeAppCalledSystemServer = in.readLong();
        this.mTimeSystemServerReceivedCallFromApp = in.readLong();
        this.mTimeLoadSandboxStarted = in.readLong();
        this.mTimeSandboxLoaded = in.readLong();
        this.mTimeSystemServerCallFinished = in.readLong();
        this.mTimeSandboxReceivedCallFromSystemServer = in.readLong();
        this.mTimeSandboxCalledSdk = in.readLong();
        this.mTimeSdkCallCompleted = in.readLong();
        this.mTimeSandboxCalledSystemServer = in.readLong();
        this.mTimeSystemServerReceivedCallFromSandbox = in.readLong();
        this.mTimeSystemServerCalledApp = in.readLong();
        this.mTimeAppReceivedCallFromSystemServer = in.readLong();
        this.mSandboxStatus = in.readInt();
        this.mResultCode = in.readInt();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SandboxLatencyInfo)) {
            return false;
        }
        SandboxLatencyInfo that = (SandboxLatencyInfo)object;
        return this.mMethod == that.mMethod && this.mTimeAppCalledSystemServer == that.mTimeAppCalledSystemServer && this.mTimeSystemServerReceivedCallFromApp == that.mTimeSystemServerReceivedCallFromApp && this.mTimeLoadSandboxStarted == that.mTimeLoadSandboxStarted && this.mTimeSandboxLoaded == that.mTimeSandboxLoaded && this.mTimeSystemServerCallFinished == that.mTimeSystemServerCallFinished && this.mTimeSandboxReceivedCallFromSystemServer == that.mTimeSandboxReceivedCallFromSystemServer && this.mTimeSandboxCalledSdk == that.mTimeSandboxCalledSdk && this.mTimeSdkCallCompleted == that.mTimeSdkCallCompleted && this.mTimeSandboxCalledSystemServer == that.mTimeSandboxCalledSystemServer && this.mTimeSystemServerReceivedCallFromSandbox == that.mTimeSystemServerReceivedCallFromSandbox && this.mTimeSystemServerCalledApp == that.mTimeSystemServerCalledApp && this.mTimeAppReceivedCallFromSystemServer == that.mTimeAppReceivedCallFromSystemServer && this.mSandboxStatus == that.mSandboxStatus && this.mResultCode == that.mResultCode;
    }

    public int hashCode() {
        return Objects.hash(this.mMethod, this.mTimeAppCalledSystemServer, this.mTimeSystemServerReceivedCallFromApp, this.mTimeLoadSandboxStarted, this.mTimeSandboxLoaded, this.mTimeSystemServerCallFinished, this.mTimeSandboxReceivedCallFromSystemServer, this.mTimeSandboxCalledSdk, this.mTimeSdkCallCompleted, this.mTimeSandboxCalledSystemServer, this.mTimeSystemServerReceivedCallFromSandbox, this.mTimeSystemServerCalledApp, this.mTimeAppReceivedCallFromSystemServer, this.mSandboxStatus, this.mResultCode);
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mMethod);
        out.writeLong(this.mTimeAppCalledSystemServer);
        out.writeLong(this.mTimeSystemServerReceivedCallFromApp);
        out.writeLong(this.mTimeLoadSandboxStarted);
        out.writeLong(this.mTimeSandboxLoaded);
        out.writeLong(this.mTimeSystemServerCallFinished);
        out.writeLong(this.mTimeSandboxReceivedCallFromSystemServer);
        out.writeLong(this.mTimeSandboxCalledSdk);
        out.writeLong(this.mTimeSdkCallCompleted);
        out.writeLong(this.mTimeSandboxCalledSystemServer);
        out.writeLong(this.mTimeSystemServerReceivedCallFromSandbox);
        out.writeLong(this.mTimeSystemServerCalledApp);
        out.writeLong(this.mTimeAppReceivedCallFromSystemServer);
        out.writeInt(this.mSandboxStatus);
        out.writeInt(this.mResultCode);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getMethod() {
        return this.mMethod;
    }

    public void setTimeAppCalledSystemServer(long timeAppCalledSystemServer) {
        this.mTimeAppCalledSystemServer = timeAppCalledSystemServer;
    }

    public void setTimeSystemServerReceivedCallFromApp(long timeSystemServerReceivedCallFromApp) {
        this.mTimeSystemServerReceivedCallFromApp = timeSystemServerReceivedCallFromApp;
    }

    public void setTimeLoadSandboxStarted(long timeLoadSandboxStarted) {
        this.mTimeLoadSandboxStarted = timeLoadSandboxStarted;
    }

    public void setTimeSandboxLoaded(long timeSandboxLoaded) {
        this.mTimeSandboxLoaded = timeSandboxLoaded;
    }

    public long getTimeSystemServerCallFinished() {
        return this.mTimeSystemServerCallFinished;
    }

    public void setTimeSystemServerCallFinished(long timeSystemServerCallFinished) {
        this.mTimeSystemServerCallFinished = timeSystemServerCallFinished;
    }

    public void setTimeSandboxReceivedCallFromSystemServer(long timeSandboxReceivedCallFromSystemServer) {
        this.mTimeSandboxReceivedCallFromSystemServer = timeSandboxReceivedCallFromSystemServer;
    }

    public void setTimeSandboxCalledSdk(long timeSandboxCalledSdk) {
        this.mTimeSandboxCalledSdk = timeSandboxCalledSdk;
    }

    public void setTimeSdkCallCompleted(long timeSdkCallCompleted) {
        this.mTimeSdkCallCompleted = timeSdkCallCompleted;
    }

    public long getTimeSandboxCalledSystemServer() {
        return this.mTimeSandboxCalledSystemServer;
    }

    public void setTimeSandboxCalledSystemServer(long timeSandboxCalledSystemServer) {
        this.mTimeSandboxCalledSystemServer = timeSandboxCalledSystemServer;
    }

    public void setTimeSystemServerReceivedCallFromSandbox(long timeSystemServerReceivedCallFromSandbox) {
        this.mTimeSystemServerReceivedCallFromSandbox = timeSystemServerReceivedCallFromSandbox;
    }

    public void setTimeSystemServerCalledApp(long timeSystemServerCalledApp) {
        this.mTimeSystemServerCalledApp = timeSystemServerCalledApp;
    }

    public void setTimeAppReceivedCallFromSystemServer(long timeAppReceivedCallFromSystemServer) {
        this.mTimeAppReceivedCallFromSystemServer = timeAppReceivedCallFromSystemServer;
    }

    public void setSandboxStatus(int sandboxStatus) {
        this.mSandboxStatus = sandboxStatus;
    }

    public void setResultCode(int resultCode) {
        this.mResultCode = resultCode;
    }

    public int getAppToSystemServerLatency() {
        return this.getLatency(this.mTimeAppCalledSystemServer, this.mTimeSystemServerReceivedCallFromApp);
    }

    public int getSystemServerAppToSandboxLatency() {
        int systemServerAppToSandboxLatency = this.getLatency(this.mTimeSystemServerReceivedCallFromApp, this.mTimeSystemServerCallFinished);
        int loadSandboxLatency = this.getLoadSandboxLatency();
        return loadSandboxLatency == -1 ? systemServerAppToSandboxLatency : systemServerAppToSandboxLatency - loadSandboxLatency;
    }

    public int getLoadSandboxLatency() {
        return this.getLatency(this.mTimeLoadSandboxStarted, this.mTimeSandboxLoaded);
    }

    public int getSystemServerToSandboxLatency() {
        return this.getLatency(this.mTimeSystemServerCallFinished, this.mTimeSandboxReceivedCallFromSystemServer);
    }

    public int getSandboxLatency() {
        int sandboxLatency = this.getLatency(this.mTimeSandboxReceivedCallFromSystemServer, this.mTimeSandboxCalledSystemServer);
        int sdkLatency = this.getSdkLatency();
        if (sdkLatency != -1) {
            sandboxLatency -= sdkLatency;
        }
        return sandboxLatency;
    }

    public int getSdkLatency() {
        return this.getLatency(this.mTimeSandboxCalledSdk, this.mTimeSdkCallCompleted);
    }

    public int getSandboxToSystemServerLatency() {
        return this.getLatency(this.mTimeSandboxCalledSystemServer, this.mTimeSystemServerReceivedCallFromSandbox);
    }

    public int getSystemServerSandboxToAppLatency() {
        return this.getLatency(this.mTimeSystemServerReceivedCallFromSandbox, this.mTimeSystemServerCalledApp);
    }

    public int getSystemServerToAppLatency() {
        return this.getLatency(this.mTimeSystemServerCalledApp, this.mTimeAppReceivedCallFromSystemServer);
    }

    public int getTotalCallLatency() {
        return this.getLatency(this.mTimeAppCalledSystemServer, this.getTotalCallFinishTime());
    }

    public boolean isSuccessfulAtAppToSystemServer() {
        return this.mSandboxStatus != 2;
    }

    public boolean isSuccessfulAtSystemServerAppToSandbox() {
        return this.mSandboxStatus != 3;
    }

    public boolean isSuccessfulAtLoadSandbox() {
        return this.mSandboxStatus != 4;
    }

    public boolean isSuccessfulAtSystemServerToSandbox() {
        return this.mSandboxStatus != 5;
    }

    public boolean isSuccessfulAtSdk() {
        return this.mSandboxStatus != 7;
    }

    public boolean isSuccessfulAtSandbox() {
        return this.mSandboxStatus != 6;
    }

    public boolean isSuccessfulAtSandboxToSystemServer() {
        return this.mSandboxStatus != 8;
    }

    public boolean isSuccessfulAtSystemServerSandboxToApp() {
        return this.mSandboxStatus != 9;
    }

    public boolean isSuccessfulAtSystemServerToApp() {
        return this.mSandboxStatus != 10;
    }

    public boolean isTotalCallSuccessful() {
        return this.mSandboxStatus == 1;
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    @VisibleForTesting
    public long getTimeAppCalledSystemServer() {
        return this.mTimeAppCalledSystemServer;
    }

    @VisibleForTesting
    public long getTimeAppReceivedCallFromSystemServer() {
        return this.mTimeAppReceivedCallFromSystemServer;
    }

    private long getTotalCallFinishTime() {
        switch (this.mMethod) {
            case 1: 
            case 3: 
            case 14: {
                return this.mTimeAppReceivedCallFromSystemServer;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return this.mTimeSystemServerCallFinished;
            }
            case 6: {
                return this.mTimeSystemServerReceivedCallFromApp;
            }
            case 7: {
                return this.mTimeSystemServerCalledApp;
            }
        }
        return -1L;
    }

    private int getLatency(long timeEventStarted, long timeEventFinished) {
        if (timeEventStarted != -1L && timeEventFinished != -1L) {
            return (int)(timeEventFinished - timeEventStarted);
        }
        return -1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResultCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SandboxStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Method {
    }
}

