/*
 * Decompiled with CFR 0.152.
 */
package android.app.ondeviceintelligence;

import android.annotation.RequiresPermission;
import android.app.ondeviceintelligence.Feature;
import android.app.ondeviceintelligence.IDownloadCallback;
import android.app.ondeviceintelligence.IFeatureCallback;
import android.app.ondeviceintelligence.IFeatureDetailsCallback;
import android.app.ondeviceintelligence.IListFeaturesCallback;
import android.app.ondeviceintelligence.IResponseCallback;
import android.app.ondeviceintelligence.IStreamingResponseCallback;
import android.app.ondeviceintelligence.ITokenInfoCallback;
import android.app.ondeviceintelligence.InferenceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteCallback;
import android.os.RemoteException;
import com.android.internal.infra.AndroidFuture;
import java.util.ArrayList;
import java.util.List;

public interface IOnDeviceIntelligenceManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.ondeviceintelligence.IOnDeviceIntelligenceManager";

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void getVersion(RemoteCallback var1) throws RemoteException;

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void getFeature(int var1, IFeatureCallback var2) throws RemoteException;

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void listFeatures(IListFeaturesCallback var1) throws RemoteException;

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void getFeatureDetails(Feature var1, IFeatureDetailsCallback var2) throws RemoteException;

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void requestFeatureDownload(Feature var1, AndroidFuture var2, IDownloadCallback var3) throws RemoteException;

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void requestTokenInfo(Feature var1, Bundle var2, AndroidFuture var3, ITokenInfoCallback var4) throws RemoteException;

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void processRequest(Feature var1, Bundle var2, int var3, AndroidFuture var4, AndroidFuture var5, IResponseCallback var6) throws RemoteException;

    @RequiresPermission(value="android.permission.USE_ON_DEVICE_INTELLIGENCE")
    public void processRequestStreaming(Feature var1, Bundle var2, int var3, AndroidFuture var4, AndroidFuture var5, IStreamingResponseCallback var6) throws RemoteException;

    public String getRemoteServicePackageName() throws RemoteException;

    public List<InferenceInfo> getLatestInferenceInfo(long var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOnDeviceIntelligenceManager {
        static final int TRANSACTION_getVersion = 2;
        static final int TRANSACTION_getFeature = 3;
        static final int TRANSACTION_listFeatures = 4;
        static final int TRANSACTION_getFeatureDetails = 5;
        static final int TRANSACTION_requestFeatureDownload = 6;
        static final int TRANSACTION_requestTokenInfo = 7;
        static final int TRANSACTION_processRequest = 8;
        static final int TRANSACTION_processRequestStreaming = 9;
        static final int TRANSACTION_getRemoteServicePackageName = 10;
        static final int TRANSACTION_getLatestInferenceInfo = 11;

        public Stub() {
            this.attachInterface(this, IOnDeviceIntelligenceManager.DESCRIPTOR);
        }

        public static IOnDeviceIntelligenceManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IOnDeviceIntelligenceManager.DESCRIPTOR);
            if (iin != null && iin instanceof IOnDeviceIntelligenceManager) {
                return (IOnDeviceIntelligenceManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 2: {
                    return "getVersion";
                }
                case 3: {
                    return "getFeature";
                }
                case 4: {
                    return "listFeatures";
                }
                case 5: {
                    return "getFeatureDetails";
                }
                case 6: {
                    return "requestFeatureDownload";
                }
                case 7: {
                    return "requestTokenInfo";
                }
                case 8: {
                    return "processRequest";
                }
                case 9: {
                    return "processRequestStreaming";
                }
                case 10: {
                    return "getRemoteServicePackageName";
                }
                case 11: {
                    return "getLatestInferenceInfo";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IOnDeviceIntelligenceManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 2: {
                    RemoteCallback _arg0 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.getVersion(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    IFeatureCallback _arg1 = IFeatureCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getFeature(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    IListFeaturesCallback _arg0 = IListFeaturesCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.listFeatures(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    Feature _arg0 = data.readTypedObject(Feature.CREATOR);
                    IFeatureDetailsCallback _arg1 = IFeatureDetailsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getFeatureDetails(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    Feature _arg0 = data.readTypedObject(Feature.CREATOR);
                    AndroidFuture _arg1 = data.readTypedObject(AndroidFuture.CREATOR);
                    IDownloadCallback _arg2 = IDownloadCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestFeatureDownload(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    Feature _arg0 = data.readTypedObject(Feature.CREATOR);
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    AndroidFuture _arg2 = data.readTypedObject(AndroidFuture.CREATOR);
                    ITokenInfoCallback _arg3 = ITokenInfoCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestTokenInfo(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    Feature _arg0 = data.readTypedObject(Feature.CREATOR);
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    int _arg2 = data.readInt();
                    AndroidFuture _arg3 = data.readTypedObject(AndroidFuture.CREATOR);
                    AndroidFuture _arg4 = data.readTypedObject(AndroidFuture.CREATOR);
                    IResponseCallback _arg5 = IResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.processRequest(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    Feature _arg0 = data.readTypedObject(Feature.CREATOR);
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    int _arg2 = data.readInt();
                    AndroidFuture _arg3 = data.readTypedObject(AndroidFuture.CREATOR);
                    AndroidFuture _arg4 = data.readTypedObject(AndroidFuture.CREATOR);
                    IStreamingResponseCallback _arg5 = IStreamingResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.processRequestStreaming(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _result = this.getRemoteServicePackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 11: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    List<InferenceInfo> _result = this.getLatestInferenceInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 10;
        }

        private static class Proxy
        implements IOnDeviceIntelligenceManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IOnDeviceIntelligenceManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getVersion(RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOnDeviceIntelligenceManager.DESCRIPTOR);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getFeature(int featureId, IFeatureCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOnDeviceIntelligenceManager.DESCRIPTOR);
                    _data.writeInt(featureId);
                    _data.writeStrongInterface(remoteCallback);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void listFeatures(IListFeaturesCallback listFeaturesCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOnDeviceIntelligenceManager.DESCRIPTOR);
                    _data.writeStrongInterface(listFeaturesCallback);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getFeatureDetails(Feature feature, IFeatureDetailsCallback featureDetailsCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOnDeviceIntelligenceManager.DESCRIPTOR);
                    _data.writeTypedObject(feature, 0);
                    _data.writeStrongInterface(featureDetailsCallback);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestFeatureDownload(Feature feature, AndroidFuture cancellationSignalFuture, IDownloadCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOnDeviceIntelligenceManager.DESCRIPTOR);
                    _data.writeTypedObject(feature, 0);
                    _data.writeTypedObject(cancellationSignalFuture, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestTokenInfo(Feature feature, Bundle requestBundle, AndroidFuture cancellationSignalFuture, ITokenInfoCallback tokenInfocallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOnDeviceIntelligenceManager.DESCRIPTOR);
                    _data.writeTypedObject(feature, 0);
                    _data.writeTypedObject(requestBundle, 0);
                    _data.writeTypedObject(cancellationSignalFuture, 0);
                    _data.writeStrongInterface(tokenInfocallback);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processRequest(Feature feature, Bundle requestBundle, int requestType, AndroidFuture cancellationSignalFuture, AndroidFuture processingSignalFuture, IResponseCallback responseCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOnDeviceIntelligenceManager.DESCRIPTOR);
                    _data.writeTypedObject(feature, 0);
                    _data.writeTypedObject(requestBundle, 0);
                    _data.writeInt(requestType);
                    _data.writeTypedObject(cancellationSignalFuture, 0);
                    _data.writeTypedObject(processingSignalFuture, 0);
                    _data.writeStrongInterface(responseCallback);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processRequestStreaming(Feature feature, Bundle requestBundle, int requestType, AndroidFuture cancellationSignalFuture, AndroidFuture processingSignalFuture, IStreamingResponseCallback streamingCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOnDeviceIntelligenceManager.DESCRIPTOR);
                    _data.writeTypedObject(feature, 0);
                    _data.writeTypedObject(requestBundle, 0);
                    _data.writeInt(requestType);
                    _data.writeTypedObject(cancellationSignalFuture, 0);
                    _data.writeTypedObject(processingSignalFuture, 0);
                    _data.writeStrongInterface(streamingCallback);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getRemoteServicePackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOnDeviceIntelligenceManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<InferenceInfo> getLatestInferenceInfo(long startTimeEpochMillis) throws RemoteException {
                ArrayList<InferenceInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IOnDeviceIntelligenceManager.DESCRIPTOR);
                    _data.writeLong(startTimeEpochMillis);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(InferenceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IOnDeviceIntelligenceManager {
        @Override
        public void getVersion(RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void getFeature(int featureId, IFeatureCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void listFeatures(IListFeaturesCallback listFeaturesCallback) throws RemoteException {
        }

        @Override
        public void getFeatureDetails(Feature feature, IFeatureDetailsCallback featureDetailsCallback) throws RemoteException {
        }

        @Override
        public void requestFeatureDownload(Feature feature, AndroidFuture cancellationSignalFuture, IDownloadCallback callback) throws RemoteException {
        }

        @Override
        public void requestTokenInfo(Feature feature, Bundle requestBundle, AndroidFuture cancellationSignalFuture, ITokenInfoCallback tokenInfocallback) throws RemoteException {
        }

        @Override
        public void processRequest(Feature feature, Bundle requestBundle, int requestType, AndroidFuture cancellationSignalFuture, AndroidFuture processingSignalFuture, IResponseCallback responseCallback) throws RemoteException {
        }

        @Override
        public void processRequestStreaming(Feature feature, Bundle requestBundle, int requestType, AndroidFuture cancellationSignalFuture, AndroidFuture processingSignalFuture, IStreamingResponseCallback streamingCallback) throws RemoteException {
        }

        @Override
        public String getRemoteServicePackageName() throws RemoteException {
            return null;
        }

        @Override
        public List<InferenceInfo> getLatestInferenceInfo(long startTimeEpochMillis) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

