/*
 * Decompiled with CFR 0.152.
 */
package android.app.ondeviceintelligence;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.MessageFormat;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.app.ondeviceintelligence.flags.enable_on_device_intelligence")
public class FeatureDetails
implements Parcelable {
    private final int mFeatureStatus;
    @NonNull
    private final PersistableBundle mFeatureDetailParams;
    public static final int FEATURE_STATUS_UNAVAILABLE = 0;
    public static final int FEATURE_STATUS_DOWNLOADABLE = 1;
    public static final int FEATURE_STATUS_DOWNLOADING = 2;
    public static final int FEATURE_STATUS_AVAILABLE = 3;
    public static final int FEATURE_STATUS_SERVICE_UNAVAILABLE = 4;
    @NonNull
    public static final Parcelable.Creator<FeatureDetails> CREATOR = new Parcelable.Creator<FeatureDetails>(){

        public FeatureDetails[] newArray(int size) {
            return new FeatureDetails[size];
        }

        @Override
        public FeatureDetails createFromParcel(@NonNull Parcel in) {
            return new FeatureDetails(in);
        }
    };

    public FeatureDetails(int featureStatus, @NonNull PersistableBundle featureDetailParams) {
        this.mFeatureStatus = featureStatus;
        AnnotationValidations.validate(Status.class, null, this.mFeatureStatus);
        this.mFeatureDetailParams = featureDetailParams;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mFeatureDetailParams);
    }

    public FeatureDetails(int featureStatus) {
        this.mFeatureStatus = featureStatus;
        AnnotationValidations.validate(Status.class, null, this.mFeatureStatus);
        this.mFeatureDetailParams = new PersistableBundle();
    }

    public int getFeatureStatus() {
        return this.mFeatureStatus;
    }

    @NonNull
    public PersistableBundle getFeatureDetailParams() {
        return this.mFeatureDetailParams;
    }

    public String toString() {
        return MessageFormat.format("FeatureDetails '{' status = {0}, persistableBundle = {1} '}'", this.mFeatureStatus, this.mFeatureDetailParams);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureDetails that = (FeatureDetails)o;
        return this.mFeatureStatus == that.mFeatureStatus && Objects.equals(this.mFeatureDetailParams, that.mFeatureDetailParams);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mFeatureStatus;
        _hash = 31 * _hash + Objects.hashCode(this.mFeatureDetailParams);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mFeatureStatus);
        dest.writeTypedObject(this.mFeatureDetailParams, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    FeatureDetails(@NonNull Parcel in) {
        int status = in.readInt();
        PersistableBundle persistableBundle = in.readTypedObject(PersistableBundle.CREATOR);
        this.mFeatureStatus = status;
        AnnotationValidations.validate(Status.class, null, this.mFeatureStatus);
        this.mFeatureDetailParams = persistableBundle;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mFeatureDetailParams);
    }

    @Target(value={ElementType.TYPE_USE, ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

