/*
 * Decompiled with CFR 0.152.
 */
package android.app.jank;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import java.util.Arrays;

@FlaggedApi(value="android.app.jank.detailed_app_jank_metrics_api")
public class RelativeFrameTimeHistogram {
    private static int[] sBucketEndpoints = new int[]{Integer.MIN_VALUE, -200, -150, -100, -90, -80, -70, -60, -50, -40, -30, -25, -20, -18, -16, -14, -12, -10, -8, -6, -4, -2, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 25, 30, 40, 50, 60, 70, 80, 90, 100, 150, 200, 300, 400, 500, 600, 700, 800, 900, 1000, Integer.MAX_VALUE};
    private int[] mBucketCounts = new int[sBucketEndpoints.length - 1];

    public void addRelativeFrameTimeMillis(int frameTimeMillis) {
        int countsIndex;
        int n = countsIndex = this.getRelativeFrameTimeBucketIndex(frameTimeMillis);
        this.mBucketCounts[n] = this.mBucketCounts[n] + 1;
    }

    @NonNull
    public int[] getBucketCounters() {
        return Arrays.copyOf(this.mBucketCounts, this.mBucketCounts.length);
    }

    @NonNull
    public int[] getBucketEndpointsMillis() {
        return Arrays.copyOf(sBucketEndpoints, sBucketEndpoints.length);
    }

    private int getRelativeFrameTimeBucketIndex(int relativeFrameTime) {
        if (relativeFrameTime < 20) {
            if (relativeFrameTime >= -20) {
                return (relativeFrameTime + 20) / 2 + 12;
            }
            if (relativeFrameTime >= -30) {
                return (relativeFrameTime + 30) / 5 + 10;
            }
            if (relativeFrameTime >= -100) {
                return (relativeFrameTime + 100) / 10 + 3;
            }
            if (relativeFrameTime >= -200) {
                return (relativeFrameTime + 200) / 50 + 1;
            }
            return 0;
        }
        if (relativeFrameTime < 30) {
            return (relativeFrameTime - 20) / 5 + 32;
        }
        if (relativeFrameTime < 100) {
            return (relativeFrameTime - 30) / 10 + 34;
        }
        if (relativeFrameTime < 200) {
            return (relativeFrameTime - 50) / 100 + 41;
        }
        if (relativeFrameTime < 1000) {
            return (relativeFrameTime - 200) / 100 + 43;
        }
        return this.mBucketCounts.length - 1;
    }
}

