/*
 * Decompiled with CFR 0.152.
 */
package android.app.blob;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import android.util.IndentingPrintWriter;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlSerializer;

public class BlobHandle
implements Parcelable {
    public static final String ALGO_SHA_256 = "SHA-256";
    private static final String[] SUPPORTED_ALGOS = new String[]{"SHA-256"};
    private static final int LIMIT_BLOB_TAG_LENGTH = 128;
    private static final int LIMIT_BLOB_LABEL_LENGTH = 100;
    @NonNull
    public final String algorithm;
    @NonNull
    public final byte[] digest;
    @NonNull
    public final CharSequence label;
    public final long expiryTimeMillis;
    @NonNull
    public final String tag;
    @NonNull
    public static final Parcelable.Creator<BlobHandle> CREATOR = new Parcelable.Creator<BlobHandle>(){

        @Override
        @NonNull
        public BlobHandle createFromParcel(@NonNull Parcel source) {
            return new BlobHandle(source);
        }

        @NonNull
        public BlobHandle[] newArray(int size) {
            return new BlobHandle[size];
        }
    };

    private BlobHandle(String algorithm, byte[] digest, CharSequence label, long expiryTimeMillis, String tag) {
        this.algorithm = algorithm;
        this.digest = digest;
        this.label = label;
        this.expiryTimeMillis = expiryTimeMillis;
        this.tag = tag;
    }

    private BlobHandle(Parcel in) {
        this.algorithm = in.readString();
        this.digest = in.createByteArray();
        this.label = in.readCharSequence();
        this.expiryTimeMillis = in.readLong();
        this.tag = in.readString();
    }

    @NonNull
    public static BlobHandle create(@NonNull String algorithm, @NonNull byte[] digest, @NonNull CharSequence label, long expiryTimeMillis, @NonNull String tag) {
        BlobHandle handle = new BlobHandle(algorithm, digest, label, expiryTimeMillis, tag);
        handle.assertIsValid();
        return handle;
    }

    @NonNull
    public static BlobHandle createWithSha256(@NonNull byte[] digest, @NonNull CharSequence label, long expiryTimeMillis, @NonNull String tag) {
        return BlobHandle.create(ALGO_SHA_256, digest, label, expiryTimeMillis, tag);
    }

    @NonNull
    public byte[] getSha256Digest() {
        return this.digest;
    }

    @NonNull
    public CharSequence getLabel() {
        return this.label;
    }

    public long getExpiryTimeMillis() {
        return this.expiryTimeMillis;
    }

    @NonNull
    public String getTag() {
        return this.tag;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.algorithm);
        dest.writeByteArray(this.digest);
        dest.writeCharSequence(this.label);
        dest.writeLong(this.expiryTimeMillis);
        dest.writeString(this.tag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BlobHandle)) {
            return false;
        }
        BlobHandle other = (BlobHandle)obj;
        return this.algorithm.equals(other.algorithm) && Arrays.equals(this.digest, other.digest) && this.label.toString().equals(other.label.toString()) && this.expiryTimeMillis == other.expiryTimeMillis && this.tag.equals(other.tag);
    }

    public int hashCode() {
        return Objects.hash(this.algorithm, Arrays.hashCode(this.digest), this.label, this.expiryTimeMillis, this.tag);
    }

    public void dump(IndentingPrintWriter fout, boolean dumpFull) {
        if (dumpFull) {
            fout.println("algo: " + this.algorithm);
            fout.println("digest: " + (dumpFull ? BlobHandle.encodeDigest(this.digest) : BlobHandle.safeDigest(this.digest)));
            fout.println("label: " + this.label);
            fout.println("expiryMs: " + this.expiryTimeMillis);
            fout.println("tag: " + this.tag);
        } else {
            fout.println(this.toString());
        }
    }

    public void assertIsValid() {
        Preconditions.checkArgumentIsSupported(SUPPORTED_ALGOS, this.algorithm);
        Preconditions.checkByteArrayNotEmpty(this.digest, "digest");
        Preconditions.checkStringNotEmpty(this.label, "label must not be null");
        Preconditions.checkArgument(this.label.length() <= 100, "label too long");
        Preconditions.checkArgumentNonnegative(this.expiryTimeMillis, "expiryTimeMillis must not be negative");
        Preconditions.checkStringNotEmpty(this.tag, "tag must not be null");
        Preconditions.checkArgument(this.tag.length() <= 128, "tag too long");
    }

    public String toString() {
        return "BlobHandle {algo:" + this.algorithm + ",digest:" + BlobHandle.safeDigest(this.digest) + ",label:" + this.label + ",expiryMs:" + this.expiryTimeMillis + ",tag:" + this.tag + "}";
    }

    public static String safeDigest(@NonNull byte[] digest) {
        String digestStr = BlobHandle.encodeDigest(digest);
        return digestStr.substring(0, 2) + ".." + digestStr.substring(digestStr.length() - 2);
    }

    private static String encodeDigest(@NonNull byte[] digest) {
        return Base64.encodeToString(digest, 2);
    }

    public boolean isExpired() {
        return this.expiryTimeMillis != 0L && this.expiryTimeMillis < System_Delegate.currentTimeMillis();
    }

    public void writeToXml(@NonNull XmlSerializer out) throws IOException {
        XmlUtils.writeStringAttribute(out, "al", this.algorithm);
        XmlUtils.writeByteArrayAttribute(out, "dg", this.digest);
        XmlUtils.writeStringAttribute(out, "lbl", this.label);
        XmlUtils.writeLongAttribute(out, "ex", this.expiryTimeMillis);
        XmlUtils.writeStringAttribute(out, "tg", this.tag);
    }

    @NonNull
    public static BlobHandle createFromXml(@NonNull XmlPullParser in) throws IOException {
        String algo = XmlUtils.readStringAttribute(in, "al");
        byte[] digest = XmlUtils.readByteArrayAttribute(in, "dg");
        String label = XmlUtils.readStringAttribute(in, "lbl");
        long expiryTimeMs = XmlUtils.readLongAttribute(in, "ex");
        String tag = XmlUtils.readStringAttribute(in, "tg");
        return BlobHandle.create(algo, digest, label, expiryTimeMs, tag);
    }
}

