/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.safeparcel;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.PendingIntent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class SafeParcelWriter {
    static final int OBJECT_HEADER = 20293;

    private SafeParcelWriter() {
    }

    private static void writeHeader(Parcel p, int id2, int size) {
        if (size >= 65535) {
            p.writeInt(0xFFFF0000 | id2);
            p.writeInt(size);
        } else {
            p.writeInt(size << 16 | id2);
        }
    }

    private static int beginVariableData(Parcel p, int id2) {
        p.writeInt(0xFFFF0000 | id2);
        p.writeInt(0);
        return p.dataPosition();
    }

    private static void finishVariableData(Parcel p, int start) {
        int end = p.dataPosition();
        int size = end - start;
        p.setDataPosition(start - 4);
        p.writeInt(size);
        p.setDataPosition(end);
    }

    public static int beginObjectHeader(@NonNull Parcel p) {
        return SafeParcelWriter.beginVariableData(p, 20293);
    }

    public static void finishObjectHeader(@NonNull Parcel p, int start) {
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeBoolean(@NonNull Parcel p, int id2, boolean val) {
        SafeParcelWriter.writeHeader(p, id2, 4);
        p.writeInt(val ? 1 : 0);
    }

    public static void writeBooleanObject(@NonNull Parcel p, int id2, @Nullable Boolean val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        SafeParcelWriter.writeHeader(p, id2, 4);
        p.writeInt(val != false ? 1 : 0);
    }

    public static void writeByte(@NonNull Parcel p, int id2, byte val) {
        SafeParcelWriter.writeHeader(p, id2, 4);
        p.writeInt(val);
    }

    public static void writeChar(@NonNull Parcel p, int id2, char val) {
        SafeParcelWriter.writeHeader(p, id2, 4);
        p.writeInt(val);
    }

    public static void writeShort(@NonNull Parcel p, int id2, short val) {
        SafeParcelWriter.writeHeader(p, id2, 4);
        p.writeInt(val);
    }

    public static void writeInt(@NonNull Parcel p, int id2, int val) {
        SafeParcelWriter.writeHeader(p, id2, 4);
        p.writeInt(val);
    }

    public static void writeIntegerObject(@NonNull Parcel p, int id2, @Nullable Integer val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        SafeParcelWriter.writeHeader(p, id2, 4);
        p.writeInt(val);
    }

    public static void writeLong(@NonNull Parcel p, int id2, long val) {
        SafeParcelWriter.writeHeader(p, id2, 8);
        p.writeLong(val);
    }

    public static void writeLongObject(@NonNull Parcel p, int id2, @Nullable Long val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        SafeParcelWriter.writeHeader(p, id2, 8);
        p.writeLong(val);
    }

    public static void writeBigInteger(@NonNull Parcel p, int id2, @Nullable BigInteger val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeByteArray(val.toByteArray());
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeFloat(@NonNull Parcel p, int id2, float val) {
        SafeParcelWriter.writeHeader(p, id2, 4);
        p.writeFloat(val);
    }

    public static void writeFloatObject(@NonNull Parcel p, int id2, @Nullable Float val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        SafeParcelWriter.writeHeader(p, id2, 4);
        p.writeFloat(val.floatValue());
    }

    public static void writeDouble(@NonNull Parcel p, int id2, double val) {
        SafeParcelWriter.writeHeader(p, id2, 8);
        p.writeDouble(val);
    }

    public static void writeDoubleObject(@NonNull Parcel p, int id2, @Nullable Double val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        SafeParcelWriter.writeHeader(p, id2, 8);
        p.writeDouble(val);
    }

    public static void writeBigDecimal(@NonNull Parcel p, int id2, @Nullable BigDecimal val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeByteArray(val.unscaledValue().toByteArray());
        p.writeInt(val.scale());
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeString(@NonNull Parcel p, int id2, @Nullable String val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeString(val);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeIBinder(@NonNull Parcel p, int id2, @Nullable IBinder val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeStrongBinder(val);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeParcelable(@NonNull Parcel p, int id2, @Nullable Parcelable val, int parcelableFlags, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        val.writeToParcel(p, parcelableFlags);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeBundle(@NonNull Parcel p, int id2, @Nullable Bundle val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeBundle(val);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeByteArray(@NonNull Parcel p, int id2, @Nullable byte[] buf, boolean writeNull) {
        if (buf == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeByteArray(buf);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeByteArrayArray(@NonNull Parcel p, int id2, @Nullable byte[][] buf, boolean writeNull) {
        if (buf == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int length = buf.length;
        p.writeInt(length);
        for (int i = 0; i < length; ++i) {
            p.writeByteArray(buf[i]);
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeBooleanArray(@NonNull Parcel p, int id2, @Nullable boolean[] val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeBooleanArray(val);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeCharArray(@NonNull Parcel p, int id2, @Nullable char[] val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeCharArray(val);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeIntArray(@NonNull Parcel p, int id2, @Nullable int[] val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeIntArray(val);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeLongArray(@NonNull Parcel p, int id2, @Nullable long[] val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeLongArray(val);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeBigIntegerArray(@NonNull Parcel p, int id2, @Nullable BigInteger[] val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int length = val.length;
        p.writeInt(length);
        for (int i = 0; i < length; ++i) {
            p.writeByteArray(val[i].toByteArray());
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeFloatArray(@NonNull Parcel p, int id2, @Nullable float[] val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeFloatArray(val);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeDoubleArray(@NonNull Parcel p, int id2, @Nullable double[] val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeDoubleArray(val);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeBigDecimalArray(@NonNull Parcel p, int id2, @Nullable BigDecimal[] val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int length = val.length;
        p.writeInt(length);
        for (int i = 0; i < length; ++i) {
            p.writeByteArray(val[i].unscaledValue().toByteArray());
            p.writeInt(val[i].scale());
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeStringArray(@NonNull Parcel p, int id2, @Nullable String[] val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeStringArray(val);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeIBinderArray(@NonNull Parcel p, int id2, @Nullable IBinder[] val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeBinderArray(val);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeBooleanList(@NonNull Parcel p, int id2, @Nullable List<Boolean> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            p.writeInt(val.get(i) != false ? 1 : 0);
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeIntegerList(@NonNull Parcel p, int id2, @Nullable List<Integer> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            p.writeInt(val.get(i));
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeLongList(@NonNull Parcel p, int id2, @Nullable List<Long> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            p.writeLong(val.get(i));
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeFloatList(@NonNull Parcel p, int id2, @Nullable List<Float> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            p.writeFloat(val.get(i).floatValue());
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeDoubleList(@NonNull Parcel p, int id2, @Nullable List<Double> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            p.writeDouble(val.get(i));
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeStringList(@NonNull Parcel p, int id2, @Nullable List<String> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeStringList(val);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeIBinderList(@NonNull Parcel p, int id2, @Nullable List<IBinder> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeBinderList(val);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static <T extends Parcelable> void writeTypedArray(@NonNull Parcel p, int id2, @Nullable T[] val, int parcelableFlags, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int length = val.length;
        p.writeInt(length);
        for (int i = 0; i < length; ++i) {
            T item = val[i];
            if (item == null) {
                p.writeInt(0);
                continue;
            }
            SafeParcelWriter.writeTypedItemWithSize(p, item, parcelableFlags);
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static <T extends Parcelable> void writeTypedList(@NonNull Parcel p, int id2, @Nullable List<T> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int length = val.size();
        p.writeInt(length);
        for (int i = 0; i < length; ++i) {
            Parcelable item = (Parcelable)val.get(i);
            if (item == null) {
                p.writeInt(0);
                continue;
            }
            SafeParcelWriter.writeTypedItemWithSize(p, item, 0);
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    private static <T extends Parcelable> void writeTypedItemWithSize(Parcel p, T item, int parcelableFlags) {
        int itemSizeDataPosition = p.dataPosition();
        p.writeInt(1);
        int itemStartPosition = p.dataPosition();
        item.writeToParcel(p, parcelableFlags);
        int currentDataPosition = p.dataPosition();
        p.setDataPosition(itemSizeDataPosition);
        p.writeInt(currentDataPosition - itemStartPosition);
        p.setDataPosition(currentDataPosition);
    }

    public static void writeParcel(@NonNull Parcel p, int id2, @Nullable Parcel val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.appendFrom(val, 0, val.dataSize());
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeParcelArray(@NonNull Parcel p, int id2, @Nullable Parcel[] val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int length = val.length;
        p.writeInt(length);
        for (int i = 0; i < length; ++i) {
            Parcel item = val[i];
            if (item != null) {
                p.writeInt(item.dataSize());
                p.appendFrom(item, 0, item.dataSize());
                continue;
            }
            p.writeInt(0);
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeParcelList(@NonNull Parcel p, int id2, @Nullable List<Parcel> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            Parcel item = val.get(i);
            if (item != null) {
                p.writeInt(item.dataSize());
                p.appendFrom(item, 0, item.dataSize());
                continue;
            }
            p.writeInt(0);
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writePendingIntent(@NonNull Parcel p, int id2, @Nullable PendingIntent val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        PendingIntent.writePendingIntentOrNullToParcel(val, p);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeList(@NonNull Parcel p, int id2, @Nullable List list, boolean writeNull) {
        if (list == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeList(list);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeSparseBooleanArray(@NonNull Parcel p, int id2, @Nullable SparseBooleanArray val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        p.writeSparseBooleanArray(val);
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeDoubleSparseArray(@NonNull Parcel p, int id2, @Nullable SparseArray<Double> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            p.writeInt(val.keyAt(i));
            p.writeDouble(val.valueAt(i));
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeFloatSparseArray(@NonNull Parcel p, int id2, @Nullable SparseArray<Float> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            p.writeInt(val.keyAt(i));
            p.writeFloat(val.valueAt(i).floatValue());
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeSparseIntArray(@NonNull Parcel p, int id2, @Nullable SparseIntArray val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            p.writeInt(val.keyAt(i));
            p.writeInt(val.valueAt(i));
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeSparseLongArray(@NonNull Parcel p, int id2, @Nullable SparseLongArray val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            p.writeInt(val.keyAt(i));
            p.writeLong(val.valueAt(i));
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeStringSparseArray(@NonNull Parcel p, int id2, @Nullable SparseArray<String> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            p.writeInt(val.keyAt(i));
            p.writeString(val.valueAt(i));
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeParcelSparseArray(@NonNull Parcel p, int id2, @Nullable SparseArray<Parcel> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            p.writeInt(val.keyAt(i));
            Parcel item = val.valueAt(i);
            if (item != null) {
                p.writeInt(item.dataSize());
                p.appendFrom(item, 0, item.dataSize());
                continue;
            }
            p.writeInt(0);
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static <T extends Parcelable> void writeTypedSparseArray(@NonNull Parcel p, int id2, @Nullable SparseArray<T> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            p.writeInt(val.keyAt(i));
            Parcelable item = (Parcelable)val.valueAt(i);
            if (item == null) {
                p.writeInt(0);
                continue;
            }
            SafeParcelWriter.writeTypedItemWithSize(p, item, 0);
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeIBinderSparseArray(@NonNull Parcel p, int id2, @Nullable SparseArray<IBinder> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            p.writeInt(val.keyAt(i));
            p.writeStrongBinder(val.valueAt(i));
        }
        SafeParcelWriter.finishVariableData(p, start);
    }

    public static void writeByteArraySparseArray(@NonNull Parcel p, int id2, @Nullable SparseArray<byte[]> val, boolean writeNull) {
        if (val == null) {
            if (writeNull) {
                SafeParcelWriter.writeHeader(p, id2, 0);
            }
            return;
        }
        int start = SafeParcelWriter.beginVariableData(p, id2);
        int size = val.size();
        p.writeInt(size);
        for (int i = 0; i < size; ++i) {
            p.writeInt(val.keyAt(i));
            p.writeByteArray(val.valueAt(i));
        }
        SafeParcelWriter.finishVariableData(p, start);
    }
}

