/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.safeparcel;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.PendingIntent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class SafeParcelReader {
    private SafeParcelReader() {
    }

    public static int readHeader(@NonNull Parcel p) {
        return p.readInt();
    }

    public static int getFieldId(int header) {
        return header & 0xFFFF;
    }

    public static int readSize(@NonNull Parcel p, int header) {
        if ((header & 0xFFFF0000) != -65536) {
            return header >> 16 & 0xFFFF;
        }
        return p.readInt();
    }

    public static void skipUnknownField(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        p.setDataPosition(p.dataPosition() + size);
    }

    private static void readAndEnforceSize(@NonNull Parcel p, int header, int required) {
        int size = SafeParcelReader.readSize(p, header);
        if (size != required) {
            throw new ParseException("Expected size " + required + " got " + size + " (0x" + Integer.toHexString(size) + ")", p);
        }
    }

    private static void enforceSize(@NonNull Parcel p, int header, int size, int required) {
        if (size != required) {
            throw new ParseException("Expected size " + required + " got " + size + " (0x" + Integer.toHexString(size) + ")", p);
        }
    }

    public static int validateObjectHeader(@NonNull Parcel p) {
        int header = SafeParcelReader.readHeader(p);
        int size = SafeParcelReader.readSize(p, header);
        int start = p.dataPosition();
        if (SafeParcelReader.getFieldId(header) != 20293) {
            throw new ParseException("Expected object header. Got 0x" + Integer.toHexString(header), p);
        }
        int end = start + size;
        if (end < start || end > p.dataSize()) {
            throw new ParseException("Size read is invalid start=" + start + " end=" + end, p);
        }
        return end;
    }

    public static boolean readBoolean(@NonNull Parcel p, int header) {
        SafeParcelReader.readAndEnforceSize(p, header, 4);
        return p.readInt() != 0;
    }

    @Nullable
    public static Boolean readBooleanObject(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        if (size == 0) {
            return null;
        }
        SafeParcelReader.enforceSize(p, header, size, 4);
        return p.readInt() != 0;
    }

    public static byte readByte(@NonNull Parcel p, int header) {
        SafeParcelReader.readAndEnforceSize(p, header, 4);
        return (byte)p.readInt();
    }

    public static char readChar(@NonNull Parcel p, int header) {
        SafeParcelReader.readAndEnforceSize(p, header, 4);
        return (char)p.readInt();
    }

    public static short readShort(@NonNull Parcel p, int header) {
        SafeParcelReader.readAndEnforceSize(p, header, 4);
        return (short)p.readInt();
    }

    public static int readInt(@NonNull Parcel p, int header) {
        SafeParcelReader.readAndEnforceSize(p, header, 4);
        return p.readInt();
    }

    @Nullable
    public static Integer readIntegerObject(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        if (size == 0) {
            return null;
        }
        SafeParcelReader.enforceSize(p, header, size, 4);
        return p.readInt();
    }

    public static long readLong(@NonNull Parcel p, int header) {
        SafeParcelReader.readAndEnforceSize(p, header, 8);
        return p.readLong();
    }

    @Nullable
    public static Long readLongObject(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        if (size == 0) {
            return null;
        }
        SafeParcelReader.enforceSize(p, header, size, 8);
        return p.readLong();
    }

    @Nullable
    public static BigInteger createBigInteger(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        byte[] val = p.createByteArray();
        p.setDataPosition(pos + size);
        return new BigInteger(val);
    }

    public static float readFloat(@NonNull Parcel p, int header) {
        SafeParcelReader.readAndEnforceSize(p, header, 4);
        return p.readFloat();
    }

    @Nullable
    public static Float readFloatObject(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        if (size == 0) {
            return null;
        }
        SafeParcelReader.enforceSize(p, header, size, 4);
        return Float.valueOf(p.readFloat());
    }

    public static double readDouble(@NonNull Parcel p, int header) {
        SafeParcelReader.readAndEnforceSize(p, header, 8);
        return p.readDouble();
    }

    @Nullable
    public static Double readDoubleObject(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        if (size == 0) {
            return null;
        }
        SafeParcelReader.enforceSize(p, header, size, 8);
        return p.readDouble();
    }

    @Nullable
    public static BigDecimal createBigDecimal(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        byte[] unscaledValue = p.createByteArray();
        int scale = p.readInt();
        p.setDataPosition(pos + size);
        return new BigDecimal(new BigInteger(unscaledValue), scale);
    }

    @Nullable
    public static String createString(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        String result = p.readString();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static IBinder readIBinder(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        IBinder result = p.readStrongBinder();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static PendingIntent readPendingIntent(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        PendingIntent result = PendingIntent.readPendingIntentOrNullFromParcel(p);
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static <T extends Parcelable> T createParcelable(@NonNull Parcel p, int header, @NonNull Parcelable.Creator<T> creator) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        Parcelable result = (Parcelable)creator.createFromParcel(p);
        p.setDataPosition(pos + size);
        return (T)result;
    }

    @Nullable
    public static Bundle createBundle(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        Bundle result = p.readBundle();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static byte[] createByteArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        byte[] result = p.createByteArray();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static byte[][] createByteArrayArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        int length = p.readInt();
        byte[][] result = new byte[length][];
        for (int i = 0; i < length; ++i) {
            result[i] = p.createByteArray();
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static boolean[] createBooleanArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        boolean[] result = p.createBooleanArray();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static char[] createCharArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        char[] result = p.createCharArray();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static int[] createIntArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        int[] result = p.createIntArray();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static long[] createLongArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        long[] result = p.createLongArray();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static BigInteger[] createBigIntegerArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        int length = p.readInt();
        BigInteger[] result = new BigInteger[length];
        for (int i = 0; i < length; ++i) {
            result[i] = new BigInteger(p.createByteArray());
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static float[] createFloatArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        float[] result = p.createFloatArray();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static double[] createDoubleArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        double[] result = p.createDoubleArray();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static BigDecimal[] createBigDecimalArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        int length = p.readInt();
        BigDecimal[] result = new BigDecimal[length];
        for (int i = 0; i < length; ++i) {
            byte[] unscaledValue = p.createByteArray();
            int scale = p.readInt();
            result[i] = new BigDecimal(new BigInteger(unscaledValue), scale);
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static String[] createStringArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        String[] result = p.createStringArray();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static IBinder[] createIBinderArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        IBinder[] result = p.createBinderArray();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static ArrayList<Boolean> createBooleanList(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        int count = p.readInt();
        for (int i = 0; i < count; ++i) {
            result.add(p.readInt() != 0);
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static ArrayList<Integer> createIntegerList(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        int count = p.readInt();
        for (int i = 0; i < count; ++i) {
            result.add(p.readInt());
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static SparseBooleanArray createSparseBooleanArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        SparseBooleanArray result = p.readSparseBooleanArray();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static SparseIntArray createSparseIntArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        SparseIntArray result = new SparseIntArray();
        int count = p.readInt();
        for (int i = 0; i < count; ++i) {
            int key = p.readInt();
            int value = p.readInt();
            result.append(key, value);
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static SparseArray<Float> createFloatSparseArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        SparseArray<Float> result = new SparseArray<Float>();
        int count = p.readInt();
        for (int i = 0; i < count; ++i) {
            int key = p.readInt();
            float value = p.readFloat();
            result.append(key, Float.valueOf(value));
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static SparseArray<Double> createDoubleSparseArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        SparseArray<Double> result = new SparseArray<Double>();
        int count = p.readInt();
        for (int i = 0; i < count; ++i) {
            int key = p.readInt();
            double value = p.readDouble();
            result.append(key, value);
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static SparseLongArray createSparseLongArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        SparseLongArray result = new SparseLongArray();
        int count = p.readInt();
        for (int i = 0; i < count; ++i) {
            int key = p.readInt();
            long value = p.readLong();
            result.append(key, value);
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static SparseArray<String> createStringSparseArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        SparseArray<String> result = new SparseArray<String>();
        int count = p.readInt();
        for (int i = 0; i < count; ++i) {
            int key = p.readInt();
            String value = p.readString();
            result.append(key, value);
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static SparseArray<Parcel> createParcelSparseArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        int count = p.readInt();
        SparseArray<Parcel> result = new SparseArray<Parcel>();
        for (int i = 0; i < count; ++i) {
            int key = p.readInt();
            int parcelSize = p.readInt();
            if (parcelSize != 0) {
                int currentDataPosition = p.dataPosition();
                Parcel item = Parcel.obtain();
                item.appendFrom(p, currentDataPosition, parcelSize);
                result.append(key, item);
                p.setDataPosition(currentDataPosition + parcelSize);
                continue;
            }
            result.append(key, null);
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static <T> SparseArray<T> createTypedSparseArray(@NonNull Parcel p, int header, @NonNull Parcelable.Creator<T> c) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        int count = p.readInt();
        SparseArray<Object> result = new SparseArray<Object>();
        for (int i = 0; i < count; ++i) {
            int key = p.readInt();
            Object value = p.readInt() != 0 ? (Object)c.createFromParcel(p) : null;
            result.append(key, value);
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static SparseArray<IBinder> createIBinderSparseArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        int count = p.readInt();
        SparseArray<IBinder> result = new SparseArray<IBinder>(count);
        for (int i = 0; i < count; ++i) {
            int key = p.readInt();
            IBinder value = p.readStrongBinder();
            result.append(key, value);
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static SparseArray<byte[]> createByteArraySparseArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        int count = p.readInt();
        SparseArray<byte[]> result = new SparseArray<byte[]>(count);
        for (int i = 0; i < count; ++i) {
            int key = p.readInt();
            byte[] value = p.createByteArray();
            result.append(key, value);
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static ArrayList<Long> createLongList(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        int count = p.readInt();
        for (int i = 0; i < count; ++i) {
            result.add(p.readLong());
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static ArrayList<Float> createFloatList(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        ArrayList<Float> result = new ArrayList<Float>();
        int count = p.readInt();
        for (int i = 0; i < count; ++i) {
            result.add(Float.valueOf(p.readFloat()));
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static ArrayList<Double> createDoubleList(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        ArrayList<Double> result = new ArrayList<Double>();
        int count = p.readInt();
        for (int i = 0; i < count; ++i) {
            result.add(p.readDouble());
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static ArrayList<String> createStringList(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        ArrayList<String> result = p.createStringArrayList();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static ArrayList<IBinder> createIBinderList(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        ArrayList<IBinder> result = p.createBinderArrayList();
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static <T> T[] createTypedArray(@NonNull Parcel p, int header, @NonNull Parcelable.Creator<T> c) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        T[] result = p.createTypedArray(c);
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static <T> ArrayList<T> createTypedList(@NonNull Parcel p, int header, @NonNull Parcelable.Creator<T> c) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        ArrayList<T> result = p.createTypedArrayList(c);
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static Parcel createParcel(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        Parcel result = Parcel.obtain();
        result.appendFrom(p, pos, size);
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static Parcel[] createParcelArray(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        int length = p.readInt();
        Parcel[] result = new Parcel[length];
        for (int i = 0; i < length; ++i) {
            int parcelSize = p.readInt();
            if (parcelSize != 0) {
                int currentDataPosition = p.dataPosition();
                Parcel item = Parcel.obtain();
                item.appendFrom(p, currentDataPosition, parcelSize);
                result[i] = item;
                p.setDataPosition(currentDataPosition + parcelSize);
                continue;
            }
            result[i] = null;
        }
        p.setDataPosition(pos + size);
        return result;
    }

    @Nullable
    public static ArrayList<Parcel> createParcelList(@NonNull Parcel p, int header) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return null;
        }
        int length = p.readInt();
        ArrayList<Parcel> result = new ArrayList<Parcel>();
        for (int i = 0; i < length; ++i) {
            int parcelSize = p.readInt();
            if (parcelSize != 0) {
                int currentDataPosition = p.dataPosition();
                Parcel item = Parcel.obtain();
                item.appendFrom(p, currentDataPosition, parcelSize);
                result.add(item);
                p.setDataPosition(currentDataPosition + parcelSize);
                continue;
            }
            result.add(null);
        }
        p.setDataPosition(pos + size);
        return result;
    }

    public static void readList(@NonNull Parcel p, int header, @NonNull List list, @Nullable ClassLoader loader) {
        int size = SafeParcelReader.readSize(p, header);
        int pos = p.dataPosition();
        if (size == 0) {
            return;
        }
        p.readList(list, loader);
        p.setDataPosition(pos + size);
    }

    public static void ensureAtEnd(@NonNull Parcel parcel, int end) {
        if (parcel.dataPosition() != end) {
            throw new ParseException("Overread allowed size end=" + end, parcel);
        }
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(@NonNull String message, @NonNull Parcel p) {
            super(message + " Parcel: pos=" + p.dataPosition() + " size=" + p.dataSize());
        }
    }
}

