/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.safeparcel;

import android.annotation.SuppressLint;
import android.app.appsearch.AppSearchBlobHandle;
import android.app.appsearch.EmbeddingVector;
import android.app.appsearch.GenericDocument;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.GenericDocumentParcelCreator;
import android.app.appsearch.safeparcel.PropertyParcel;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import com.android.internal.lang.System_Delegate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@SafeParcelable.Class(creator="GenericDocumentParcelCreator")
@SuppressLint(value={"BanParcelableUsage"})
public class GenericDocumentParcel
extends AbstractSafeParcelable
implements Parcelable {
    public static final @NonNull Parcelable.Creator<GenericDocumentParcel> CREATOR = new GenericDocumentParcelCreator();
    private static final int DEFAULT_SCORE = 0;
    private static final long DEFAULT_TTL_MILLIS = 0L;
    private static final long INVALID_CREATION_TIMESTAMP_MILLIS = -1L;
    @SafeParcelable.Field(id=1, getter="getNamespace")
    private final @NonNull String mNamespace;
    @SafeParcelable.Field(id=2, getter="getId")
    private final @NonNull String mId;
    @SafeParcelable.Field(id=3, getter="getSchemaType")
    private final @NonNull String mSchemaType;
    @SafeParcelable.Field(id=4, getter="getCreationTimestampMillis")
    private final long mCreationTimestampMillis;
    @SafeParcelable.Field(id=5, getter="getTtlMillis")
    private final long mTtlMillis;
    @SafeParcelable.Field(id=6, getter="getScore")
    private final int mScore;
    @SafeParcelable.Field(id=7, getter="getProperties")
    private final @NonNull List<PropertyParcel> mProperties;
    @SafeParcelable.Field(id=8, getter="getParentTypes")
    private final @Nullable List<String> mParentTypes;
    private final @NonNull Map<String, PropertyParcel> mPropertyMap;
    private @Nullable Integer mHashCode;

    @SafeParcelable.Constructor
    GenericDocumentParcel(@SafeParcelable.Param(id=1) @NonNull String namespace, @SafeParcelable.Param(id=2) @NonNull String id2, @SafeParcelable.Param(id=3) @NonNull String schemaType, @SafeParcelable.Param(id=4) long creationTimestampMillis, @SafeParcelable.Param(id=5) long ttlMillis, @SafeParcelable.Param(id=6) int score, @SafeParcelable.Param(id=7) @NonNull List<PropertyParcel> properties, @SafeParcelable.Param(id=8) @Nullable List<String> parentTypes) {
        this(namespace, id2, schemaType, creationTimestampMillis, ttlMillis, score, properties, GenericDocumentParcel.createPropertyMapFromPropertyArray(properties), parentTypes);
    }

    GenericDocumentParcel(@NonNull String namespace, @NonNull String id2, @NonNull String schemaType, long creationTimestampMillis, long ttlMillis, int score, @NonNull List<PropertyParcel> properties, @NonNull Map<String, PropertyParcel> propertyMap, @Nullable List<String> parentTypes) {
        this.mNamespace = Objects.requireNonNull(namespace);
        this.mId = Objects.requireNonNull(id2);
        this.mSchemaType = Objects.requireNonNull(schemaType);
        this.mCreationTimestampMillis = creationTimestampMillis;
        this.mTtlMillis = ttlMillis;
        this.mScore = score;
        this.mProperties = Objects.requireNonNull(properties);
        this.mPropertyMap = Objects.requireNonNull(propertyMap);
        this.mParentTypes = parentTypes;
    }

    public static @NonNull GenericDocumentParcel fromGenericDocument(@NonNull GenericDocument genericDocument) {
        Objects.requireNonNull(genericDocument);
        return genericDocument.getDocumentParcel();
    }

    private static Map<String, PropertyParcel> createPropertyMapFromPropertyArray(@NonNull List<PropertyParcel> properties) {
        Objects.requireNonNull(properties);
        ArrayMap<String, PropertyParcel> propertyMap = new ArrayMap<String, PropertyParcel>(properties.size());
        for (int i = 0; i < properties.size(); ++i) {
            PropertyParcel property = properties.get(i);
            propertyMap.put(property.getPropertyName(), property);
        }
        return propertyMap;
    }

    public @NonNull String getId() {
        return this.mId;
    }

    public @NonNull String getNamespace() {
        return this.mNamespace;
    }

    public @NonNull String getSchemaType() {
        return this.mSchemaType;
    }

    public long getCreationTimestampMillis() {
        return this.mCreationTimestampMillis;
    }

    public long getTtlMillis() {
        return this.mTtlMillis;
    }

    public int getScore() {
        return this.mScore;
    }

    public @NonNull Set<String> getPropertyNames() {
        return this.mPropertyMap.keySet();
    }

    public @NonNull List<PropertyParcel> getProperties() {
        return this.mProperties;
    }

    public @NonNull Map<String, PropertyParcel> getPropertyMap() {
        return this.mPropertyMap;
    }

    public @Nullable List<String> getParentTypes() {
        return this.mParentTypes;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GenericDocumentParcel)) {
            return false;
        }
        GenericDocumentParcel otherDocument = (GenericDocumentParcel)other;
        return this.mNamespace.equals(otherDocument.mNamespace) && this.mId.equals(otherDocument.mId) && this.mSchemaType.equals(otherDocument.mSchemaType) && this.mTtlMillis == otherDocument.mTtlMillis && this.mCreationTimestampMillis == otherDocument.mCreationTimestampMillis && this.mScore == otherDocument.mScore && Objects.equals(this.mProperties, otherDocument.mProperties) && Objects.equals(this.mPropertyMap, otherDocument.mPropertyMap) && Objects.equals(this.mParentTypes, otherDocument.mParentTypes);
    }

    public int hashCode() {
        if (this.mHashCode == null) {
            this.mHashCode = Objects.hash(this.mNamespace, this.mId, this.mSchemaType, this.mTtlMillis, this.mScore, this.mCreationTimestampMillis, Objects.hashCode(this.mProperties), Objects.hashCode(this.mPropertyMap), Objects.hashCode(this.mParentTypes));
        }
        return this.mHashCode;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        GenericDocumentParcelCreator.writeToParcel(this, dest, flags);
    }

    public static class Builder {
        private String mNamespace;
        private String mId;
        private String mSchemaType;
        private long mCreationTimestampMillis;
        private long mTtlMillis;
        private int mScore;
        private Map<String, PropertyParcel> mPropertyMap;
        private @Nullable List<String> mParentTypes;

        public Builder(@NonNull String namespace, @NonNull String id2, @NonNull String schemaType) {
            this.mNamespace = Objects.requireNonNull(namespace);
            this.mId = Objects.requireNonNull(id2);
            this.mSchemaType = Objects.requireNonNull(schemaType);
            this.mCreationTimestampMillis = -1L;
            this.mTtlMillis = 0L;
            this.mScore = 0;
            this.mPropertyMap = new ArrayMap<String, PropertyParcel>();
        }

        public Builder(@NonNull GenericDocumentParcel documentSafeParcel) {
            Objects.requireNonNull(documentSafeParcel);
            this.mNamespace = documentSafeParcel.mNamespace;
            this.mId = documentSafeParcel.mId;
            this.mSchemaType = documentSafeParcel.mSchemaType;
            this.mCreationTimestampMillis = documentSafeParcel.mCreationTimestampMillis;
            this.mTtlMillis = documentSafeParcel.mTtlMillis;
            this.mScore = documentSafeParcel.mScore;
            Map<String, PropertyParcel> propertyMap = documentSafeParcel.mPropertyMap;
            this.mPropertyMap = new ArrayMap<String, PropertyParcel>(propertyMap.size());
            for (PropertyParcel value : propertyMap.values()) {
                this.mPropertyMap.put(value.getPropertyName(), value);
            }
            this.mParentTypes = documentSafeParcel.mParentTypes;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setNamespace(@NonNull String namespace) {
            Objects.requireNonNull(namespace);
            this.mNamespace = namespace;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setId(@NonNull String id2) {
            Objects.requireNonNull(id2);
            this.mId = id2;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setSchemaType(@NonNull String schemaType) {
            Objects.requireNonNull(schemaType);
            this.mSchemaType = schemaType;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setScore(int score) {
            this.mScore = score;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setCreationTimestampMillis(long creationTimestampMillis) {
            this.mCreationTimestampMillis = creationTimestampMillis;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setTtlMillis(long ttlMillis) {
            if (ttlMillis < 0L) {
                throw new IllegalArgumentException("Document ttlMillis cannot be negative.");
            }
            this.mTtlMillis = ttlMillis;
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setParentTypes(@Nullable List<String> parentTypes) {
            this.mParentTypes = parentTypes == null ? null : new ArrayList<String>(parentTypes);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder clearProperty(@NonNull String name) {
            Objects.requireNonNull(name);
            this.mPropertyMap.remove(name);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder putInPropertyMap(@NonNull String name, String @NonNull [] values) throws IllegalArgumentException {
            this.putInPropertyMap(name, new PropertyParcel.Builder(name).setStringValues(values).build());
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder putInPropertyMap(@NonNull String name, boolean @NonNull [] values) {
            this.putInPropertyMap(name, new PropertyParcel.Builder(name).setBooleanValues(values).build());
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder putInPropertyMap(@NonNull String name, double @NonNull [] values) {
            this.putInPropertyMap(name, new PropertyParcel.Builder(name).setDoubleValues(values).build());
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder putInPropertyMap(@NonNull String name, long @NonNull [] values) {
            this.putInPropertyMap(name, new PropertyParcel.Builder(name).setLongValues(values).build());
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder putInPropertyMap(@NonNull String name, byte @NonNull [][] values) {
            this.putInPropertyMap(name, new PropertyParcel.Builder(name).setBytesValues(values).build());
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder putInPropertyMap(@NonNull String name, GenericDocumentParcel @NonNull [] values) {
            this.putInPropertyMap(name, new PropertyParcel.Builder(name).setDocumentValues(values).build());
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder putInPropertyMap(@NonNull String name, EmbeddingVector @NonNull [] values) {
            this.putInPropertyMap(name, new PropertyParcel.Builder(name).setEmbeddingValues(values).build());
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder putInPropertyMap(@NonNull String name, AppSearchBlobHandle @NonNull [] values) {
            Objects.requireNonNull(values);
            this.putInPropertyMap(name, new PropertyParcel.Builder(name).setBlobHandleValues(values).build());
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder putInPropertyMap(@NonNull String name, @NonNull PropertyParcel value) {
            Objects.requireNonNull(value);
            this.mPropertyMap.put(name, value);
            return this;
        }

        public @NonNull GenericDocumentParcel build() {
            if (this.mCreationTimestampMillis == -1L) {
                this.mCreationTimestampMillis = System_Delegate.currentTimeMillis();
            }
            return new GenericDocumentParcel(this.mNamespace, this.mId, this.mSchemaType, this.mCreationTimestampMillis, this.mTtlMillis, this.mScore, new ArrayList<PropertyParcel>(this.mPropertyMap.values()), this.mParentTypes);
        }
    }
}

